/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.dnd.ReportObjectPaletteTransferable;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.outline.nodes.ParametersNode;
import com.jaspersoft.ireport.designer.sheet.JRPropertiesMapProperty;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.DefaultValueExpressionProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.ErrorManager;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ParameterNode
extends IRAbstractNode
implements PropertyChangeListener {
    JasperDesign jd = null;
    private JRDesignParameter parameter = null;

    public ParameterNode(JasperDesign jd, JRDesignParameter parameter, Lookup doLkp) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, parameter})}));
        this.jd = jd;
        this.parameter = parameter;
        this.setDisplayName(parameter.getName());
        super.setName(parameter.getName());
        if (parameter.isSystemDefined()) {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/parameter-16.png");
        } else {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/parameter-16.png");
        }
        parameter.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public String getDisplayName() {
        return this.parameter.getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
        set.put((Node.Property)new NameProperty(this.getParameter(), dataset));
        set.put((Node.Property)new ValueClassNameProperty(this.getParameter()));
        if (!this.getParameter().isSystemDefined()) {
            set.put((Node.Property)new ForPromptingProperty(this.getParameter()));
            set.put((Node.Property)new DefaultValueExpressionProperty(this.getParameter(), dataset));
            set.put((Node.Property)new DescriptionProperty(this.getParameter()));
            set.put((Node.Property)new JRPropertiesMapProperty((JRPropertiesHolder)this.getParameter()));
        }
        sheet.put(set);
        return sheet;
    }

    public boolean canCut() {
        return !this.parameter.isSystemDefined();
    }

    public boolean canRename() {
        return !this.parameter.isSystemDefined();
    }

    public boolean canDestroy() {
        return !this.parameter.isSystemDefined();
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public void destroy() throws IOException {
        if (this.getParentNode() == null) {
            return;
        }
        if (!this.getParameter().isSystemDefined()) {
            JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
            if (dataset != null) {
                dataset.removeParameter((JRParameter)this.getParameter());
            }
            super.destroy();
        }
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), SystemAction.get(RenameAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        tras.put((ExTransferable.Single)new ReportObjectPaletteTransferable("com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldFromParameterAction", this.getParameter()));
        return tras;
    }

    public void setName(String s) {
        if (s.equals("")) {
            throw new IllegalArgumentException("Parameter name not valid.");
        }
        List currentParameters = null;
        JRDesignDataset dataset = (JRDesignDataset)this.getParentNode().getLookup().lookup(JRDesignDataset.class);
        currentParameters = dataset.getParametersList();
        for (JRParameter pa : currentParameters) {
            JRDesignParameter p = (JRDesignParameter)pa;
            if (p == this.getParameter() || !p.getName().equals(s)) continue;
            throw new IllegalArgumentException("Parameter name already in use.");
        }
        String oldName = this.getParameter().getName();
        this.getParameter().setName(s);
        dataset.getParametersMap().remove(oldName);
        dataset.getParametersMap().put(s, this.getParameter());
        ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getParameter(), "Name", String.class, oldName, s);
        IReportManager.getInstance().addUndoableEdit(opue);
    }

    public JRDesignParameter getParameter() {
        return this.parameter;
    }

    public void setParameter(JRDesignParameter parameter) {
        this.parameter = parameter;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("name")) {
            super.setName(this.getParameter().getName());
            this.setDisplayName(this.getParameter().getName());
            if (this.getParentNode() != null && this.getParentNode() instanceof ParametersNode) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((ParametersNode)ParameterNode.this.getParentNode()).updateSorting();
                    }
                });
            }
        }
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public class DescriptionProperty
    extends PropertySupport.ReadWrite {
        JRDesignParameter parameter;

        public DescriptionProperty(JRDesignParameter parameter) {
            super("description", String.class, I18n.getString("ParameterNode.Property.Description"), I18n.getString("ParameterNode.Property.Description"));
            this.parameter = null;
            this.parameter = parameter;
        }

        public boolean canWrite() {
            return !this.getParameter().isSystemDefined();
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.parameter.getDescription() == null ? "" : this.parameter.getDescription();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            String oldValue = this.getParameter().getDescription();
            String newValue = val == null ? null : "" + val.toString();
            this.getParameter().setDescription(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getParameter(), "Description", String.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public JRDesignParameter getParameter() {
            return this.parameter;
        }

        public void setParameter(JRDesignParameter parameter) {
            this.parameter = parameter;
        }

        public boolean isDefaultValue() {
            return this.getParameter().getDescription() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class ForPromptingProperty
    extends PropertySupport.ReadWrite {
        JRDesignParameter parameter = null;

        public ForPromptingProperty(JRDesignParameter parameter) {
            super("forPrompting", Boolean.class, I18n.getString("ParameterNode.Property.UsePrompt"), I18n.getString("ParameterNode.Property.UsePrompt"));
            this.parameter = parameter;
        }

        public boolean canWrite() {
            return !this.getParameter().isSystemDefined();
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Boolean(this.getParameter().isForPrompting());
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val != null && val instanceof Boolean) {
                Boolean oldValue = this.getParameter().isForPrompting();
                Boolean newValue = (Boolean)val;
                this.getParameter().setForPrompting(newValue.booleanValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getParameter(), "ForPrompting", Boolean.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.getParameter().isForPrompting();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            super.restoreDefaultValue();
            this.setValue(Boolean.TRUE);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public JRDesignParameter getParameter() {
            return this.parameter;
        }

        public void setParameter(JRDesignParameter parameter) {
            this.parameter = parameter;
        }
    }

    public class ValueClassNameProperty
    extends PropertySupport.ReadWrite {
        JRDesignParameter parameter;
        PropertyEditor editor;

        public ValueClassNameProperty(JRDesignParameter parameter) {
            super("valueClassName", String.class, I18n.getString("ParameterNode.Property.ParameterClass"), I18n.getString("ParameterNode.Property.ParameterClass"));
            this.parameter = null;
            this.editor = null;
            this.parameter = parameter;
        }

        public boolean canWrite() {
            return !this.getParameter().isSystemDefined();
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getParameter().getValueClassName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null) {
                return;
            }
            if (val instanceof String) {
                String s = ((String)val).trim();
                if (s.length() == 0) {
                    s = "java.lang.String";
                }
                String oldValue = this.getParameter().getValueClassName();
                String newValue = s;
                this.getParameter().setValueClassName(s);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.getParameter(), "ValueClassName", String.class, oldValue, newValue);
                if (this.getParameter().getDefaultValueExpression() != null) {
                    ((JRDesignExpression)this.getParameter().getDefaultValueExpression()).setValueClassName(s);
                    ObjectPropertyUndoableEdit urob2 = new ObjectPropertyUndoableEdit((JRDesignExpression)this.getParameter().getDefaultValueExpression(), "ValueClassName", String.class, oldValue, newValue);
                    urob.addEdit(urob2);
                }
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.getParameter().getValueClassName().equals("java.lang.String");
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            super.restoreDefaultValue();
            this.setValue("java.lang.String");
            this.editor.setValue("java.lang.String");
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public JRDesignParameter getParameter() {
            return this.parameter;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                if (this.getParameter().isSystemDefined()) {
                    this.editor = super.getPropertyEditor();
                } else {
                    ArrayList<Tag> classes = new ArrayList<Tag>();
                    classes.add(new Tag("java.lang.Boolean"));
                    classes.add(new Tag("java.lang.Byte"));
                    classes.add(new Tag("java.util.Date"));
                    classes.add(new Tag("java.sql.Timestamp"));
                    classes.add(new Tag("java.sql.Time"));
                    classes.add(new Tag("java.lang.Double"));
                    classes.add(new Tag("java.lang.Float"));
                    classes.add(new Tag("java.lang.Integer"));
                    classes.add(new Tag("java.lang.Long"));
                    classes.add(new Tag("java.lang.Short"));
                    classes.add(new Tag("java.math.BigDecimal"));
                    classes.add(new Tag("java.lang.Number"));
                    classes.add(new Tag("java.lang.String"));
                    classes.add(new Tag("java.util.Collection"));
                    classes.add(new Tag("java.util.List"));
                    classes.add(new Tag("java.lang.Object"));
                    classes.add(new Tag("java.io.InputStream"));
                    classes.add(new Tag("net.sf.jasperreports.engine.JREmptyDataSource"));
                    this.editor = new ComboBoxPropertyEditor(true, classes);
                }
            }
            return this.editor;
        }

        public Object getValue(String attributeName) {
            if ("canEditAsText".equals(attributeName)) {
                return true;
            }
            if ("oneline".equals(attributeName)) {
                return true;
            }
            if ("suppressCustomEditor".equals(attributeName)) {
                return false;
            }
            return super.getValue(attributeName);
        }
    }

    public static final class NameProperty
    extends PropertySupport.ReadWrite {
        JRDesignParameter parameter = null;
        JRDesignDataset dataset = null;

        public NameProperty(JRDesignParameter parameter, JRDesignDataset dataset) {
            super("name", String.class, I18n.getString("ParameterNode.Property.Name"), I18n.getString("ParameterNode.Property.Namedetail"));
            this.parameter = parameter;
            this.dataset = dataset;
            this.setValue("oneline", Boolean.TRUE);
        }

        public boolean canWrite() {
            return !this.getParameter().isSystemDefined();
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getParameter().getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val.equals("")) {
                IllegalArgumentException iae = this.annotateException(I18n.getString("ParameterNode.Property.NameInvalid"));
                throw iae;
            }
            String s = val + "";
            List currentParameters = null;
            currentParameters = this.getDataset().getParametersList();
            for (JRParameter pa : currentParameters) {
                JRDesignParameter p = (JRDesignParameter)pa;
                if (p == this.getParameter() || !p.getName().equals(s)) continue;
                IllegalArgumentException iae = this.annotateException(I18n.getString("ParameterNode.Property.NameInUse"));
                throw iae;
            }
            String oldName = this.getParameter().getName();
            this.getParameter().setName(s);
            this.dataset.getParametersMap().remove(oldName);
            this.dataset.getParametersMap().put(s, this.getParameter());
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getParameter(), "Name", String.class, oldName, this.getParameter().getName());
            IReportManager.getInstance().addUndoableEdit(opue);
        }

        public JRDesignDataset getDataset() {
            return this.dataset;
        }

        public void setDataset(JRDesignDataset dataset) {
            this.dataset = dataset;
        }

        public JRDesignParameter getParameter() {
            return this.parameter;
        }

        public void setParameter(JRDesignParameter parameter) {
            this.parameter = parameter;
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }
}

