/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrtx;

import com.jaspersoft.ireport.designer.jrtx.JRTXVisualView;
import com.jaspersoft.ireport.designer.jrtx.PaintDelegated;
import com.jaspersoft.ireport.designer.jrtx.PaintablePanel;
import com.jaspersoft.ireport.designer.jrtx.StyleNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.draw.DrawVisitor;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.jdesktop.layout.GroupLayout;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class JRTXPreviewPanel
extends JPanel {
    private JRTXVisualView mainVisualView = null;
    private final JasperDesign STYLE_REPORT;
    private DrawVisitor drawVisitor;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelStyleName;
    private JPanel jPanelGraphicElements;
    private JPanel jPanelTextElements;
    private JSeparator jSeparator1;

    public JRTXPreviewPanel(JRTXVisualView vv) {
        this.initComponents();
        try {
            this.STYLE_REPORT = JRXmlLoader.load((InputStream)this.getClass().getResourceAsStream("/com/jaspersoft/ireport/designer/resources/style.jrxml"));
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        this.mainVisualView = vv;
        ((PaintablePanel)this.jPanelGraphicElements).setPainter(new PaintDelegated(){

            public void paintComponent(JComponent component, Graphics2D g) {
                JRTXPreviewPanel.this.paintGraphicsElements(component, g);
            }
        });
        ((PaintablePanel)this.jPanelTextElements).setPainter(new PaintDelegated(){

            public void paintComponent(JComponent component, Graphics2D g) {
                JRTXPreviewPanel.this.paintTextElements(component, g);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintGraphicsElements(JComponent component, Graphics2D gr) {
        this.drawVisitor = new DrawVisitor((JRReport)this.STYLE_REPORT, null);
        this.drawVisitor.setGraphics2D(gr);
        Paint p = gr.getPaint();
        Stroke s = gr.getStroke();
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform af = (AffineTransform)gr.getTransform().clone();
        AffineTransform af_new = (AffineTransform)gr.getTransform().clone();
        int gap = 15;
        af_new.translate(0.0, 10.0);
        try {
            int i;
            JRDesignElement[] elements = new JRDesignElement[]{(JRDesignElement)this.STYLE_REPORT.getTitle().getElementByKey("rectangle"), (JRDesignElement)this.STYLE_REPORT.getTitle().getElementByKey("ellipse"), (JRDesignElement)this.STYLE_REPORT.getTitle().getElementByKey("line"), (JRDesignElement)this.STYLE_REPORT.getTitle().getElementByKey("image")};
            int requiredSpace = 0;
            for (i = 0; i < elements.length; ++i) {
                requiredSpace += elements[i].getWidth();
            }
            gap = Math.max(15, (component.getWidth() - component.getInsets().left - component.getInsets().right - requiredSpace) / (1 + elements.length));
            for (i = 0; i < elements.length; ++i) {
                af_new.translate(gap, 0.0);
                gr.setTransform(af_new);
                elements[i].visit((JRVisitor)this.drawVisitor);
                af_new.translate(elements[i].getWidth(), 0.0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            gr.setPaint(p);
            gr.setStroke(s);
            gr.setTransform(af);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintTextElements(JComponent component, Graphics2D gr) {
        this.drawVisitor = new DrawVisitor((JRReport)this.STYLE_REPORT, null);
        this.drawVisitor.setGraphics2D(gr);
        Paint p = gr.getPaint();
        Stroke s = gr.getStroke();
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform af = (AffineTransform)gr.getTransform().clone();
        AffineTransform af_new = (AffineTransform)gr.getTransform().clone();
        int gap = 15;
        af_new.translate(15.0, 10.0);
        try {
            JRDesignElement[] elements = new JRDesignElement[]{(JRDesignElement)this.STYLE_REPORT.getTitle().getElementByKey("statictext"), (JRDesignElement)this.STYLE_REPORT.getTitle().getElementByKey("textfield")};
            for (int i = 0; i < 2; ++i) {
                af_new.translate(0.0, 15.0);
                gr.setTransform(af_new);
                elements[i].visit((JRVisitor)this.drawVisitor);
                af_new.translate(0.0, elements[i].getHeight());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            gr.setPaint(p);
            gr.setStroke(s);
            gr.setTransform(af);
        }
    }

    public void modelChanged() {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                if (JRTXPreviewPanel.this.getMainVisualView() != null) {
                    Node[] selectedNodes = JRTXPreviewPanel.this.getMainVisualView().getExplorerManager().getSelectedNodes();
                    if (selectedNodes.length > 0 && selectedNodes[0] instanceof StyleNode) {
                        JRTXPreviewPanel.this.setPreviewStyle((JRStyle)((StyleNode)selectedNodes[0]).getStyle(), (JRTemplate)((StyleNode)selectedNodes[0]).getTemplate());
                    } else {
                        JRTXPreviewPanel.this.setPreviewStyle(null, null);
                    }
                }
            }
        });
    }

    public void setPreviewStyle(JRStyle style, JRTemplate template) {
        this.STYLE_REPORT.setDefaultStyle(null);
        this.STYLE_REPORT.getStylesList().clear();
        this.STYLE_REPORT.getStylesMap().clear();
        if (style == null) {
            this.jLabelStyleName.setText("No style selected");
            this.jPanelGraphicElements.repaint();
            this.jPanelTextElements.repaint();
            this.setElementsStyle(null);
        } else {
            this.jLabelStyleName.setText(style.getName());
            try {
                JRStyle[] styles = template.getStyles();
                for (int i = 0; i < styles.length; ++i) {
                    this.STYLE_REPORT.addStyle(styles[i]);
                    if (!styles[i].isDefault()) continue;
                    this.STYLE_REPORT.setDefaultStyle(style);
                }
                if (style.isDefault()) {
                    this.STYLE_REPORT.setDefaultStyle(style);
                }
                this.setElementsStyle(style);
                this.jPanelGraphicElements.repaint();
                this.jPanelTextElements.repaint();
            }
            catch (JRException jRException) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.jLabelStyleName = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.jPanelGraphicElements = new PaintablePanel();
        this.jLabel2 = new JLabel();
        this.jPanelTextElements = new PaintablePanel();
        this.jLabelStyleName.setFont(new Font("Tahoma", 0, 18));
        this.jLabelStyleName.setText(NbBundle.getMessage(JRTXPreviewPanel.class, (String)"JRTXPreviewPanel.jLabelStyleName.text"));
        this.jLabel1.setText(NbBundle.getMessage(JRTXPreviewPanel.class, (String)"JRTXPreviewPanel.jLabel1.text"));
        this.jPanelGraphicElements.setBackground(new Color(255, 255, 255));
        this.jPanelGraphicElements.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel2.setText(NbBundle.getMessage(JRTXPreviewPanel.class, (String)"JRTXPreviewPanel.jLabel2.text"));
        this.jPanelTextElements.setBackground(new Color(255, 255, 255));
        this.jPanelTextElements.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jPanelGraphicElements, -1, 478, Short.MAX_VALUE).add(1, (Component)this.jPanelTextElements, -1, 478, Short.MAX_VALUE).add(1, (Component)this.jSeparator1, -1, 478, Short.MAX_VALUE).add(1, (Component)this.jLabelStyleName, -1, 478, Short.MAX_VALUE).add(1, (Component)this.jLabel1, -1, 478, Short.MAX_VALUE).add(1, (Component)this.jLabel2, -1, 478, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabelStyleName, -2, 28, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jPanelGraphicElements, -2, 124, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jPanelTextElements, -1, 138, Short.MAX_VALUE).addContainerGap()));
    }

    public JRTXVisualView getMainVisualView() {
        return this.mainVisualView;
    }

    public void setMainVisualView(JRTXVisualView mainVisualView) {
        this.mainVisualView = mainVisualView;
    }

    public DrawVisitor getDrawVisitor() {
        return this.drawVisitor;
    }

    public void setDrawVisitor(DrawVisitor drawVisitor) {
        this.drawVisitor = drawVisitor;
    }

    private void setElementsStyle(JRStyle style) {
        String[] elementNames = new String[]{"rectangle", "ellipse", "line", "image", "statictext", "textfield"};
        for (int i = 0; i < elementNames.length; ++i) {
            JRDesignElement element = (JRDesignElement)this.STYLE_REPORT.getTitle().getElementByKey(elementNames[i]);
            if (element == null) continue;
            element.setStyle(style);
        }
    }
}

