/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.export;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.export.ExporterFactory;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.util.prefs.Preferences;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JExcelApiMetadataExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.oasis.JROdsExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRProperties;

public class DefaultExporterFactory
implements ExporterFactory {
    String format = "";

    public DefaultExporterFactory(String format) {
        this.format = format;
    }

    public String getExportFormat() {
        return this.format;
    }

    public String getExporterFileExtension() {
        if (this.format.equals("xhtml")) {
            return "html";
        }
        if (this.format.equals("xml")) {
            return "jrpxml";
        }
        if (this.format.equals("xls")) {
            return "xls";
        }
        if (this.format.equals("xls2")) {
            return "xls";
        }
        if (this.format.equals("xls3")) {
            return "xls";
        }
        return this.format;
    }

    public JRExporter createExporter() {
        JRPdfExporter exporter = null;
        if (this.format.equalsIgnoreCase("pdf")) {
            exporter = new JRPdfExporter();
            this.configurePdfExporter((JRExporter)exporter);
        } else if (this.format.equalsIgnoreCase("csv")) {
            exporter = new JRCsvExporter();
            this.configureCsvExporter((JRExporter)exporter);
        } else if (this.format.equalsIgnoreCase("html")) {
            exporter = new JRHtmlExporter();
            this.configureHtmlExporter((JRExporter)exporter);
        } else if (this.format.equalsIgnoreCase("xhtml")) {
            exporter = new JRXhtmlExporter();
            this.configureXHtmlExporter((JRExporter)exporter);
        } else if (this.format.equalsIgnoreCase("xls")) {
            exporter = new JRXlsExporter();
            this.configureXlsExporter((JRExporter)exporter);
        } else if (this.format.equalsIgnoreCase("xls2")) {
            exporter = new JExcelApiExporter();
            this.configureXlsExporter((JRExporter)exporter);
        } else if (this.format.equalsIgnoreCase("xls3")) {
            exporter = new JExcelApiMetadataExporter();
            this.configureXlsExporter((JRExporter)exporter);
        } else if (this.format.equalsIgnoreCase("xlsx")) {
            exporter = new JRXlsxExporter();
            this.configureXlsExporter((JRExporter)exporter);
        } else if (!this.format.equalsIgnoreCase("java2D")) {
            if (this.format.equalsIgnoreCase("txt")) {
                exporter = new JRTextExporter();
                this.configureTextExporter((JRExporter)exporter);
            } else if (this.format.equalsIgnoreCase("rtf")) {
                exporter = new JRRtfExporter();
            } else if (this.format.equalsIgnoreCase("odt")) {
                exporter = new JROdtExporter();
            } else if (this.format.equalsIgnoreCase("ods")) {
                exporter = new JROdsExporter();
            } else if (this.format.equalsIgnoreCase("docx")) {
                exporter = new JRDocxExporter();
            } else if (this.format.equalsIgnoreCase("xml")) {
                exporter = new JRXmlExporter();
                this.configureXmlExporter((JRExporter)exporter);
            } else if (this.format.equalsIgnoreCase("pptx")) {
                exporter = new JRPptxExporter();
            }
        }
        return exporter;
    }

    public String getExportFormatDisplayName() {
        return I18n.getString("export.format.name." + this.format);
    }

    public String getViewer() {
        if (this.format.equalsIgnoreCase("pdf")) {
            return IReportManager.getInstance().getProperty("ExternalPDFViewer");
        }
        if (this.format.equalsIgnoreCase("csv")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalCSVViewer"), "");
        }
        if (this.format.equalsIgnoreCase("html") || this.format.equalsIgnoreCase("xhtml")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalHTMLViewer"), "");
        }
        if (this.format.equalsIgnoreCase("xls") || this.format.equalsIgnoreCase("xls2") || this.format.equalsIgnoreCase("xls3") || this.format.equalsIgnoreCase("xlsx")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalXLSViewer"), "");
        }
        if (this.format.equalsIgnoreCase("java2D")) {
            return null;
        }
        if (this.format.equalsIgnoreCase("txt") || this.format.equalsIgnoreCase("xml")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalTXTViewer"), "");
        }
        if (this.format.equalsIgnoreCase("rtf")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalRTFViewer"), "");
        }
        if (this.format.equalsIgnoreCase("odt")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalODFViewer"), "");
        }
        if (this.format.equalsIgnoreCase("ods")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalODSViewer"), "");
        }
        if (this.format.equalsIgnoreCase("docx")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalDOCXViewer"), "");
        }
        if (this.format.equalsIgnoreCase("pptx")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalPPTXViewer"), "");
        }
        return null;
    }

    private void configureTextExporter(JRExporter exporter) {
        int val;
        Preferences pref = IReportManager.getPreferences();
        float floatVal = pref.getFloat("net.sf.jasperreports.export.text.character.height", 0.0f);
        if (floatVal > 0.0f) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.text.character.height", (String)(floatVal + ""));
        }
        if ((floatVal = pref.getFloat("net.sf.jasperreports.export.text.character.width", 0.0f)) > 0.0f) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.text.character.width", (String)(floatVal + ""));
        }
        if ((val = pref.getInt("net.sf.jasperreports.export.text.page.height", 0)) > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.text.page.height", (String)("" + val));
        }
        if ((val = pref.getInt("net.sf.jasperreports.export.text.page.width", 0)) > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.text.page.width", (String)("" + val));
        }
        String s = null;
        if (pref.getBoolean("net.sf.jasperreports.export.txt.nothingBetweenPages", false)) {
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.BETWEEN_PAGES_TEXT, (Object)"");
        } else {
            s = pref.get("net.sf.jasperreports.export.txt.betweenPagesText", "");
            if (s.length() > 0) {
                exporter.setParameter((JRExporterParameter)JRTextExporterParameter.BETWEEN_PAGES_TEXT, (Object)s);
            }
        }
        s = pref.get("net.sf.jasperreports.export.txt.lineSeparator", "");
        if (s.length() > 0) {
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.LINE_SEPARATOR, (Object)s);
        }
    }

    private void configureXlsExporter(JRExporter exporter) {
        int row;
        String col;
        Preferences pref = IReportManager.getPreferences();
        JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.create.custom.palette", (boolean)pref.getBoolean("net.sf.jasperreports.export.xls.create.custom.palette", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.create.custom.palette")));
        String password = pref.get("net.sf.jasperreports.export.xls.password", JRProperties.getProperty((String)"net.sf.jasperreports.export.xls.password"));
        if (password != null && password.length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.password", (String)password);
        }
        JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.collapse.row.span", (boolean)pref.getBoolean("net.sf.jasperreports.export.xls.collapse.row.span", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.collapse.row.span")));
        System.out.println("Setting detect cell type to:" + pref.getBoolean("net.sf.jasperreports.export.xls.detect.cell.type", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.detect.cell.type")));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.detect.cell.type", (boolean)pref.getBoolean("net.sf.jasperreports.export.xls.detect.cell.type", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.detect.cell.type")));
        System.out.println("Setting detect cell type to (net.sf.jasperreports.export.xls.detect.cell.type):" + JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.detect.cell.type"));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.font.size.fix.enabled", (boolean)pref.getBoolean("net.sf.jasperreports.export.xls.font.size.fix.enabled", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.font.size.fix.enabled")));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.ignore.cell.border", (boolean)pref.getBoolean("net.sf.jasperreports.export.xls.ignore.cell.border", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.ignore.cell.border")));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.ignore.cell.background", (boolean)pref.getBoolean("net.sf.jasperreports.export.xls.ignore.cell.background", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.ignore.cell.background")));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.ignore.graphics", (boolean)pref.getBoolean("net.sf.jasperreports.export.xls.ignore.graphics", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.ignore.graphics")));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.image.border.fix.enabled", (boolean)pref.getBoolean("net.sf.jasperreports.export.xls.image.border.fix.enabled", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.image.border.fix.enabled")));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.one.page.per.sheet", (boolean)pref.getBoolean("net.sf.jasperreports.export.xls.one.page.per.sheet", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.one.page.per.sheet")));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.remove.empty.space.between.columns", (boolean)pref.getBoolean("net.sf.jasperreports.export.xls.remove.empty.space.between.columns", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.remove.empty.space.between.columns")));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.remove.empty.space.between.rows", (boolean)pref.getBoolean("net.sf.jasperreports.export.xls.remove.empty.space.between.rows", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.remove.empty.space.between.rows")));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.white.page.background", (boolean)pref.getBoolean("net.sf.jasperreports.export.xls.white.page.background", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.white.page.background")));
        int maxRowsPerSheet = pref.getInt("net.sf.jasperreports.export.xls.max.rows.per.sheet", JRProperties.getIntegerProperty((String)"net.sf.jasperreports.export.xls.max.rows.per.sheet"));
        if (maxRowsPerSheet > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.max.rows.per.sheet", (String)("" + maxRowsPerSheet));
        }
        if (pref.getBoolean("net.sf.jasperreports.export.xls.useSheetNames", false)) {
            String sheetNames = pref.get("net.sf.jasperreports.export.xls.sheetNames", "");
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.SHEET_NAMES, (Object)sheetNames.split("\n"));
        }
        if ((col = pref.get("net.sf.jasperreports.export.xls.freeze.column", JRProperties.getProperty((String)"net.sf.jasperreports.export.xls.freeze.column"))) != null && col.length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.freeze.column", (String)("" + col));
        }
        if ((row = pref.getInt("net.sf.jasperreports.export.xls.freeze.row", JRProperties.getIntegerProperty((String)"net.sf.jasperreports.export.xls.freeze.row", (int)0))) > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.freeze.row", (String)("" + row));
        }
    }

    private void configurePdfExporter(JRExporter exporter) {
        String pdfaICC;
        String pdfa;
        Preferences pref = IReportManager.getPreferences();
        String pdfVersion = pref.get("net.sf.jasperreports.export.pdf.version", null);
        if (pdfVersion != null && pdfVersion.length() == 1) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.pdf.version", (String)("" + pdfVersion.charAt(0)));
        }
        boolean b = pref.getBoolean("net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks"));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks", (boolean)new Boolean(b));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.pdf.compressed", (boolean)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.compressed", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.compressed"))));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.pdf.force.linebreak.policy", (boolean)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.force.linebreak.policy", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.force.linebreak.policy"))));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.pdf.force.svg.shapes", (boolean)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.force.svg.shapes", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.force.svg.shapes"))));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.pdf.tagged", (boolean)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.tagged", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.tagged"))));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.pdf.encrypted", (boolean)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.encrypted", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.encrypted"))));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.pdf.128.bit.key", (boolean)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.128.bit.key", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.128.bit.key"))));
        if (pref.get("export.pdf.METADATA_AUTHOR", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_AUTHOR, (Object)pref.get("export.pdf.METADATA_AUTHOR", ""));
        }
        if (pref.get("export.pdf.METADATA_CREATOR", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_CREATOR, (Object)pref.get("export.pdf.METADATA_CREATOR", ""));
        }
        if (pref.get("export.pdf.METADATA_KEYWORDS", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_KEYWORDS, (Object)pref.get("export.pdf.METADATA_KEYWORDS", ""));
        }
        if (pref.get("export.pdf.METADATA_SUBJECT", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_SUBJECT, (Object)pref.get("export.pdf.METADATA_SUBJECT", ""));
        }
        if (pref.get("export.pdf.METADATA_TITLE", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_TITLE, (Object)pref.get("export.pdf.METADATA_TITLE", ""));
        }
        if (pref.get("export.pdf.OWNER_PASSWORD", "").length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.pdf.owner.password", (String)pref.get("export.pdf.OWNER_PASSWORD", ""));
        }
        if (pref.get("export.pdf.USER_PASSWORD", "").length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.pdf.user.password", (String)pref.get("export.pdf.USER_PASSWORD", ""));
        }
        if (pref.get("export.pdf.TAG_LANGUAGE", JRProperties.getProperty((String)"net.sf.jasperreports.export.pdf.tag.language")) != null) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.pdf.tag.language", (String)pref.get("export.pdf.TAG_LANGUAGE", JRProperties.getProperty((String)"net.sf.jasperreports.export.pdf.tag.language")));
        }
        if (pref.get("export.pdf.PDF_JAVASCRIPT", JRProperties.getProperty((String)"net.sf.jasperreports.export.pdf.javascript")) != null) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.pdf.javascript", (String)pref.get("export.pdf.PDF_JAVASCRIPT", JRProperties.getProperty((String)"net.sf.jasperreports.export.pdf.javascript")));
        }
        if (pref.getInt("export.pdf.PERMISSIONS", 0) != 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.PERMISSIONS, (Object)pref.getInt("export.pdf.PERMISSIONS", 0));
        }
        if ((pdfa = pref.get("net.sf.jasperreports.export.pdfa.conformance", JRProperties.getProperty((String)"none"))) != null) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.pdfa.conformance", (String)pdfa);
        }
        if ((pdfaICC = pref.get("net.sf.jasperreports.export.pdfa.icc.profile.path", JRProperties.getProperty((String)"net.sf.jasperreports.export.pdfa.icc.profile.path"))) != null && !pdfaICC.equals("")) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.pdfa.icc.profile.path", (String)pdfaICC);
        }
    }

    private void configureXHtmlExporter(JRExporter exporter) {
        Preferences pref = IReportManager.getPreferences();
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)pref.getBoolean("net.sf.jasperreports.export.html.saveImages", true));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)pref.getBoolean("net.sf.jasperreports.export.xls.white.page.background", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.white.page.background")));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WRAP_BREAK_WORD, (Object)pref.getBoolean("net.sf.jasperreports.export.html.wrap.break.word", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.html.wrap.break.word")));
        if (pref.get("net.sf.jasperreports.export.html.imagesDirectory", "").length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.html.imagesDirectory", (String)pref.get("net.sf.jasperreports.export.html.imagesDirectory", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.imagesUri", "").length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.html.imagesUri", (String)pref.get("net.sf.jasperreports.export.html.imagesUri", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlHeader", "").length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.html.htmlHeader", (String)pref.get("net.sf.jasperreports.export.html.htmlHeader", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlBetweenPages", "").length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.html.htmlBetweenPages", (String)pref.get("net.sf.jasperreports.export.html.htmlBetweenPages", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlFooter", "").length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.html.htmlFooter", (String)pref.get("net.sf.jasperreports.export.html.htmlFooter", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.size.unit", JRProperties.getProperty((String)"net.sf.jasperreports.export.html.size.unit")).length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.html.size.unit", (String)pref.get("net.sf.jasperreports.export.html.size.unit", JRProperties.getProperty((String)"net.sf.jasperreports.export.html.size.unit")));
        }
    }

    private void configureHtmlExporter(JRExporter exporter) {
        Preferences pref = IReportManager.getPreferences();
        JRProperties.setProperty((String)"net.sf.jasperreports.export.html.frames.as.nested.tables", (boolean)pref.getBoolean("net.sf.jasperreports.export.html.frames.as.nested.tables", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.html.frames.as.nested.tables")));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.html.remove.emtpy.space.between.rows", (boolean)pref.getBoolean("net.sf.jasperreports.export.html.remove.emtpy.space.between.rows", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.html.remove.emtpy.space.between.rows")));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)pref.getBoolean("net.sf.jasperreports.export.html.saveImages", true));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.html.using.images.to.align", (boolean)pref.getBoolean("net.sf.jasperreports.export.html.using.images.to.align", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.html.using.images.to.align")));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.xls.white.page.background", (boolean)pref.getBoolean("net.sf.jasperreports.export.xls.white.page.background", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.white.page.background")));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.html.wrap.break.word", (boolean)pref.getBoolean("net.sf.jasperreports.export.html.wrap.break.word", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.html.wrap.break.word")));
        if (pref.get("net.sf.jasperreports.export.html.imagesDirectory", "").length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.html.imagesDirectory", (String)pref.get("net.sf.jasperreports.export.html.imagesDirectory", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.imagesUri", "").length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.html.imagesUri", (String)pref.get("net.sf.jasperreports.export.html.imagesUri", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlHeader", "").length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.html.htmlHeader", (String)pref.get("net.sf.jasperreports.export.html.htmlHeader", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlBetweenPages", "").length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.html.htmlBetweenPages", (String)pref.get("net.sf.jasperreports.export.html.htmlBetweenPages", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlFooter", "").length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.html.htmlFooter", (String)pref.get("net.sf.jasperreports.export.html.htmlFooter", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.size.unit", JRProperties.getProperty((String)"net.sf.jasperreports.export.html.size.unit")).length() > 0) {
            JRProperties.setProperty((String)"net.sf.jasperreports.export.html.size.unit", (String)pref.get("net.sf.jasperreports.export.html.size.unit", JRProperties.getProperty((String)"net.sf.jasperreports.export.html.size.unit")));
        }
    }

    private void configureCsvExporter(JRExporter exporter) {
        Preferences pref = IReportManager.getPreferences();
        JRProperties.setProperty((String)"net.sf.jasperreports.export.csv.field.delimiter", (String)pref.get("net.sf.jasperreports.export.csv.field.delimiter", JRProperties.getProperty((String)"net.sf.jasperreports.export.csv.field.delimiter")));
        JRProperties.setProperty((String)"net.sf.jasperreports.export.csv.record.delimiter", (String)pref.get("net.sf.jasperreports.export.csv.record.delimiter", JRProperties.getProperty((String)"net.sf.jasperreports.export.csv.record.delimiter")));
    }

    private void configureXmlExporter(JRExporter exporter) {
        Preferences pref = IReportManager.getPreferences();
    }
}

