/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.ThreadLocalStack;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.ReportResource;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositoryUtil {
    private static ThreadLocalStack localContextStack = new ThreadLocalStack();
    private static AtomicReference<List<RepositoryService>> repositoryServices = new AtomicReference();

    private static List<RepositoryService> getRepositoryServices() {
        List<RepositoryService> cachedServices = repositoryServices.get();
        if (cachedServices != null) {
            return cachedServices;
        }
        List<RepositoryService> services = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(RepositoryService.class);
        if (repositoryServices.compareAndSet(null, services)) {
            return services;
        }
        return repositoryServices.get();
    }

    public static void setRepositoryContext(RepositoryContext context) {
        List<RepositoryService> services = RepositoryUtil.getRepositoryServices();
        if (services != null) {
            for (RepositoryService service : services) {
                service.setContext(context);
            }
        }
        localContextStack.push(context);
    }

    public static void revertRepositoryContext() {
        List<RepositoryService> services = RepositoryUtil.getRepositoryServices();
        if (services != null) {
            for (RepositoryService service : services) {
                service.revertContext();
            }
        }
        localContextStack.pop();
    }

    public static JasperReport getReport(String location) throws JRException {
        ReportResource resource = RepositoryUtil.getResource(location, ReportResource.class);
        if (resource == null) {
            throw new JRException("Report not found at : " + location);
        }
        return resource.getReport();
    }

    public static <K extends Resource> K getResource(String location, Class<K> resourceType) throws JRException {
        K resource = null;
        List<RepositoryService> services = RepositoryUtil.getRepositoryServices();
        if (services != null) {
            RepositoryService service;
            Iterator<RepositoryService> i$ = services.iterator();
            while (i$.hasNext() && (resource = (K)(service = i$.next()).getResource(location, resourceType)) == null) {
            }
        }
        if (resource == null) {
            throw new JRException("Resource not found at : " + location);
        }
        return resource;
    }

    public static InputStream getInputStream(String location) throws JRException {
        InputStream is = RepositoryUtil.findInputStream(location);
        if (is == null) {
            throw new JRException("Input stream not found at : " + location);
        }
        return is;
    }

    private static InputStream findInputStream(String location) throws JRException {
        InputStreamResource inputStreamResource;
        block1: {
            RepositoryService service;
            inputStreamResource = null;
            List<RepositoryService> services = RepositoryUtil.getRepositoryServices();
            if (services == null) break block1;
            Iterator<RepositoryService> i$ = services.iterator();
            while (i$.hasNext() && (inputStreamResource = (service = i$.next()).getResource(location, InputStreamResource.class)) == null) {
            }
        }
        return inputStreamResource == null ? null : inputStreamResource.getInputStream();
    }

    public static byte[] getBytes(String location) throws JRException {
        InputStream is = RepositoryUtil.findInputStream(location);
        if (is == null) {
            throw new JRException("Byte data not found at : " + location);
        }
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[10000];
            int ln = 0;
            while ((ln = is.read(bytes)) > 0) {
                baos.write(bytes, 0, ln);
            }
            baos.flush();
        }
        catch (IOException e) {
            throw new JRException("Error loading byte data from : " + location, e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return baos.toByteArray();
    }

    private RepositoryUtil() {
    }
}

