/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.export.TabSegment;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.ParagraphUtil;

public abstract class AbstractTextRenderer {
    public static final FontRenderContext LINE_BREAK_FONT_RENDER_CONTEXT = new FontRenderContext(null, true, true);
    protected JRPrintText text;
    protected JRStyledText styledText;
    protected String allText;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int topPadding;
    protected int leftPadding;
    protected int bottomPadding;
    protected int rightPadding;
    protected float verticalAlignOffset;
    protected float drawPosY;
    protected float drawPosX;
    protected float lineHeight;
    protected boolean isMaxHeightReached;
    protected List<TabSegment> segments;
    protected int segmentIndex;
    private boolean isMinimizePrinterJobSize = true;
    private boolean ignoreMissingFont;

    public AbstractTextRenderer(boolean isMinimizePrinterJobSize, boolean ignoreMissingFont) {
        this.isMinimizePrinterJobSize = isMinimizePrinterJobSize;
        this.ignoreMissingFont = ignoreMissingFont;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public JRStyledText getStyledText() {
        return this.styledText;
    }

    public String getPlainText() {
        return this.allText;
    }

    public void initialize(JRPrintText text, int offsetX, int offsetY) {
        this.styledText = text.getStyledText(JRStyledTextAttributeSelector.NO_BACKCOLOR);
        if (this.styledText == null) {
            return;
        }
        this.allText = this.styledText.getText();
        this.x = text.getX() + offsetX;
        this.y = text.getY() + offsetY;
        this.width = text.getWidth();
        this.height = text.getHeight();
        this.topPadding = text.getLineBox().getTopPadding();
        this.leftPadding = text.getLineBox().getLeftPadding();
        this.bottomPadding = text.getLineBox().getBottomPadding();
        this.rightPadding = text.getLineBox().getRightPadding();
        switch (text.getRotationValue()) {
            case LEFT: {
                this.y = text.getY() + offsetY + text.getHeight();
                this.width = text.getHeight();
                this.height = text.getWidth();
                int tmpPadding = this.topPadding;
                this.topPadding = this.leftPadding;
                this.leftPadding = this.bottomPadding;
                this.bottomPadding = this.rightPadding;
                this.rightPadding = tmpPadding;
                break;
            }
            case RIGHT: {
                this.x = text.getX() + offsetX + text.getWidth();
                this.width = text.getHeight();
                this.height = text.getWidth();
                int tmpPadding = this.topPadding;
                this.topPadding = this.rightPadding;
                this.rightPadding = this.bottomPadding;
                this.bottomPadding = this.leftPadding;
                this.leftPadding = tmpPadding;
                break;
            }
            case UPSIDE_DOWN: {
                int tmpPadding = this.topPadding;
                this.x = text.getX() + offsetX + text.getWidth();
                this.y = text.getY() + offsetY + text.getHeight();
                this.topPadding = this.bottomPadding;
                this.bottomPadding = tmpPadding;
                tmpPadding = this.leftPadding;
                this.leftPadding = this.rightPadding;
                this.rightPadding = tmpPadding;
                break;
            }
        }
        this.text = text;
        this.verticalAlignOffset = 0.0f;
        switch (text.getVerticalAlignmentValue()) {
            case TOP: {
                this.verticalAlignOffset = 0.0f;
                break;
            }
            case MIDDLE: {
                this.verticalAlignOffset = ((float)(this.height - this.topPadding - this.bottomPadding) - text.getTextHeight()) / 2.0f;
                break;
            }
            case BOTTOM: {
                this.verticalAlignOffset = (float)(this.height - this.topPadding - this.bottomPadding) - text.getTextHeight();
                break;
            }
            default: {
                this.verticalAlignOffset = 0.0f;
            }
        }
        this.drawPosY = 0.0f;
        this.drawPosX = 0.0f;
        this.isMaxHeightReached = false;
    }

    public void render() {
        AttributedCharacterIterator allParagraphs = this.styledText.getAwtAttributedString(this.ignoreMissingFont).getIterator();
        int tokenPosition = 0;
        int lastParagraphStart = 0;
        String lastParagraphText = null;
        StringTokenizer tkzer = new StringTokenizer(this.allText, "\n", true);
        while (tkzer.hasMoreTokens() && !this.isMaxHeightReached) {
            String token = tkzer.nextToken();
            if ("\n".equals(token)) {
                this.renderParagraph(allParagraphs, lastParagraphStart, lastParagraphText);
                lastParagraphStart = tokenPosition + (tkzer.hasMoreTokens() || tokenPosition == 0 ? 1 : 0);
                lastParagraphText = null;
            } else {
                lastParagraphStart = tokenPosition;
                lastParagraphText = token;
            }
            tokenPosition += token.length();
        }
        if (!this.isMaxHeightReached && lastParagraphStart < this.allText.length()) {
            this.renderParagraph(allParagraphs, lastParagraphStart, lastParagraphText);
        }
    }

    private void renderParagraph(AttributedCharacterIterator allParagraphs, int lastParagraphStart, String lastParagraphText) {
        AttributedCharacterIterator paragraph = null;
        if (lastParagraphText == null) {
            lastParagraphText = " ";
            paragraph = new AttributedString(lastParagraphText, new AttributedString(allParagraphs, lastParagraphStart, lastParagraphStart + lastParagraphText.length()).getIterator().getAttributes()).getIterator();
        } else {
            paragraph = new AttributedString(allParagraphs, lastParagraphStart, lastParagraphStart + lastParagraphText.length()).getIterator();
        }
        List<Integer> tabIndexes = JRStringUtil.getTabIndexes(lastParagraphText);
        int currentTab = 0;
        int lines = 0;
        float endX = 0.0f;
        TabStop nextTabStop = null;
        boolean requireNextWord = false;
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, this.getFontRenderContext());
        while (lineMeasurer.getPosition() < paragraph.getEndIndex() && !this.isMaxHeightReached) {
            boolean lineComplete = false;
            float maxAscent = 0.0f;
            float maxDescent = 0.0f;
            float maxLeading = 0.0f;
            this.segments = new ArrayList<TabSegment>(1);
            TabSegment oldSegment = null;
            TabSegment crtSegment = null;
            while (!lineComplete) {
                AttributedString tmpText;
                int tabIndexOrEndIndex = tabIndexes == null || currentTab >= tabIndexes.size() ? paragraph.getEndIndex() : tabIndexes.get(currentTab) + 1;
                float startX = (lineMeasurer.getPosition() == 0 ? this.text.getParagraph().getFirstLineIndent() : 0) + this.leftPadding;
                endX = this.width - this.text.getParagraph().getRightIndent() - this.rightPadding;
                endX = endX < startX ? startX : endX;
                int startIndex = lineMeasurer.getPosition();
                float rightX = 0.0f;
                if (this.segments.size() == 0) {
                    rightX = startX;
                } else {
                    rightX = oldSegment.rightX;
                    nextTabStop = ParagraphUtil.getNextTabStop(this.text.getParagraph(), endX, rightX);
                }
                float availableWidth = endX - (float)this.text.getParagraph().getLeftIndent().intValue() - ParagraphUtil.getSegmentOffset(nextTabStop, rightX);
                TextLayout layout = lineMeasurer.nextLayout(availableWidth, tabIndexOrEndIndex, requireNextWord);
                if (layout != null) {
                    tmpText = new AttributedString(paragraph, startIndex, startIndex + layout.getCharacterCount());
                    if (this.isMinimizePrinterJobSize) {
                        layout = new TextLayout(tmpText.getIterator(), this.getFontRenderContext());
                    }
                    if (this.text.getHorizontalAlignmentValue() == HorizontalAlignEnum.JUSTIFIED && lineMeasurer.getPosition() < paragraph.getEndIndex()) {
                        layout = layout.getJustifiedLayout(availableWidth);
                    }
                    maxAscent = Math.max(maxAscent, layout.getAscent());
                    maxDescent = Math.max(maxDescent, layout.getDescent());
                    maxLeading = Math.max(maxLeading, layout.getLeading());
                    crtSegment = new TabSegment();
                    crtSegment.layout = layout;
                    crtSegment.as = tmpText;
                    crtSegment.text = lastParagraphText.substring(startIndex, startIndex + layout.getCharacterCount());
                    float leftX = ParagraphUtil.getLeftX(nextTabStop, layout.getAdvance());
                    if (rightX > leftX) {
                        crtSegment.leftX = rightX;
                        crtSegment.rightX = rightX + layout.getAdvance();
                    } else {
                        crtSegment.leftX = leftX;
                        crtSegment.rightX = ParagraphUtil.getRightX(nextTabStop, layout.getAdvance());
                    }
                    this.segments.add(crtSegment);
                }
                requireNextWord = true;
                if (lineMeasurer.getPosition() == tabIndexOrEndIndex) {
                    ++currentTab;
                }
                if (lineMeasurer.getPosition() == paragraph.getEndIndex()) {
                    lineComplete = true;
                    nextTabStop = null;
                } else if (lineMeasurer.getPosition() == tabIndexOrEndIndex) {
                    if (crtSegment.rightX >= (float)ParagraphUtil.getLastTabStop(this.text.getParagraph(), endX).getPosition()) {
                        lineComplete = true;
                        nextTabStop = ParagraphUtil.getFirstTabStop(this.text.getParagraph(), endX);
                    }
                } else {
                    lineComplete = true;
                    if (layout == null) {
                        if (nextTabStop.getPosition() == ParagraphUtil.getFirstTabStop(this.text.getParagraph(), endX).getPosition()) {
                            nextTabStop = null;
                            requireNextWord = false;
                            tmpText = new AttributedString(paragraph, startIndex, startIndex + 1);
                            LineBreakMeasurer lbm = new LineBreakMeasurer(tmpText.getIterator(), this.getFontRenderContext());
                            TextLayout tlyt = lbm.nextLayout(100.0f);
                            maxAscent = tlyt.getAscent();
                            maxDescent = tlyt.getDescent();
                            maxLeading = tlyt.getLeading();
                        } else {
                            nextTabStop = ParagraphUtil.getFirstTabStop(this.text.getParagraph(), endX);
                        }
                    } else {
                        nextTabStop = null;
                        requireNextWord = false;
                    }
                }
                oldSegment = crtSegment;
            }
            this.lineHeight = AbstractTextRenderer.getLineHeight(lastParagraphStart == 0 && lines == 0, this.text.getParagraph(), maxLeading, maxAscent);
            if (lastParagraphStart == 0 && lines == 0) {
                this.lineHeight += (float)this.text.getParagraph().getSpacingBefore().intValue();
            }
            if (this.drawPosY + this.lineHeight <= this.text.getTextHeight()) {
                ++lines;
                this.drawPosY += this.lineHeight;
                float lastRightX = this.segments == null || this.segments.size() == 0 ? 0.0f : this.segments.get((int)(this.segments.size() - 1)).rightX;
                this.segmentIndex = 0;
                while (this.segmentIndex < this.segments.size()) {
                    TabSegment segment = this.segments.get(this.segmentIndex);
                    TextLayout layout = segment.layout;
                    switch (this.text.getHorizontalAlignmentValue()) {
                        case JUSTIFIED: {
                            if (layout.isLeftToRight()) {
                                this.drawPosX = (float)this.text.getParagraph().getLeftIndent().intValue() + segment.leftX;
                                break;
                            }
                            this.drawPosX = endX - lastRightX + segment.leftX;
                            break;
                        }
                        case RIGHT: {
                            this.drawPosX = endX - lastRightX + segment.leftX;
                            break;
                        }
                        case CENTER: {
                            this.drawPosX = (endX - lastRightX) / 2.0f + segment.leftX;
                            break;
                        }
                        default: {
                            this.drawPosX = (float)this.text.getParagraph().getLeftIndent().intValue() + segment.leftX;
                        }
                    }
                    this.draw();
                    ++this.segmentIndex;
                }
                this.drawPosY += maxDescent;
                continue;
            }
            this.isMaxHeightReached = true;
        }
    }

    public abstract void draw();

    public static float getLineHeight(boolean isFirstLine, JRParagraph paragraph, float maxLeading, float maxAscent) {
        float lineHeight = 0.0f;
        switch (paragraph.getLineSpacing()) {
            default: {
                lineHeight = maxLeading + 1.0f * maxAscent;
                break;
            }
            case ONE_AND_HALF: {
                if (isFirstLine) {
                    lineHeight = maxLeading + 1.0f * maxAscent;
                    break;
                }
                lineHeight = maxLeading + 1.5f * maxAscent;
                break;
            }
            case DOUBLE: {
                if (isFirstLine) {
                    lineHeight = maxLeading + 1.0f * maxAscent;
                    break;
                }
                lineHeight = maxLeading + 2.0f * maxAscent;
                break;
            }
            case PROPORTIONAL: {
                if (isFirstLine) {
                    lineHeight = maxLeading + 1.0f * maxAscent;
                    break;
                }
                lineHeight = maxLeading + paragraph.getLineSpacingSize().floatValue() * maxAscent;
                break;
            }
            case AT_LEAST: {
                if (isFirstLine) {
                    lineHeight = maxLeading + 1.0f * maxAscent;
                    break;
                }
                lineHeight = Math.max(maxLeading + 1.0f * maxAscent, paragraph.getLineSpacingSize().floatValue());
                break;
            }
            case FIXED: {
                lineHeight = isFirstLine ? maxLeading + 1.0f * maxAscent : paragraph.getLineSpacingSize().floatValue();
            }
        }
        return lineHeight;
    }

    public FontRenderContext getFontRenderContext() {
        return LINE_BREAK_FONT_RENDER_CONTEXT;
    }
}

