/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data;

import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataAdapterServiceFactory;
import net.sf.jasperreports.data.bean.BeanDataAdapter;
import net.sf.jasperreports.data.bean.BeanDataAdapterService;
import net.sf.jasperreports.data.csv.CsvDataAdapter;
import net.sf.jasperreports.data.csv.CsvDataAdapterService;
import net.sf.jasperreports.data.ds.DataSourceDataAdapter;
import net.sf.jasperreports.data.ds.DataSourceDataAdapterService;
import net.sf.jasperreports.data.ejbql.EjbqlDataAdapter;
import net.sf.jasperreports.data.ejbql.EjbqlDataAdapterService;
import net.sf.jasperreports.data.empty.EmptyDataAdapter;
import net.sf.jasperreports.data.empty.EmptyDataAdapterService;
import net.sf.jasperreports.data.hibernate.HibernateDataAdapter;
import net.sf.jasperreports.data.hibernate.HibernateDataAdapterService;
import net.sf.jasperreports.data.hibernate.spring.SpringHibernateDataAdapter;
import net.sf.jasperreports.data.hibernate.spring.SpringHibernateDataAdapterService;
import net.sf.jasperreports.data.jdbc.JdbcDataAdapter;
import net.sf.jasperreports.data.jdbc.JdbcDataAdapterImpl;
import net.sf.jasperreports.data.jdbc.JdbcDataAdapterService;
import net.sf.jasperreports.data.jndi.JndiDataAdapter;
import net.sf.jasperreports.data.jndi.JndiDataAdapterService;
import net.sf.jasperreports.data.json.JsonDataAdapter;
import net.sf.jasperreports.data.json.JsonDataAdapterService;
import net.sf.jasperreports.data.mondrian.MondrianDataAdapter;
import net.sf.jasperreports.data.mondrian.MondrianDataAdapterService;
import net.sf.jasperreports.data.provider.DataSourceProviderDataAdapter;
import net.sf.jasperreports.data.provider.DataSourceProviderDataAdapterService;
import net.sf.jasperreports.data.qe.QueryExecuterDataAdapter;
import net.sf.jasperreports.data.qe.QueryExecuterDataAdapterService;
import net.sf.jasperreports.data.xls.XlsDataAdapter;
import net.sf.jasperreports.data.xls.XlsDataAdapterService;
import net.sf.jasperreports.data.xlsx.XlsxDataAdapter;
import net.sf.jasperreports.data.xlsx.XlsxDataAdapterService;
import net.sf.jasperreports.data.xml.RemoteXmlDataAdapter;
import net.sf.jasperreports.data.xml.RemoteXmlDataAdapterService;
import net.sf.jasperreports.data.xml.XmlDataAdapter;
import net.sf.jasperreports.data.xml.XmlDataAdapterService;
import net.sf.jasperreports.data.xmla.XmlaDataAdapter;
import net.sf.jasperreports.data.xmla.XmlaDataAdapterService;

public class DefaultDataAdapterServiceFactory
implements DataAdapterServiceFactory {
    private static final DefaultDataAdapterServiceFactory INSTANCE = new DefaultDataAdapterServiceFactory();

    public static DefaultDataAdapterServiceFactory getInstance() {
        return INSTANCE;
    }

    public DataAdapterService getDataAdapterService(DataAdapter dataAdapter) {
        AbstractDataAdapterService dataAdapterService = null;
        if (dataAdapter instanceof BeanDataAdapter) {
            dataAdapterService = new BeanDataAdapterService((BeanDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof CsvDataAdapter) {
            dataAdapterService = new CsvDataAdapterService((CsvDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof DataSourceDataAdapter) {
            dataAdapterService = new DataSourceDataAdapterService((DataSourceDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof EmptyDataAdapter) {
            dataAdapterService = new EmptyDataAdapterService((EmptyDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof JndiDataAdapter) {
            dataAdapterService = new JndiDataAdapterService((JndiDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof DataSourceProviderDataAdapter) {
            dataAdapterService = new DataSourceProviderDataAdapterService((DataSourceProviderDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof QueryExecuterDataAdapter) {
            dataAdapterService = new QueryExecuterDataAdapterService((QueryExecuterDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof XlsDataAdapter) {
            dataAdapterService = new XlsDataAdapterService((XlsDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof XlsxDataAdapter) {
            dataAdapterService = new XlsxDataAdapterService((XlsxDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof RemoteXmlDataAdapter) {
            dataAdapterService = new RemoteXmlDataAdapterService((RemoteXmlDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof XmlDataAdapter) {
            dataAdapterService = new XmlDataAdapterService((XmlDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof JsonDataAdapter) {
            dataAdapterService = new JsonDataAdapterService((JsonDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof HibernateDataAdapter) {
            dataAdapterService = new HibernateDataAdapterService((HibernateDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof SpringHibernateDataAdapter) {
            dataAdapterService = new SpringHibernateDataAdapterService((SpringHibernateDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof EjbqlDataAdapter) {
            dataAdapterService = new EjbqlDataAdapterService((EjbqlDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof MondrianDataAdapter) {
            dataAdapterService = new MondrianDataAdapterService((MondrianDataAdapter)dataAdapter);
        } else if (dataAdapter instanceof XmlaDataAdapter) {
            dataAdapterService = new XmlaDataAdapterService((XmlaDataAdapter)dataAdapter);
        } else if (dataAdapter.getClass().getName().equals(JdbcDataAdapterImpl.class.getName())) {
            dataAdapterService = new JdbcDataAdapterService((JdbcDataAdapter)dataAdapter);
        }
        return dataAdapterService;
    }
}

