/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.jaxrs.IClientProvider;
import oracle.cloudstorage.api.jaxrs.IJaxrsImplementation;
import oracle.cloudstorage.api.queryparam.Map;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.processor.Content;
import oracle.cloudstorage.api.request.processor.IContent;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.concurrent.Future;
import oracle.cloudstorage.io.Md5OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class SendableInvocationAdapter
implements IClientProvider {
    private static final Logger logger = LoggerFactory.getLogger(SendableInvocationAdapter.class);
    private static final String OPCS_POST = "__OPCS_POST__";
    private final Logger sendableLogger;
    private final Marker marker;
    private final IClientProvider clientProvider;
    private final ISendable sendable;
    private final Invocation.Builder builder;
    private final IJaxrsImplementation jaxrs;
    private static final WriterInterceptor writerInterceptor = new WriterInterceptor(){

        public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
            WriterInterceptor writerInterceptor = (WriterInterceptor)context.getProperty(ISession.WRITER_INTERCEPTOR);
            if (writerInterceptor == null) {
                context.proceed();
                return;
            }
            context.removeProperty(ISession.WRITER_INTERCEPTOR);
            writerInterceptor.aroundWriteTo(context);
        }
    };
    private static final ClientRequestFilter filter = new ClientRequestFilter(){

        public void filter(ClientRequestContext requestContext) throws IOException {
            Marker marker = (Marker)requestContext.getProperty(ISession.LOG_HEADERS_MARKER);
            if (marker == null) {
                return;
            }
            Logger logger = (Logger)requestContext.getProperty(ISession.LOG_HEADERS_LOGGER);
            requestContext.removeProperty(ISession.LOG_HEADERS_MARKER);
            requestContext.removeProperty(ISession.LOG_HEADERS_LOGGER);
            StringBuilder msg = new StringBuilder(requestContext.getMethod());
            msg.append(' ').append(requestContext.getUri());
            msg.append(" with").append(requestContext.hasEntity() ? "" : "no").append(" entity and headers:");
            for (String key : requestContext.getHeaders().keySet()) {
                String value = oracle.cloudstorage.api.header.Map.mask(key, requestContext.getHeaderString(key));
                msg.append("\n    ").append(key).append(':').append(value);
            }
            logger.trace(marker, "{}", (Object)msg);
        }
    };
    private static final ClientRequestFilter contentTypeRemover = new ClientRequestFilter(){

        public void filter(ClientRequestContext requestContext) throws IOException {
            if (!Method.post.name().equalsIgnoreCase(requestContext.getMethod())) {
                return;
            }
            if (requestContext.getProperty(SendableInvocationAdapter.OPCS_POST) != null) {
                requestContext.setEntity(null);
                requestContext.getHeaders().remove((Object)Header.contentType.key);
            }
            requestContext.removeProperty(SendableInvocationAdapter.OPCS_POST);
        }
    };
    private static final IJaxrsImplementation defaultImplementation = new IJaxrsImplementation(){

        @Override
        public void applyTransferEncoding(Invocation.Builder builder, int chunk) {
            if (chunk > -2) {
                builder.header(Header.transferEncoding.key, Header.transferEncoding.provide().getValue());
            }
        }

        @Override
        public void applyTimeouts(Invocation.Builder builder, int connect, int read) {
        }
    };

    public SendableInvocationAdapter(Logger sendableLogger, Marker marker, IClientProvider clientProvider, ISendable sendable) {
        this(null, sendableLogger, marker, clientProvider, sendable);
    }

    public SendableInvocationAdapter(IJaxrsImplementation jaxrs, Logger senableLogger, Marker marker, IClientProvider clientProvider, ISendable sendable) {
        this.jaxrs = jaxrs == null ? defaultImplementation : jaxrs;
        this.sendableLogger = senableLogger;
        this.marker = marker;
        this.clientProvider = clientProvider;
        this.sendable = sendable;
        String url = sendable.getUrl().toString();
        Map queryParams = sendable.getQueryParams();
        WebTarget target = clientProvider.getClient().target(url);
        for (String key : queryParams.keySet()) {
            List values = (List)queryParams.get(key);
            if (values == null || values.isEmpty()) {
                target = target.queryParam(key, new Object[0]);
                continue;
            }
            for (String value : values) {
                target = target.queryParam(key, new Object[]{value});
            }
        }
        this.builder = target.request();
    }

    public Invocation adapt() {
        Client client = this.getClient();
        this.addClientInterceptors(client);
        this.applyTransferEncoding();
        this.applyTimeouts();
        this.registerHeaderLogging();
        this.md5Listener();
        java.util.Map<String, List<Object>> headers = this.sendable.getHeaders().split();
        for (String key : headers.keySet()) {
            List<Object> values = headers.get(key);
            if (values.isEmpty()) {
                this.builder.header(key, (Object)"");
            }
            for (Object value : headers.get(key)) {
                this.builder.header(key, (Object)(value == null ? "" : value.toString()));
            }
        }
        Method method = this.sendable.getMethod();
        String methodName = method.name().toUpperCase();
        Invocation invocation = null;
        if (method == Method.put || method == Method.post) {
            String requestedContentType = this.sendable.getHeaders().get(Header.contentType);
            String contentType = requestedContentType == null ? "*/*" : requestedContentType;
            IContent content = this.sendable.getContent();
            if (content == null) {
                content = new Content();
            }
            content.prepareForRead();
            InputStream inputStream = content.getInputStream();
            Entity entity = Entity.entity((Object)inputStream, (String)contentType);
            String value = method == Method.post && requestedContentType == null ? OPCS_POST : null;
            this.builder.property(OPCS_POST, (Object)value);
            invocation = this.builder.build(methodName, entity);
        } else {
            invocation = this.builder.build(methodName);
        }
        return invocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addClientInterceptors(Client client) {
        Client client2 = client;
        synchronized (client2) {
            if (client.getConfiguration().getInstances().contains(filter)) {
                return;
            }
            client.register((Object)filter);
            client.register((Object)writerInterceptor);
            client.register((Object)contentTypeRemover);
        }
    }

    protected void applyTransferEncoding() {
        int chunk = this.sendable.getChunk();
        this.jaxrs.applyTransferEncoding(this.builder, chunk);
    }

    protected void applyTimeouts() {
        int connect = this.sendable.getConnectTimeout();
        int read = this.sendable.getReadTimeout();
        this.jaxrs.applyTimeouts(this.builder, connect, read);
    }

    protected void registerHeaderLogging() {
        if (!this.sendableLogger.isTraceEnabled(this.marker)) {
            return;
        }
        this.builder.property(ISession.LOG_HEADERS_LOGGER, (Object)this.sendableLogger);
        this.builder.property(ISession.LOG_HEADERS_MARKER, (Object)this.marker);
    }

    protected void md5Listener() {
        Future<String> futureMd5;
        Future<String> future = futureMd5 = this.sendable.getContent() == null ? null : this.sendable.getContent().getFutureMd5();
        if (futureMd5 == null) {
            return;
        }
        this.builder.property(ISession.WRITER_INTERCEPTOR, (Object)new WriterInterceptor(){

            public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
                Md5OutputStream md5er = new Md5OutputStream(context.getOutputStream(), futureMd5);
                context.setOutputStream((OutputStream)md5er);
                context.proceed();
            }
        });
    }

    @Override
    public Client getClient() {
        return this.clientProvider.getClient();
    }
}

