/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.head;

import java.util.List;
import java.util.Map;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.head.HeadAccountReply;
import oracle.cloudstorage.api.head.HeadContainerReply;
import oracle.cloudstorage.api.head.HeadObjectReply;
import oracle.cloudstorage.api.head.HeadRequestProcessor;
import oracle.cloudstorage.api.head.IHeadAccountReply;
import oracle.cloudstorage.api.head.IHeadContainerReply;
import oracle.cloudstorage.api.head.IHeadObjectReply;
import oracle.cloudstorage.api.request.processor.IProcessorFactory;
import oracle.cloudstorage.api.request.processor.IRequestProcessor;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.ScopedRequestProcessor;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.text.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadSendableProcessor
extends HeadRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(HeadSendableProcessor.class);

    public HeadSendableProcessor(IProcessorFactory processorFactory) {
        super(processorFactory);
    }

    @Override
    public IHeadAccountReply account() throws RetryException {
        ScopedRequestProcessor<IRequestBuilder, IHeadAccountReply> processor = new ScopedRequestProcessor<IRequestBuilder, IHeadAccountReply>((IRequestProcessor)this){

            @Override
            protected IResponse executeRequest(IRequestBuilder request) {
                IResponse response = HeadSendableProcessor.this.send(logger, Marker.head.and(Marker.jaxrs), this.getSendable());
                return response;
            }

            @Override
            protected IHeadAccountReply buildReply(IResponse response, IReply.Context context) {
                Map<String, List<Object>> headers = response.getHeaders();
                int statusCode = response.getStatus();
                String message = response.getErrorContent();
                HeadAccountReply reply = new HeadAccountReply(headers, statusCode, message, context);
                return reply;
            }
        };
        IHeadAccountReply reply = (IHeadAccountReply)processor.execute(this.getBuilder());
        return reply;
    }

    @Override
    public IHeadContainerReply container() throws RetryException {
        ScopedRequestProcessor<IRequestBuilder, IHeadContainerReply> processor = new ScopedRequestProcessor<IRequestBuilder, IHeadContainerReply>((IRequestProcessor)this){

            @Override
            protected IResponse executeRequest(IRequestBuilder request) {
                IResponse response = HeadSendableProcessor.this.send(logger, Marker.head.and(Marker.jaxrs), this.getSendable());
                return response;
            }

            @Override
            protected IHeadContainerReply buildReply(IResponse response, IReply.Context context) {
                Map<String, List<Object>> headers = response.getHeaders();
                int statusCode = response.getStatus();
                String message = response.getErrorContent();
                HeadContainerReply reply = new HeadContainerReply(headers, statusCode, message, context);
                return reply;
            }
        };
        IHeadContainerReply reply = (IHeadContainerReply)processor.execute(this.getBuilder());
        return reply;
    }

    @Override
    public IHeadObjectReply object() throws RetryException {
        ScopedRequestProcessor<IRequestBuilder, IHeadObjectReply> processor = new ScopedRequestProcessor<IRequestBuilder, IHeadObjectReply>((IRequestProcessor)this){

            @Override
            protected IResponse executeRequest(IRequestBuilder request) {
                IResponse response = HeadSendableProcessor.this.send(logger, Marker.head.and(Marker.jaxrs), this.getSendable());
                return response;
            }

            @Override
            protected IHeadObjectReply buildReply(IResponse response, IReply.Context context) {
                Map<String, List<Object>> headers = response.getHeaders();
                int statusCode = response.getStatus();
                String message = response.getErrorContent();
                HeadObjectReply reply = new HeadObjectReply(headers, statusCode, message, context);
                return reply;
            }
        };
        IHeadObjectReply reply = (IHeadObjectReply)processor.execute(this.getBuilder());
        return reply;
    }
}

