/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.storage.internal;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import oracle.cloud.storage.CloudStorageConfig;
import oracle.cloud.storage.spi.CloudStorageAuthenticationProvider;
import oracle.cloud.storage.spi.CloudStorageReAuthenticationProvider;

final class TokenAuthFilter
extends ClientFilter {
    private static final String AUTH_HEADER = "X-Auth-Token";
    private final String token;
    private CloudStorageAuthenticationProvider provider;
    private Client client;
    private CloudStorageConfig config;

    public TokenAuthFilter(String token) {
        this.token = token;
    }

    public TokenAuthFilter(String token, CloudStorageAuthenticationProvider provider, Client client, CloudStorageConfig config) {
        this.token = token;
        this.provider = provider;
        this.client = client;
        this.config = config;
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        ClientResponse crs;
        if (!cr.getMetadata().containsKey((Object)AUTH_HEADER)) {
            cr.getMetadata().add((Object)AUTH_HEADER, (Object)this.token);
        }
        if ((crs = this.getNext().handle(cr)).getClientResponseStatus() == ClientResponse.Status.UNAUTHORIZED && this.provider instanceof CloudStorageReAuthenticationProvider) {
            this.client.removeFilter((ClientFilter)this);
            ((CloudStorageReAuthenticationProvider)((Object)this.provider)).reauthenticate(this.client, this.config, cr);
            return this.getNext().handle(cr);
        }
        return crs;
    }
}

