/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.Base64;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Attachments {
    @JsonProperty(value="content")
    private String content;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="filename")
    private String filename;
    @JsonProperty(value="disposition")
    private String disposition;
    @JsonProperty(value="content_id")
    private String contentId;

    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="filename")
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @JsonProperty(value="disposition")
    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    @JsonProperty(value="content_id")
    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    @JsonIgnoreType
    public static class Builder {
        private static final int BYTE_BUFFER_SIZE = 4096;
        private String fileName;
        private String content;
        private String type;
        private String disposition;
        private String contentId;

        public Builder(String fileName, InputStream content) {
            if (fileName == null) {
                throw new IllegalArgumentException("File name mustn't be null");
            }
            if (content == null) {
                throw new IllegalArgumentException("Content mustn't be null");
            }
            this.fileName = fileName;
            this.content = this.encodeToBase64(content);
        }

        public Builder(String fileName, String content) {
            if (fileName == null) {
                throw new IllegalArgumentException("File name mustn't be null");
            }
            if (content == null) {
                throw new IllegalArgumentException("Content mustn't be null");
            }
            this.fileName = fileName;
            this.content = content;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String encodeToBase64(InputStream content) {
            int read = 0;
            byte[] bytes = new byte[4096];
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                while ((read = content.read(bytes)) != -1) {
                    baos.write(bytes, 0, read);
                }
                String string = Base64.encodeBase64String((byte[])baos.toByteArray());
                return string;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to convert content stream to base 64 encoded string", e);
            }
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withDisposition(String disposition) {
            this.disposition = disposition;
            return this;
        }

        public Builder withContentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public Attachments build() {
            Attachments attachments = new Attachments();
            attachments.setContent(this.content);
            attachments.setFilename(this.fileName);
            attachments.setDisposition(this.disposition);
            attachments.setContentId(this.contentId);
            attachments.setType(this.type);
            return attachments;
        }
    }
}

