/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.Query;
import org.opengion.hayabusa.db.QueryFactory;
import org.opengion.hayabusa.resource.UserInfo;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TransactionTag;

public class UserInfoTag
extends CommonTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    public static final String CMD_SET = "SET";
    public static final String CMD_GET = "GET";
    public static final String CMD_REMOVE = "REMOVE";
    public static final String CMD_SQL = "SQL";
    public static final String CMD_NVLGET = "NVLGET";
    private static final String[] COMMAND_LIST = new String[]{"SET", "GET", "NVLGET", "REMOVE", "SQL"};
    private String command = "SET";
    private String key = null;
    private String value = null;
    private transient DBTableModel table = null;
    private String dbid = null;
    private String sql = null;
    private boolean save = false;

    @Override
    public int doStartTag() {
        if (CMD_SQL.equals(this.command)) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doAfterBody() {
        this.sql = this.getBodyString().trim();
        Query query = QueryFactory.newInstance();
        try {
            TransactionTag transactionTag = (TransactionTag)UserInfoTag.findAncestorWithClass((Tag)this, TransactionTag.class);
            Object object = transactionTag == null ? new TransactionReal(this.dbid, this.getApplicationInfo()) : transactionTag.getTransaction();
            query.setTransaction(this.dbid, (Transaction)object);
            query.setResourceManager(this.getResource());
            query.setStatement(this.sql);
            query.execute();
            this.table = query.getDBTableModel();
        }
        finally {
            if (query != null) {
                query.close();
            }
            QueryFactory.close(query);
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.check(this.command, COMMAND_LIST)) {
            this.commandExec(this.command);
            if (CMD_GET.equals(this.command)) {
                this.jspPrint(this.value);
            } else if (CMD_NVLGET.equals(this.command)) {
                this.jspPrint(StringUtil.nval((String)this.value, (String)""));
            }
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.command = CMD_SET;
        this.key = null;
        this.value = null;
        this.table = null;
        this.dbid = null;
        this.sql = null;
        this.save = false;
    }

    protected void commandExec(String string) {
        if (CMD_SQL.equals(string)) {
            this.setSQLAttribute();
        } else if (CMD_SET.equals(string)) {
            this.setAttribute();
        } else if (CMD_GET.equals(string)) {
            this.getAttribute();
        } else if (CMD_NVLGET.equals(string)) {
            this.getAttribute();
        } else if (CMD_REMOVE.equals(string)) {
            this.removeAttribute();
        }
    }

    private void setAttribute() {
        this.setUserInfo(this.key, this.value, this.save);
    }

    private void getAttribute() {
        this.value = this.getUserInfo(this.key);
    }

    private void removeAttribute() {
        UserInfo userInfo = this.getUser();
        userInfo.removeAttribute(this.key);
    }

    private void setSQLAttribute() {
        if (this.table == null || this.table.getRowCount() == 0) {
            return;
        }
        int n = 0;
        int n2 = this.table.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            String string = this.table.getColumnName(i);
            String string2 = (String)this.table.getValue(n, i);
            this.setUserInfo(string, string2, this.save);
        }
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setKey(String string) {
        this.key = this.getRequestParameter(string).toUpperCase(Locale.JAPAN);
        if (this.key.startsWith("USER.")) {
            this.key = this.key.substring(5);
        }
    }

    public void setValue(String string) {
        this.value = this.getRequestParameter(string);
    }

    public void setSave(String string) {
        this.save = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.save);
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("command", (Object)this.command).println("key", (Object)this.key).println("value", (Object)this.value).println("dbid", (Object)this.dbid).println("sql", (Object)this.sql).println("save", (Object)this.save).println("COMMAND_LIST", (Object[])COMMAND_LIST).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

