/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.FileLineModel;
import org.opengion.fukurou.process.FirstProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.HybsFileFilter;
import org.opengion.fukurou.util.LogWriter;

public class Process_FileSearch
extends AbstractProcess
implements FirstProcess,
ChainProcess {
    private Stack<FileListStack> dirs = null;
    private File file = null;
    private HybsFileFilter filter = null;
    private FileLineModel newData = null;
    private int level = 1;
    private String startDir = null;
    private int maxLevel = 256;
    private boolean display = false;
    private int inCount = 0;
    private int outCount = 0;
    private int inPathLen = 0;
    private String outPath = null;
    private static final Map<String, String> mustProparty = new LinkedHashMap<String, String>();
    private static final Map<String, String> usableProparty;

    public Process_FileSearch() {
        super("org.opengion.fukurou.process.Process_FileSearch", mustProparty, usableProparty);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        File file;
        Argument argument = this.getArgument();
        this.startDir = argument.getProparty("start");
        String string = argument.getProparty("inPath");
        if (string != null) {
            this.inPathLen = string.length();
        }
        String string2 = argument.getProparty("prefix");
        String string3 = argument.getProparty("unprefix");
        String string4 = argument.getProparty("suffix");
        String string5 = argument.getProparty("unsuffix");
        String string6 = argument.getProparty("instr");
        String string7 = argument.getProparty("uninstr");
        String string8 = argument.getProparty("equals");
        String string9 = argument.getProparty("notequals");
        String string10 = argument.getProparty("match");
        String string11 = argument.getProparty("unmatch");
        String string12 = argument.getProparty("modify");
        String string13 = argument.getProparty("larger");
        String string14 = argument.getProparty("smaller");
        this.maxLevel = argument.getProparty("maxLevel", this.maxLevel);
        this.outPath = argument.getProparty("outPath");
        boolean bl = argument.getProparty("useLineCnt", false);
        boolean bl2 = argument.getProparty("useDIR", false);
        this.display = argument.getProparty("display", this.display);
        if (this.display) {
            this.println(this.startDir);
        }
        this.filter = new HybsFileFilter(bl2);
        this.filter.startsWith(string2, false);
        this.filter.startsWith(string3, true);
        this.filter.endsWith(string4, false);
        this.filter.endsWith(string5, true);
        this.filter.instr(string6, false);
        this.filter.instr(string7, true);
        this.filter.fileEquals(string8, false);
        this.filter.fileEquals(string9, true);
        this.filter.matches(string10, false);
        this.filter.matches(string11, true);
        this.filter.lastModified(string12);
        if (string13 != null) {
            this.filter.isLarger(Integer.parseInt(string13));
        }
        if (string14 != null) {
            this.filter.isSmaller(Integer.parseInt(string14));
        }
        if ((file = new File(this.startDir)).isDirectory()) {
            this.dirs = new Stack();
            File[] fileArray = file.listFiles(this.filter);
            this.dirs.push(new FileListStack(fileArray, this.level));
        } else {
            this.dirs = new Stack();
            File[] fileArray = new File[]{file};
            this.dirs.push(new FileListStack(fileArray, this.level));
        }
        this.newData = new FileLineModel(bl);
    }

    @Override
    public boolean next() {
        while (!this.dirs.empty()) {
            File[] fileArray;
            FileListStack fileListStack = this.dirs.pop();
            this.level = fileListStack.getLevel();
            if (this.level > this.maxLevel || (fileArray = fileListStack.getFileList()) == null) continue;
            for (int i = fileListStack.getAddress(); i < fileArray.length; ++i) {
                ++this.inCount;
                if (!fileArray[i].isDirectory()) {
                    this.file = fileArray[i];
                    fileListStack.setAddress(i + 1);
                    this.dirs.push(fileListStack);
                    return true;
                }
                File[] fileArray2 = fileArray[i].listFiles(this.filter);
                this.dirs.push(new FileListStack(fileArray2, this.level + 1));
            }
        }
        return false;
    }

    @Override
    public LineModel makeLineModel(int n) {
        ++this.outCount;
        this.newData.setFileVals(this.level, this.file);
        String string = null;
        if (this.inPathLen > 0) {
            string = this.file.getAbsolutePath().substring(this.inPathLen);
        }
        if (this.outPath != null) {
            string = string == null ? this.outPath + this.file.getName() : this.outPath + string;
        }
        if (string != null) {
            this.newData.setBiko(string);
        }
        this.newData.setRowNo(n);
        return this.newData;
    }

    @Override
    public LineModel action(LineModel lineModel) {
        LineModel lineModel2 = null;
        if (!(lineModel instanceof FileLineModel)) {
            String string = "\u30c7\u30fc\u30bf\u304c FileLineModel \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002" + CR;
            throw new RuntimeException(string);
        }
        FileLineModel fileLineModel = (FileLineModel)lineModel;
        File file = fileLineModel.getFile();
        File[] fileArray = file.listFiles(this.filter);
        if (fileArray != null && fileArray.length > 0) {
            lineModel2 = lineModel;
        }
        if (this.display && lineModel2 != null) {
            this.println(lineModel2.dataLine());
        }
        return lineModel2;
    }

    @Override
    public void end(boolean bl) {
        this.dirs = null;
        this.file = null;
        this.filter = null;
        this.newData = null;
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + "\t" + "Start Folder : " + this.startDir + CR + "\t" + "Search Count : " + this.inCount + CR + "\t" + "Output Count : " + this.outCount;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Process_FileSearch \u306f\u3001\u6307\u5b9a\u306e\u30d5\u30a9\u30eb\u30c0\u4ee5\u4e0b\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u4e00\u89a7\u3059\u308b\u3001FirstProcess").append(CR);
        stringBuilder.append("\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u3068\u3001ChainProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u6307\u5b9a\u306e\u6761\u4ef6\u306b\u5408\u81f4\u3059\u308b\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22\u3057\u3001\u30d5\u30a1\u30a4\u30eb\u5c5e\u6027(Level,File,Length,Modify)").append(CR);
        stringBuilder.append("\u3092\u5143\u306b\u3001LineModel\u3092\u4f5c\u6210\u3057\u3001\u4e0b\u6d41\u306b\u6e21\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR);
        stringBuilder.append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("  -start=\u958b\u59cb\u30d5\u30a9\u30eb\u30c0       \uff1a\u691c\u7d22\u3092\u958b\u59cb\u3059\u308b\u30d5\u30a9\u30eb\u30c0                                                         ").append(CR);
        stringBuilder.append("[ -prefix=\u63a5\u982d\u8f9e         ]").append(CR);
        stringBuilder.append("[ -unprefix=\u4e0d\u63a5\u982d\u8f9e     ]").append(CR);
        stringBuilder.append("[ -suffix=\u63a5\u5c3e\u8f9e         ]").append(CR);
        stringBuilder.append("[ -unsuffix=\u4e0d\u63a5\u5c3e\u8f9e     ]").append(CR);
        stringBuilder.append("[ -instr=\u90e8\u5206\u6587\u5b57\u5217      ]").append(CR);
        stringBuilder.append("[ -uninstr=\u4e0d\u90e8\u5206\u6587\u5b57\u5217  ]").append(CR);
        stringBuilder.append("[ -equals=\u4e00\u81f4           ]").append(CR);
        stringBuilder.append("[ -notequals=\u4e0d\u4e00\u81f4      ]").append(CR);
        stringBuilder.append("[ -match=\u6b63\u898f\u8868\u73fe        ]").append(CR);
        stringBuilder.append("[ -unmatch=\u6b63\u898f\u8868\u73fe      ]").append(CR);
        stringBuilder.append("[ -modify=YYYYMMDD       ]  \uff1a\u6307\u5b9a\u65e5\u4ed8\u3051\u4ee5\u964d\u306b\u5909\u66f4\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22").append(CR);
        stringBuilder.append("          YYYYMMDD   : YYYYMMDD \u5f62\u5f0f\u3067\u306e\u6307\u5b9a\u65e5\u306e 00:00:00 \u3092\u57fa\u6e96\u6642\u523b").append(CR);
        stringBuilder.append("          TODAY      : \u5b9f\u884c\u65e5\u306e 00:00:00 \u3092\u57fa\u6e96\u6642\u523b                 ").append(CR);
        stringBuilder.append("          YESTERDAY  : \u5b9f\u884c\u65e5\u524d\u65e5\u306e 00:00:00 \u3092\u57fa\u6e96\u6642\u523b             ").append(CR);
        stringBuilder.append("          LAST_WEEK  : \u5b9f\u884c\u65e5\u306e\u5148\u9031(7\u65e5\u524d) 00:00:00 \u3092\u57fa\u6e96\u6642\u523b      ").append(CR);
        stringBuilder.append("          MONTH      : \u5b9f\u884c\u6708\u306e 1\u65e5 00:00:00 \u3092\u57fa\u6e96\u6642\u523b             ").append(CR);
        stringBuilder.append("          LAST_MONTH : \u5b9f\u884c\u524d\u6708\u306e \u540c\u65e5 00:00:00 \u3092\u57fa\u6e96\u6642\u523b          ").append(CR);
        stringBuilder.append("          LAST_YEAR  : \u5b9f\u884c\u524d\u5e74\u306e \u540c\u6708\u540c\u65e5 00:00:00 \u3092\u57fa\u6e96\u6642\u523b      ").append(CR);
        stringBuilder.append("[ -useDIR=[false/true]   ]  \uff1a").append(CR);
        stringBuilder.append("[ -larger=\u30b5\u30a4\u30ba(KByte)  ]  \uff1a").append(CR);
        stringBuilder.append("[ -smaller=\u30b5\u30a4\u30ba(KByte) ]  \uff1a").append(CR);
        stringBuilder.append("[ -maxLevel=\u6700\u5927\u968e\u5c64\u6570   ]  \uff1a").append(CR);
        stringBuilder.append("[ -useLineCnt=\u884c\u6570\u8a08\u7b97   ]  \uff1a").append(CR);
        stringBuilder.append("[ -inPath=\u5165\u529b\u5171\u901a\u30d1\u30b9   ]  \uff1a").append(CR);
        stringBuilder.append("[ -outPath=\u51fa\u529b\u8ffd\u52a0\u30d1\u30b9  ]  \uff1a").append(CR);
        stringBuilder.append("[ -display=[false/true]  ]  \uff1a").append(CR);
        stringBuilder.append(CR).append(CR);
        stringBuilder.append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_FileSearch().usage());
    }

    static {
        mustProparty.put("start", "\u691c\u7d22\u3092\u958b\u59cb\u3059\u308b\u30d5\u30a9\u30eb\u30c0(\u5fc5\u9808)");
        usableProparty = new LinkedHashMap<String, String>();
        usableProparty.put("prefix", "File\uff65\uff65\uff65\uff65,View\uff65\uff65\uff65\uff65,\u306a\u3069\u3001\u6307\u5b9a\u306e\u63a5\u982d\u8f9e\u3067\u59cb\u307e\u308b\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22");
        usableProparty.put("unprefix", "File\uff65\uff65\uff65\uff65,View\uff65\uff65\uff65\uff65,\u306a\u3069\u3001\u6307\u5b9a\u306e\u63a5\u982d\u8f9e\u3067\u59cb\u307e\u3089\u306a\u3044\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22");
        usableProparty.put("suffix", ".txt,.java,.jsp.... \u306a\u3069\u3001\u6307\u5b9a\u306e\u63a5\u5c3e\u8f9e\u3067\u7d42\u308f\u308b\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22");
        usableProparty.put("unsuffix", ".txt,.java,.jsp.... \u306a\u3069\u3001\u6307\u5b9a\u306e\u63a5\u5c3e\u8f9e\u3067\u7d42\u308f\u3089\u306a\u3044\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22");
        usableProparty.put("instr", "\u30d5\u30a1\u30a4\u30eb\u540d\u3068\u4e00\u81f4\u3059\u308b\u90e8\u5206\u6587\u5b57\u5217\u3092\u6307\u5b9a");
        usableProparty.put("uninstr", "\u30d5\u30a1\u30a4\u30eb\u540d\u3068\u4e00\u81f4\u3057\u306a\u3044\u90e8\u5206\u6587\u5b57\u5217\u3092\u6307\u5b9a");
        usableProparty.put("equals", "\u30d5\u30a1\u30a4\u30eb\u540d\u3068\u4e00\u81f4\u3059\u308b\u6587\u5b57\u5217(\u5927\u6587\u5b57\u5c0f\u6587\u5b57\u306f\u533a\u5225\u3057\u306a\u3044)\u3092\u6307\u5b9a");
        usableProparty.put("notequals", "\u30d5\u30a1\u30a4\u30eb\u540d\u3068\u4e00\u81f4\u3057\u306a\u3044\u6587\u5b57\u5217(\u5927\u6587\u5b57\u5c0f\u6587\u5b57\u306f\u533a\u5225\u3057\u306a\u3044)\u3092\u6307\u5b9a");
        usableProparty.put("match", "\u30d5\u30a1\u30a4\u30eb\u540d\u3068\u4e00\u81f4\u3059\u308b\u6b63\u898f\u8868\u73fe\u3092\u6307\u5b9a");
        usableProparty.put("unmatch", "\u30d5\u30a1\u30a4\u30eb\u540d\u3068\u4e00\u81f4\u3057\u306a\u3044\u6b63\u898f\u8868\u73fe\u3092\u6307\u5b9a");
        usableProparty.put("modify", "\u6307\u5b9a\u65e5\u4ed8\u3051\u4ee5\u964d\u306b\u5909\u66f4\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22" + CR + "YYYYMMDD   : YYYYMMDD \u5f62\u5f0f\u3067\u306e\u6307\u5b9a\u65e5\u306e 00:00:00 \u3092\u57fa\u6e96\u6642\u523b" + CR + "TODAY      : \u5b9f\u884c\u65e5\u306e 00:00:00 \u3092\u57fa\u6e96\u6642\u523b" + CR + "YESTERDAY  : \u5b9f\u884c\u65e5\u524d\u65e5\u306e 00:00:00 \u3092\u57fa\u6e96\u6642\u523b" + CR + "LAST_WEEK  : \u5b9f\u884c\u65e5\u306e\u5148\u9031(7\u65e5\u524d) 00:00:00 \u3092\u57fa\u6e96\u6642\u523b" + CR + "MONTH      : \u5b9f\u884c\u6708\u306e 1\u65e5 00:00:00 \u3092\u57fa\u6e96\u6642\u523b" + CR + "LAST_MONTH : \u5b9f\u884c\u524d\u6708\u306e \u540c\u65e5 00:00:00 \u3092\u57fa\u6e96\u6642\u523b" + CR + "LAST_YEAR  : \u5b9f\u884c\u524d\u5e74\u306e \u540c\u6708\u540c\u65e5 00:00:00 \u3092\u57fa\u6e96\u6642\u523b");
        usableProparty.put("useDIR", "\u5224\u5b9a\u3092\u30d5\u30a1\u30a4\u30eb\u3060\u3051\u3067\u306a\u304f\u3001\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u3082\u884c\u3046\u304b\u3069\u3046\u304b\u3092\u6307\u5b9a\u3002(\u521d\u671f\u5024\uff1afalse)");
        usableProparty.put("larger", "\u30d5\u30a1\u30a4\u30eb\u306e\u5927\u304d\u3055\u304c\u6307\u5b9a\u306e\uff2b\u30d0\u30a4\u30c8\u6570\u3088\u308a\u5927\u304d\u3044\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22");
        usableProparty.put("smaller", "\u30d5\u30a1\u30a4\u30eb\u306e\u5927\u304d\u3055\u304c\u6307\u5b9a\u306e\uff2b\u30d0\u30a4\u30c8\u6570\u3088\u308a\u5c0f\u3055\u3044\u30d5\u30a1\u30a4\u30eb\u3092\u691c\u7d22");
        usableProparty.put("maxLevel", "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u968e\u5c64\u3092\u4e0b\u304c\u308b\u6700\u5927\u6570\u3002(\u521d\u671f\u5024\uff1a256)");
        usableProparty.put("useLineCnt", "\u30d5\u30a1\u30a4\u30eb\u306e\u884c\u6570\u3092\u30ab\u30a6\u30f3\u30c8\u3059\u308b\u304b\u3069\u3046\u304b\u3092\u6307\u5b9a\u3002(\u521d\u671f\u5024\uff1afalse)");
        usableProparty.put("inPath", "BIKO\u4f5c\u6210\u7528\u306e\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9\u304b\u3089\u524a\u9664\u3059\u308b\u90e8\u5206(\u6587\u5b57\u6570\u306e\u307f)");
        usableProparty.put("outPath", "BIKO\u4f5c\u6210\u7528\u306e\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9\u306b\u8ffd\u52a0\u3059\u308b\u90e8\u5206");
        usableProparty.put("display", "true\u306f\u3001\u691c\u7d22\u72b6\u6cc1\u3092\u8868\u793a\u3057\u307e\u3059\u3002(\u521d\u671f\u5024\uff1afalse)");
    }

    private static final class FileListStack {
        private int address;
        private final File[] files;
        private final int level;

        FileListStack(File[] fileArray, int n) {
            this.files = fileArray;
            this.address = 0;
            this.level = n;
        }

        void setAddress(int n) {
            this.address = n;
        }

        int getAddress() {
            return this.address;
        }

        File[] getFileList() {
            return this.files;
        }

        int getLevel() {
            return this.level;
        }
    }
}

