/////////////////////////////////////////////
///// NOA からの継承値 /////////////////////////

// NOA 組込みの場合は patient_id() などを直接取得できるが
// 外付けツールにも出来るようあえて以下の仕組みを使う

function noa(){
    if (window.opener.name == "noa"){
        return window.opener;
    } else if (window.opener.name == "tools"){
        return window.opener.top.noa;
    } else {
        alert("ERROR *** tools.js: window.opener としての NOA が見つかりません");
        return null;
    }
}

function owner(){
	return noa().owner();
}

function code(){
    // NOA から送られたコード番号
    return document.getElementById("_code").value;    
}

///// NOA からの継承値 /////////////////////////
/////////////////////////////////////////////

///////////////////////////
/// Ajax による処理 /////////

function gl_searched(){
	// サーバから返された処理を実行
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("gl_searched ===\n"+value);//##
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			var records = JSON.parse(array[1]);
            //alert("records->"+encodeObject(records));//##
            
			setRecords(records);
			showResult(records);
		}
		hideMessage("_message");
	} else
		showMessage("_message", "サーバで処理中です ...");
}
function gl_search(){
	// 検索キーによりデータを検索
    var code = keyCode();
    var name = document.getElementById("nameF").value;
	if (code.length + name.length == 0){
		alert("検索キーが指定されていません");
		return;
	}
	
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(gl_searched);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["code"] = code;
		array["name"] = name;
		
		var st = "vinServer.php?command=GET_GLOBAL_PRICE"
		+ "&value=" + encodeSTRING(encodeObject(array));
		//alert(st); //return; //===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function gl_puttedRecord(){
	// サーバから返された処理を実行
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("gl_puttedRecord ->"+value);//##
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            var obj = JSON.parse(array[1]);

            //alert("gl_puttedRecord->"+encodeObject(obj)); //##
            
            closeFloatPanel();
            
            // PriceList 確認パネル表示
            gl_showRecord(obj);
		}
		hideMessage("_message");
	} else
		showMessage("_message", "サーバで処理中です ...");
}
function gl_putRecord(){
    // レコードを PriceList へ追加
    var obj = recordAtIndex(currentRow());
    //alert("gl_putRecord->"+currentRow()+"->"+encodeObject(obj)); //##
    
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(gl_puttedRecord);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var st = "vinServer.php?command=PUT_PRICE_LIST"
		+ "&value=" + encodeSTRING(encodeObject(obj));
		//alert(st); //return; //===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function gl_verified(){
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
        //alert("gl_verified:\n"+value);//##
        
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            var rec = JSON.parse(array[1]);
            if (rec.alias){
                //alert("gl_verified->"+encodeObject(rec));//##
                alert(rec.alias + " は既に存在します。重複しない alias をローマ字で入れてください");
            } else {
                gl_putRecord();
            }
		}
	}
}
function gl_verify(code, alias){
    // obj.alias がユニークかどうか検証    
    //xmlHttpObject = createXMLHttpRequest(NR_debug);
	xmlHttpObject = createXMLHttpRequest(gl_verified);
	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
		var array = new Array();
		array["code"] = code;
		array["alias"] = alias;

		var st = "./vinServer.php?command=GET_PRICE_LIST"
		+ "&value=" + encodeSTRING(encodeObject(array));
		//alert("gl_verify->"+st); //return; //===
        
		xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

/// Ajax による処理 /////////
///////////////////////////

var _records;
function setRecords(array){
	// 読込まれたレコードを記憶
	_records = array;
}
function records(){
	return _records;
}
function recordAtIndex(num){
	return _records[num];
}

var _currentRow;
function setCurrentRow(row){
    _currentRow = row;
}
function currentRow(){
    // 現在編集中の行を返す
    return _currentRow;
}

var _keyCode;
function setKeyCode(cd){
    _keyCode = cd.substr(0, 1);
}
function keyCode(){
    // 検索用コード
    if (! _keyCode){
        // NOA の code:22 は Global master の code:21 に相当したりするので
        // １桁目の数値だけを検索対象とする
        _keyCode = code().substr(0, 1);
    }
    return _keyCode;
}



function gl_showRecord(obj){
    // PriceList 確認パネル表示
	var elm = document.getElementById("_floatPanel");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "base-table");
    tbl.style.margin = "10px 10px";
	
	var tr = newTR(tbl, "", "コード");
	var td = newTD(tr, "", obj.code);
	
	var tr = newTR(tbl, "", "請求コード");
	var td = newTD(tr, "", obj.requestCode);
	
	var tr = newTR(tbl, "", "alias");
	var td = newTD(tr, "", obj.alias);
	
	var tr = newTR(tbl, "", "名称");
	var td = newTD(tr, "", obj.name);
	
	var tr = newTR(tbl, "", "ジェネリック");
	var td = newTD(tr, "", obj.generic);
	
	var tr = newTR(tbl, "", "点数");
	var td = newTD(tr, "", obj.point);
	
	if (obj.unitName){
		var tr = newTR(tbl, "", "単位");
		var td = newTD(tr, "", obj.unitName);
	}
	
	if (obj.effectCode){
		var tr = newTR(tbl, "", "薬効コード");
		var td = newTD(tr, "", obj.effectCode);
	}
	
	if (obj.handanCode && obj.handanCode * 1){
		var tr = newTR(tbl, "", "判断料");
		// handanCode から handan を生成
		obj.handan = handan(obj.handanCode);
		var td = newTD(tr, "", obj.handan);
	}
    
	var tr = newTR(tbl, "", "薬効");
	var td = newTD(tr, "", obj.effect);
	
	var tr = newTR(tbl, "", "メモ");
	var td = newTD(tr, "", obj.memo);

	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "PriceList に登録しました");
	td.setAttribute("colspan", "2");
    td.style.textAlign = "center";
	td.style.color = "#930";
	
	openFloatPanel(tbl, 30, 20, "PriceList 確認パネル");
}

function putPriceList(row){
    // レコード・オブジェクトを PriceList へ追加
	var obj = recordAtIndex(row);
    obj.alias = document.getElementById("aliasF").value;
    obj.generic = document.getElementById("genericF").value;
    obj.effect = document.getElementById("effectF").value;
    obj.memo = document.getElementById("memoF").value;
    
    if (obj.alias.length == 0){
        alert("alias にユニークな名称をローマ字で入れてください");
        return;
    }
    
    // obj.alias がユニークかどうか検証
    gl_verify(obj.code, obj.alias);
}
function clickedRow(row){
	// row 行のレコードを返送するかどうか確認パネル
    setCurrentRow(row); // 現在行を記憶
	var obj = recordAtIndex(row);
	//alert(encodeObject(obj)); //##
    
	var elm = document.getElementById("_floatPanel");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "base-table");
    tbl.style.margin = "10px 10px";
	
	var tr = newTR(tbl, "", "コード");
	var td = newTD(tr, "", code()); // NOA から送られたコードを使う
	
	var tr = newTR(tbl, "", "請求コード");
	var td = newTD(tr, "", obj.requestCode);
	
	var tr = newTR(tbl, "", "alias");
	var td = newTD(tr, "", "");
    var fd = newFIELD(td, "aliasF", "", 40, "");
    fd.setAttribute("placeholder", "ID の役割をするローマ字名称"); // 入力ヒントを表示
	
	var tr = newTR(tbl, "", "名称");
	var td = newTD(tr, "", obj.name);
	
	var tr = newTR(tbl, "", "ジェネリック");
	var td = newTD(tr, "", "");
    var fd = newFIELD(td, "genericF", "", 40, "");
    fd.setAttribute("placeholder", "後発医薬品があればその名称"); // 入力ヒントを表示
	
	var tr = newTR(tbl, "", "点数");
	var td = newTD(tr, "", obj.point);
	
	if (obj.unitName){
		var tr = newTR(tbl, "", "単位");
		var td = newTD(tr, "", obj.unitName);
	}
	
	if (obj.effectCode){
		var tr = newTR(tbl, "", "薬効コード");
		var td = newTD(tr, "", obj.effectCode);
	}
	
	if (obj.handanCode && obj.handanCode * 1){
		var tr = newTR(tbl, "", "判断料");
		// handanCode から handan を生成
		obj.handan = handan(obj.handanCode);
		var td = newTD(tr, "", obj.handan);
	}
    
	var tr = newTR(tbl, "", "薬効");
	var td = newTD(tr, "", "");
    var fd = newFIELD(td, "effectF", "", 40, "");
    fd.setAttribute("placeholder", "抗生剤 胃炎など：絞込みに使われる"); // 入力ヒントを表示
	
	var tr = newTR(tbl, "", "メモ");
	var td = newTD(tr, "", "");
    var fd = newFIELD(td, "memoF", "", 40, "");
    fd.setAttribute("placeholder", "NOA では使われない：管理者用メモ"); // 入力ヒントを表示
	
	var tr = newTR(tbl, "", " ");
	var td = newTD(tr, "", "このレコードを PriceList へ ");
	td.style.textAlign = "right-side";
	td.style.color = "#930";
	var bt = newBUTTON(td, "", "転記");
	var action = "putPriceList('" + row + "')"
	bt.setAttribute("onclick", action);
	
	openFloatPanel(tbl, 30, 20, "確認パネル");
	
	function handan(code){
		// handanCode から判断料を返す
		switch (code * 1){
			case 1: return "尿";
			case 2: return "血";
			case 3: return "生1";
			case 4: return "生2";
			case 5: return "免";
			case 6: return "微";
			case 7: return "病";
			default: return "";
		}
	}
}

function showResult(){
    // グローバル辞書での検索結果をリストアップ
	var elm = document.getElementById("resultArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "");
    tbl.style.width = "100%";
    tbl.style.fontSize = "10pt";
	
	// title
	var tr = newTR(tbl, "", "");
	tr.style.backgroundColor = "#bfc";
	var td = newTD(tr, "/listTitle", "コード");
	var td = newTD(tr, "/listTitle", "requestCode");
	var td = newTD(tr, "/listTitle", "項目名");
	var td = newTD(tr, "/listTitle", "点数");
	var td = newTD(tr, "/listTitle", "単位");
	var td = newTD(tr, "/listTitle", "判断コード");
	var td = newTD(tr, "/listTitle", "effectCode");
	var td = newTD(tr, "/listTitle", "enforceDate");
	
	// records
    for (num in records()){
		var obj = records()[num];
		var tr = newTR(tbl, "/oddColor", "");
		var td = newTD(tr, "", obj.code);
		var td = newTD(tr, "", obj.requestCode);
		var td = newTD(tr, "/listRow", obj.name);
		td.setAttribute("onclick", "clickedRow('" + num + "')");
		var td = newTD(tr, "", obj.point);
		var td = newTD(tr, "", obj.unitName);
		var td = newTD(tr, "", obj.handanCode);
		var td = newTD(tr, "", obj.effectCode);
		var td = newTD(tr, "", obj.enforceDate);
	}
}

function makeContentsArea(elm){
    // コンテンツ部分を生成
	elm.innerHTML = "";
    elm.style.fontSize = "10pt";
    
	// コメント
    var div = newDIV(elm, "");
    div.style.padding = "5px";
    div.style.color = "#b33"; // brown
	div.innerHTML = "　グローバル辞書は「厚労省マスター」などから作成された辞書、PriceList は個人用辞書です。NOA は PriceList しか使いませんが、そこにない処置・検査・薬剤などをグローバル辞書から PriceList へコピーして使える仕組みになっています。";
    
    // 検索エリア
    var div = newDIV(elm, "tool-bar");
    div.style.paddingLeft = "10px";
    
    var sp = newSPAN(div, "");
    sp.style.padding = "0 10px";
    sp.innerHTML = codeName(code()); // vin.js

    // 検索フィールド
	var fd = newFIELD(div, "nameF", "名前（部分一致検索） ", 20, "");
	fd.setAttribute("onchange","gl_search()");
	fd.focus();
    
    // 検索ボタン
	var bt = newBUTTON(div, "", "検索");
	bt.setAttribute("onclick","gl_search()");
    
    // 検索結果エリア
    var div = newDIV(elm, "resultArea");
}

function openPliceList(){
    // PriceList を開く
	window.open("../NOAManager/priceList.php?mode=NOA","PriceList");
}

function initGlobalList(){
	var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    // HEADER
    var div = newDIV(elm, "tool-header");
    var dv = newDIV(div, "left-side");
    dv.innerHTML = "グローバル辞書　owner ( "+ owner() + " ) code ( " + code() + " )";
    
    // CONTENTS
    var div = newDIV(elm, "contentsArea");
    makeContentsArea(div);
    
    // FOOTER
    var div = newDIV(elm, "tool-footer");
    var dv = newDIV(div, "right-side");
    // PriceList へのアンカー
    var sp = newSPAN(dv, "");
    var a = newA(sp, "PriceList", "#", "");
    a.setAttribute("onclick", "openPliceList()"); 
    // version
    var sp = newSPAN(dv, "");
    sp.style.paddingLeft = "10px";
    sp.innerHTML = gl_version();
}

function gl_version(){
    return "Ver.130515";
}

