
var _currentRow;
function setCurrentRow(row){
    _currentRow = row;
}
function currentRow(){
    // 現在選択されている行を返す
    return _currentRow;
}

function remakePrefixMenus(){
    // 接頭語リストを再表示
    var elm = document.getElementById("prefixPopArea");
    elm.innerHTML = "";
    
    var pu = newPopupMenu(elm, "prefixPop", prefixMenus(), "");
    pu.setAttribute("onchange", "prefixPopupChanged(this)");
}
function addedPrefixMenu(answer){
   var obj = JSON.parse(answer);
    setPrefixMenus(obj);
    
    // 接頭語リストを再表示
    remakePrefixMenus();
}
function addPrefixMenu(){
    // 接頭語メニューに item を新規追加
    var item = prompt("新規に追加するメニュー項目");
    if (item.length > 0){
        // item をサーバへ登録するために incrementFrequency() を使う
        NRPutMenu(owner(), _prefix, item, "", "", addedPrefixMenu);
    }
}

function removedPrefixMenu(answer){
    var obj = JSON.parse(answer);
    setPrefixMenus(obj);
    
    // 接頭語リストを再表示
    remakePrefixMenus();
}
function removePrefixMenu(){
    // 選択された接頭語をメニューから削除
    var item = document.getElementById("prefixPop").value;
    
    if (item == "") return;
    if (item == "...その他") return;
    if (confirm(item + " をメニューから削除していいですか"))
        NRRemoveMenu(owner(), _prefix, item, "", removedPrefixMenu);
}

function remakeSuffixMenus(){
    // 接尾語リストを再表示
    var elm = document.getElementById("suffixPopArea");
    elm.innerHTML = "";
    
    var pu = newPopupMenu(elm, "suffixPop", suffixMenus(), "");
    pu.setAttribute("onchange", "suffixPopupChanged(this)");
}
function addedSuffixMenu(answer){
    var obj = JSON.parse(answer);
    setSuffixMenus(obj);
    
    // 接尾語リストを再表示
    remakeSuffixMenus();
}
function addSuffixMenu(){
    // 接尾語メニューに item を新規追加
    var item = prompt("新規に追加するメニュー項目");
    if (item.length > 0){
        // item をサーバへ登録するために incrementFrequency() を使う
        NRPutMenu(owner(), _suffix, item, "", "", addedSuffixMenu);
    }
}

function removedSuffixMenu(answer){
    var obj = JSON.parse(answer);
    setSuffixMenus(obj);
    
    // 接尾語リストを再表示
    remakeSuffixMenus();
}
function removeSuffixMenu(){
    // 選択された接尾語をメニューから削除
    var item = document.getElementById("suffixPop").value;
    
    if (item == "") return;
    if (item == "...その他") return;
    if (confirm(item + " をメニューから削除していいですか"))
        NRRemoveMenu(owner(), _suffix, item, "", removedSuffixMenu);
}

function remakeMenus(){
    // 病名リストを再表示
    var elm = document.getElementById("menuPopArea");
    elm.innerHTML = "";
    
    var pu = newPopupMenu(elm, "namePop", diseaseMenus(), "");
    pu.setAttribute("onchange", "diseasePopupChanged(this)");
}
function addedMenu(answer){
    var obj = JSON.parse(answer);
    setMenus(obj);
    
    // 病名リストを再表示
    remakeMenus();
}
function addMenu(){
    // 病名メニューに item を新規追加
    var item = prompt("新規に追加するメニュー項目");
    if (item.length > 0){
        // item をサーバへ登録するために incrementFrequency() を使う
        NRPutMenu(owner(), "ProgressSection.disease", item, "", "", addedMenu);
    }
}

function removedMenu(answer){
    var obj = JSON.parse(answer);
    setMenus(obj);
    
    // 病名リストを再表示
    remakeMenus();
}
function removeMenu(){
    // 選択された病名をメニューから削除
    var item = document.getElementById("namePop").value;
    
    if (item == "") return;
    if (item == "...その他") return;
    if (confirm(item + " をメニューから削除していいですか"))
        NRRemoveMenu(owner(), "ProgressSection.disease", item, "", removedMenu);
}


function setDiseaseAt(row){
    // 編集パネルの結果を _disease へ反映させる
    var rec = _diseases[row];
    rec.start = shortDate(document.getElementById("start").value);
    rec.name = document.getElementById("name").value;
    rec.end = shortDate(document.getElementById("end").value);
    // rec.conclusion は changedConclusion() で更新済み
    
    // エディターを閉じリスト内容を更新
    closeFloatPanel();
    makeRow(row);
    
    // CELL の入力欄（隠しフィールド）に転記
    var elm = elmFor(currentTag() + ".value");
    elm.innerHTML = diseasesToString();
}
function checkKeyDown(row){
    // CTRL-j が入力されたら setDiseaseAt() を実行
    if (window.event.ctrlKey){
        if (window.event.keyCode == 74){ // CTRL-J
            setDiseaseAt(row);
        }
    }
}

function focusPressed(){
    // 絞り込みフィールドでキーが押される度に実行
    var elm = document.getElementById("menuPopArea");
    elm.innerHTML = "";
    
    //_initDebug(true); //##
    
    var key = document.getElementById("focusF").value;
    var pu = newPopupMenu(elm, "namePop", menuItems(diseaseMenus(), key), "");
    pu.setAttribute("onchange", "diseasePopupChanged(this)");
    diseasePopupChanged(pu);
    
    function menuItems(menuArray, key){
        // メニュー・データを表示用にカスタマイズして返す
        //_debug(key+"->"+encodeObject(menuArray)); //##
        
        var array = new Array();
        for (num in menuArray){
            var item = menuArray[num];
            if (item.length == 0) continue;
            
            // key が存在する場合「...その他」は絞込まれたメニューに含めない
            // key が空の場合は初期値にもどるので「...その他」もメニューに含む
            if (key.length && (item == "...その他")) continue;
            
            if (item.indexOf(key) < 0){
                // key に対応する item がなかった：key がアルファベットかも知れない
                // メニューに対応するローマ字は value フィールドに存在
                var romaji = aliasForMenu(item);
                if (romaji && (romaji.length > 0)){
                    // ローマ字が絞り込みキーにマッチしないものはスキップ
                    if (romaji.indexOf(key) < 0) continue;
                }
            }
            array.push(item);
        }
        return array;
    }
}

function diseasePopupChanged(elm){
    // name ポップアップが変更された
    if (elm.value == "...その他"){
        addMenu();
    } else {
        var array = [];
        
        var prefix = elmFor("prefixPop").value;
        if (prefix.length) array.push(prefix);
        
        var name = elm.value;
        array.push(name);
        
        var suffix = elmFor("suffixPop").value;
        if (suffix.length) array.push(suffix);
        
        elmFor("name").value = array.join(" ");
    }
}
function prefixPopupChanged(elm){
    // 接頭語ポップアップが変更された
    if (elm.value == "...その他"){
        addPrefixMenu();
    } else {
        var fd = document.getElementById("name");
        var name = fd.value;
        var array = name.split(" ");
        if (indexOfArray(prefixMenus(), array[0]) >= 0){ // 接頭語＋病名＋[接尾語]
            if (elm.value.length)
                array[0] = elm.value; // 接頭語を置換
            else
                array.shift(); // 接頭語を削除
        } else { // 病名＋[接尾語]
            array.splice(0, 0, elm.value); // 先頭に接頭語を挿入
        }
        fd.value = array.join(" ");
    }
}
function suffixPopupChanged(elm){
    // 接尾語ポップアップが変更された
    if (elm.value == "...その他"){
        addSuffixMenu();
    } else {
        var fd = document.getElementById("name");
        var name = fd.value;
        var array = name.split(" ");
        if (array.length > 2){ // 接頭語＋病名＋接尾語
            array[2] = elm.value;
            fd.value = array.join(" ");
        } else if (array.length > 1){ // 接頭語＋病名 or 病名＋接尾語
            if (indexOfArray(suffixMenus(), array[array.length - 1]) >= 0){
                // 病名＋接尾語
                if (elm.value.length)
                    array[1] = elm.value; // 末尾を接尾語と置換
                else
                    array.pop(); // 末尾を削除
            } else { // 接頭語＋病名
                array[2] = elm.value; // 末尾に接尾語を追加
            }
            fd.value = array.join(" ");
        } else { // 病名に接尾語を追加
            fd.value = name + " " + elm.value;
        }
    }
}

function diseaseEditorHelp(){
	window.open("./diseaseEditorHelp.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function openDiseaseEditor(row, isEndDate){
    // 病名編集ペーンを開く
    //_initDebug(true); //##
    _debug("== openEditor"); //##
    var elm = valueElementForTag(currentDate(), currentTag()); // CELL 位置
    var pos = getPosition(elm);

    var w = 400;
	var x = pos.x; // 表示するx座標
	var y = pos.y - 200; // 表示するy座標
    var title = "病名編集";
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, title, "diseaseEditorHelp()");
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    elm.style.padding = "8px";
    elm.style.color = "#f55";
    var tbl = newTABLE(elm, "/base-table");
    var tr = newTR(tbl, "", "");
    
    var rec = diseaseAt(row);
    var start = (rec) ? rec.start : shortDate(today());
    var names = (rec) ? rec.name : "";
    var end = (rec) ? rec.end : "";
    var conclusion = (rec) ? rec.conclusion : "";
    
    var prefix = "";
    var name = "";
    var suffix = "";
    if (names.length){
        var ary = names.split(" ");
        if (indexOfArray(prefixMenus(), ary[0]) >= 0){
            // ary[0] が接頭語に含まれるなら ary[1] は病名
            prefix = ary[0];
            name = (ary.length > 1) ? ary[1] : "";
        } else {
            name = ary[0];
        }
        if (indexOfArray(suffixMenus(), ary[ary.length - 1]) >= 0){
            // ary[ary.length - 1] が接尾語に含まれるなら
            suffix = ary[ary.length - 1];
        }
    }
    
    // 開始日
    if (trim(start) == ""){
        var array = dateTimeArray(todayAndTime());
        var yyyy = array[0];
        var mm = array[1];
        var dd = array[2];
    } else {
        var yyyy = "20" + start.substr(0, 2);
        var mm = start.substr(2, 2);
        var dd = start.substr(4, 2);
    }
    
    var td = newTD(tr, "", "");
    td.setAttribute("colspan", "5");
    var elm = newDIV(td, "/editorPane");
    
    // 開始日 ---------------
    var div = newDIV(elm, "/clearfix");
    var sp = newSPAN(div, "");
    sp.innerHTML = "開始日 ";
    newDatePopUp(div, "start", "西暦", yyyy, mm, dd, false, null);

    // 病名接頭語 -------------
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "接頭語 ";
    var sp = newSPAN(div, "prefixPopArea");
    var pu = newPopupMenu(sp, "prefixPop", prefixMenus(), prefix);
    pu.setAttribute("onchange", "prefixPopupChanged(this)");
    // 削除アイコン
    var img = newIMAGE(div, "", "./remove-field.png", "remove");
    img.setAttribute("onclick", "removePrefixMenu()");
    img.style.height = "12px";
    img.style.marginLeft = "3px";
    img.style.position = "relative";
    img.style.top = "3px";
    // 病名 ---------------
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "病　名 ";
    var sp = newSPAN(div, "menuPopArea");
    var pu = newPopupMenu(sp, "namePop", diseaseMenus(), name);
    pu.setAttribute("onchange", "diseasePopupChanged(this)");
    var focusF = newFIELD(div, "focusF", "", 10, "");
    focusF.setAttribute("placeholder", "絞込み"); // 入力ヒントを表示
    focusF.setAttribute("onkeyup", "focusPressed()");
    focusF.setAttribute("onkeydown", "checkKeyDown('" + row + "')");

    // 削除アイコン
    var img = newIMAGE(div, "", "./remove-field.png", "remove");
    img.setAttribute("onclick", "removeMenu()");
    img.style.height = "12px";
    img.style.marginLeft = "3px";
    img.style.position = "relative";
    img.style.top = "3px";
    // 病名接尾語 -------------
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "接尾語 ";
    var sp = newSPAN(div, "suffixPopArea");
    var pu = newPopupMenu(sp, "suffixPop", suffixMenus(), suffix);
    pu.setAttribute("onchange", "suffixPopupChanged(this)");
    // 削除アイコン
    var img = newIMAGE(div, "", "./remove-field.png", "remove");
    img.setAttribute("onclick", "removeSuffixMenu()");
    img.style.height = "12px";
    img.style.marginLeft = "3px";
    img.style.position = "relative";
    img.style.top = "3px";
    // 病名欄 ---------------
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "　　　 ";
    var fd = newFIELD(div, "name", "", 40, names);
    
    // 終了日
    if (trim(end) == ""){
        // yyyy は start と同じ年を表示
        // mm は start と同じ月を表示
        var dd = 0;
    } else {
        var yyyy = "20" + end.substr(0, 2);
        var mm = end.substr(2, 2);
        var dd = end.substr(4, 2);
    }
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "終了日 ";
    newDatePopUp(div, "end", "西暦", yyyy, mm, dd, false, null);
    // 転帰
    var array = ["","治癒","中止"];
    _debug("conclusion->"+rec.conclusion); //##
    var pu = newPopupMenu(div, "conclusion", array, rec.conclusion);
    pu.setAttribute("onchange", "changedConclusion(this,'" + row + "')");
    
    // 確定ボタン
    var div = newDIV(elm, "/clearfix");
    div.style.marginTop = "5px";
    // VERSION
    var dv = newDIV(div, "/left-side");
    dv.style.paddingLeft = "0";
    dv.style.width = "50%";
    var sp = newSPAN(dv, "");
    sp.innerHTML = di_version();
    sp.style.fontSize = "9pt";
    sp.style.color = "#888";
    // とりやめ・確定ボタン
    var dv = newDIV(div, "/right-side");
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "とりやめ";
    bt.setAttribute("onclick", "closeFloatPanel()");
    var bt = newDIV(dv, "/fixButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "setDiseaseAt('" + row + "')");
 
    focusF.focus();
}
