
function owner(){
    return "ohashi"; // ### とりあえず決め打ち ###
}

var _groupObj;
function setGroupObj(obj){
    _groupObj = obj;
    
    if (indexOfArray(_groupObj, 'お気に入り') < 0)
        _groupObj.splice(0,0,'お気に入り');
}
function groupObj(){
    // グループオブジェクトを返す
    if (!_groupObj) _groupObj = new Array();
        
    return _groupObj;
}
function addGroupObj(name){
    // name をグループメニューに追加
    groupObj().push(name);
}
function groupMenu(){
    // グループメニューを返す
    var menus = [];
    for (num in groupObj()){
        menus.push(groupObj()[num]);
    }
    menus.push("...その他");
    return menus;
}

////////////////////////////////////////////////////////////////
///// Ajax /////////////////////////////////////////////////////

function puttedGroup(answer){
    //alert("puttedGroup->"+answer); //##
    
    // グループメニューを再読み込み
    getGroupMenu();
}
function putGroupName(name){
    // グループ名 name をサーバへ保存
    addGroupObj(name);
    
    PutGroup(owner(), groupObj(), puttedGroup);
}

function gotGroup(answer){
    if (answer.indexOf("ERROR") == 0){
        showGroupMenu();
    } else {
        var obj = JSON.parse(answer);
        setGroupObj(obj);
        showGroupMenu();
    }
}
function getGroupMenu(){
    // グループメニューをサーバから読み込む
    GetGroup(owner(), gotGroup);
}

function removeGroupMenu(menu){
    // menu をグループメニューから削除
    var num = indexOfArray(_groupObj, menu);
    if (num >= 0){
        _groupObj.splice(num, 1);
        
        PutGroup(owner(), groupObj(), puttedGroup);
    }
}

function moveTo(drop_id, target_node){
    // ドロップされたエレメントをドロップされたターゲット・エレメント位置へ移動
    var target_id = target_node.id;
    if (drop_id == target_node.id) return; // 自分自身は無視
    
    // drop_id の位置と target_id の位置をスワップ
    var menus = [];
    var array = groupObj();
    for (num in array){
        var id = array[num] + ".lid";
        
        // target_node.id の位置に drop_id node を挿入
        if (id == target_node.id){
            var ary = drop_id.split('.');
            drop_menu = ary[0];
            
            menus.push(drop_menu);
        }
        if (id != drop_id)
            menus.push(array[num]);
    }
    //alert("swapped->"+encodeObject(menus)); //##
    
    PutGroup(owner(), menus, puttedGroup);
}

function uploadFileName(){
    // ファイル・セレクターで選択されたファイル名を返す
    var fileSelector = elmFor("imageFile");
    var st = fileSelector.value; // "C:\fakepath\filename.pdf" 型式
    var ary = st.split('\\');
    
    return ary[ary.length - 1];
}

function saved(answer){
    // 保存が確認されたら編集パネルを閉じる
    //alert("saved->"+answer); //##
    
    closeFloatPanel();
    initInfoSack();
    
    showFadeoutInfo("_debug", answer, 1000);
}
function save(command){
    // ファイル情報をサーバへ保存
    var obj = new Object();

    // ファイル ID
    var nodes = document.getElementsByName("fileId"); // NAME では配列が返される
    obj.id = nodes[0].value;
    
    // URL
    obj.url = (elmFor("urlF")) ? elmFor("urlF").value : "";
    
    // ファイルの接尾語
    obj.suffix = elmFor("suffixF").value;
    
    // ラベル
    obj.label = elmFor("labelF").value;
    
    // グループ
    var array = [];
    var menus = groupMenu();
    for (num in menus){
        var menu = menus[num];
        var cbox = elmFor(menu + ".id");
        if (cbox && cbox.checked) array.push(menu);
    }
    obj.group = array.join('^');
    
    if (command == "put"){
        PutInfo(owner(), obj.id, obj, saved);
    } else {
        var filename = obj.id + "." + obj.suffix;
        RemoveInfo(filename, saved);
    }
}

///// Ajax /////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////
///// DRAG and DROP ////////////////////////////////////

function f_dragstart(event){
    // ドラッグ開始時の処理
    // ドラッグするデータのid名をDataTransferオブジェクトにセット
    event.dataTransfer.setData("text", event.target.id);
}

function f_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

function f_drop(event){
    // ドロップ時の処理
    // ドラッグされたデータのid名をDataTransferオブジェクトから取得
    var id_name = event.dataTransfer.getData("text");
    
    //id名からドラッグされた要素を取得
    var drag_elm = document.getElementById(id_name);
    
    if (event.currentTarget.id == "groupLabel"){
        var array = id_name.split('.'); // id_name = "labelName.lid" 形式
        var menu = array[0];
        if (confirm(menu + " を削除していいですか")){
            removeGroupMenu(menu);
        }
    } else {
        //ドロップ先にドラッグされた要素を追加
        moveTo(id_name, event.currentTarget);
    }
    
    //エラー回避のため、ドロップ処理の最後にdropイベントをキャンセルしておく
    event.preventDefault();
}

function showGroupMenu(checkedGroups){
    // グループメニューを生成
    var area = elmFor("groupPopArea");
    area.innerHTML = "";
    
    var checkArray = [];
    if (checkedGroups){
        checkArray = checkedGroups.split('^');
    }
    
    var menus = groupMenu();
    for (num in menus){
        var menu = menus[num];
        if (menu == "...その他"){
            var label = newDIV(area, "/listMember");
            label.innerHTML = menu;
            label.setAttribute("onclick", "newGroupName()");
        } else {
            var sp = newSPAN(area, "/group-menu");
            var status = (arrayHasItem(checkArray, menu)) ? 1 : 0;
            var cb = newCHECKBOX(sp, menu + ".id", "", status);
            var label = newSPAN(sp, menu + ".lid");
            label.innerHTML = menu;
            label.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
            label.setAttribute("ondragstart", "f_dragstart(event)");
            label.setAttribute("ondragover", "f_dragover(event)");
            label.setAttribute("ondrop", "f_drop(event)");
        }
    }
}

///// DRAG and DROP ////////////////////////////////////
////////////////////////////////////////////////////////



function newGroupName(){
    // グループ名が選択された
    var name = prompt("新規グループ名を入力してください");
    if (name.length > 0){
        putGroupName(name);
    }
}

function upload(){
    // form を submit し画像をアップロード
    
    // 画像ファイル名を default 値としてラベル欄に表示
    var st = uploadFileName();
    var pos = st.lastIndexOf('.');
    var title = (pos > 0) ? st.substr(0, pos) : st; // suffix を除去した文字列
    elmFor("labelF").value = title;
    
    // suffix が save() で必要になるので記憶しておく
    elmFor("suffixF").value = suffix(st);

    // 画像ファイルを読み込んだ場合 URL は空にする
    elmFor("urlF").value = "";
    
    var submitButton = document.getElementById("uploadForm");
    submitButton.submit();
    
    // 以下の画面書き換えを行うとアップロードが中断され失敗するようだ
    // window.location.reload(true);
}

function infoEditHelp(){
	// ヘルプパネルを表示
    window.open("./infoEditHelp.html","Help"
                ,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function openEditor(fileId){
    // 編集パネルを開く
    var addMode = (fileId) ? false : true;
    var w = 330;
	var x = 10; // 表示するx座標
	var y = 40; // 表示するy座標
    var title = "編集パネル";
    var elm = openSeeThroughPanel("_floatPanel",x,y,w,title,"infoEditHelp()");
    if (!elm){
        alert("_floatPanel がないのでパネルを表示できません"); return;
    }
    
    if (addMode){ // 新規データ 
        fileId = todayAndTimeId();
        var label = "";
        var sfx = "";
        var url = "";
    } else { // 既存データの編集
        var rec = recordForId(fileId);
        var label = rec.label;
        var groups = rec.group;
        var sfx = rec.suffix;
        var url = rec.url;
    }
    
    // === FORM を生成 =============================
    var fm = newFORM(elm, "pictServer.php"); // submit で起動される URL
    fm.setAttribute("id", "uploadForm");
    // ### iframe を使うにはここがキモ ###
    fm.setAttribute("target", "iframeElement"); // iframe を指定
    fm.style.backgroundColor = "#ffe";
    fm.style.padding = "10px";
    fm.style.borderRadius = "10px";
    
    // === FIELD ID
    var div = newDIV(fm, "/clearfix");
    var dv = newDIV(div, "/label");
    dv.innerHTML = "ID";
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = fileId;
    dv.style.fontSize = "10pt";
    dv.style.color = "#555";
    // サーバへ ID を送るには newFIELD() タイプの必要あり
    // ### fd.setAttribute("disabled") だと FORM で送られないので表示は上記型式
    var fd = newFIELD(dv, "", "", 30, fileId);
    fd.setAttribute("NAME", "fileId"); // form で送られるパラメータ
    fd.setAttribute("type", "hidden");

    // === URL
    if (addMode || (url && url.length)){
        var div = newDIV(fm, "/clearfix");
        var dv = newDIV(div, "/label");
        dv.innerHTML = "URL";
        var dv = newDIV(div, "/left-side");
        var fd = newFIELD(dv, "urlF", "", 40, (url) ? url : "");
    }

    if (addMode){ // 新規データ
        // === ファイル選択ボタン ========================
        var dv = newDIV(fm, "file");
        var bt = newUploadBUTTON(dv, "imageFile", "files[]");
        // アップロード・ボタン 
        // ### iframe を使うにはここがキモ ###
        // form を見せない形で処理するため submit-button 機能を別に作成
        var bt = newDIV(dv, "/whiteButton");
        bt.innerHTML = "転送";
        bt.setAttribute("onclick", "upload()");
        
        // === データ戻り先として iframe を作成 ===========
        // ### iframe を使うにはここがキモ ###
        var dv = newDIV(fm, "");
        //    dv.style.display = "none"; // 表示しない
        var fr = newIFRAME(dv, "iframeElement");
        fr.style.height = "70px";
        fr.style.width = "280px";
        fr.style.fontSize = "8pt";
        fr.style.color = "#aaa";
        fr.style.border = "thin solid #fff";
    }
    
    // === ラベル名
    var div = newDIV(fm, "/clearfix");
    var dv = newDIV(div, "/label");
    dv.innerHTML = "ラベル";
    var dv = newDIV(div, "/left-side");
    var fd = newFIELD(dv, "labelF", "", 40, label);
    
    // === 接尾語
    var fd = newFIELD(fm, "suffixF", "", "", sfx);
    fd.setAttribute("NAME", "suffix"); // form で送られるパラメータ
    fd.setAttribute("type", "hidden");

    // === カテゴリー
    var div = newDIV(fm, "/clearfix");
    var dv = newDIV(div, "groupLabel/label");
    dv.innerHTML = "カテゴリー";
    dv.setAttribute("ondragover", "f_dragover(event)");
    dv.setAttribute("ondrop", "f_drop(event)");
    var dv = newDIV(div, "/left-side");
    var sp = newSPAN(dv, "groupPopArea");
    showGroupMenu(groups);
    
    // === key：pictServer への COMMAND を設定
    var fd = newFIELD(fm, "key", "", "", "SAVE_IMAGE");
    fd.setAttribute("NAME", "key"); // form で送られるパラメータ
    fd.setAttribute("type", "hidden");

    var div = newDIV(fm, "/clearfix");
    var dv = newDIV(div, "/label");
    var dv = newDIV(div, "/right-side");
    dv.style.fontSize = "9pt";

    // FOOTER =====================================
    var div = newDIV(elm, "");
    div.style.textAlign = "right"
    // 削除ボタン
    var bt = newDIV(div, "uploadButton/flatButton");
    bt.innerHTML = "削除";
    bt.setAttribute("onclick", "save('remove')");
    // 保存ボタン
    var bt = newDIV(div, "uploadButton/fixButton");
    bt.innerHTML = "保存";
    bt.setAttribute("onclick", "save('put')");
}
