/*============================================================================*
 *  FILE: 
 *     nnshmain.c
 *
 *  Description: 
 *     Main routines for NNsh. 
 *
 *===========================================================================*/
#define THRMNG_C
#include "local.h"

static Err get_subject_info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR);
static Err get_message_Info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR, 
                            NNshBoardDatabase   *bbsInfo,  UInt16 *selBBS);
static Boolean set_SearchTitleString     (MemHandle *bufH);
static Boolean search_NextTitle          (Int16 direction);
static Boolean search_NextBBS            (UInt16 start, UInt16 *bbsId);
static Boolean display_message           (void);
static Boolean get_all_message           (void);
static Boolean update_message            (void);
static Boolean update_getall_message     (void);
static Boolean delete_notreceived_message(Boolean update);
static Boolean delete_message            (void);
static Boolean get_subject_txt           (void);
static Boolean popEvt_ThreadMain         (EventType *event);
static Boolean keyDownEvt_ThreadMain     (EventType *event);
static Boolean ctlSelEvt_ThreadMain      (EventType *event);
static Boolean ctlRepEvt_ThreadMain      (EventType *event);
static Boolean menuEvt_ThreadMain        (EventType *event);

static Boolean rctPointEvt_ThreadMain(EventType *event,
                                      FormType *frm, RectangleType *rect);

extern void    Initialize_NNshSetting(FormType *frm);
extern void    Effect_NNshSetting    (FormType *frm);
extern Boolean Handler_NNshSetting   (EventType *event);
extern Boolean Handler_JumpSelection(EventType *event);

/*-------------------------------------------------------------------------*/
/*   Function : change_handera_rotate                                      */
/*                                                         HandEraʉ] */
/*-------------------------------------------------------------------------*/
static void change_handera_rotate(void)
{
    FormType            *frm;

#ifdef USE_HANDERA
    VgaScreenModeType   handEraScreenMode;     // XN[[h
    VgaRotateModeType   handEraRotateMode;     // ][h

    if(NNshGlobal->device == NNSH_DEVICE_HANDERA)
    {
        // HandErafoCXȂAʂ]
        VgaGetScreenMode(&handEraScreenMode, &handEraRotateMode);
        VgaSetScreenMode(screenMode1To1, VgaRotateSelect(handEraRotateMode));
        frm = FrmGetActiveForm();
        HandEraResizeForm(frm);
        FrmDrawForm(frm);
        Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, (NNshGlobal->NNsiParam)->selectedTitleItem,
                                                             NNSH_STEP_REDRAW);
        return;
    }
#endif
#ifdef USE_PIN_DIA
    if ((NNshGlobal->device == NNSH_DEVICE_DIASUPPORT)||
        (NNshGlobal->device == NNSH_DEVICE_GARMIN))
    {
        // DIAT|[gfoCXȂAʉ]s
        VgaFormRotate_DIA();

        // ʉ]̑傫ɂ킹AtH[𒲐`悷
        frm = FrmGetActiveForm();
        if (HandEraResizeForm(frm) == true)
        {
            FrmDrawForm(frm);
            Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, (NNshGlobal->NNsiParam)->selectedTitleItem,
                                                             NNSH_STEP_REDRAW);
        }
        return;
    }
#endif    // #ifdef USE_PIN_DIA

    // "݃T|[gĂ܂" \s
    NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : updateSelectionItem                                        */
/*                                                          Iitem̍XV */
/*-------------------------------------------------------------------------*/
static void updateSelectionItem(Int16 direction)
{
    FormType      *frm;
    RectangleType  dimF;
    Int16          item;
    UInt16         fontID, nlines, fontHeight;

    // IACeړ
    item = (NNshGlobal->NNsiParam)->selectedTitleItem + direction;
    
    // Oy[WIꂽꍇ...
    if (item < 0)
    {
        // Oy[Wꍇɂ́APÕy[W\
        if (((NNshGlobal->NNsiParam)->titleDispState == NNSH_DISP_HALFWAY)||
             ((NNshGlobal->NNsiParam)->titleDispState == NNSH_DISP_LOWERLIMIT))
        {   
            // Oy[W\
            Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS,
                               NNSH_ITEM_LASTITEM, NNSH_STEP_PAGEDOWN);
        }
        return;
    }
         
    // IACeύX(ʃy[W؂ւȂꍇɂ͑IitemXV)    
    if (item < NNshGlobal->nofTitleItems)
    {
        frm = FrmGetActiveForm();
        FrmGetObjectBounds(frm,
                            FrmGetObjectIndex(frm, GADID_MESSAGE_LIST), &dimF);

        fontID = ((NNshGlobal->NNsiParam)->useSonyTinyFontTitle == 0) ?
                           (NNshGlobal->NNsiParam)->currentFont : (NNshGlobal->NNsiParam)->sonyHRFontTitle;

        NNsi_UpdateRectangle(&dimF, (NNshGlobal->NNsiParam)->useSonyTinyFontTitle,
                                                &fontID, &fontHeight, &nlines);

        // Xꗗ̕\(`)
        NNsi_WinUpdateList(item, (NNshGlobal->NNsiParam)->selectedTitleItem,
                         NNshGlobal->msgTitleIndex, nlines, &dimF, fontHeight);
        (NNshGlobal->NNsiParam)->selectedTitleItem = item;

        return;
    }

    // ʃy[W؂ւ(y[Wꍇɂ́Ay[W\)
    if (((NNshGlobal->NNsiParam)->titleDispState == NNSH_DISP_HALFWAY)||
        ((NNshGlobal->NNsiParam)->titleDispState == NNSH_DISP_UPPERLIMIT))
    {     
        Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 0, NNSH_STEP_PAGEUP);
    }
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : change_list_font                                           */
/*                                                            tHgύX */
/*-------------------------------------------------------------------------*/
static void change_list_font(void)
{
#ifdef USE_TSPATCH
    UInt32  ver, fontId;
    Err     ret;
#endif

    // tHgID̑I
    if ((NNshGlobal->NNsiParam)->useSonyTinyFontTitle == 0)
    {
        // ʏ`惂[hptHg̕ύX
        (NNshGlobal->NNsiParam)->currentFont = FontSelect((NNshGlobal->NNsiParam)->currentFont);

#ifdef USE_TSPATCH
        // TsPatch@\gƂ...
        if ((NNshGlobal->NNsiParam)->notUseTsPatch == 0)
        {    
            // TsPatchKpǂ`FbN
            ret = FtrGet(SmallFontAppCreator, SMF_FTR_SMALL_FONT_SUPPORT, &ver);
            if (ret == errNone)
            {    
                // TsPatchKp...tHgB
                switch ((NNshGlobal->NNsiParam)->currentFont)
                {
                  case stdFont:
                    FtrGet(SmallFontAppCreator, SMF_FTR_TINY_FONT, &fontId);
                    break;

                  case boldFont:
                    FtrGet(SmallFontAppCreator, SMF_FTR_TINY_BOLD_FONT, &fontId);
                    break;

                  case largeFont:
                    FtrGet(SmallFontAppCreator, SMF_FTR_SMALL_FONT, &fontId);
                    break;

                  case largeBoldFont:
                    FtrGet(SmallFontAppCreator, SMF_FTR_SMALL_BOLD_FONT, &fontId);
                    break;

                  default:
                    fontId = (NNshGlobal->NNsiParam)->currentFont;
                    break;
                }
                (NNshGlobal->NNsiParam)->currentFont = fontId;
            }
        }
#endif  // #ifdef USE_TSPATCH

    }
    else
    {
        // nC][hptHg̕ύX
        (NNshGlobal->NNsiParam)->sonyHRFontTitle = FontSelect((NNshGlobal->NNsiParam)->sonyHRFontTitle);
    }

    // tHgύX̕\́AXgč쐬ĕ\
    Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 
                       (NNshGlobal->NNsiParam)->selectedTitleItem, NNSH_STEP_REDRAW);

    NNshGlobal->updateHR = NNSH_UPDATE_DISPLAY;

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : change_graph_mode                                          */
/*                                        OtBbN`惂[h̐؂ւ */
/*-------------------------------------------------------------------------*/
static void change_graph_mode(void)
{
    // nC][h/ʏ`惂[h̐؂ւ(1:nC], 0:ʏ`)
    (NNshGlobal->NNsiParam)->useSonyTinyFontTitle = 
                                ((NNshGlobal->NNsiParam)->useSonyTinyFontTitle == 0) ? 1 : 0;

    // `惂[hύX̕\́AXgč쐬ĕ\
    Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 
                       (NNshGlobal->NNsiParam)->selectedTitleItem, NNSH_STEP_REDRAW);
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : Show_tab_info                                              */
/*                                                          ^u̕\ */
/*-------------------------------------------------------------------------*/
UInt16 Show_tab_info(Boolean disp)
{
    UInt16               tabNum, selBBS, count, loop;
    Char                 logMsg[MINIBUF], buffer[BUFSIZE * 2];
    FormType            *frm;
    ListType            *lstP;
    NNshBoardDatabase    bbsInfo;
    NNshSubjectDatabase *mesRead;
    MemHandle            mesH;
    DmOpenRef            dbRef;

    // ϐ̏
    tabNum = 0;
    MemSet(buffer, sizeof(buffer), 0x00);


    // ^u쐬    
    frm     = FrmGetActiveForm();
    lstP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
    selBBS  = LstGetSelection(lstP);
    StrCopy(buffer, MSG_TAB_INFO);
    StrCat (buffer, LstGetSelectionText(lstP, selBBS));

    // "X"\
    Show_BusyForm(MSG_SEARCHING_TITLE);

    switch (selBBS)
    {
      case NNSH_SELBBS_NOTREAD:     // ǂ
      case NNSH_SELBBS_GETALL:      // 擾ςݑS
      case NNSH_SELBBS_FAVORITE:    // CɓX
        // BBS͎擾Ȃ(擾)
        break;

      case NNSH_SELBBS_CUSTOM1:     // CUSTOM1
        (void) Get_BBS_Info((NNshGlobal->NNsiParam)->custom1.boardNick, &bbsInfo);
        break;

      case NNSH_SELBBS_CUSTOM2:     // CUSTOM2
        (void) Get_BBS_Info((NNshGlobal->NNsiParam)->custom2.boardNick, &bbsInfo);
        break;

      case NNSH_SELBBS_CUSTOM3:     // CUSTOM3
        (void) Get_BBS_Info((NNshGlobal->NNsiParam)->custom3.boardNick, &bbsInfo);
        break;

      case NNSH_SELBBS_CUSTOM4:     // CUSTOM4
        (void) Get_BBS_Info((NNshGlobal->NNsiParam)->custom4.boardNick, &bbsInfo);
        break;

      case NNSH_SELBBS_CUSTOM5:     // CUSTOM5
        (void) Get_BBS_Info((NNshGlobal->NNsiParam)->custom5.boardNick, &bbsInfo);
        break;

      default:
        // BBSȊÔƂ
        Get_BBS_Info(selBBS, &bbsInfo);
        break;
    }

    // SX擾
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    GetDBCount_NNsh(dbRef, &count);

    // VmF
    for (loop = count; loop > 0; loop--)
    {
        // 悻̌c茏\
        if ((loop % 10) == 0)
        {
            StrCopy(logMsg, MSG_SEARCHING_TITLE MSG_SEARCHING_LEFT);
            NUMCATI(logMsg, loop);
            SetMsg_BusyForm(logMsg);
        }

        // Xf[^擾
        GetRecordReadOnly_NNsh(dbRef, (loop - 1), &mesH, (void **) &mesRead);

        // ɍv邩ǂ`FbN
        if (CheckDispList(selBBS, mesRead, &bbsInfo) == true)
        {
            tabNum++;
        }

        // R[hbN̉
        ReleaseRecordReadOnly_NNsh(dbRef, mesH);
   }
    CloseDatabase_NNsh(dbRef);
    Hide_BusyForm(false);

    // \
    if (disp == true)
    {
        StrCat(buffer, MSG_TAB_COUNT);
        NUMCATI(buffer, tabNum);
        NNsh_ErrorMessage(ALTID_INFO, buffer, " ", 0);
    }
    return (tabNum);
}

/*-------------------------------------------------------------------------*/
/*   Function : setMultiPurposeSwitch                                      */
/*                                          ړIXCb`ɏf[^ݒ */
/*-------------------------------------------------------------------------*/
static void setMultiPurposeSwitch(FormType *frm, UInt16 itemID, UInt16 btnID)
{
    UInt16       data;
    ControlType *ctlP;

    // ړIXCb`ɐݒ肳ꂽڂɂ킹ăf[^擾
    switch (itemID & (NNSH_SWITCHUSAGE_FUNCMASK))
    {
      case NNSH_SWITCHUSAGE_GETPART:
        // ꊇ/
        data = (NNshGlobal->NNsiParam)->enablePartGet;
        break;

      case NNSH_SWITCHUSAGE_HANZEN:
        // p/Sp
        data = (NNshGlobal->NNsiParam)->convertHanZen;
        break;

      case NNSH_SWITCHUSAGE_USEPROXY:
        // proxygp
        data = (NNshGlobal->NNsiParam)->useProxy;
        break;

      case NNSH_SWITCHUSAGE_CONFIRM:
        // mFȗ
        data = (NNshGlobal->NNsiParam)->confirmationDisable;
        break;

      case NNSH_SWITCHUSAGE_SUBJECT:
        // ꗗS擾
        data = (NNshGlobal->NNsiParam)->getAllThread;
        break;

      case NNSH_SWITCHUSAGE_TITLEDISP:
        // `惂[h
        data = (NNshGlobal->NNsiParam)->useSonyTinyFontTitle;
        break;

      case NNSH_SWITCHUSAGE_MSGNUMBER:
        // ꗗɔԍ
        data = (NNshGlobal->NNsiParam)->printNofMessage;
        break;

      case NNSH_SWITCHUSAGE_GETRESERVE:
        // X擾\
        data = (NNshGlobal->NNsiParam)->getReserveFeature;
        break;

      case NNSH_SWITCHUSAGE_IMODEURL:
        // i-mode URLgp
        data = (NNshGlobal->NNsiParam)->useImodeURL;
        break;

      case NNSH_SWITCHUSAGE_BLOCKDISP:
        // ][\[h
        data = (NNshGlobal->NNsiParam)->blockDispMode;
        break;

      case NNSH_SWITCHUSAGE_MACHINEW:
        // ܂BBSVmF{
        data = (NNshGlobal->NNsiParam)->enableNewArrivalHtml;
        break;

      case NNSH_SWITCHUSAGE_USEPLUGIN:
        // VmFɃ[`FbN{
        data = (NNshGlobal->NNsiParam)->use_DAplugin;
        break;

      case NNSH_SWITCHUSAGE_LISTUPDATE:
        // ꗗXVɓɃX擾
        data = (NNshGlobal->NNsiParam)->listAndUpdate;
        break;

      case NNSH_SWITCHUSAGE_NOREADONLY:
        // 擾ςݑSĂɂ͎QƃOȂ
        data = (UInt16) (NNshGlobal->NNsiParam)->notListReadOnly;
        break;
      
      case NNSH_SWITCHUSAGE_NORDOLY_NW:
        // ǂɂ͎QƃOȂ
        data = (UInt16) (NNshGlobal->NNsiParam)->notListReadOnlyNew;
        break;

      case NNSH_SWITCHUSAGE_NOUSE:
      default:
        // gpȂ(`FbN{bNX̉ʕ\Ȃ)
        ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, btnID));
        CtlSetValue  (ctlP, 0);
        CtlSetEnabled(ctlP, false);
        CtlSetUsable (ctlP, false);
        return;
        break;
    }
    // ݒlʂɔf
    SetControlValue(frm, btnID, &data);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function : updateMultiPurposeSwitch                                   */
/*                                                  ړI{^ꂽ */
/*-------------------------------------------------------------------------*/
static Boolean updateMultiPurposeSwitch(UInt16 paramID, UInt16 btnID)
{
    Boolean ret;
    UInt16  data;
    Char    *ptr;

    // f[^̏
    ret = false;
    data = 0;
    ptr  = "";

    // ݒ肳ꂽf[^擾
    UpdateParameter(FrmGetActiveForm(), btnID, &data);
    switch (paramID & (NNSH_SWITCHUSAGE_FUNCMASK))
    {
      case NNSH_SWITCHUSAGE_GETPART:
        // ꊇ/
        (NNshGlobal->NNsiParam)->enablePartGet = data;
        ptr = MSG_PARTGET_MODE;
        break;

      case NNSH_SWITCHUSAGE_HANZEN:
        // p/Sp
        (NNshGlobal->NNsiParam)->convertHanZen = data;
        ptr = MSG_HANZEN_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_USEPROXY:
        // proxygp
        (NNshGlobal->NNsiParam)->useProxy = data;
        ptr = MSG_USEPROXY_MODE;
        break;

      case NNSH_SWITCHUSAGE_CONFIRM:
        if (data == 0)
        {
            // mFȗ
            (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_NOTHING;
        }
        else
        {
            // _CAOSďȗ
            (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
        }
        ptr = MSG_OMITCONFIRM_MODE;
        break;

      case NNSH_SWITCHUSAGE_SUBJECT:
        // ꗗS擾
        (NNshGlobal->NNsiParam)->getAllThread = data;
        ptr = MSG_GETALLSUBJECT_MODE;
        break;

      case NNSH_SWITCHUSAGE_TITLEDISP:
        // `惂[h
        (NNshGlobal->NNsiParam)->useSonyTinyFontTitle = data;
        ptr = MSG_GRAPHIC_DRAW_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_MSGNUMBER:
        // ꗗɔԍ
        (NNshGlobal->NNsiParam)->printNofMessage = data;
        ptr = MSG_SHOWMESSAGENUM_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_GETRESERVE:
        // X擾\
        (NNshGlobal->NNsiParam)->getReserveFeature = data;
        ptr = MSG_GETRESERVE_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_IMODEURL:
        // i-mode URLgp[h
        (NNshGlobal->NNsiParam)->useImodeURL = data;
        ptr = MSG_IMODEURL_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_BLOCKDISP:
        // ][\[h
        (NNshGlobal->NNsiParam)->blockDispMode = data * NNSH_BLOCKDISP_NOFMSG;
        ptr = MSG_BLOCKDISP_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_MACHINEW:
        // ܂BBSVmF
        (NNshGlobal->NNsiParam)->enableNewArrivalHtml = data;
        ptr = MSG_MACHINEW_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_USEPLUGIN:
        // VmFɃ[mF{
        (NNshGlobal->NNsiParam)->use_DAplugin = data;
        ptr = MSG_USE_DA_PLUGIN_MODE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_LISTUPDATE:
        // ꗗ擾ɓɃX擾{
        (NNshGlobal->NNsiParam)->listAndUpdate = data;
        ptr = MSG_LISTGET_AND_UPDATE;
        ret = true;
        break;

      case NNSH_SWITCHUSAGE_NOREADONLY:
        // 擾ςݑSĂɂ͎QƃOȂ
        (NNshGlobal->NNsiParam)->notListReadOnly = (UInt8) data;
        ptr = MSG_NOTREADONLY;
        ret = true;
        break;
      
      case NNSH_SWITCHUSAGE_NORDOLY_NW:
        // ǂɂ͎QƃOȂ
        (NNshGlobal->NNsiParam)->notListReadOnlyNew = (UInt8) data;
        ptr = MSG_NOTREADONLY_NEW;
        ret = true;
        break;


      case NNSH_SWITCHUSAGE_NOUSE:
      default:
        // gpȂ
        return (false);
        break;
    }
    if (data == 0)
    {
        // ݒƂʒm
        NNsh_InformMessage(ALTID_INFO, ptr, MSG_RESET_SUFFIX, 0);
    }
    else
    {
        // ݒ肵Ƃʒm
        NNsh_InformMessage(ALTID_INFO, ptr, MSG_SET_SUFFIX, 0);
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function : moveSelectionTab                                           */
/*                                                      \^uύX */
/*-------------------------------------------------------------------------*/
static void moveSelectionTab(UInt16 selBBS)
{
    FormType    *frm;
    ListType    *lstP;
    ControlType *ctlP;

    frm     = FrmGetActiveForm();
    lstP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
    
    // BBS\XgύX
    LstSetSelection(lstP, selBBS);

    // BBS\^uύX
    (NNshGlobal->NNsiParam)->lastBBS = selBBS;

    // \^u(x)
    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, POPTRID_BBSINFO));
    CtlSetLabel(ctlP, LstGetSelectionText(lstP, selBBS));

    // XgXV
    Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 0, NNSH_STEP_UPDATE);

    return; 
}

/*-------------------------------------------------------------------------*/
/*   Function : ExecuteAction                                              */
/*                                          @\s(ړI{^p) */
/*-------------------------------------------------------------------------*/
Boolean ExecuteAction(UInt16 funcID)
{
    Boolean      ret = false;
    UInt16       item, dummy;
    EventType   *dummyEvent;
    Char        *data;

    // @\R}hԍjumpSelectionɊi[
    // (܂ǂȂB)
    NNshGlobal->jumpSelection = funcID;
    switch (funcID)
    {
      case MULTIBTN_FEATURE_INFO:
         // X
        if (NNshGlobal->nofTitleItems != 0)
        {
            item = convertListIndexToMsgIndex((NNshGlobal->NNsiParam)->selectedTitleItem);
            (void) DisplayMessageInformations(item, &dummy);

            NNsi_RedrawThreadList();
        }
        break;

      case MULTIBTN_FEATURE_OPEN:
        // XQ
        display_message();
        break;

      case MULTIBTN_FEATURE_GET:
        // bZ[W擾(擾/S擾͎؊)
        update_getall_message();
        break;

      case MULTIBTN_FEATURE_PARTGET:
        // bZ[W擾
        update_message();
        break;

      case MULTIBTN_FEATURE_ALLGET:
        // bZ[WS擾(Ď擾)
        get_all_message();
        break;

      case MULTIBTN_FEATURE_DELETE:
        // X폜
        delete_message();
        break;

      case MULTIBTN_FEATURE_SORT:
        // X̐s
        Show_BusyForm(MSG_SORTING_WAIT);
        SortSubjectList();
        Hide_BusyForm(false);

        // X^Cg̐擪ֈړ
        Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 0, NNSH_STEP_UPDATE);
        break;

      case MULTIBTN_FEATURE_MODTITLE:
        // X^CgύX
        modify_title();
        break;

      case MULTIBTN_FEATURE_OPENWEB:
        // IXuEUŊJ
        if (NNshGlobal->browserCreator != 0)
        {
            // WebBrowserŊJ
            launch_WebBrowser();
        }
        else
        {
            // "݃T|[gĂ܂" \s
            NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
        }
        break;

      case MULTIBTN_FEATURE_MESNUM:
        // XԎw̃bZ[W擾
        Get_MessageFromMesNum(&ret, &dummy, false);
        if (ret == true)
        {
            // BBSꗗĂ
            MEMFREE_PTR(NNshGlobal->bbsTitles);

            // gpBBSꗗ̍XV
            (void) Create_BBS_INDEX(&(NNshGlobal->bbsTitles), &item);
            if (item < (NNshGlobal->NNsiParam)->lastBBS)
            {
                (NNshGlobal->NNsiParam)->lastBBS = 0;
            }
        }
        Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 0, NNSH_STEP_UPDATE);
        break;

      case MULTIBTN_FEATURE_SEARCH:
        // ^Cg(̐ݒ)
        if (set_SearchTitleString(&(NNshGlobal->searchTitleH)) != true)
        {
            return (true);
        }
        // not break;  (ăX^Cs)

      case MULTIBTN_FEATURE_NEXT:
        // X^C()
        (void) search_NextTitle(NNSH_SEARCH_FORWARD);
        break;

      case MULTIBTN_FEATURE_PREV:
        // X^C(O)
        (void) search_NextTitle(NNSH_SEARCH_BACKWARD);
        break;

      case MULTIBTN_FEATURE_TOP:
        // X^Cg̐擪ֈړ
        Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 0, NNSH_STEP_TO_TOP);
        break;

      case MULTIBTN_FEATURE_BOTTOM:
        // X^Cg̖ֈړ(_~[ňُf[^𑗂荞)
        Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, NNSH_ITEM_LASTITEM,
                                                          NNSH_STEP_TO_BOTTOM);
        break;

      case MULTIBTN_FEATURE_GETBBS:
        // ̍XV(擾)
        if (GetBBSList((NNshGlobal->NNsiParam)->bbs_URL) == false)
        {
            return (true);
        }
        /** not break; (ĎgpIs) **/

      case MULTIBTN_FEATURE_USEBBS:
        // gpIʂJ
        NNshMain_Close(FRMID_MANAGEBBS);
        break;

      case MULTIBTN_FEATURE_COPYGIKO:
        // QƃOɃRs[
        copy_to_readOnly();
        break;

      case MULTIBTN_FEATURE_DELNOTGET:
        // 擾X폜
        delete_notreceived_message(true);
        break;

      case MULTIBTN_FEATURE_DBCOPY:
        // DBVFSɃobNAbv
        if ((((NNshGlobal->NNsiParam)->useVFS) & (NNSH_VFS_ENABLE)) == NNSH_VFS_ENABLE)
        {
            // DBVFSɃobNAbv
            BackupDBtoVFS(NNSH_ENABLE);
        }
        else
        {
             // "݃T|[gĂ܂" \s
             NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
        }
        break;

      case MULTIBTN_FEATURE_GRAPHMODE:
        // `惂[hύX
        change_graph_mode();
        break;

      case MULTIBTN_FEATURE_ROTATE:
        // HandEraʉ]
        change_handera_rotate();
        break;

      case MULTIBTN_FEATURE_FONT:
        // tHgύX
        change_list_font();
        break;

      case MULTIBTN_FEATURE_NETWORK:
        // lbg[NݒJ
        OpenNetworkPreferences();
        break;

      case MULTIBTN_FEATURE_SELMENU:
        // Ij[\
        open_menu();
        break;

      case MULTIBTN_FEATURE_DISCONN:
        // ؒf
        NNshNet_LineHangup();
        break;

      case MULTIBTN_FEATURE_GETLIST:
        // Xꗗ擾(SUBJECT.TXT擾)
        get_subject_txt();
        break;

      case MULTIBTN_FEATURE_NEWARRIVAL:
        // VbZ[WmF
        update_newarrival_message(NNSH_NEWARRIVAL_NORMAL);
        break;

      case MULTIBTN_FEATURE_NNSHSET:
        // NNsiݒ(T)ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING_ABSTRACT);
        break;

      case MULTIBTN_FEATURE_NNSHSET1:
        // NNsiݒ-1ʂJ
        NNshMain_Close(FRMID_CONFIG_NNSH);
        break;

      case MULTIBTN_FEATURE_NNSHSET2:
        // NNsiݒ-2ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING2);
        break;

      case MULTIBTN_FEATURE_NNSHSET3:
        // NNsiݒ-3ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING3);
        break;

      case MULTIBTN_FEATURE_NNSHSET4:
        // NNsiݒ-4ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING4);
        break;

      case MULTIBTN_FEATURE_NNSHSET5:
        // NNsiݒ-5ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING5);
        break;

      case MULTIBTN_FEATURE_NNSHSET6:
        // NNsiݒ-6ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING6);
        break;

      case MULTIBTN_FEATURE_NNSHSET7:
        // NNsiݒ-7ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING7);
        break;

      case MULTIBTN_FEATURE_NNSHSET8:
        // NNsiݒ-8ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING8);
        break;

      case MULTIBTN_FEATURE_NNSHSET9:
        // NNsiݒ-9ʂJ
        NNshMain_Close(FRMID_NNSI_SETTING9);
        break;

      case MULTIBTN_FEATURE_VERSION:
        // o[W\
        ShowVersion_NNsh();
        break;

      case MULTIBTN_FEATURE_SELECTNEXT:
        // 1̃ACeI
        updateSelectionItem(NNSH_STEP_ITEMDOWN);
        break;

      case MULTIBTN_FEATURE_SELECTPREV:
        // 1̃ACeI
        updateSelectionItem(NNSH_STEP_ITEMUP);
        break;

      case MULTIBTN_FEATURE_PREVPAGE:
        // Oy[W̕\
        if (((NNshGlobal->NNsiParam)->titleDispState == NNSH_DISP_HALFWAY)||
            ((NNshGlobal->NNsiParam)->titleDispState == NNSH_DISP_LOWERLIMIT))
        {
            Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 0, NNSH_STEP_PAGEDOWN);
        }
        break;

      case MULTIBTN_FEATURE_NEXTPAGE:
        // y[W̕\
        if (((NNshGlobal->NNsiParam)->titleDispState == NNSH_DISP_HALFWAY)||
            ((NNshGlobal->NNsiParam)->titleDispState == NNSH_DISP_UPPERLIMIT))
        {
            Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 0, NNSH_STEP_PAGEUP);
        }
        break;

      case MULTIBTN_FEATURE_NNSIEND:
        // NNsiI
        dummyEvent = &(NNshGlobal->dummyEvent);
        MemSet(dummyEvent, sizeof(EventType), 0x00);
        dummyEvent->eType = appStopEvent;
        EvtAddEventToQueue(dummyEvent);
        break;

      case MULTIBTN_FEATURE_NGWORD1:
        // NGL[[hPݒ
        DataInputDialog(NNSH_INPUTWIN_NGWORD1,
                        (NNshGlobal->NNsiParam)->hideWord1, HIDEBUFSIZE,
                        NNSH_DIALOG_USE_SETNGWORD, NULL);

        // NGݒ1̕`FbN
        SeparateWordList((NNshGlobal->NNsiParam)->hideWord1, &(NNshGlobal->hide1));

        NNsi_RedrawThreadList();
        break;

      case MULTIBTN_FEATURE_NGWORD2:
        // NGL[[hQݒ
        DataInputDialog(NNSH_INPUTWIN_NGWORD2,
                        (NNshGlobal->NNsiParam)->hideWord2, HIDEBUFSIZE,
                        NNSH_DIALOG_USE_SETNGWORD, NULL);

        // NGݒ2̕`FbN
        SeparateWordList((NNshGlobal->NNsiParam)->hideWord2, &(NNshGlobal->hide2));

        NNsi_RedrawThreadList();
        break;

      case MULTIBTN_FEATURE_USER1TAB:
      case MULTIBTN_FEATURE_USER2TAB:
      case MULTIBTN_FEATURE_USER3TAB:
      case MULTIBTN_FEATURE_USER4TAB:
      case MULTIBTN_FEATURE_USER5TAB:
        // [U^uݒʂJ
        NNshMain_Close(FRMID_FAVORSET_DETAIL);
        break;

      case MULTIBTN_FEATURE_DEVICEINFO:
        // foCX̏\
        ShowDeviceInfo_NNsh();
        break;
        
      case MULTIBTN_FEATURE_GOTODUMMY:
        // _~[ʂ֑J
        NNshMain_Close(FRMID_NNSI_DUMMY);
        break;

      case MULTIBTN_FEATURE_NEWTHREAD:
        // Xĉʂ֑J
        newThread_message();
        break;

      case MULTIBTN_FEATURE_DIRSELECT:
        // fBNgI
        if ((NNshGlobal->NNsiParam)->lastBBS == NNSH_SELBBS_OFFLINE)
        {
            // ^uuQƃOv̎Ai[fBNgI
            readonly_dir_selection();
        }
        break;
      case MULTIBTN_FEATURE_TABINFO:
        // ^u
        Show_tab_info(true);
        break;

      case MULTIBTN_FEATURE_MOVELOGLOC:
        // OǗꏊ؂ւ
        move_log_location();
        break;

      case MULTIBTN_FEATURE_MOVELOGDIR:
        // Oi[fBNg̕ύX
        move_log_directory();
        break;

      case MULTIBTN_FEATURE_TO_NOTREAD:
        // 'ǂ'ֈړ
        moveSelectionTab(NNSH_SELBBS_NOTREAD);
        break;

      case MULTIBTN_FEATURE_TO_GETALL:
        // '擾ςݑS'ֈړ
        moveSelectionTab(NNSH_SELBBS_GETALL);
        break;

      case MULTIBTN_FEATURE_LOGCHARGE:
        // QƃO̎擾
#ifdef USE_LOGCHARGE
        GetReadOnlyLogData_NNsh();
        
        // ʕ\XV
        Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 
                           (NNshGlobal->NNsiParam)->selectedTitleItem,
                           NNSH_STEP_REDRAW);
#endif
        break;

      case MULTIBTN_FEATURE_OPENURL:
#ifdef USE_LOGCHARGE
        // URLJ
        openURL();
#endif
        break;

      case MULTIBTN_FEATURE_SETNGWORD3:
        // NG[hݒ-3
        SetNGword3();
        NNsi_RedrawThreadList();
        break;

      case MULTIBTN_FEATURE_SETLOGCHRG:
#ifdef USE_LOGCHARGE
        // QƃO擾ݒ
        SetLogGetURL(NNSH_ITEM_BOTTOMITEM);
        NNsi_RedrawThreadList();
#endif
        break;

      case MULTIBTN_FEATURE_BT_ON:
        // Bluetooth ON
#ifdef USE_BT_CONTROL
        OpenBluetoothPreferences(true);
#endif  // #ifdef USE_BT_CONTROL
        break;

      case MULTIBTN_FEATURE_BT_OFF:
        // Bluetooth OFF
#ifdef USE_BT_CONTROL
        OpenBluetoothPreferences(false);
#endif  // #ifdef USE_BT_CONTROL
        break;

      case MULTIBTN_FEATURE_TO_OFFLINE:
        // '擾ςݑS'ֈړ
        moveSelectionTab(NNSH_SELBBS_OFFLINE);
        break;

      case MULTIBTN_FEATURE_TO_FAVOR:
        // 'Cɓ'ֈړ
        moveSelectionTab(NNSH_SELBBS_FAVORITE);
        break;

      case MULTIBTN_FEATURE_TO_USER1:
        // '[U1'ֈړ
        moveSelectionTab(NNSH_SELBBS_CUSTOM1);
        break;

      case MULTIBTN_FEATURE_TO_USER2:
        // '[U2'ֈړ
        moveSelectionTab(NNSH_SELBBS_CUSTOM2);
        break;

      case MULTIBTN_FEATURE_TO_USER3:
        // '[U3'ֈړ
        moveSelectionTab(NNSH_SELBBS_CUSTOM3);
        break;

      case MULTIBTN_FEATURE_TO_USER4:
        // '[U4'ֈړ
        moveSelectionTab(NNSH_SELBBS_CUSTOM4);
        break;

      case MULTIBTN_FEATURE_TO_USER5:
        // '[U5'ֈړ
        moveSelectionTab(NNSH_SELBBS_CUSTOM5);
        break;

      case MULTIBTN_FEATURE_MACRO_SET:
#ifdef USE_MACROEDIT
        // }Nݒ
        NNsi_MacroDataEdit(DBNAME_MACROSCRIPT, DBVERSION_MACROSCRIPT);
        //NNsi_RedrawThreadList();
#else
        // "݃T|[gĂ܂" \s
        NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
#endif
        break;
      
      case MULTIBTN_FEATURE_MACRO_EXEC:
#ifdef USE_MACRO
        // }Ns
        NNsi_ExecuteMacroMain(DBNAME_MACROSCRIPT, DBVERSION_MACROSCRIPT);
        NNsi_RedrawThreadList();
#else
        // "݃T|[gĂ܂" \s
        NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
#endif
        break;

      case MULTIBTN_FEATURE_MACRO_VIEW:
#ifdef USE_MACRO
        // MACRO\
        NNsi_MacroDataView(DBNAME_MACROSCRIPT, DBVERSION_MACROSCRIPT);
        //NNsi_RedrawThreadList();
#else
        // "݃T|[gĂ܂" \s
        NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
#endif
        break;

      case MULTIBTN_FEATURE_MACRO_LOG:
#ifdef USE_MACRO
        // MACROO\
        NNsi_MacroExecLogView(DBNAME_MACRORESULT, DBVERSION_MACRO);
        //NNsi_RedrawThreadList();
#else
        // "݃T|[gĂ܂" \s
        NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
#endif
        break;
      case MULTIBTN_FEATURE_SELECT_BBS:
        // I
        CtlHitControl(FrmGetObjectPtr(FrmGetActiveForm(),
                                      FrmGetObjectIndex(FrmGetActiveForm(),
                                                        POPTRID_BBSINFO)));
        break;

      case MULTIBTN_FEATURE_OYSTERLOGIN:
#ifdef USE_SSL
        // ''OC
        ProceedOysterLogin();
#else
        // "݃T|[gĂ܂" \s
        NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
#endif
        break;
        
      case MULTIBTN_FEATURE_USAGE:
        // wv̕\
        // (Nbv{[hɁAnnDAɓnf[^ɂĂ̎wi[)
        data = MEMALLOC_PTR(sizeof(nnDA_NNSIEXT_VIEWSTART
                                    nnDA_NNSIEXT_INFONAME
                                    nnDA_NNSIEXT_HELPLIST
                                    nnDA_NNSIEXT_ENDINFONAME
                                    nnDA_NNSIEXT_ENDVIEW) + MARGIN);
        if (data != NULL)
        {
            // nnDAN
            MemSet(data, 
                   sizeof(nnDA_NNSIEXT_VIEWSTART
                           nnDA_NNSIEXT_INFONAME
                           nnDA_NNSIEXT_HELPLIST
                           nnDA_NNSIEXT_ENDINFONAME
                           nnDA_NNSIEXT_ENDVIEW) + MARGIN,
                   0x00);
            StrCopy(data, 
                    nnDA_NNSIEXT_VIEWSTART
                      nnDA_NNSIEXT_INFONAME
                      nnDA_NNSIEXT_HELPLIST
                      nnDA_NNSIEXT_ENDINFONAME
                      nnDA_NNSIEXT_ENDVIEW);            
            ClipboardAddItem(clipboardText, data, StrLen(data) + 1);
            MEMFREE_PTR(data);
            (void) LaunchResource_NNsh('DAcc','nnDA','code',1000);
        }
        break;
#ifdef USE_LOGCHARGE
      case MULTIBTN_FEATURE_SETTOKEN:
        // ؂蕶ݒ(擪R[h\)
        SetLogCharge_LogToken(0);
        break;

      case MULTIBTN_FEATURE_OPENGETLOGLIST:
        // 擾QƃOꗗʂJ
        NNshMain_Close(FRMID_LISTGETLOG);
        break;
#endif  // #ifdef USE_LOGCHARGE

      case MULTIBTN_FEATURE_SEARCHBBS:
        // 
        if (set_SearchTitleString(&(NNshGlobal->searchBBSH)) != true)
        {
            return (true);
        }
        if (search_NextBBS(NNSH_NOF_SPECIAL_BBS, &item) == false)
        {
            // Ȃ...
            return (true);
        }
        // A\ĂύX
        moveSelectionTab(item);
        break;

      case MULTIBTN_FEATURE_NEXTSEARCHBBS:
        // 
        if (search_NextBBS(((NNshGlobal->NNsiParam)->lastBBS + 1), &item) == false)
        {
            // Ȃ...
            return (true);
        }
        // A\ĂύX
        moveSelectionTab(item);
        break;

      case MULTIBTN_FEATURE_BEAMURL:
        // URLBeam
        beam_URL();
        break;

      default:
        // ̑(Ȃ)
        NNsh_DebugMessage(ALTID_WARN, "Unknown FuncID", "", funcID);
        break;
    }
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   select_readonly_directory                                */
/*                                 @@  uQƃOṽfBNgI  */
/*-------------------------------------------------------------------------*/
static UInt16 select_readonly_directory(UInt16 orgDir)
{
    Char      *listPtr, area[(MAX_DIRNAME + 1) * MAX_DEPTH + MARGIN], *ptr;
    UInt16     itemCnt, btnId, size;
    DmOpenRef  dirRef;

    // fBNgJEg擾
    OpenDatabase_NNsh(DBNAME_DIRINDEX, DBVERSION_DIRINDEX, &dirRef);
    GetDBCount_NNsh(dirRef, &itemCnt);
    CloseDatabase_NNsh(dirRef);

    // Xgmۗ̈̐ݒ
    size    = (itemCnt + 2) * (MAX_LISTLENGTH + MARGIN) + MARGIN;
    listPtr = MEMALLOC_PTR(size);
    if (listPtr == NULL)
    {
        return (orgDir);
    }
    MemSet(listPtr, size, 0x00);
    
    // "Xꗗ쐬" ̕\
    Show_BusyForm(MSG_MAKE_DIRECTORY_WAIT);

    // TufBNĝ(S)擾
    for (ptr = listPtr, size = 0; size <= itemCnt; size++)
    {        
        MemSet (area, sizeof(area), 0x00);
        area[0] = chrEllipsis;
        area[1] = '/';
        GetSubDirectoryName(size, &area[2]);
        btnId = StrLen(area);
        if (btnId > MAX_LISTLENGTH)
        {
            // i[̈悩炠ӂoĂꍇ...
            *ptr = chrEllipsis;
            ptr++;
            StrCopy(ptr, &area[btnId - MAX_LISTLENGTH]);
        }
        else
        {
            StrCopy(ptr, area);
        }
        ptr = ptr + StrLen(ptr) + 1;
    }

    // fBNg쐬
    Hide_BusyForm(false);

    // ifBNgjIEBhE\
    btnId = NNshWinSelectionWindow(FRMID_DIRSELECTION, listPtr, 
                                                        (itemCnt + 1), orgDir);
    if (btnId == BTNID_JUMPCANCEL)
    {
        // LZꂽꍇAAAw肳ꂽfBNgԍ
        NNshGlobal->jumpSelection = orgDir;
    }

    // mۂ̈NA
    MEMFREE_PTR(listPtr);
    
    // Iꂽ(fBNg)ԍ
    return (NNshGlobal->jumpSelection);
}


/*-------------------------------------------------------------------------*/
/*   Function :   readonly_dir_selection                                   */
/*                                @ uQƃOv̊i[fBNgI  */
/*-------------------------------------------------------------------------*/
static Boolean readonly_dir_selection(void)
{
    UInt16 newDir;

    // fBNg̊Kw\{Ȃꍇ...
    if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_DIROFFLINE) == 0)
    {
        return (false);
    }

    // fBNgI
    newDir = select_readonly_directory((NNshGlobal->NNsiParam)->readOnlySelection);

    if (newDir != (NNshGlobal->NNsiParam)->readOnlySelection)
    {
        (NNshGlobal->NNsiParam)->readOnlySelection = newDir;

        // IꂽfBNgXVꂽꍇɂ́AX^CꗗXV
        Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 0, NNSH_STEP_UPDATE);
    }
    else
    {
        // Xꗗʂĕ\
        NNsi_RedrawThreadList();
    }
    
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   open_menu                                                */
/*                                                 NNsiƎ̃j[\  */
/*-------------------------------------------------------------------------*/
static Boolean open_menu(void)
{
    FormType    *frm;
    ControlType *ctlP;
    EventType   *dummyEvent;
    Char      *ptr, listPtr[NNSH_ITEMLEN_JUMPLIST*(NNSH_JUMPSEL_NUMLIST + 1)];
    UInt16    btnId, savedParam, jumpList[NNSH_JUMPSEL_NUMLIST + 1], itemCnt;

    // Xg̍쐬
    MemSet(listPtr, sizeof(listPtr), 0x00);
    MemSet(jumpList, sizeof(jumpList), 0x00);
    ptr = listPtr;
    itemCnt = 0;

    // BBSI
    StrCopy(ptr, NNSH_JUMPMSG_OPENBBS);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENBBS);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENBBS;
    itemCnt++;

    // j[J
    if ((NNshGlobal->NNsiParam)->addMenuTitle != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_OPENMENU);
        ptr = ptr + sizeof(NNSH_JUMPMSG_OPENMENU);
        jumpList[itemCnt] = NNSH_JUMPSEL_OPENMENU;
        itemCnt++;
    }

    // ؒf
    StrCopy(ptr, NNSH_JUMPMSG_DISCONNECT);
    ptr = ptr + sizeof(NNSH_JUMPMSG_DISCONNECT);
    jumpList[itemCnt] = NNSH_JUMPSEL_DISCONNECT;
    itemCnt++;

    // VmF
    StrCopy(ptr, NNSH_JUMPMSG_OPENNEW);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENNEW);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENNEW;
    itemCnt++;

    // ꗗ擾
    StrCopy(ptr, NNSH_JUMPMSG_OPENLIST);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENLIST);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENLIST;
    itemCnt++;

    // X擾
    StrCopy(ptr, NNSH_JUMPMSG_OPENGET);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENGET);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENGET;
    itemCnt++;

    // XQ
    StrCopy(ptr, NNSH_JUMPMSG_OPENMES);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENMES);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENMES;
    itemCnt++;

    // QƃOփRs[
    if ((NNshGlobal->NNsiParam)->addMenuCopyMsg != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_COPYMSG);
        ptr = ptr + sizeof(NNSH_JUMPMSG_COPYMSG);
        jumpList[itemCnt] = NNSH_JUMPSEL_COPYMSG;
        itemCnt++;
    }

    // X
    StrCopy(ptr, NNSH_JUMPMSG_OPENINFO);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENINFO);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENINFO;
    itemCnt++;

    // X폜
    if ((NNshGlobal->NNsiParam)->addMenuDeleteMsg != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_DELMSG);
        ptr = ptr + sizeof(NNSH_JUMPMSG_DELMSG);
        jumpList[itemCnt] = NNSH_JUMPSEL_DELMSG;
        itemCnt++;
    }

    // QƃOꗗʂ
    StrCopy(ptr, NNSH_JUMPMSG_OPENGETLOGLIST);
    ptr = ptr + sizeof(NNSH_JUMPMSG_OPENGETLOGLIST);
    jumpList[itemCnt] = NNSH_JUMPSEL_OPENGETLOGLIST;
    itemCnt++;

    // `惂[hύX
    if ((NNshGlobal->NNsiParam)->addMenuGraphTitle != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_GRAPHMODE);
        ptr = ptr + sizeof(NNSH_JUMPMSG_GRAPHMODE);
        jumpList[itemCnt] = NNSH_JUMPSEL_GRAPHMODE;
        itemCnt++;
    }

    // ړIXCb`P
    if ((NNshGlobal->NNsiParam)->addMenuMultiSW1 != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_MULTISW1);
        ptr = ptr + sizeof(NNSH_JUMPMSG_MULTISW1);
        jumpList[itemCnt] = NNSH_JUMPSEL_MULTISW1;
        itemCnt++;
    }

    // ړIXCb`Q
    if ((NNshGlobal->NNsiParam)->addMenuMultiSW2 != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_MULTISW2);
        ptr = ptr + sizeof(NNSH_JUMPMSG_MULTISW2);
        jumpList[itemCnt] = NNSH_JUMPSEL_MULTISW2;
        itemCnt++;
    }

    // foCX
    if ((NNshGlobal->NNsiParam)->addMenuDeviceInfo != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_SHOWDEVINFO);
        ptr = ptr + sizeof(NNSH_JUMPMSG_SHOWDEVINFO);
        jumpList[itemCnt] = NNSH_JUMPSEL_SHOWDEVINFO;
        itemCnt++;
    }

    // DirIDirړ
    if ((NNshGlobal->NNsiParam)->addMenuDirSelect != 0)
    {
        if ((NNshGlobal->NNsiParam)->lastBBS == NNSH_SELBBS_OFFLINE)
        {
            // QƃÔƂ̂ݕ\
            StrCopy(ptr, NNSH_JUMPMSG_DIRSELECTION);
            ptr = ptr + sizeof(NNSH_JUMPMSG_DIRSELECTION);
            jumpList[itemCnt] = NNSH_JUMPSEL_DIRSELECTION;
            itemCnt++;

            StrCopy(ptr, NNSH_JUMPMSG_CHANGELOGDIR);
            ptr = ptr + sizeof(NNSH_JUMPMSG_CHANGELOGDIR);
            jumpList[itemCnt] = NNSH_JUMPSEL_CHANGELOGDIR;
            itemCnt++;
        }
    }

    // NNsiI
    if ((NNshGlobal->NNsiParam)->addMenuNNsiEnd != 0)
    {
        StrCopy(ptr, NNSH_JUMPMSG_NNSIEND);
        ptr = ptr + sizeof(NNSH_JUMPMSG_NNSIEND);
        jumpList[itemCnt] = NNSH_JUMPSEL_NNSIEND;
        itemCnt++;
    }

    // Oʒuړ
    if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) == 0)
    {
        // VFSgpݒ̂Ƃ̂ݕ\
        StrCopy(ptr, NNSH_JUMPMSG_CHANGELOGLOC);
        ptr = ptr + sizeof(NNSH_JUMPMSG_CHANGELOGLOC);
        jumpList[itemCnt] = NNSH_JUMPSEL_CHANGELOGLOC;
        itemCnt++;
    }

#ifdef USE_BT_CONTROL
    // Bluetooth On/Off
    if ((NNshGlobal->NNsiParam)->addBtOnOff != 0)
    {
            // XgɁuBt On/Bt Offvǉ
            StrCopy(ptr, NNSH_JUMPMSG_BT_ON);
            ptr = ptr + sizeof(NNSH_JUMPMSG_BT_ON);
            jumpList[itemCnt] = NNSH_JUMPSEL_BT_ON;
            itemCnt++;

            StrCopy(ptr, NNSH_JUMPMSG_BT_OFF);
            ptr = ptr + sizeof(NNSH_JUMPMSG_BT_OFF);
            jumpList[itemCnt] = NNSH_JUMPSEL_BT_OFF;
            itemCnt++;
    }
#endif

    // IEBhE\
    btnId = NNshWinSelectionWindow(FRMID_JUMPMSG, listPtr, itemCnt, 0);
    if (btnId != BTNID_JUMPCANCEL)
    {
        // IXgԍj[ԍ̕ϊ
        btnId = jumpList[NNshGlobal->jumpSelection];
        switch (btnId)
        {
          case NNSH_JUMPSEL_OPENBBS:
            // BBSꗗI(|bvAbv)
            (void) ExecuteAction(MULTIBTN_FEATURE_SELECT_BBS);
            break;

          case NNSH_JUMPSEL_OPENMENU:
            // j[J
            // (_~[ō㕔penDownEvent𐶐)
            dummyEvent = &(NNshGlobal->dummyEvent);
            MemSet(dummyEvent, sizeof(EventType), 0x00);
            dummyEvent->eType    = penDownEvent;
            dummyEvent->penDown  = true;
            dummyEvent->tapCount = 1;
            dummyEvent->screenX  = 5;
            dummyEvent->screenY  = 5;
            EvtAddEventToQueue(dummyEvent);
            break;

          case NNSH_JUMPSEL_DISCONNECT:
            // ؒf
            savedParam = (NNshGlobal->NNsiParam)->confirmationDisable;
            (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
            NNshNet_LineHangup();
            (NNshGlobal->NNsiParam)->confirmationDisable = savedParam;
            break;

          case NNSH_JUMPSEL_OPENNEW:
            // VmF
            (void) ExecuteAction(MULTIBTN_FEATURE_NEWARRIVAL);
            break;

          case NNSH_JUMPSEL_OPENLIST:
            // ꗗXV
            (void) ExecuteAction(MULTIBTN_FEATURE_GETLIST);
            break;

          case NNSH_JUMPSEL_OPENGET:
            // bZ[W擾(擾/S擾͎f)
            (void) ExecuteAction(MULTIBTN_FEATURE_GET);
            break;

          case NNSH_JUMPSEL_OPENMES:
            // XQ
            (void) ExecuteAction(MULTIBTN_FEATURE_OPEN);
            break;

          case NNSH_JUMPSEL_OPENINFO:
            // X\
            (void) ExecuteAction(MULTIBTN_FEATURE_INFO);
            break;

          case NNSH_JUMPSEL_COPYMSG:
            // QƃOփRs[
            (void) ExecuteAction(MULTIBTN_FEATURE_COPYGIKO);
            break;

          case NNSH_JUMPSEL_DELMSG:
            // X폜
            (void) ExecuteAction(MULTIBTN_FEATURE_DELETE);
            break;

          case NNSH_JUMPSEL_GRAPHMODE:
            // `惂[hύX
            (void) ExecuteAction(MULTIBTN_FEATURE_GRAPHMODE);
            return (true);
            break;

          case NNSH_JUMPSEL_MULTISW1:
            // ړIXCb`PƂɂ
            frm  = FrmGetActiveForm();
            ctlP = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,CHKID_SELECT_GETMODE));
            btnId = CtlGetValue(ctlP);
            btnId = (btnId == 0) ? 1 : 0;
            CtlSetValue(ctlP, btnId);
            CtlHitControl(ctlP);
            break;

          case NNSH_JUMPSEL_MULTISW2:
            // ړIXCb`QƂɂ
            frm  = FrmGetActiveForm();
            ctlP = FrmGetObjectPtr(frm,
                             FrmGetObjectIndex(frm,CHKID_SELECT_MULTIPURPOSE));
            btnId = CtlGetValue(ctlP);
            btnId = (btnId == 0) ? 1 : 0;
            CtlSetValue(ctlP, btnId);
            CtlHitControl(ctlP);
            break;

          case NNSH_JUMPSEL_SHOWDEVINFO:
            // foCX\
            (void) ExecuteAction(MULTIBTN_FEATURE_DEVICEINFO);
            break;

          case NNSH_JUMPSEL_DIRSELECTION:
            // fBNgI
            (void) ExecuteAction(MULTIBTN_FEATURE_DIRSELECT);
            return (true);
            break;

          case NNSH_JUMPSEL_NNSIEND:
            // NNsiI
            dummyEvent = &(NNshGlobal->dummyEvent);
            MemSet(dummyEvent, sizeof(EventType), 0x00);
            dummyEvent->eType    = appStopEvent;
            EvtAddEventToQueue(dummyEvent);
            break;

          case NNSH_JUMPSEL_CHANGELOGDIR:
            // Oi[fBNg̕ύX
            (void) ExecuteAction(MULTIBTN_FEATURE_MOVELOGDIR);
            return (true);
            break;

          case NNSH_JUMPSEL_CHANGELOGLOC:
            // OǗꏊ̕ύX
            (void) ExecuteAction(MULTIBTN_FEATURE_MOVELOGLOC);
            return (true);
            break;
            
#ifdef USE_BT_CONTROL
          case NNSH_JUMPSEL_BT_ON:
            // Bluetooth On
            (void) ExecuteAction(MULTIBTN_FEATURE_BT_ON);
            break;

          case NNSH_JUMPSEL_BT_OFF:
            // Bluetooth Off
            (void) ExecuteAction(MULTIBTN_FEATURE_BT_OFF);
            break;
#endif
          case NNSH_JUMPSEL_OPENGETLOGLIST:
            // QƃOꗗʂJ
            (void) ExecuteAction(MULTIBTN_FEATURE_OPENGETLOGLIST);
            break;

          default:
            // Ȃ
            break;
        }
    }
    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function : NNshMain_Close                                             */
/*                                                      ꗗʂ̃N[Y */
/*-------------------------------------------------------------------------*/
static void NNshMain_Close(UInt16 nextFormID)
{
#ifdef ERASE_NOTRECEIVED_THREAD_CLOSEFORM
    UInt16 savedParam;

    if ((NNshGlobal->NNsiParam)->autoDeleteNotYet != 0)
    {
        // ړɖ擾X폜
        savedParam = (NNshGlobal->NNsiParam)->confirmationDisable;
        (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
        delete_notreceived_message(false);
        (NNshGlobal->NNsiParam)->confirmationDisable = savedParam;
    }
#endif

    // X^Cg\폜
    ClearMsgTitleInfo();

    // ʂ̉ʂJ
    FrmEraseForm(FrmGetActiveForm());
    FrmGotoForm(nextFormID);

    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   copy_to_readOnly                                         */
/*                                      Ot@CQƃOɃRs[ */
/*-------------------------------------------------------------------------*/
static Boolean copy_to_readOnly(void)
{
    Err                  ret;
    UInt16               selM, selBBS, butID;
    NNshSubjectDatabase  mesInfo;
    NNshBoardDatabase    bbsInfo;
    Char                *fileName, *orgName, *area;

    // {@\́AVFSpł|\(VFSȊO͏sȂ)
    if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) == 0)
    {
        NNsh_ErrorMessage(ALTID_WARN, MSG_ONLYVFS_FEATURE, "", 0);
        return (false);
    }

    // obt@̊m
    fileName = MEMALLOC_PTR(MAXLENGTH_FILENAME);
    if (fileName == NULL)
    {
        return (false);
    }
    orgName  = MEMALLOC_PTR(MAXLENGTH_FILENAME);
    if (orgName == NULL)
    {
        MEMFREE_PTR(fileName);
        return (false);
    }

    // X擾
    ret = get_message_Info(&mesInfo, &selM, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        goto FUNC_END;
    }

    if (mesInfo.state == NNSH_SUBJSTATUS_NOT_YET)
    {
        //  X擾̂߁ARs[͍sȂ
        NNsh_InformMessage(ALTID_WARN, MSG_NOTGET_MESSAGE,
                           mesInfo.threadTitle, 0);
        ret = ~errNone;
        goto FUNC_END;
    }

    // Rs[fBNg쐬
    MemSet (fileName, MAXLENGTH_FILENAME, 0x00);

    // Ox[XfBNgt
    area = NULL;
    if (NNshGlobal->logPrefixH != 0)
    {
        area = MemHandleLock(NNshGlobal->logPrefixH);
    }
    if (area == NULL)
    {
        StrCopy(fileName, LOGDATAFILE_PREFIX);
    }
    else
    {
        StrCopy(fileName, area);
        MemHandleUnlock(NNshGlobal->logPrefixH);
    }
    StrCat (fileName, mesInfo.boardNick);
    fileName[StrLen(fileName) - 1] = '\0';
    (void) CreateDir_NNsh(fileName);

    // Rs[t@C쐬
    StrCat (fileName, "/");
    StrCat (fileName, mesInfo.threadFileName);

    // Rs[t@C쐬
    MemSet (orgName, MAXLENGTH_FILENAME, 0x00);
    StrCopy(orgName, mesInfo.boardNick);
    StrCat (orgName, mesInfo.threadFileName);

    // t@C{ɃRs[邩mF
    butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_CONFIRM_COPY,
                                mesInfo.threadTitle, 0);
    if (butID != 0)
    {
        // CancelI(Ȃ)
        ret = ~errNone;
        goto FUNC_END;
    }

    // Rs[̎{
    NNsh_DebugMessage(ALTID_INFO, "Dest :",   fileName, 0);
    NNsh_DebugMessage(ALTID_INFO, "Source :", orgName, 0);
    Show_BusyForm(MSG_COPY_IN_PROGRESS);

    if (mesInfo.msgState == FILEMGR_STATE_OPENED_STREAM)
    {
        // Palm{̂VFS̎QƃOփRs[
        ret = CopyFile_NNsh(fileName, orgName, NNSH_COPY_PALM_TO_VFS);
    }
    else
    {
        // VFS̃OVFS̎QƃOփRs[
        ret = CopyFile_NNsh(fileName, orgName, NNSH_COPY_VFS_TO_VFS);
    }
    Hide_BusyForm(false);
    if (ret != errNone)
    {
        // t@CRs[ɎsB
        (void) DeleteFile_NNsh(fileName, NNSH_VFS_ENABLE);

        // Rs[Ɏs|\
        NNsh_ErrorMessage(ALTID_ERROR, MSG_FAILURE_COPY, fileName, ret);
        goto FUNC_END;
    }

    // Rs[ʒm
    NNsh_InformMessage(ALTID_INFO, MSG_INFORM_COPYEND, "", 0);

FUNC_END:
    MEMFREE_PTR(orgName);
    MEMFREE_PTR(fileName);
    if (ret != errNone)
    {
        return (false);
    }

    if ((NNshGlobal->NNsiParam)->copyDelReadOnly != 0)
    {
        // Rs[ƂARs[t@C폜
        return (delete_message());
    }
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   move_log_directory                                       */
/*                                Ot@C̊i[fBNgύX */
/*-------------------------------------------------------------------------*/
static Boolean move_log_directory(void)
{
    Err                  ret;
    UInt16               selM, dirIndex;
    Char                 source[BUFSIZE + MARGIN], dest[BUFSIZE + MARGIN];
    Char                *area;
    NNshSubjectDatabase  mesInfo;

    ret = ~errNone;

    // {@\́AVFSpł|\(VFSȊO͏sȂ)
    if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) == 0)
    {
        NNsh_ErrorMessage(ALTID_WARN, MSG_ONLYVFS_FEATURE, "", 0);
        goto FUNC_END;
    }

    // {@\́AVFSɎQƃOuꍇɂgȂ|\
    if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_USEOFFLINE) == 0)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_OFFLOG_VFS_FEATURE, "", 0);
        goto FUNC_END;
    }

    // X擾
    ret = get_subject_info(&mesInfo, &selM);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "get_subject_info()", "", ret);
        goto FUNC_END;
    }

    // w肳ꂽXQƃOmF
#ifdef USE_STRSTR
    if (StrCompare(mesInfo.boardNick, OFFLINE_THREAD_NICK) != 0)
#else
    if ((mesInfo.boardNick[0]  != '!')||
        (mesInfo.boardNick[1]  != 'G')||
        (mesInfo.boardNick[2]  != 'i')||
        (mesInfo.boardNick[3]  != 'k'))
#endif
    {
        //  QƃOł͂Ȃ߁Aړ͍sȂ
        NNsh_InformMessage(ALTID_WARN, MSG_NOTMOVE_LOGMESSAGE,
                           mesInfo.threadTitle, 0);
        ret = ~errNone;
        goto FUNC_END;
    }

    // Oړ̎w
    dirIndex = select_readonly_directory(mesInfo.dirIndex);
    if (dirIndex == mesInfo.dirIndex)
    {
        // Öړ悪w肳ȂAI
        ret = ~errNone;
        goto FUNC_END;
    }

    // QƃOi[fBNg̃x[Xt
    if ((NNshGlobal->logPrefixH == 0)||
         ((area = MemHandleLock(NNshGlobal->logPrefixH)) == NULL))
    {
        // ftHg̃fBNggp
        StrCopy(source, LOGDATAFILE_PREFIX);
        StrCopy(dest,   LOGDATAFILE_PREFIX);
    }
    else
    {
        // JX^}CYꂽfBNggp
        StrCopy(source, area);
        StrCopy(dest,   area);
        MemHandleUnlock(NNshGlobal->logPrefixH);
    }

    // ɃTufBNgĕt
    GetSubDirectoryName(mesInfo.dirIndex, &source[StrLen(source)]);
    GetSubDirectoryName(dirIndex, &dest[StrLen(dest)]);

    // t@Ct
    StrCat(source, mesInfo.threadFileName);
    StrCat(dest,   mesInfo.threadFileName);

    // t@C{ɃRs[邩mF
    if (NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_CONFIRM_MOVELOGDIR,
                            mesInfo.threadTitle, 0) != 0)
    {
        // CancelI(Ȃ)
        ret = ~errNone;
        goto FUNC_END;
    }

    // OfBNgύX̎{
    Show_BusyForm(MSG_MOVEDIR_IN_PROGRESS);

    // OǗs
    ret = CopyFile_NNsh(dest, source, NNSH_COPY_VFS_TO_VFS);
    if (ret != errNone)
    {
        // t@C̃Rs[Ɏs
        // Rs[悤Ƃt@C(r[ȃt@C)폜
        DeleteFile_NNsh(dest, NNSH_VFS_ENABLE);
    }
    else
    {
        // Rs[Ot@C폜
        DeleteFile_NNsh(source, NNSH_VFS_ENABLE);

        // DBɋL^Ăi[ꏊXV
        mesInfo.dirIndex = dirIndex;
    }

    Hide_BusyForm(false);
    if (ret != errNone)
    {
        // Rs[Ɏs|\
        NNsh_ErrorMessage(ALTID_ERROR, MSG_FAILURE_COPY, mesInfo.threadFileName, ret);
        goto FUNC_END;
    }

    // Rs[ʒm
    NNsh_InformMessage(ALTID_INFO, MSG_INFORM_CHGLOGDIR_END, dest, 0);

    // f[^XV(IԍDB Indexԍ֕ϊčXV)
    dirIndex = convertListIndexToMsgIndex(selM);
    ret = update_subject_database(dirIndex, &mesInfo);
    if (ret != errNone)
    {
        // 肦Ȃ͂...
        NNsh_DebugMessage(ALTID_ERROR, "update_subject_database()"," ", ret);
    }

FUNC_END:
    // ÕRs[ɐꍇ́AXgč쐬ĕ\
    Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 
                       (NNshGlobal->NNsiParam)->selectedTitleItem, NNSH_STEP_REDRAW);
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   move_log_location                                        */
/*                                        Ot@C̊ǗꏊύX */
/*-------------------------------------------------------------------------*/
static Boolean move_log_location(void)
{
    Err                  ret;
    UInt16               selM;
    NNshSubjectDatabase  mesInfo;

    // {@\́AVFSpł|\(VFSȊO͏sȂ)
    if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) == 0)
    {
        NNsh_ErrorMessage(ALTID_WARN, MSG_ONLYVFS_FEATURE, "", 0);
        return (false);
    }

    // X擾
    ret = get_subject_info(&mesInfo, &selM);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, "get_subject_info()", "", ret);
        goto FUNC_END;
    }

    if (mesInfo.state == NNSH_SUBJSTATUS_NOT_YET)
    {
        //  X擾̂߁ARs[͍sȂ
        NNsh_InformMessage(ALTID_WARN, MSG_NOTGET_MESSAGE,
                           mesInfo.threadTitle, 0);
        ret = ~errNone;
        goto FUNC_END;
    }

    // t@C{ɃRs[邩mF
    if (NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_CONFIRM_MANAGELOGLOC,
                                mesInfo.threadTitle, 0) != 0)
    {
        // CancelI(Ȃ)
        ret = ~errNone;
        goto FUNC_END;
    }

    // ǗꏊύX̎{
    Show_BusyForm(MSG_CHANGE_IN_PROGRESS);

    // OǗs
    ret = MoveLogMessage((NNshGlobal->NNsiParam)->openMsgIndex);

    Hide_BusyForm(false);
    if (ret != errNone)
    {
        // Rs[Ɏs|\
        NNsh_ErrorMessage(ALTID_ERROR, MSG_FAILURE_COPY, mesInfo.threadFileName, ret);
        goto FUNC_END;
    }

    // Rs[ʒm
    NNsh_InformMessage(ALTID_INFO, MSG_INFORM_CHANGELOCEND, mesInfo.threadTitle, 0);

FUNC_END:
    if (ret != errNone)
    {
        return (false);
    }

    // ÕRs[ɐꍇ́AXgč쐬ĕ\
    Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 
                       (NNshGlobal->NNsiParam)->selectedTitleItem, NNSH_STEP_REDRAW);

    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   set_SearchTitleString                                    */
/*                                                X^C̐ݒ */
/*-------------------------------------------------------------------------*/
static Boolean set_SearchTitleString(MemHandle *bufH)
{
    Boolean       ret = false;
    Char         *ptr = NULL;

    // ̈̎擾
    if (*bufH == 0)
    {
        *bufH = MemHandleNew(BUFSIZE);
        if (*bufH == 0)
        {
            return (false);
        }
        ptr = MemHandleLock(*bufH);
        if (ptr != NULL)
        {
            MemSet(ptr, BUFSIZE, 0x00);
        }
    }
    else
    {
        ptr = MemHandleLock(*bufH);
    }
    if (ptr == NULL)
    {
        // ̈擾s
        MemHandleFree(*bufH);
        *bufH = 0;
        return (false);
    }

    // ̓EBhEJAf[^l
    ret = DataInputDialog(NNSH_INPUTWIN_SEARCH,
                          ptr, BUFSIZE, NNSH_DIALOG_USE_SEARCH, NULL);

    MemHandleUnlock(*bufH);

    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   isValidRecordForSearchTitle                              */
/*                  X^C{Ă悢Xǂ̃`FbN */
/*-------------------------------------------------------------------------*/
static Boolean isValidRecordForSearchTitle(UInt16  selBBS, Char *bbsName,
                                           NNshSubjectDatabase  *mesInfo)
{
    // Xg`FbN
    switch (selBBS)
    {
      case NNSH_SELBBS_FAVORITE:
        if ((mesInfo->msgAttribute & NNSH_MSGATTR_FAVOR) < (NNshGlobal->NNsiParam)->displayFavorLevel)
        {
            // uCɓvł͂Ȃ
            return (false);
        }
        break;

      case NNSH_SELBBS_GETALL:
        if (mesInfo->state == NNSH_SUBJSTATUS_NOT_YET)
        {
            // 擾ςݑSĂ̂Ƃ͖擾̃Xł͂Ȃꍇ
            return (false);
        }
        break;

      case NNSH_SELBBS_NOTREAD:
        if ((mesInfo->state != NNSH_SUBJSTATUS_NEW)&&
            (mesInfo->state != NNSH_SUBJSTATUS_UPDATE)&&
            (mesInfo->state != NNSH_SUBJSTATUS_REMAIN))
        {
            // ǂXł͂Ȃ
            return (false);
        }
        break;

      case NNSH_SELBBS_CUSTOM1:
        // mF{邩ǂ̊mF([UݒP)
        return (CheckIfCustomTabIsValid(bbsName, mesInfo, &((NNshGlobal->NNsiParam)->custom1)));
        break;

      case NNSH_SELBBS_CUSTOM2:
        // mF{邩ǂ̊mF([UݒQ)
        return (CheckIfCustomTabIsValid(bbsName, mesInfo, &((NNshGlobal->NNsiParam)->custom2)));
        break;

      case NNSH_SELBBS_CUSTOM3:
        // mF{邩ǂ̊mF([UݒR)
        return (CheckIfCustomTabIsValid(bbsName, mesInfo, &((NNshGlobal->NNsiParam)->custom3)));
        break;

      case NNSH_SELBBS_CUSTOM4:
        // mF{邩ǂ̊mF([UݒS)
        return (CheckIfCustomTabIsValid(bbsName, mesInfo, &((NNshGlobal->NNsiParam)->custom4)));
        break;

      case NNSH_SELBBS_CUSTOM5:
        // mF{邩ǂ̊mF([UݒT)
        return (CheckIfCustomTabIsValid(bbsName, mesInfo, &((NNshGlobal->NNsiParam)->custom5)));
        break;

      default:
        if (StrCompare(bbsName, mesInfo->boardNick) != 0)
        {
            // X̏vȂ
            return (false);
        }
        break;
    }
    // sX
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   search_NextBBS                                           */
/*                                                               */
/*-------------------------------------------------------------------------*/
static Boolean search_NextBBS(UInt16 start, UInt16 *bbsId)
{
    FormType        *frm;
    ListType        *lstP;
    Char            *ptr;
    Char             msg[BUFSIZE];
    Char             match1[BUFSIZE], match2[MAX_BOARDNAME + MARGIN];
    UInt16           selBBS, maxBBS;

    // 񂪊mۍς݂mF
    if (NNshGlobal->searchBBSH == 0)
    {
        return (false);
    }

    // 񂪐ݒς݂̏ꍇɂ́A̕擾
    ptr = MemHandleLock(NNshGlobal->searchBBSH);
    if ((ptr == NULL)||(*ptr == '\0'))
    {
        return (false);
    }

    // X̎{(\)
    MemSet (msg, sizeof(msg), 0x00);
    StrCopy(msg, MSG_SEARCHING_TITLE);
    StrCat (msg, ptr);
    Show_BusyForm(msg);

    // ...
    if (start < NNSH_NOF_SPECIAL_BBS)
    {
        // ͒ʏ̂݁B
        start = NNSH_NOF_SPECIAL_BBS;
    }

    // 召ϊi͕j
    if ((NNshGlobal->NNsiParam)->searchCaseless != 0)
    {
        (void) StrToLower(match1, ptr);
    }
    else
    {
        (void) StrCopy(match1, ptr);
    }

    frm     = FrmGetActiveForm();
    lstP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
    maxBBS  = LstGetNumberOfItems(lstP);

    // iXg̈ꗗjT
    for (selBBS = start; selBBS < maxBBS; selBBS++)
    {
        // 召ϊio͕j
        MemSet (match2, sizeof(match2), 0x00);
        if ((NNshGlobal->NNsiParam)->searchCaseless != 0)
        {
            (void) StrToLower(match2, LstGetSelectionText(lstP, selBBS));
        }
        else
        {
            (void) StrCopy(match2, LstGetSelectionText(lstP, selBBS));
        }

        if (StrStr(match2, match1) != NULL)
        {
            // 񂪌I
            Hide_BusyForm(false);
            *bbsId = selBBS;
            MemHandleUnlock(NNshGlobal->searchBBSH);
            return (true);
        }
    }

    // \
    Hide_BusyForm(false);

    // Ɏs(Ȃ)
    NNsh_InformMessage(ALTID_WARN, MSG_NOTFOUND_TITLE, ptr, 0);
    MemHandleUnlock(NNshGlobal->searchBBSH);

    // Xꗗʂĕ\
    NNsi_RedrawThreadList();

    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   search_NextTitle                                         */
/*                                                        X^C */
/*-------------------------------------------------------------------------*/
static Boolean search_NextTitle(Int16 direction)
{
    Err                  ret;
    Char                 msg[BUFSIZE], match1[BUFSIZE], match2[MAX_THREADNAME];
    Char                *ptr;
    UInt16               selMES, selBBS, index, loop, end;
    Int16                step;
    DmOpenRef            dbRef;
    NNshSubjectDatabase  mesInfo;
    NNshBoardDatabase    bbsInfo;

    // X^CꗗȂꍇ́Aɉ
    if (NNshGlobal->nofTitleItems == 0)
    {
        // R[h񂪑݂Ȃ
        NNsh_InformMessage(ALTID_WARN, MSG_NOTFOUND_TITLE, MSG_NOTFOUND_OMIT, 0);
        return (false);
    }

    // 񂪊mۍς݂mF
    if (NNshGlobal->searchTitleH == 0)
    {
        return (false);
    }

    // 񂪐ݒς݂̏ꍇɂ́A̕擾
    ptr = MemHandleLock(NNshGlobal->searchTitleH);
    if ((ptr == NULL)||(*ptr == '\0'))
    {
        return (false);
    }

    // (J[\ʒu)̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        goto FUNC_END;
    }

    // [Uݒ̂Ƃɂ́Aʓr擾
    switch (selBBS)
    {
       case NNSH_SELBBS_CUSTOM1:
        // [UݒP
        ret = Get_BBS_Info((NNshGlobal->NNsiParam)->custom1.boardNick, &bbsInfo);
        break;

       case NNSH_SELBBS_CUSTOM2:
        // [UݒQ
        ret = Get_BBS_Info((NNshGlobal->NNsiParam)->custom2.boardNick, &bbsInfo);
        break;

       case NNSH_SELBBS_CUSTOM3:
        // [UݒR
        ret = Get_BBS_Info((NNshGlobal->NNsiParam)->custom3.boardNick, &bbsInfo);
        break;

       case NNSH_SELBBS_CUSTOM4:
        // [UݒS
        ret = Get_BBS_Info((NNshGlobal->NNsiParam)->custom4.boardNick, &bbsInfo);
        break;

       case NNSH_SELBBS_CUSTOM5:
        // [UݒT
        ret = Get_BBS_Info((NNshGlobal->NNsiParam)->custom5.boardNick, &bbsInfo);
        break;

       default:
         // [UݒȊO
         ret = errNone;
         break;        
    }
    if (ret != errNone)
    {
        goto FUNC_END;
    }

    // X̎{(\)
    MemSet (msg, sizeof(msg), 0x00);
    StrCopy(msg, MSG_SEARCHING_TITLE);
    StrCat (msg, ptr);
    Show_BusyForm(msg);

    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (direction == NNSH_SEARCH_FORWARD)
    {
        // tH[hw
        GetDBCount_NNsh(dbRef, &end);
        end  = 0;
        step = -1;
    }
    else
    {
        // obN[hw
        GetDBCount_NNsh(dbRef, &end);
        end--;
        step = 1;
    }

    // 啶ʂȂꍇɂ́Aɕϊ
    MemSet(match1, sizeof(match1), 0x00);
    if ((NNshGlobal->NNsiParam)->searchCaseless != 0)
    {
        (void) StrToLower(match1, ptr);
    }
    else
    {
        (void) StrCopy(match1, ptr);
    }

    // JnR[hԍ擾
    index = convertListIndexToMsgIndex(selMES);
    if (ret != errNone)
    {
        // R[h̎擾ɎsAs\
        goto FUNC_END;
    }
    // JnR[hԍ""猟{悤
    index = index + step;

    // ̎
    for (loop = index; loop != end; loop = loop + step)
    {
        // GetRecord_NNsh()Ń[NAĂ邽ߕsv
        // MemSet(&tmpDb, sizeof(NNshSubjectDatabase), 0x00);
        GetRecord_NNsh(dbRef, loop, sizeof(NNshSubjectDatabase), &mesInfo);

        // rɍvXǂ̃`FbN
        if (isValidRecordForSearchTitle(selBBS, bbsInfo.boardNick, &mesInfo) ==
            false)
        {
            // rKv̂ȂXAɂ
            continue;
        }

        //  w肳ꂽƃ}b`邩mF
        MemSet(match2, sizeof(match2), 0x00);
        if ((NNshGlobal->NNsiParam)->searchCaseless != 0)
        {
            // X^Cɕϊ
            (void) StrToLower(match2, mesInfo.threadTitle);
        }
        else
        {
            (void) StrCopy(match2, mesInfo.threadTitle);
        }

        if (StrStr(match2, match1) != NULL)
        {
            // 񂪌I
            CloseDatabase_NNsh(dbRef);
            Hide_BusyForm(false);

            // Xꗗ̕\ӏύX
            (NNshGlobal->NNsiParam)->startTitleRec = loop;
            (NNshGlobal->NNsiParam)->endTitleRec   = loop;
            (NNshGlobal->NNsiParam)->titleDispState = NNSH_DISP_HALFWAY;
            Update_Thread_List(selBBS, 0, NNSH_STEP_REDRAW);
            MemHandleUnlock(NNshGlobal->searchTitleH);
            return (true);
        }
    }
    CloseDatabase_NNsh(dbRef);
    Hide_BusyForm(false);

FUNC_END:
    // Ɏs
    NNsh_InformMessage(ALTID_WARN, MSG_NOTFOUND_TITLE, ptr, 0);
    MemHandleUnlock(NNshGlobal->searchTitleH);

    // XXg̍XV(SELMES)
    Update_Thread_List(selBBS, (NNshGlobal->NNsiParam)->selectedTitleItem, NNSH_STEP_REDRAW);

    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   get_subject_info                                         */
/*                                                   bZ[W̎擾  */
/*-------------------------------------------------------------------------*/
static Err get_subject_info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR)
{
    Err ret;

    if (NNshGlobal->nofTitleItems == 0)
    {
        // R[h񂪑݂Ȃ
        return (~errNone);
    }

    // bZ[W̏
    *selTHR                    = (NNshGlobal->NNsiParam)->selectedTitleItem;
    (NNshGlobal->NNsiParam)->openThreadIndex = *selTHR;

    // XgԍXindexɕϊ
    (NNshGlobal->NNsiParam)->openMsgIndex    = convertListIndexToMsgIndex(*selTHR);

    // X擾
    ret = Get_Subject_Database((NNshGlobal->NNsiParam)->openMsgIndex, mesInfo);
    if (ret != errNone)
    {
        // R[h̎擾Ɏs
        NNsh_DebugMessage(ALTID_ERROR, "Get_Subject_Database()", "", ret);
        MemSet(mesInfo, sizeof(NNshSubjectDatabase), 0x00);
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   get_message_Info                                         */
/*                                                   bZ[W̎擾  */
/*-------------------------------------------------------------------------*/
static Err get_message_Info(NNshSubjectDatabase *mesInfo,  UInt16 *selTHR, 
                            NNshBoardDatabase   *bbsInfo,  UInt16 *selBBS)
{
    Err        ret;
    FormType  *frm;
    ListType  *lstP;
    UInt16     dummy;

    *selBBS = 0;

    // X擾
    ret = get_subject_info(mesInfo, selTHR);
    if (ret != errNone)
    {
        return (~errNone);
    }

    // IĂBBS̃Xgԍ擾
    frm     = FrmGetActiveForm();
    lstP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
    *selBBS = LstGetSelection(lstP);

    // IꂽBBS̃XgԍŁABBS̃[h𔻒f
    if (*selBBS >= NNSH_SELBBS_OFFLINE)
    {
        // BBSȊÔƂ́ABBS擾
        ret = Get_BBS_Info(*selBBS, bbsInfo);
    }
    else
    {
        // ́AboardNickgBBS擾
        ret = Get_BBS_Database(mesInfo->boardNick, bbsInfo, &dummy);
    }
    return (ret);
}

/*-------------------------------------------------------------------------*/
/*   Function :   display_message                                          */
/*                                                        bZ[W̕\ */
/*-------------------------------------------------------------------------*/
static Boolean display_message(void)
{
    Err                  ret;
    UInt16               selM, butID, selBBS;
    NNshSubjectDatabase  subjInfo;
    NNshBoardDatabase    bbsInfo;

    // X擾
    ret = get_message_Info(&subjInfo, &selM, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // X擾̂ƂA擾̎|xAX擾邩mFB
    if (subjInfo.state == NNSH_SUBJSTATUS_NOT_YET)
    {
        butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_NOT_YET_SUBJECT, 
                                    MSG_CONFIRM_GETALLMSG, 0);
        if (butID != 0)
        {
            // CancelI(Ȃ)
            return (true);
        }
        // X擾
        if (get_all_message() == false)
        {
            // Xꗗʂĕ\
            NNsi_RedrawThreadList();
            return (false);
        }
        // Xf[^擾łƂ́Aʂ\ɑJڂB
    }

    // BBS(Ō)QƂƂɕύX(CɓΉ)
    (NNshGlobal->NNsiParam)->lastBBS = selBBS;

    // QƉʂI[v
    NNshMain_Close(FRMID_MESSAGE);

    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   get_all_message                                          */
/*                                                     bZ[WS擾  */
/*-------------------------------------------------------------------------*/
static Boolean get_all_message(void)
{
    Boolean             err = false;
    Err                 ret;
    Char                url[BUFSIZE];
    UInt16              butID, selMES, selBBS, index;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // ݂̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // OFFLINEXIꂽꍇAXVs\
    if (StrCompare(mesInfo.boardNick, OFFLINE_THREAD_NICK) == 0)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE,
                           mesInfo.threadTitle, 0);
        return (false);
    }

    // 擾~aar̃XIꂽꍇAXVs\
    if (((bbsInfo.state) & (NNSH_BBSSTATE_SUSPEND)) == NNSH_BBSSTATE_SUSPEND)
    {
        NNsh_InformMessage(ALTID_WARN, bbsInfo.boardName,
                           MSG_WARN_SUSPENDBBS, 0);
        return (false);
    }

    // XXXg̏ʂɂ邩`FbN
    if (Check_same_thread(selMES, &mesInfo, NULL, &butID) == errNone)
    {
        //  XꍇADB̕sh~邽߁Ax\
        // f[^̎擾sȂB
        NNsh_InformMessage(ALTID_WARN, MSG_THREADLIST_ALREADY,
                           mesInfo.threadTitle, 0);
        NNsi_RedrawThreadList();
        return (false);
    }

    if (mesInfo.state != NNSH_SUBJSTATUS_NOT_YET)
    {
        // Ɏ擾ς݁AbZ[Wŏ擾邪A{ɂ̊mF
        butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_GET_ALREADY, 
                                    MSG_CONFIRM_GETALLMSG, 0);
        if (butID != 0)
        {
            // LZ
            NNsh_InformMessage(ALTID_INFO, MSG_ABORT_INFO, "", 0);
            NNsi_RedrawThreadList();
            return (false);
        }
    }
    ////////////  bZ[WS擾̏  ///////////

    //  擾\@\LłlbgɐڑĂȂꍇA
    // 擾\񂷂邩mF
    if (((NNshGlobal->NNsiParam)->getReserveFeature != 0)&&(NNshGlobal->netRef == 0))
    {
        if (NNsh_ConfirmMessage(ALTID_CONFIRM,
                                NNSH_MSGINFO_RESERVE, "", 0) == 0)
        {
            // XgԍXindexɕϊ
            index = convertListIndexToMsgIndex(selMES);

            // V\񎞂Ɏ擾\ݒ肵ďI
            mesInfo.msgAttribute
                     = mesInfo.msgAttribute | NNSH_MSGATTR_GETRESERVE;
            (void) update_subject_database(index, &mesInfo);

            // XXg̍XV(SELMES)
            err = Update_Thread_List(selBBS,
                             (NNshGlobal->NNsiParam)->selectedTitleItem,
                             NNSH_STEP_REDRAW);
            return (true);
        }
    }

    /** (VFS)fBNg쐬 **/
    (void) CreateDir_NNsh(mesInfo.boardNick);

    // bZ[W擾̍쐬
    (void) CreateThreadURL(NNSH_DISABLE, url, sizeof(url), &bbsInfo, &mesInfo);
    
    // XgԍXindexɕϊ
    index = convertListIndexToMsgIndex(selMES);

    // O擾ыL^
    ret = Get_AllMessage(url, bbsInfo.boardNick, mesInfo.threadFileName,
                         index, (UInt16) bbsInfo.bbsType);
    if ((ret == errNone)&&((bbsInfo.state&(NNSH_BBSSTATE_LEVELMASK)) != 0))         
    {
        // MIAWXxݒ肳Ăꍇ
        if (Get_Subject_Database(index, &mesInfo) == errNone)
        {
            // BBSɐݒ肳ꂽWXx𔽉f
            switch ((bbsInfo.state)&(NNSH_BBSSTATE_LEVELMASK))
            {
              case NNSH_BBSSTATE_FAVOR_L1:
                // Lxɐݒ
                mesInfo.msgAttribute
                   = ((mesInfo.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR_L1));
                break;

              case NNSH_BBSSTATE_FAVOR_L2:
                // 1xɐݒ
                mesInfo.msgAttribute
                   = ((mesInfo.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR_L2));
                break;

              case NNSH_BBSSTATE_FAVOR_L3:
                // 2xɐݒ
                mesInfo.msgAttribute
                   = ((mesInfo.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR_L3));
                break;

              case NNSH_BBSSTATE_FAVOR_L4:
                // 3xɐݒ
                mesInfo.msgAttribute
                   = ((mesInfo.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR_L4));
                break;

              case NNSH_BBSSTATE_FAVOR:
                // Hxɐݒ
                mesInfo.msgAttribute
                   = ((mesInfo.msgAttribute&(NNSH_MSGATTR_NOTFAVOR))|(NNSH_MSGATTR_FAVOR));
                break;

              default:
                // Ȃ
                break;
            }
            // XDBXV
            (void) update_subject_database(index, &mesInfo);
        }
    }

    // 擾I̕\(DEBUGIvVL̂)
    NNsh_DebugMessage(ALTID_INFO, MSG_GET_MESSAGE_END,
                      mesInfo.threadTitle, ret);

    // XXg̍XV(SELMES)
    err = Update_Thread_List(selBBS,
                             (NNshGlobal->NNsiParam)->selectedTitleItem,
                             NNSH_STEP_REDRAW);

    // NNsiݒŁAu擾X\vɃ`FbNĂꍇ́Aʕ\
    if ((ret == errNone)&&((NNshGlobal->NNsiParam)->openAutomatic != 0))
    {
        // X\B
        display_message();
        err = false;
    }
    // 擾G[ɂ́AG[
    if (ret != errNone)
    {
        err = false;
    }
    return (err);
}

/*-------------------------------------------------------------------------*/
/*   Function :   update_message                                           */
/*                                                     bZ[W擾  */
/*-------------------------------------------------------------------------*/
static Boolean update_message(void)
{
    Boolean             err;
    Err                 ret;
    Char                url[BUFSIZE];
    UInt16              butID, selBBS, selMES, index;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // ݂̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // OFFLINEXIꂽꍇAXVs\
    if (StrCompare(mesInfo.boardNick, OFFLINE_THREAD_NICK) == 0)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE,
                           mesInfo.threadTitle, 0);
        return (false);
    }

    // 擾~aar̃XIꂽꍇAXVs\
    if (((bbsInfo.state) & (NNSH_BBSSTATE_SUSPEND)) == NNSH_BBSSTATE_SUSPEND)
    {
        NNsh_InformMessage(ALTID_WARN, bbsInfo.boardName,
                           MSG_WARN_SUSPENDBBS, 0);
        return (false);
    }

    //  Palm{̂ɃO邪AVFSgpݒɂȂĂꍇɂ́A
    // XVłȂ|\
    if (((((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) != 0)&&
        (mesInfo.msgState == FILEMGR_STATE_OPENED_STREAM))||
        ((((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) == 0)&&
         (mesInfo.msgState == FILEMGR_STATE_OPENED_VFS)))
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE_LOG,
                           mesInfo.threadTitle, 0);
        return (false);
    }

    //  VFSɃO邪AVFSgpݒɂȂĂȂꍇɂ́A
    // XVłȂ|\
    if (((((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) != 0)&&
        (mesInfo.msgState == FILEMGR_STATE_OPENED_STREAM))||
        ((((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) == 0)&&
         (mesInfo.msgState == FILEMGR_STATE_OPENED_VFS)))
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOT_UPDATE_LOG,
                           mesInfo.threadTitle, 0);
        return (false);
    }

    if (mesInfo.state == NNSH_SUBJSTATUS_NOT_YET)
    {
        // 擾IA܂擾ĂȂB(S擾邩mF)
        butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_NOT_YET_SUBJECT, 
                                    MSG_CONFIRM_GETALLMSG, 0);
        if (butID != 0)
        {
            // CancelI(Ȃ)
            return (true);
        }
        // X(S)擾
        return (get_all_message());
    }

    ////////////  bZ[W擾̏  ///////////

    //  擾\@\LłlbgɐڑĂȂꍇA
    // 擾\񂷂邩mF
    if (((NNshGlobal->NNsiParam)->getReserveFeature != 0)&&(NNshGlobal->netRef == 0))
    {
        if (NNsh_ConfirmMessage(ALTID_CONFIRM,
                                NNSH_MSGINFO_RESERVE, "", 0) == 0)
        {
            // XgԍXindexɕϊ
            index = convertListIndexToMsgIndex(selMES);

            // V\񎞂Ɏ擾\ݒ肵ďI
            mesInfo.msgAttribute
                     = mesInfo.msgAttribute | NNSH_MSGATTR_GETRESERVE;
            (void) update_subject_database(index, &mesInfo);

            // XXg̍XV(SELMES)
            err = Update_Thread_List(selBBS,
                             (NNshGlobal->NNsiParam)->selectedTitleItem,
                             NNSH_STEP_REDRAW);
            return (true);
        }
    }

    /** (VFS)fBNg쐬 **/
    (void) CreateDir_NNsh(mesInfo.boardNick);

    // bZ[W擾̍쐬
    (void) CreateThreadURL(NNSH_DISABLE, url, sizeof(url), &bbsInfo, &mesInfo);

    // XgԍXindexɕϊ
    index = convertListIndexToMsgIndex(selMES);

    // O̎擾ыL^(ǋL)
    ret = Get_PartMessage(url, bbsInfo.boardNick, &mesInfo, index, NULL);

    // 擾I̕\(DEBUGIvVL̂)
    NNsh_DebugMessage(ALTID_INFO, MSG_GET_PARTMESSAGE_END,
                      mesInfo.threadTitle, ret);

    // XXg̍XV(SELMES)
    err = Update_Thread_List(selBBS, 
                             (NNshGlobal->NNsiParam)->selectedTitleItem,
                             NNSH_STEP_REDRAW);

    // NNsiݒŁAu擾X\vɃ`FbNĂꍇ́Aʕ\
    if ((ret == errNone)&&((NNshGlobal->NNsiParam)->openAutomatic != 0))
    {
        // X\B
        display_message();
        err = true;
    }

    return (err);
}

/*-------------------------------------------------------------------------*/
/*   Function :   modify_title                                             */
/*                                                      X^Cg̕ύX */
/*-------------------------------------------------------------------------*/
static Boolean modify_title(void)
{
    Err                 ret;
    Char                newName[MAX_THREADNAME], logBuf[BUFSIZE];
    UInt16              selBBS, selTHR, butID, index;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // ݂̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selTHR, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // lƂČ݂̃^CgRs[
    MemSet(newName, sizeof(newName), 0x00);
    StrNCopy(newName, mesInfo.threadTitle, MAX_THREADNAME);

    // ̓EBhEJAf[^l
    ret = DataInputDialog(NNSH_INPUTWIN_MODIFYTITLE, newName, sizeof(newName),
                          NNSH_DIALOG_USE_MODIFYTITLE, NULL);
    if (ret == true)
    {
        MemSet(logBuf, sizeof(logBuf), 0x00);
        StrCopy(logBuf, MSG_DIALOG_MODIFYTITLE);
        StrCat (logBuf, mesInfo.threadTitle);
        StrCat (logBuf, MSG_DIALOG_MODIFYTITLE2);

        // {ɃX^CgύX邩mF
        butID = NNsh_ConfirmMessage(ALTID_CONFIRM, logBuf, newName, 0);
        if (butID == 0)
        {
            // ^CgXV
            MemSet  (mesInfo.threadTitle, MAX_THREADNAME, 0x00);
            StrNCopy(mesInfo.threadTitle, newName, MAX_THREADNAME);
            index = convertListIndexToMsgIndex(selTHR);
            ret =  update_subject_database(index, &mesInfo);
            if (ret != errNone)
            {
                NNsh_InformMessage(ALTID_WARN, "Update failure", " ret:", ret);
            }
            else
            {
                Update_Thread_List(selBBS, 
                                   (NNshGlobal->NNsiParam)->selectedTitleItem, 
                                   NNSH_STEP_REDRAW);
            }
            return (true);
        }
    }
    NNsi_RedrawThreadList();
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   launch_WebBrowser                                        */
/*                                                  WebBrowserŃXJ */
/*-------------------------------------------------------------------------*/
static Boolean launch_WebBrowser(void)
{
    Err                 ret;
    Char                logBuf[BIGBUF];
    UInt16              selBBS, selTHR;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // ݂̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selTHR, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // XbZ[WURL\z
    MemSet (logBuf, sizeof(logBuf), 0x00);
    CreateThreadBrowserURL(NNSH_DISABLE, logBuf, &bbsInfo, &mesInfo);

    // WebBrowserŊJƂAŐVTOJ悤ɂ
    if ((NNshGlobal->NNsiParam)->browseMesNum != 0)
    {
        switch (bbsInfo.bbsType)
        {
          case NNSH_BBSTYPE_SHITARABAJBBS_OLD:
          case NNSH_BBSTYPE_MACHIBBS:
            StrCat(logBuf, "&LAST=");
            break;

          case NNSH_BBSTYPE_SHITARABA:
            StrCat(logBuf, "&ls=");
            break;

          case NNSH_BBSTYPE_SHITARABAJBBS_RAW:
          case NNSH_BBSTYPE_2ch:
          case NNSH_BBSTYPE_OTHERBBS:
          default:
            if ((NNshGlobal->NNsiParam)->useImodeURL != 0)
            {
                StrCat(logBuf, "/n");
                goto OPEN_WEB;
            }
            else
            {
                StrCat(logBuf, "/l");
            }
            break;
        }
        NUMCATI(logBuf, (NNshGlobal->NNsiParam)->browseMesNum);
    }
    else
    {
        // i-modepURLꍇAURL𒲐
        if ((NNshGlobal->NNsiParam)->useImodeURL != 0)
        {
            switch (bbsInfo.bbsType)
            {
              case NNSH_BBSTYPE_2ch:
                StrCat(logBuf, "/i");
                break;

              case NNSH_BBSTYPE_SHITARABAJBBS_OLD:
              case NNSH_BBSTYPE_SHITARABAJBBS_RAW:
              case NNSH_BBSTYPE_MACHIBBS:
              case NNSH_BBSTYPE_SHITARABA:
              case NNSH_BBSTYPE_OTHERBBS:
              default:
                break;
            }
        }
    }
OPEN_WEB:

    // \XURLfobO\
    NNsh_DebugMessage(ALTID_INFO, "OPEN URL :", logBuf, 0);

    // NetFrontN(NNsiIɋN)
    (void) WebBrowserCommand(NNshGlobal->browserCreator,
                             0, 0, NNshGlobal->browserLaunchCode, 
                             logBuf, StrLen(logBuf), NULL);
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   beam_URL                                                 */
/*                                                          XԍBeam */
/*-------------------------------------------------------------------------*/
static Boolean beam_URL(void)
{
    Err                 ret;
    Char                logBuf[BUFSIZE + BUFSIZE + MARGIN];
    Char                titleBuf[MAX_THREADNAME + MARGIN], *ptr;
    UInt16              selBBS, selTHR;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // ݂̃bZ[W擾
    ret = get_message_Info(&mesInfo, &selTHR, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    if ((mesInfo.bbsType != NNSH_BBSTYPE_2ch)||
        ((mesInfo.boardNick[0]  == '!')&&
        (mesInfo.boardNick[1]  == 'G')&&
        (mesInfo.boardNick[2]  == 'i')))
    {
        // QƃOA܂͂Q^CvȊOȂABeamȂ
        //   ("݃T|[gĂ܂" \s)
        NNsh_InformMessage(ALTID_ERROR, MSG_NOTSUPPORT_BBS, "", 0);
        return (false);
    }

    // "Xԍ"𐶐
    MemSet(logBuf, sizeof(logBuf), 0x00);
    StrCopy(logBuf, NNSI_NNSIEXT_THREADNUMBER_START);
    StrCat (logBuf, mesInfo.boardNick);
    StrCat (logBuf, mesInfo.threadFileName);
    ptr = logBuf;
    while ((*ptr != '\0')&&(*ptr != '.'))
    {
        ptr++;
    }
    *ptr = '\0';  // Xt@Cdat폜
    StrCat (logBuf, NNSI_NNSIEXT_THREADNUMBER_END);

    // Mf[^̃^Cg𐶐
    MemSet(titleBuf, sizeof(titleBuf), 0x00);
    StrCopy(titleBuf, "  ");
    StrCat (titleBuf, mesInfo.threadTitle);

    // f[^NNsiBeam
    SendToExternalDevice(titleBuf, logBuf, SOFT_CREATOR_ID);
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   checkIfNewArrivalIsValid                                 */
/*                                        VbZ[W擾ۂ̃`FbN */
/*-------------------------------------------------------------------------*/
static Err checkIfNewArrivalIsValid(UInt16  selBBS, Char *bbsName,
                                    NNshSubjectDatabase  *mesInfo)
{
    if ((mesInfo->msgAttribute & NNSH_MSGATTR_GETRESERVE) != 0)
    {
        // 擾\񂵂ĂXAbZ[W擾
        return (errNone);
    }

    if (mesInfo->state == NNSH_SUBJSTATUS_NOT_YET)
    {
        // bZ[W擾ȂA擾{Ȃ
        return (~errNone);
    }

    if (((((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) != 0)&&
        (mesInfo->msgState == FILEMGR_STATE_OPENED_STREAM))||
        ((((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_ENABLE) == 0)&&
         (mesInfo->msgState == FILEMGR_STATE_OPENED_VFS)))
    {
        //  Palm{̂ɃO邪AVFSgpݒɂȂĂꍇɂ́A
        // 擾{łȂ
        return (~errNone);
    }

    switch (mesInfo->bbsType)
    {
      case NNSH_BBSTYPE_2ch:
      case NNSH_BBSTYPE_SHITARABA:
      case NNSH_BBSTYPE_OTHERBBS:
      case NNSH_BBSTYPE_SHITARABAJBBS_RAW:
        // `FbNnj
        break;

      case NNSH_BBSTYPE_MACHIBBS:
      case NNSH_BBSTYPE_SHITARABAJBBS_OLD:
        if ((NNshGlobal->NNsiParam)->enableNewArrivalHtml != 0)
        {
            // ܂BBS/@JBBSVmFꍇɂ́A`FbNOK
            break;
        }
        return (~errNone);
        break;

      default:
        // ^Cv "Q˂" ܂ "" ȊÓA{Ȃ
        return (~errNone);
        break;
    }

#ifdef USE_STRSTR
    if (StrCompare(mesInfo->boardNick, OFFLINE_THREAD_NICK) == 0)
#else
    if ((mesInfo->boardNick[0]  == '!')&&
        (mesInfo->boardNick[1]  == 'G')&&
        (mesInfo->boardNick[2]  == 'i'))
#endif
    {
        // QƃOȂA擾{Ȃ
        return (~errNone);
    }
    if (mesInfo->maxLoc >= NNSH_MESSAGE_LIMIT)
    {
        // 擾(ő)bZ[WɓBĂȂA擾{Ȃ
        return (~errNone);
    }

    // ʂ̃`FbN
    switch (selBBS)
    {
      case NNSH_SELBBS_FAVORITE:
        if ((mesInfo->msgAttribute & NNSH_MSGATTR_FAVOR) < (NNshGlobal->NNsiParam)->displayFavorLevel)
        {
            // uCɓvł͂Ȃ
            return (~errNone);
        }
        break;

      case NNSH_SELBBS_GETALL:
        // 擾ςݑSĂ̂Ƃ͑S
        break;

      case NNSH_SELBBS_NOTREAD:
        if ((mesInfo->state != NNSH_SUBJSTATUS_NEW)&&
            (mesInfo->state != NNSH_SUBJSTATUS_UPDATE)&&
            (mesInfo->state != NNSH_SUBJSTATUS_REMAIN))
        {
            // ǂXł͂Ȃ
            return (~errNone);
        }
        break;

      case NNSH_SELBBS_CUSTOM1:
        // [UݒP̏`FbN
        if (CheckIfCustomTabIsValid(bbsName, mesInfo, &((NNshGlobal->NNsiParam)->custom1)) != true)
        {
            return (~errNone);
        }
        break;

      case NNSH_SELBBS_CUSTOM2:
        // [UݒQ̏`FbN
        if (CheckIfCustomTabIsValid(bbsName, mesInfo, &((NNshGlobal->NNsiParam)->custom2)) != true)
        {
            return (~errNone);
        }
        break;

      case NNSH_SELBBS_CUSTOM3:
        // [UݒȐ`FbN
        if (CheckIfCustomTabIsValid(bbsName, mesInfo, &((NNshGlobal->NNsiParam)->custom3)) != true)
        {
            return (~errNone);
        }
        break;

      case NNSH_SELBBS_CUSTOM4:
        // [UݒS̏`FbN
        if (CheckIfCustomTabIsValid(bbsName, mesInfo, &((NNshGlobal->NNsiParam)->custom4)) != true)
        {
            return (~errNone);
        }
        break;

      case NNSH_SELBBS_CUSTOM5:
        // [UݒT̏`FbN
        if (CheckIfCustomTabIsValid(bbsName, mesInfo, &((NNshGlobal->NNsiParam)->custom5)) != true)
        {
            return (~errNone);
        }
        break;

      default:
        if (StrCompare(bbsName, mesInfo->boardNick) != 0)
        {
            // X̏Ⴄ
            return (~errNone);
        }
        break;
    }
    return (errNone);
}

/*-------------------------------------------------------------------------*/
/*   Function :   update_newarrival_message                                */
/*                                                  VbZ[W擾 */
/*-------------------------------------------------------------------------*/
static Boolean update_newarrival_message(UInt16 command)
{
    Err                  ret = ~errNone;
    Boolean              penState, bbsUpdate;
    UInt16               selBBS, loop, savedParam, count, x, y;
    UInt16               getBBS, dummy, keepBBS;
    Char                *url, logMsg[MINIBUF], dispMsg[MINIBUF];
    FormType            *frm;
    ListType            *lstP;
    ControlType         *ctlP;
    MemHandle            mesH;
    DmOpenRef            dbRef;
    NNshBoardDatabase   *bbsInfo;
    NNshSubjectDatabase *mesInfo, *mesRead;

    // [N̈̊m(3)
    url = MEMALLOC_PTR(BUFSIZE);
    if (url == NULL)
    {
        return (false);
    }

    // XԎw擾Ŏ擾ۗ̂ɂāA"VmF"
    OpenDatabase_NNsh(DBNAME_GETRESERVE, DBVERSION_GETRESERVE, &dbRef);
    if (dbRef != 0)
    {
        // 擾ۗX̃XԎw擾{́AmFbZ[W\Ȃ
        savedParam = (NNshGlobal->NNsiParam)->confirmationDisable;
        (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;

        // 擾
        GetDBCount_NNsh(dbRef, &count);

        // SAXԎw擾{
        for (loop = 0; loop < count; loop++)
        {
            // f[^擾
            GetRecord_NNsh(dbRef, loop, BUFSIZE, url);

            // XԎw擾{
            (void) GetThreadDataFromMesNum(&bbsUpdate, url, BUFSIZE, &x);
        }

        // XԎw擾̎擾ۗcȃSR[h폜
        while (count != 0)
        {
            (void) DeleteRecordIDX_NNsh(dbRef, (count - 1));
            count--;
        }
        CloseDatabase_NNsh(dbRef);

        (NNshGlobal->NNsiParam)->confirmationDisable = savedParam;
    }
    if (command == NNSH_NEWARRIVAL_ONLYMESNUM)
    {
        // XԎw擾̎擾ۗ̂ݐVmF郂[hAI
        MEMFREE_PTR(url);
        goto KICK_DA;
    }


    bbsInfo = MEMALLOC_PTR(sizeof(NNshBoardDatabase));
    if (bbsInfo == NULL)
    {
        MEMFREE_PTR(url);
        return (false);
    }
    mesInfo = MEMALLOC_PTR(sizeof(NNshSubjectDatabase));
    if (bbsInfo == NULL)
    {
        MEMFREE_PTR(url);
        MEMFREE_PTR(bbsInfo);
        return (false);
    }

    // mۂ[N̈
    MemSet(url,     BUFSIZE,                     0x00);
    MemSet(bbsInfo, sizeof(NNshBoardDatabase),   0x00);

    // IĂBBS̃Xgԍ擾
    frm     = FrmGetActiveForm();
    lstP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
    selBBS  = LstGetSelection(lstP);
    keepBBS = selBBS;
    switch (selBBS)
    {
      case NNSH_SELBBS_NOTREAD:
        // ǂɂƂAVmF^úAp[^擾
        selBBS = (NNshGlobal->NNsiParam)->newArrivalNotRead;
        dummy  = 1;
        break;

      case NNSH_SELBBS_CUSTOM1:
        selBBS  = (NNshGlobal->NNsiParam)->custom1.newArrival;
        dummy   = 1;
        break;

      case NNSH_SELBBS_CUSTOM2:
        selBBS = (NNshGlobal->NNsiParam)->custom2.newArrival;
        dummy  = 1;
        break;

      case NNSH_SELBBS_CUSTOM3:
        selBBS = (NNshGlobal->NNsiParam)->custom3.newArrival;
        dummy  = 1;
        break;

      case NNSH_SELBBS_CUSTOM4:
        selBBS = (NNshGlobal->NNsiParam)->custom4.newArrival;
        dummy  = 1;
        break;

      case NNSH_SELBBS_CUSTOM5:
        selBBS = (NNshGlobal->NNsiParam)->custom5.newArrival;
        dummy  = 1;
        break;

      default:
        dummy   = 0;
        break;
    }
    if (dummy != 0)
    {
        // BBS\^u()ύX
        LstSetSelection(lstP, selBBS);

        // BBS\^uύX
        (NNshGlobal->NNsiParam)->lastBBS = selBBS;

        ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, POPTRID_BBSINFO));
        CtlSetLabel(ctlP, LstGetSelectionText(lstP, selBBS));
    }

    // BBS̎擾^uI
    switch (selBBS)
    {
      case NNSH_SELBBS_CUSTOM1:
        // [UݒP̔擾
        getBBS = (NNshGlobal->NNsiParam)->custom1.boardNick;
        break;

      case NNSH_SELBBS_CUSTOM2:
        // [UݒQ̔擾
        getBBS = (NNshGlobal->NNsiParam)->custom2.boardNick;
        break;

      case NNSH_SELBBS_CUSTOM3:
        // [UݒR̔擾
        getBBS = (NNshGlobal->NNsiParam)->custom3.boardNick;
        break;

      case NNSH_SELBBS_CUSTOM4:
        // [UݒS̔擾
        getBBS = (NNshGlobal->NNsiParam)->custom4.boardNick;
        break;

      case NNSH_SELBBS_CUSTOM5:
        // [UݒT̔擾
        getBBS = (NNshGlobal->NNsiParam)->custom5.boardNick;
        break;

      case NNSH_SELBBS_OFFLINE:
        // OFFLINEXIĂꍇ́AQƃO擾@\{
        ExecuteAction(MULTIBTN_FEATURE_LOGCHARGE);
        goto FUNC_END;
        break;

      case NNSH_SELBBS_GETALL:
        // u擾ςݑSāvIĂƂłA
        // u擾ςݑSĂɂ͎QƃOȂvɃ`FbNĂȂƂ́A
        // QƃO擾@\s
        if ((NNshGlobal->NNsiParam)->notListReadOnly == 0)
        {
            ExecuteAction(MULTIBTN_FEATURE_LOGCHARGE);
        }
        getBBS = selBBS;
        break;

      case NNSH_SELBBS_FAVORITE:
      case NNSH_SELBBS_NOTREAD:
      default:
        getBBS = selBBS;
        break;
    }

    // ʏ̏ꍇɂ́A擾(̏ꍇ͒擾)
    if (getBBS > NNSH_SELBBS_OFFLINE)
    {
        ret = Get_BBS_Info(getBBS, bbsInfo);
        if (ret != errNone)
        {
            // BBSɎ擾sAI
            NNsh_DebugMessage(ALTID_ERROR, MSG_CANNOT_UPDATE, "(BBS data)", 0);
            goto FUNC_END;
        }
    }

    /////////////////  bZ[W擾̏  ////////////////

    // "X"\
    Show_BusyForm(MSG_SEARCHING_TITLE);

    // VbZ[WmF́AmFbZ[Wu\ȂvݒɂB
    savedParam = (NNshGlobal->NNsiParam)->confirmationDisable;
    (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;

    // SX擾
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    GetDBCount_NNsh(dbRef, &count);

    // BBS擾XVtOneeɂ
    bbsUpdate = false;

    // VmF
    for (loop = count; loop > 0; loop--)
    {
        // 悻̌c茏\
        if ((loop % 10) == 0)
        {
            StrCopy(logMsg, MSG_SEARCHING_TITLE MSG_SEARCHING_LEFT);
            NUMCATI(logMsg, loop);
            SetMsg_BusyForm(logMsg);
        }

        // Xf[^擾
        GetRecordReadOnly_NNsh(dbRef, (loop - 1), &mesH, (void **) &mesRead);

        // 擾\XA^uCɓ/擾ςݑS/ǂǂ̃`FbN
        if (((mesRead->msgAttribute & NNSH_MSGATTR_GETRESERVE) != 0)||
            (getBBS < NNSH_SELBBS_OFFLINE))
        {
            //  `FbNɊYꍇɂ́ABBS擾BA擾ς
            // BBSboardNickƍ擾悤ƂBBSboardNickv
            // ꍇɂ́ABBS͂łɎ擾ς݂ƂĂ̏𗘗p
            if (StrCompare(mesRead->boardNick, bbsInfo->boardNick) != 0)
            {
                ret = Get_BBS_Database(mesRead->boardNick, bbsInfo, &dummy);
                if (ret != errNone)
                {
                    // BBSɎ擾sAf`FbNւ
                    ReleaseRecordReadOnly_NNsh(dbRef, mesH);
                    goto NEXT_STEP;
                }
                bbsUpdate = true;  // BBSXVAƃtO𗧂Ă
            }
        }

        // VbZ[W擾Xǂ`FbN
        if (checkIfNewArrivalIsValid(selBBS,bbsInfo->boardNick,mesRead) != 
                                                                       errNone)
        {
            // VmF{Xł͂ȂAf`FbNւ
            ReleaseRecordReadOnly_NNsh(dbRef, mesH);
            goto NEXT_STEP;
        }

        // 擾~aar̃XIꂽꍇAXVs(֐i)
        if (((bbsInfo->state) & (NNSH_BBSSTATE_SUSPEND)) == NNSH_BBSSTATE_SUSPEND)
        {
            // f`FbNւ
            ReleaseRecordReadOnly_NNsh(dbRef, mesH);
            goto NEXT_STEP;
        }

        // f[^x[Xx
        ReleaseRecordReadOnly_NNsh(dbRef, mesH);
        CloseDatabase_NNsh(dbRef);
        Get_Subject_Database((loop - 1), mesInfo);

        // bZ[W擾URL̍쐬
        (void) CreateThreadURL(NNSH_DISABLE, url, BUFSIZE, bbsInfo, mesInfo);

        // \郁bZ[W̒ǉ
        MemSet (dispMsg, MINIBUF, 0x00);
        StrCopy(dispMsg, " (");
        NUMCATI(dispMsg, (count - loop) + 1);
        StrCat (dispMsg, "/");
        NUMCATI(dispMsg, count);
        StrCat (dispMsg, ")");

        // ꎞIBUSYEBhE
        Hide_BusyForm(false);

        // O̎擾ыL^(ǋL)
        ret = Get_PartMessage(url, bbsInfo->boardNick, mesInfo,
                              (loop - 1), dispMsg);

        // VmFō擾sꍇ
        if ((ret == NNSH_ERRORCODE_PARTGET)&&
            ((NNshGlobal->NNsiParam)->autoUpdateGetError != 0))
        {
            // bZ[Wǂ񂾏ꏊ
            x = mesInfo->maxLoc;
            y = mesInfo->currentLoc;

            // ŏSĎ擾Ȃ
            ret = Get_AllMessage(url, bbsInfo->boardNick,
                                 mesInfo->threadFileName,
                                 (loop - 1), (UInt16) bbsInfo->bbsType);
            if (ret == errNone)         
            {
                // MÎƂAǂݏoꏊȑȌꏊɕ
                if (Get_Subject_Database((loop - 1), mesInfo) == errNone)
                {
                    mesInfo->maxLoc     = x;
                    mesInfo->currentLoc = y;
                    (void) update_subject_database((loop - 1), mesInfo);
                }
            }
        }

        // BUSYEBhE𕜊
        Show_BusyForm(MSG_SEARCHING_TITLE);

        // f[^x[XēxJ
        OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);

        //  O擾~ꂽ or vIG[ɂ
        // VbZ[W̊mF𒆎~B
        if (ret == ~errNone)
        {
            // mFbZ[Wȗ̃p[^ɖ߂
            (NNshGlobal->NNsiParam)->confirmationDisable = savedParam;

            // 𒆎~|Aʕ\
            NNsh_InformMessage(ALTID_INFO, 
                               MSG_ABORT_MESSAGE, 
                               MSG_NOTCHECK_RECORDS, loop);
            break;
        }

        //  BBS(擾\X̂߂)XVĂꍇ
        if (bbsUpdate == true)
        {
            if (getBBS > NNSH_SELBBS_OFFLINE)
            {
                // BBSĎ擾ČBBSɖ߂
                // (̓[v擾̂ōXVȂ)
                (void) Get_BBS_Info(getBBS, bbsInfo);
                bbsUpdate = false;
            }
        }

NEXT_STEP:
        // y̏ԂE(ʃ^bvĂ邩mF)
        EvtGetPen(&x, &y, &penState);
        if (penState == true)
        {
            // y_EĂA~邩mFs
            if (NNsh_ErrorMessage(ALTID_CONFIRM,
                                  MSG_CONFIRM_ABORT_GET, 
                                  MSG_NOTCHECK_RECORDS, loop) == 0)
            {
                // OKꂽAbreak
                break;
            }
        }
    }
    CloseDatabase_NNsh(dbRef);
    Hide_BusyForm(false);

    // mFbZ[Wȗ̃p[^ɖ߂
    (NNshGlobal->NNsiParam)->confirmationDisable = savedParam;

    // uVmFvɖǈꗗ\
    if ((NNshGlobal->NNsiParam)->autoOpenNotRead != 0)
    {
        // IĂBBS̃XgԍύX
        keepBBS = NNSH_SELBBS_NOTREAD;
    }

    // BBS\^uύX
    (NNshGlobal->NNsiParam)->lastBBS = keepBBS;
    NNshWinSetPopItems(FrmGetActiveForm(),POPTRID_BBSINFO, LSTID_BBSINFO, keepBBS);

FUNC_END:
    // ֐̏I
    MEMFREE_PTR(url);
    MEMFREE_PTR(bbsInfo);
    MEMFREE_PTR(mesInfo);

KICK_DA:
    if ((ret != ~errNone)&&((NNshGlobal->NNsiParam)->use_DAplugin != 0))
    {
        // DÃvOC(cMDA)N
        (void) LaunchResource_NNsh('DAcc','cMDA','code',1000);
    }

    if ((NNshGlobal->NNsiParam)->disconnArrivalEnd != 0)
    {
        // uVmFvIɉؒf
        savedParam = (NNshGlobal->NNsiParam)->confirmationDisable;
        (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
        NNshNet_LineHangup();
        (NNshGlobal->NNsiParam)->confirmationDisable = savedParam;
    }

    // XgXV
    Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 0, NNSH_STEP_UPDATE);

    // uVmFvɃr[v炵Ă݂
    if ((NNshGlobal->NNsiParam)->autoBeep != 0)
    {
        SndPlaySystemSound(sndAlarm);
    }

    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   update_getall_message                                    */
/*                                     bZ[W擾("XV" {^p) */
/*-------------------------------------------------------------------------*/
static Boolean update_getall_message(void)
{
    Err                 ret;
    UInt16              selMES, selBBS;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // bZ[WԂ擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // bZ[WԂɂāAANVύX
    if (mesInfo.state == NNSH_SUBJSTATUS_NOT_YET)
    {
        // 擾ȂS擾
        (void) get_all_message();
        goto RETR;
    }

    // 擾ς݂Ȃ獷擾
    (void) update_message();
RETR:
    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   delete_notreceived_message                               */
/*                                                    MX폜 */
/*-------------------------------------------------------------------------*/
Boolean delete_notreceived_message(Boolean update)
{
    Err                   ret;
    UInt16                selMES, selBBS, cnt;
    NNshSubjectDatabase   mesInfo;

    // BBSԍ擾
    selBBS = (NNshGlobal->NNsiParam)->lastBBS;

    //  uǂvu擾ςݑSāv^u\ɖ擾ꗗ폜ꂽꍇ́A
    // S擾X(^Cg)폜
    if ((selBBS == NNSH_SELBBS_GETALL)||(selBBS == NNSH_SELBBS_NOTREAD))
    {
        (void) DeleteSubjectList(" ", NNSH_SUBJSTATUS_UNKNOWN, &cnt);
        // XgXV(selBBS)
        return (Update_Thread_List(selBBS, 0, NNSH_STEP_UPDATE));
        // return (true);
    }

    // 疢擾ꗗ͍폜łȂB
    if (selBBS <  NNSH_SELBBS_OFFLINE)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_CANNOTDELETE_FAVOR,"", 0);
        return (false);    
    }

    // X̎擾
    ret = get_subject_info(&mesInfo, &selMES);
    if (ret != errNone)
    {
        return (false);
    }

    // 擾̃X폜
    (void) DeleteSubjectList(mesInfo.boardNick, NNSH_SUBJSTATUS_NOT_YET, &cnt);

    // Ẍ݂ʒu菬ꍇɂ́ÃXɃJ[\킹
    if (selMES >= cnt)
    {
        selMES = cnt - 1;    
    }

    if (update == false)
    {
        // ʕ\XVȂꍇ
        return (true);
    }

    // XgXV(selBBS)
    return (Update_Thread_List(selBBS, 0, NNSH_STEP_UPDATE));
}


/*-------------------------------------------------------------------------*/
/*   Function :   newThread_message                                        */
/*                                                           Xď  */
/*-------------------------------------------------------------------------*/
static Boolean newThread_message(void)
{
#ifdef USE_NEWTHREAD_FEATURE
    Err                ret;
    UInt16             selBBS, btnID;
    NNshBoardDatabase  bbsData;

    // XĂ擾
    selBBS = (NNshGlobal->NNsiParam)->lastBBS;

    // 疢擾ꗗ͍폜łȂ
    if (selBBS <=  NNSH_SELBBS_OFFLINE)
    {
        NNsh_InformMessage(ALTID_WARN, MSG_NOTAVAIL_BBS, "", 0);
        return (false);    
    }

    // BBS擾
    MemSet(&bbsData, sizeof(bbsData), 0x00);
    ret = Get_BBS_Info(selBBS, &bbsData);
    if (ret != errNone)
    {
        NNsh_DebugMessage(ALTID_ERROR, MSG_NOTAVAIL_BBS, "(Get_BBS_Info())", ret);
        return (false);
    }

    // BBS^CvQ˂ȊÔƂ́AXĂȂ
    if (bbsData.bbsType != NNSH_BBSTYPE_2ch)
    {
        //   uݖȃtB[`[v\
        NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "(BBS TYPE)", 0);
        return (false);
    }

    // X{ɗĂ邩mF
    btnID = NNsh_ErrorMessage(ALTID_CONFIRM, bbsData.boardName, MSG_NEWTHREAD_CONFIRM, 0);
    if (btnID != 0)
    {
        // XăLZ
        return (false);
    }

    // XĉʂJ
    NNshMain_Close(FRMID_NEW_THREAD);
    
#else
    // XďsȂꍇ...
    //   uݖȃtB[`[v\
    NNsh_InformMessage(ALTID_ERROR, MSG_NOT_SUPPORT, "", 0);
#endif     
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   delete_message                                           */
/*                                                           X폜  */
/*-------------------------------------------------------------------------*/
Boolean delete_message(void)
{
    Err                 ret;
    UInt16              selMES, selBBS, butID, index;
    Char                fileName[MAXLENGTH_FILENAME], *area;
    DmOpenRef           dbRef;
    NNshSubjectDatabase mesInfo;
    NNshBoardDatabase   bbsInfo;

    // bZ[W擾
    ret = get_message_Info(&mesInfo, &selMES, &bbsInfo, &selBBS);
    if (ret != errNone)
    {
        return (false);
    }

    // X{ɍ폜邩mF
    butID = NNsh_ConfirmMessage(ALTID_CONFIRM, MSG_DELETE_MSGCONFIRM, 
                                mesInfo.threadTitle, 0);
    if (butID != 0)
    {
        // 폜LZ
        return (false);
    }

    // XDB̃I[v
    OpenDatabase_NNsh(DBNAME_SUBJECT, DBVERSION_SUBJECT, &dbRef);
    if (dbRef == 0)
    {
        // G[
        return (~errNone);
    }

    // Xt@C({̂̃Ot@C)폜
    MemSet (fileName, sizeof(fileName), 0x00);
    if (selBBS != NNSH_SELBBS_OFFLINE)
    {
        // OFFLINEÔƂ́AboardNicktȂ
        // (OFFLINEÔƂÃWbN͒ʂȂ)
        StrCopy(fileName, mesInfo.boardNick);
    }
    else
    {
        // OFFLINEXVFSɊi[Ăꍇɂ́AfBNgtB
        if (((NNshGlobal->NNsiParam)->useVFS & NNSH_VFS_USEOFFLINE) != 0)
        {
            // Ox[XfBNg擾
            if ((NNshGlobal->logPrefixH == 0)||
                ((area = MemHandleLock(NNshGlobal->logPrefixH)) == NULL))
            {
                StrCopy(fileName, LOGDATAFILE_PREFIX);
            }
            else
            {
                StrCopy(fileName, area);
                MemHandleUnlock(NNshGlobal->logPrefixH);
            }

            GetSubDirectoryName(mesInfo.dirIndex, &fileName[StrLen(fileName)]);
        }
    }
    StrCat (fileName, mesInfo.threadFileName);

    if (mesInfo.msgState == FILEMGR_STATE_OPENED_STREAM)
    {
        // Palm{̏̃O폜
        ret = DeleteFile_NNsh(fileName, NNSH_VFS_DISABLE);
    }
    else
    {
        // VFS̃O폜
        ret = DeleteFile_NNsh(fileName, NNSH_VFS_ENABLE);
    }
    if((ret != errNone)&&(ret != fileErrNotFound)&&(ret != vfsErrFileNotFound))
    {
        NNsh_InformMessage(ALTID_ERROR, "File Delete: ", fileName, ret);
    }

    // XgԍXindexɕϊ
    index = convertListIndexToMsgIndex(selMES);

    // XCfbNXt@C폜ăN[Y
    (void) DeleteRecordIDX_NNsh(dbRef, index);
    CloseDatabase_NNsh(dbRef);

    // XꗗDBXVƂɂ
    NNshGlobal->updateDatabaseInfo = 
                ((NNshGlobal->updateDatabaseInfo) | (NNSH_DB_UPDATE_SUBJECT));

    return (Update_Thread_List(selBBS, selMES, NNSH_STEP_REDRAW));
}

/*-------------------------------------------------------------------------*/
/*   Function :   get_subject_txt                                          */
/*                                      Xꗗ(subject.txt)擾  */
/*-------------------------------------------------------------------------*/
static Boolean get_subject_txt(void)
{
    Err       ret;
    Boolean   penState;
    UInt16    selBBS, keepBBS, loop, x, y;
    FormType *frm;
    ListType *lstP;
    ControlType *ctlP;

    frm  = FrmGetActiveForm();
    lstP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO)); 
    selBBS  = LstGetSelection(lstP);

    // [Uݒ^ûƂ́Aw肳ꂽ^üꗗ擾
    switch (selBBS)
    {
      case NNSH_SELBBS_CUSTOM1:
        selBBS  = (NNshGlobal->NNsiParam)->custom1.getList;
        keepBBS = NNSH_SELBBS_CUSTOM1;
        break;

      case NNSH_SELBBS_CUSTOM2:
        selBBS  = (NNshGlobal->NNsiParam)->custom2.getList;
        keepBBS = NNSH_SELBBS_CUSTOM2;
        break;
 
      case NNSH_SELBBS_CUSTOM3:
        selBBS  = (NNshGlobal->NNsiParam)->custom3.getList;
        keepBBS = NNSH_SELBBS_CUSTOM3;
        break;
        
      case NNSH_SELBBS_CUSTOM4:
        selBBS  = (NNshGlobal->NNsiParam)->custom4.getList;
        keepBBS = NNSH_SELBBS_CUSTOM4;
        break;

      case NNSH_SELBBS_CUSTOM5:
        selBBS  = (NNshGlobal->NNsiParam)->custom5.getList;
        keepBBS = NNSH_SELBBS_CUSTOM5;
        break;

      default:
        keepBBS = 0;
        break;
    }

    if (keepBBS != 0)
    {
        // BBS\^u()ύX
        LstSetSelection(lstP, selBBS);

        // BBS\^uύX
        (NNshGlobal->NNsiParam)->lastBBS = selBBS;
        ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, POPTRID_BBSINFO));
        CtlSetLabel(ctlP, LstGetSelectionText(lstP, selBBS));
    }

    switch (selBBS)
    {
      case NNSH_SELBBS_NOTREAD:
      case NNSH_SELBBS_FAVORITE:
      case NNSH_SELBBS_CUSTOM1:
      case NNSH_SELBBS_CUSTOM2:
      case NNSH_SELBBS_CUSTOM3:
      case NNSH_SELBBS_CUSTOM4:
      case NNSH_SELBBS_CUSTOM5:
        // "[Uݒ^u"A"Cɓ"A"ǂ"\ɂ́A󂯕tȂB
        ret = ~errNone;
        break;
      case NNSH_SELBBS_GETALL:
        // "擾ςݑS"̎ɂ́ASẌꗗ擾
        for (loop = (NNshGlobal->useBBS - 1); loop > NNSH_SELBBS_OFFLINE; loop--)
        {
            // Xꗗ擾
            (void) NNsh_GetSubjectList(loop);

            // y̏ԂE(ʃ^bvĂ邩mF)
            EvtGetPen(&x, &y, &penState);
            if (penState == true)
            {
                // y_EĂA~邩mFs
                if (NNsh_ErrorMessage(ALTID_CONFIRM,
                                      MSG_CONFIRM_ABORT_LIST, 
                                      MSG_NOTCHECK_RECORDS,
                                      (loop - NNSH_SELBBS_OFFLINE)) == 0)
                {
                    // OKꂽAbreak
                    break;
                }
            }
        }
        ret = errNone;
        break;

      case NNSH_SELBBS_OFFLINE:
        // ItCX̌s
        create_offline_database();
        ret = errNone;
        break;

      default:
        // Xꗗ擾
        ret = NNsh_GetSubjectList(selBBS);
        break;
    }
    if (keepBBS != 0)
    {
        // BBS\^u()ɖ߂
        LstSetSelection(lstP, keepBBS);

        // BBS\^uύX
        (NNshGlobal->NNsiParam)->lastBBS = keepBBS;
        ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, POPTRID_BBSINFO));
        CtlSetLabel(ctlP, LstGetSelectionText(lstP, keepBBS));
    }

    // Xꗗ擾ɐVmFɎ{ꍇ
    if ((NNshGlobal->NNsiParam)->listAndUpdate != 0)
    {
        // 擾ۗ̃XԎw擾{
        (void) update_newarrival_message(NNSH_NEWARRIVAL_ONLYMESNUM);
    }

    // Xꗗ\Ȃ
    if (ret == errNone)
    {
        FrmDrawForm(frm);
        Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 0, NNSH_STEP_UPDATE);
        return (true);
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   popEvt_ThreadMain                                        */
/*                                          XgICxg[` */
/*-------------------------------------------------------------------------*/
static Boolean popEvt_ThreadMain(EventType *event)
{
    UInt16 savedParam;
    switch (event->data.popSelect.listID)
    {
      case LSTID_BBSINFO:
        if ((NNshGlobal->NNsiParam)->autoDeleteNotYet != 0)
        {
            // ړɖ擾X폜
            savedParam = (NNshGlobal->NNsiParam)->confirmationDisable;
            (NNshGlobal->NNsiParam)->confirmationDisable = NNSH_OMITDIALOG_ALLOMIT;
            delete_notreceived_message(false);
            (NNshGlobal->NNsiParam)->confirmationDisable = savedParam;
        }

        // LSTID_BBSINFOpopSelectEventȂAXXV
        (NNshGlobal->NNsiParam)->lastBBS = event->data.popSelect.selection;
        (void) Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 0, NNSH_STEP_UPDATE);
        break;

      default:
        break;
    }
    return (false);
}

/*-------------------------------------------------------------------------*/
/*   Function :   rctPointEvt_ThreadMain                                   */
/*                                              X^bvƂ̏ */
/*-------------------------------------------------------------------------*/
static Boolean rctPointEvt_ThreadMain(EventType *event,
                                      FormType *frm, RectangleType *rect)
{
    Coord  locY;
    UInt16 fontID, nlines, fontHeight, selItem;

    // IACe肷
    if ((NNshGlobal->NNsiParam)->useSonyTinyFontTitle == 0)
    {
        fontID = (NNshGlobal->NNsiParam)->currentFont;
    }
    else
    {
        fontID = (NNshGlobal->NNsiParam)->sonyHRFontTitle;
    }
    NNsi_UpdateRectangle(rect, (NNshGlobal->NNsiParam)->useSonyTinyFontTitle,
                         &fontID, &fontHeight, &nlines);

#ifdef USE_CLIE
    if (NNshGlobal->hrRef != 0)
    {
        locY = (event->screenY * 2) - rect->topLeft.y;
    }
    else
#endif
    {
#ifdef USE_HIGHDENSITY
        // 𑜓xɂ킹ĕ`̈̍擾
        switch (NNshGlobal->os5HighDensity)
        {
          case kDensityDouble:
            locY = (event->screenY * 2) - rect->topLeft.y;
            break;

          case kDensityTriple:
            locY = (event->screenY * 3) - rect->topLeft.y;
            break;

          case kDensityQuadruple:
            locY = (event->screenY * 4) - rect->topLeft.y;
            break;

          case kDensityOneAndAHalf:
            locY = (event->screenY * 3 / 2) - rect->topLeft.y;
            break;

          case kDensityLow:
          default:
            locY = event->screenY - rect->topLeft.y;
            break;
        }
#else
        locY = event->screenY - rect->topLeft.y;
#endif // #ifdef USE_HIGHDENSITY
    }
    selItem = locY / fontHeight;

    // ͈͊ȎIꍇAȂ
    if (selItem >= NNshGlobal->nofTitleItems)
    {
        return (true);
    }

    if (selItem == (NNshGlobal->NNsiParam)->selectedTitleItem)
    {
        // _u^bvoAXJƂ
        return (display_message());
    }

    // IACeړ
    NNsi_WinUpdateList(selItem,
                       (NNshGlobal->NNsiParam)->selectedTitleItem, 
                       NNshGlobal->msgTitleIndex,
                       nlines, rect, fontHeight);
    (NNshGlobal->NNsiParam)->selectedTitleItem = selItem;
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   keyDownEvt_ThreadMain                                    */
/*                                                        L[͎̏ */
/*-------------------------------------------------------------------------*/
static Boolean keyDownEvt_ThreadMain(EventType *event)
{
    Boolean      ret = false;
    UInt16       keyCode;
    FormType    *frm;
    ControlType *ctlP;


    // 5way navigatorpL[R[hRo[g
    keyCode = KeyConvertFiveWayToJogChara(event);
    switch (keyCode)
    {
      case vchrHard1:
        // n[hL[𐧌䂷ꍇ́AAA
        if ((NNshGlobal->NNsiParam)->useHardKeyControl != 0)
        {
            // n[hL[PƂ̐ݒ
            return (ExecuteAction(((NNshGlobal->NNsiParam)->ttlFtr.key1)&(MULTIBTN_FEATURE_MASK)));
        }
        break;

      case vchrHard2:
        // n[hL[𐧌䂷ꍇ́AAA
        if ((NNshGlobal->NNsiParam)->useHardKeyControl != 0)
        {
            // n[hL[QƂ̐ݒ
            return (ExecuteAction(((NNshGlobal->NNsiParam)->ttlFtr.key2)&(MULTIBTN_FEATURE_MASK)));
        }
        break;

      case vchrHard3:
        // n[hL[𐧌䂷ꍇ́AAA
        if ((NNshGlobal->NNsiParam)->useHardKeyControl != 0)
        {
            // n[hL[RƂ̐ݒ
            return (ExecuteAction(((NNshGlobal->NNsiParam)->ttlFtr.key3)&(MULTIBTN_FEATURE_MASK)));
        }
        break;

      case vchrHard4:
        // n[hL[𐧌䂷ꍇ́AAA
        if ((NNshGlobal->NNsiParam)->useHardKeyControl != 0)
        {
            // n[hL[SƂ̐ݒ
            return (ExecuteAction(((NNshGlobal->NNsiParam)->ttlFtr.key4)&(MULTIBTN_FEATURE_MASK)));
        }
        break;

      case vchrCapture:
      case vchrVoiceRec:
        // CLIELv`[{^𐧌䂷ꍇ́AAA
        if ((NNshGlobal->NNsiParam)->useHardKeyControl != 0)
        {
            // CLIELv`[{^Ƃ̐ݒ
            return (ExecuteAction(((NNshGlobal->NNsiParam)->ttlFtr.clieCapture)&(MULTIBTN_FEATURE_MASK)));
        }
        break;

      // n[hL[̏
      case chrLeftArrow:         // J[\L[(5way)
      case vchrJogLeft:
        return (ExecuteAction(((NNshGlobal->NNsiParam)->ttlFtr.left)&(MULTIBTN_FEATURE_MASK)));
        break;

      // n[hL[Ȅ
      case chrRightArrow:         // J[\L[E(5wayE)
      case vchrJogRight:
        return (ExecuteAction(((NNshGlobal->NNsiParam)->ttlFtr.right)&(MULTIBTN_FEATURE_MASK)));
        break;

      // n[hL[̏
      case vchrPageDown:
        return (ExecuteAction(((NNshGlobal->NNsiParam)->ttlFtr.down)&(MULTIBTN_FEATURE_MASK)));
        break;

      // n[hL[̏
      case vchrPageUp:
        return (ExecuteAction(((NNshGlobal->NNsiParam)->ttlFtr.up)&(MULTIBTN_FEATURE_MASK)));
        break;

      // uv(WO_C)̏
      case vchrJogDown:
      case vchrTrgJogDown:
      case vchrNextField:
      case vchrThumbWheelDown:
      case chrDownArrow:
        ret = ExecuteAction(MULTIBTN_FEATURE_SELECTNEXT);
        break;

      // uv(WO_C)̏
      case vchrJogUp:
      case vchrTrgJogUp:
      case vchrPrevField:
      case vchrThumbWheelUp:
      case chrUpArrow:
        ret = ExecuteAction(MULTIBTN_FEATURE_SELECTPREV);
        break;

      case chrCapital_U:  // UL[̓
      case chrSmall_U:
        // X̐s
        (void) ExecuteAction(MULTIBTN_FEATURE_SORT);
        break;

      case chrCapital_T:  // TL[̓
      case chrSmall_T:
        // Xg̐擪\
        (void) ExecuteAction(MULTIBTN_FEATURE_TOP);
        break;

      case chrCapital_B:    // BL[̓
      case chrSmall_B:
        // X^Cg̖ֈړ
        (void) ExecuteAction(MULTIBTN_FEATURE_BOTTOM);
        break;

      case chrCapital_K:    // KL[̓
      case chrSmall_K:
        // X̍폜
        (void) ExecuteAction(MULTIBTN_FEATURE_DELETE);
        break;

      case chrCapital_F:    // FL[̓
      case chrSmall_F:
        // X^Cg
        (void) ExecuteAction(MULTIBTN_FEATURE_SEARCH);
        break;

      case chrCapital_E:    // EL[̓
      case chrSmall_E:
        // X̖擾ꗗ폜
        (void) ExecuteAction(MULTIBTN_FEATURE_DELNOTGET);
        break;

      case chrCapital_D:    // DL[̓
      case chrSmall_D:
        // `惂[hύX
        (void) ExecuteAction(MULTIBTN_FEATURE_GRAPHMODE);
        break;

      // WO_C()̏(1y[W)
      case vchrJogPushedUp:
        // ꎞԂ(])ݒ肷
#ifdef USE_CLIE
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_PUSHEDJOGUP;
#endif
        /** not break!!  **/
      case chrCapital_P:         // PL[̓
      case chrSmall_P:           // pL[̓
        // Oy[W̕\ 
        (void) ExecuteAction(MULTIBTN_FEATURE_PREVPAGE);
        break;

      // WO_C()̏(1y[W)
      case vchrJogPushedDown:
        // ꎞԂ(])ݒ肷
#ifdef USE_CLIE
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_PUSHEDJOGDOWN;
#endif
        /** not break!!  **/

      case chrCapital_N:      // NL[̓
      case chrSmall_N:        // nL[̓
        // y[W̕\ 
        (void) ExecuteAction(MULTIBTN_FEATURE_NEXTPAGE);
        break;

      // JOG PushȈ(XgI)
      case vchrJogRelease:
#ifdef USE_CLIE
        if (NNshGlobal->tempStatus != NNSH_TEMPTYPE_CLEARSTATE)
        {
            // ꎞԂNA(܂킵Ƃ)
            NNshGlobal->tempStatus = NNSH_TEMPTYPE_CLEARSTATE;
            break;
        }
#endif
        /*****  not break!! (XgI{)  *****/

      // HandEra JOG PushI/EnterL[͎̏(XgI)
      case chrCarriageReturn:
      case chrLineFeed:
      case vchrThumbWheelPush:
        return (ExecuteAction(((NNshGlobal->NNsiParam)->ttlFtr.jogPush)&(MULTIBTN_FEATURE_MASK)));
        break;

      // obN{^/ESCL[/BSL[̏
      case vchrJogBack:
      case chrBackspace:
      case chrEscape:
      case vchrThumbWheelBack:
      case vchrGarminEscape:
        return (ExecuteAction(((NNshGlobal->NNsiParam)->ttlFtr.jogBack)&(MULTIBTN_FEATURE_MASK)));
        break;

      // Xy[XL[
      case chrSpace:
      case chrSJISIdeographicSpace:
        // VMSGmF
        return (ExecuteAction(MULTIBTN_FEATURE_NEWARRIVAL));
        break;

      case chrCapital_L:
      case chrSmall_L:
        // ꗗ擾
        return (ExecuteAction(MULTIBTN_FEATURE_GETLIST));
        break;

      case chrCapital_A:
      case chrSmall_A:
        // A (lbg[NݒJ)
        return (ExecuteAction(MULTIBTN_FEATURE_NETWORK));
        break;

      case chrCapital_J:
      case chrSmall_J:
        // XԎw̃bZ[W擾
        return (ExecuteAction(MULTIBTN_FEATURE_MESNUM));
        break;

      // @L[
      case chrCommercialAt:
        // BBSꗗ擾
        return (ExecuteAction(MULTIBTN_FEATURE_GETBBS));
        break;

     case chrHyphenMinus:
        // nCtL[(BBSꗗI(|bvAbv))
        return (ExecuteAction(MULTIBTN_FEATURE_SELECT_BBS));
        break;

      // QL[
      case chrCapital_Q:
      case chrSmall_Q:
        // ؒf
        return (ExecuteAction(MULTIBTN_FEATURE_DISCONN));
        break;

      // CL[
      case chrCapital_C:
      case chrSmall_C:
        // foCX
        return (ExecuteAction(MULTIBTN_FEATURE_DEVICEINFO));
        break;

      // OL[
      case chrCapital_O:
      case chrSmall_O:
        //URL擾
        return (ExecuteAction(MULTIBTN_FEATURE_OPENURL));
        break;

      // GL[
      case chrCapital_G:
      case chrSmall_G:
        // fBNgI(chdir)
        return (ExecuteAction(MULTIBTN_FEATURE_DIRSELECT));
        break;

      case chrDigitNine:
        // XL[iړIXCb`P̐ݒXVj
        frm  = FrmGetActiveForm();
        ctlP = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,CHKID_SELECT_GETMODE));
        keyCode = CtlGetValue(ctlP);
        keyCode = (keyCode == 0) ? 1 : 0;
        CtlSetValue(ctlP, keyCode);
        CtlHitControl(ctlP);
        break;

      case chrDigitZero:
        // OL[iړIXCb`Q̐ݒXVj
        frm  = FrmGetActiveForm();
        ctlP = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,CHKID_SELECT_MULTIPURPOSE));
        keyCode = CtlGetValue(ctlP);
        keyCode = (keyCode == 0) ? 1 : 0;
        CtlSetValue(ctlP, keyCode);
        CtlHitControl(ctlP);
        break;

      case chrDigitOne:
        // ړI{^P
        return (ExecuteAction(((NNshGlobal->NNsiParam)->multiBtn1Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case chrDigitTwo:
        // ړI{^Q
        return (ExecuteAction(((NNshGlobal->NNsiParam)->multiBtn2Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case chrDigitThree:
        // ړI{^R
        return (ExecuteAction(((NNshGlobal->NNsiParam)->multiBtn3Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case chrDigitFour:
        // ړI{^S
        return (ExecuteAction(((NNshGlobal->NNsiParam)->multiBtn4Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case chrDigitFive:
        // ړI{^T
        return (ExecuteAction(((NNshGlobal->NNsiParam)->multiBtn5Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case chrDigitSix:
        // ړI{^U
        return (ExecuteAction(((NNshGlobal->NNsiParam)->multiBtn6Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case chrComma:
        // J}L[i'ǂ'ֈړj
        return (ExecuteAction(MULTIBTN_FEATURE_TO_NOTREAD));
        break;

      case chrFullStop:
        // sIhL[i'擾ςݑS'ֈړj
        return (ExecuteAction(MULTIBTN_FEATURE_TO_GETALL));
        break;

      case chrColon:
        // RL[i'QƃO'ֈړj
        return (ExecuteAction(MULTIBTN_FEATURE_TO_OFFLINE));
        break;

      case chrSemicolon:
        // Z~RL[i'Cɓ'ֈړj
        return (ExecuteAction(MULTIBTN_FEATURE_TO_FAVOR));
        break;

      case chrDigitSeven:
        // L[7 (Bt ON)
        return (ExecuteAction(MULTIBTN_FEATURE_BT_ON));
        break;

      case chrDigitEight:
        // L[8 (Bt Off)
        return (ExecuteAction(MULTIBTN_FEATURE_BT_OFF));
        break;

      case chrExclamationMark:
        // NNsiݒ-1
        return (ExecuteAction(MULTIBTN_FEATURE_NNSHSET1));
        break;

      case chrQuotationMark:
        // NNsiݒ-2
        return (ExecuteAction(MULTIBTN_FEATURE_NNSHSET2));
        break;

      case chrNumberSign:
        // NNsiݒ-3
        return (ExecuteAction(MULTIBTN_FEATURE_NNSHSET3));
        break;

      case chrDollarSign:
        // NNsiݒ-4
        return (ExecuteAction(MULTIBTN_FEATURE_NNSHSET4));
        break;

      case chrPercentSign:
        // NNsiݒ-5
        return (ExecuteAction(MULTIBTN_FEATURE_NNSHSET5));
        break;

      case chrAmpersand:
        // NNsiݒ-6
        return (ExecuteAction(MULTIBTN_FEATURE_NNSHSET6));
        break;

      case chrApostrophe:
        // NNsiݒ-7
        return (ExecuteAction(MULTIBTN_FEATURE_NNSHSET7));
        break;

      case chrLeftParenthesis:
        // NNsiݒ-8
        return (ExecuteAction(MULTIBTN_FEATURE_NNSHSET8));
        break;

      case chrRightParenthesis:
        // NNsiݒ-9
        return (ExecuteAction(MULTIBTN_FEATURE_NNSHSET9));
        break;

      case chrQuestionMark:
        // NNsiݒʂJ
        return (ExecuteAction(MULTIBTN_FEATURE_NNSHSET));
        break;

      case chrEqualsSign:
        // [UݒPJ
        return (ExecuteAction(MULTIBTN_FEATURE_USER1TAB));
        break;

      case chrCapital_S:
      case chrSmall_S:
        // }Ns
        return (ExecuteAction(MULTIBTN_FEATURE_MACRO_EXEC));
        break;

      case chrCapital_I:
      case chrSmall_I:
        // X
        return (ExecuteAction(MULTIBTN_FEATURE_INFO));
        break;

      case chrCapital_X:
      case chrSmall_X:
        // Ij[
        return (ExecuteAction(MULTIBTN_FEATURE_SELMENU));
        break;

      case chrCapital_W:
      case chrSmall_W:
        // }Nʕ\
        return (ExecuteAction(MULTIBTN_FEATURE_MACRO_LOG));
        break;

      case chrCapital_V:
      case chrSmall_V:
        // QƃO擾ݒꗗJ
        (void) ExecuteAction(MULTIBTN_FEATURE_OPENGETLOGLIST);
        break;

      case chrCapital_H:
      case chrSmall_H:
      case chrCapital_R:
      case chrSmall_R:
      case chrCapital_Y:
      case chrSmall_Y:
      default:
        // ̑
        return (false);
        break;
    }
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   ctlSelEvt_ThreadMain                                     */
/*                                                      {^̏ */
/*-------------------------------------------------------------------------*/
static Boolean ctlSelEvt_ThreadMain(EventType *event)
{
    switch (event->data.ctlSelect.controlID)
    {
      case BTNID_BUTTON6:
        // ړI{^U
        return (ExecuteAction(((NNshGlobal->NNsiParam)->multiBtn6Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case BTNID_BUTTON1:
        // ړI{^P
        return (ExecuteAction(((NNshGlobal->NNsiParam)->multiBtn1Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case BTNID_BUTTON2:
        // ړI{^Q
        return (ExecuteAction(((NNshGlobal->NNsiParam)->multiBtn2Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case BTNID_BUTTON3:
        // ړI{^R
        return (ExecuteAction(((NNshGlobal->NNsiParam)->multiBtn3Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case BTNID_BUTTON5:
        // ړI{^T
        return (ExecuteAction(((NNshGlobal->NNsiParam)->multiBtn5Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case BTNID_BUTTON4:
        // ړI{^S
        return (ExecuteAction(((NNshGlobal->NNsiParam)->multiBtn4Feature)&(MULTIBTN_FEATURE_MASK)));
        break;

      case CHKID_SELECT_GETMODE:
        // ړIXCb`P̐ݒXV
        if (updateMultiPurposeSwitch((NNshGlobal->NNsiParam)->usageOfTitleMultiSwitch1,
                                     CHKID_SELECT_GETMODE) == true)
        {
            // ʍXVKvȃp[^XVꂽꍇ
            // Xꗗ̕\XV
            Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 
                               (NNshGlobal->NNsiParam)->selectedTitleItem,
                               NNSH_STEP_REDRAW);
        }
        break;

      case CHKID_SELECT_MULTIPURPOSE:
        // ړIXCb`Q̐ݒXV
        if (updateMultiPurposeSwitch((NNshGlobal->NNsiParam)->usageOfTitleMultiSwitch2,
                                     CHKID_SELECT_MULTIPURPOSE) == true)
        {
            // ʍXVKvȃp[^XVꂽꍇ
            // Xꗗ̕\XV
            Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 
                               (NNshGlobal->NNsiParam)->selectedTitleItem,
                               NNSH_STEP_REDRAW);
        }
        break;
  
      default:
        // ̑
        return (false);
        break;
    }

    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (true);
}

/*-------------------------------------------------------------------------*/
/*   Function :   ctlRepEvt_ThreadMain                                     */
/*                                              s[g{^̏ */
/*-------------------------------------------------------------------------*/
static Boolean ctlRepEvt_ThreadMain(EventType *event)
{
    switch (event->data.ctlRepeat.controlID)
    {
      case BTNID_LISTPREV:
        // Py[Wֈړ
        return (ExecuteAction(MULTIBTN_FEATURE_PREVPAGE));
        break;

      case BTNID_LISTNEXT:
        // Py[Wֈړ
        return (ExecuteAction(MULTIBTN_FEATURE_NEXTPAGE));
        break;
  
      default:
        // ̑
        break;
    }
    return (false);
}

/*=========================================================================*/
/*   Function :   Handler_ThreadMain                                       */
/*                                          XǗʗpCxgnh */
/*=========================================================================*/
Boolean Handler_ThreadMain(EventType *event)
{
    Boolean        ret;
    FormType      *frm;
    RectangleType  dimF;

#ifdef USE_MACRO
    LocalID        dbId;
    if (NNshGlobal->tempStatus == NNSH_MACROCMD_OPERATE)
    {
        if ((NNshGlobal->NNsiParam)->debugMessageON == 0)
        {
            // NɃ}N1xsꍇAAA
            // (AfobO[hɂ͎sȂ...)
            NNsi_ExecuteMacroMain(DBNAME_RUNONCEMACRO, DBVERSION_MACROSCRIPT);
            NNsi_RedrawThreadList();

            // s̃f[^x[X폜
            dbId = DmFindDatabase(0, DBNAME_RUNONCEMACRO);
            DmDeleteDatabase(0, dbId);

            NNshGlobal->tempStatus = NNSH_TEMPTYPE_CLEARSTATE;
            return (false);
        }
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_CLEARSTATE;
    }

    if (((NNshGlobal->NNsiParam)->autostartMacro != 0)&&
        (NNshGlobal->tempStatus == NNSH_MACROCMD_EXECUTE))
    {
        // }N̎swĂꍇɂ́A}Ns
        ExecuteAction(MULTIBTN_FEATURE_MACRO_EXEC);
        NNshGlobal->tempStatus = NNSH_TEMPTYPE_CLEARSTATE;
        return (false);
    }
#endif

    ret = false;
    switch (event->eType)
    {
      case keyDownEvent:
        (void) keyDownEvt_ThreadMain(event);
        return (true);
        break;

      case fldEnterEvent:
        break;

      case ctlSelectEvent:
        return (ctlSelEvt_ThreadMain(event));
        break;

      case ctlRepeatEvent:
        return (ctlRepEvt_ThreadMain(event));
        break;

      case frmOpenEvent:
        break;

      case popSelectEvent:
        return (popEvt_ThreadMain(event));
        break;

      case lstSelectEvent:
        break;

      case lstEnterEvent:
        break;

      case lstExitEvent:
        break;

      case menuEvent:
        (void) menuEvt_ThreadMain(event);
        return (true);
        break;

#ifdef USE_HANDERA
      case displayExtentChangedEvent :
        if (NNshGlobal->device == NNSH_DEVICE_HANDERA)
        {
            frm = FrmGetActiveForm();
            HandEraResizeForm(frm);
            FrmDrawForm(frm);
            Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 
                               (NNshGlobal->NNsiParam)->selectedTitleItem,
                               NNSH_STEP_REDRAW);
        }
        break;
#endif  // #ifdef USE_HANDERA

#ifdef USE_PIN_DIA
      case winDisplayChangedEvent:
        if ((NNshGlobal->device == NNSH_DEVICE_DIASUPPORT)||
            (NNshGlobal->device == NNSH_DEVICE_GARMIN))
        {
            frm = FrmGetActiveForm();
            if (HandEraResizeForm(frm) == true)
            {
                FrmDrawForm(frm);        
                Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 
                                   (NNshGlobal->NNsiParam)->selectedTitleItem,
                                   NNSH_STEP_REDRAW);
            }
        }
        break;
#endif

      case menuOpenEvent:
        break;

      case sclRepeatEvent:
        break;

      case sclExitEvent:
        break;

      case penDownEvent:
        frm = FrmGetActiveForm();
        FrmGetObjectBounds(frm, 
                           FrmGetObjectIndex(frm, GADID_MESSAGE_TAPPED),&dimF);
        if (RctPtInRectangle(event->screenX, event->screenY, &dimF))
        {
            // Gadget^bv(== XI)
            return (rctPointEvt_ThreadMain(event, frm, &dimF));
        }
        FrmGetObjectBounds(frm, 
                           FrmGetObjectIndex(frm, GADID_MESSAGE_LIST),&dimF);
        if (RctPtInRectangle(event->screenX, event->screenY, &dimF))
        {
            // Gadget^bv(== X̉E[)

            // y[W{^ꂽ`FbN
            FrmGetObjectBounds(frm, 
                               FrmGetObjectIndex(frm, BTNID_LISTNEXT),&dimF);
            if (RctPtInRectangle(event->screenX, event->screenY, &dimF))
            {
                // y[W{^ꂽƂɂ
                return (ExecuteAction(MULTIBTN_FEATURE_NEXTPAGE));
            }

            // Oy[W{^ꂽ`FbN
            FrmGetObjectBounds(frm, 
                               FrmGetObjectIndex(frm, BTNID_LISTPREV),&dimF);
            if (RctPtInRectangle(event->screenX, event->screenY, &dimF))
            {
                // Oy[W{^ꂽƂɂ
                return (ExecuteAction(MULTIBTN_FEATURE_PREVPAGE));
            }

            // XIƂɂ
            FrmGetObjectBounds(frm, 
                           FrmGetObjectIndex(frm, GADID_MESSAGE_LIST),&dimF);
            return (rctPointEvt_ThreadMain(event, frm, &dimF));
        }
        return (false);
        break;

      default:
        break;
    }
    return (ret);
}

/*=========================================================================*/
/*   Function :   OpenForm_ThreadMain                                      */
/*                                         XǗʂJƂ̏  */
/*=========================================================================*/
void OpenForm_ThreadMain(FormType *frm)
{
    Err          ret;
    UInt16       lp;
    ControlType *ctlP;

    // I[vAItCX̌
    if (((NNshGlobal->NNsiParam)->offChkLaunch != 0)&&(NNshGlobal->bbsTitles == NULL))
    {
        create_offline_database();
    }

    // ړIXCb`P̏ݒʂɔf
    setMultiPurposeSwitch(frm, (NNshGlobal->NNsiParam)->usageOfTitleMultiSwitch1,
                          CHKID_SELECT_GETMODE);

    // ړIXCb`Q̏ݒʂɔf
    setMultiPurposeSwitch(frm, (NNshGlobal->NNsiParam)->usageOfTitleMultiSwitch2,
                          CHKID_SELECT_MULTIPURPOSE);

    // ړI{^P̃LvVݒ
    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_BUTTON1));
    CtlSetLabel(ctlP, (NNshGlobal->NNsiParam)->multiBtn1Caption);

    // ړI{^Q̃LvVݒ
    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_BUTTON2));
    CtlSetLabel(ctlP, (NNshGlobal->NNsiParam)->multiBtn2Caption);

    // ړI{^R̃LvVݒ
    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_BUTTON3));
    CtlSetLabel(ctlP, (NNshGlobal->NNsiParam)->multiBtn3Caption);

    // ړI{^S̃LvVݒ
    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_BUTTON4));
    CtlSetLabel(ctlP, (NNshGlobal->NNsiParam)->multiBtn4Caption);

    // ړI{^T̃LvVݒ
    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_BUTTON5));
    CtlSetLabel(ctlP, (NNshGlobal->NNsiParam)->multiBtn5Caption);

    // ړI{^ŨLvVݒ
    ctlP = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, BTNID_BUTTON6));
    CtlSetLabel(ctlP, (NNshGlobal->NNsiParam)->multiBtn6Caption);

    // BBSꗗ̍쐬(ꗗȂ΁ABBSꗗ擾悤)
    ret = Create_BBS_INDEX(&(NNshGlobal->bbsTitles), &lp);
    if (ret != errNone)
    {
        // 쐬sAtH[͍XVȂAUʂ`悷
        Update_Thread_List(0, 0, NNSH_STEP_REDRAW);

        // Ƃ肠AJʂ̐ݒs
        (NNshGlobal->NNsiParam)->lastFrmID = NNSH_FRMID_THREAD;
        NNshGlobal->backFormId = FRMID_THREAD;
        return;
    }

    // (NNshGlobal->NNsiParam)->lastBBS(OIĂBBS)ςȂƂ(ꗗ̐擪ɂ)
    if (lp < (NNshGlobal->NNsiParam)->lastBBS)
    {
        (NNshGlobal->NNsiParam)->lastBBS = 0;
    }

    // BBSꗗ̃XgԂ𔽉fB
    NNshWinSetListItems(frm, LSTID_BBSINFO, NNshGlobal->bbsTitles, lp,
                        (NNshGlobal->NNsiParam)->lastBBS, &(NNshGlobal->bbsTitleH), NULL);

    // |bvAbvgK̃x(XgԂɍ킹)XV
    NNshWinSetPopItems(frm, POPTRID_BBSINFO, LSTID_BBSINFO, (NNshGlobal->NNsiParam)->lastBBS);

    // Xꗗ̕\XV
    Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 
                       (NNshGlobal->NNsiParam)->selectedTitleItem,
                       NNSH_STEP_REDRAW);

    // JtH[IDݒ肷(ݒ蒆ɂ́AlastFrmID͕ύXȂ)
    if (((NNshGlobal->NNsiParam)->useBookmark != 0)&&((NNshGlobal->NNsiParam)->bookMsgNumber != 0))
    {
        // ݒ蒆Ȃ̂ŁAȂ
    }
    else
    {
        (NNshGlobal->NNsiParam)->lastFrmID = NNSH_FRMID_THREAD;
    }
    NNshGlobal->backFormId = FRMID_THREAD;
    return;
}

/*-------------------------------------------------------------------------*/
/*   Function :   menuEvt_ThreadMain                                       */
/*                                      XǗʗpj[[` */
/*-------------------------------------------------------------------------*/
static Boolean menuEvt_ThreadMain(EventType *event)
{
    Boolean err = false;

    switch (event->data.menu.itemID)
    {
      case MNUID_SHOW_DEVICEINFO:
        // foCX݂̌̏ԕ\
        (void) ExecuteAction(MULTIBTN_FEATURE_DEVICEINFO);
        break;

      case MNUID_SHOW_VERSION:
        // o[W̕\
        (void) ExecuteAction(MULTIBTN_FEATURE_VERSION);
        break;

      case MNUID_CONFIG_NNSH:
        // NNsiݒʂJ
        return (ExecuteAction(MULTIBTN_FEATURE_NNSHSET));
        break;

      case MNUID_NET_DISCONN:
        // ؒf
        return (ExecuteAction(MULTIBTN_FEATURE_DISCONN));
        break;

      case MNUID_UPDATE_CHECK:
        // VbZ[WmF
        return (ExecuteAction(MULTIBTN_FEATURE_NEWARRIVAL));
        break;

      case MNUID_UPDATE_BBS:
        // XV(擾)
        return (ExecuteAction(MULTIBTN_FEATURE_GETBBS));
        break;

      case MNUID_SELECT_BBS:
        // gpIʂJ
        return (ExecuteAction(MULTIBTN_FEATURE_USEBBS));
        break;

      case MNUID_GET_NEWMESSAGE:
        // Xꗗ擾(SUBJECT.TXT擾)
        return (ExecuteAction(MULTIBTN_FEATURE_GETLIST));
        break;

      case MNUID_INFO_MESSAGE:
        // X
        return (ExecuteAction(MULTIBTN_FEATURE_INFO));
        break;

      case MNUID_MODIFY_TITLE:
        // X^CgύX
        return (ExecuteAction(MULTIBTN_FEATURE_MODTITLE));
        break;

      case MNUID_DEL_THREADLIST:
        // 擾X폜
        return (ExecuteAction(MULTIBTN_FEATURE_DELNOTGET));
        break;

      case MNUID_DELETE_MESSAGE:
        // X폜
        err = ExecuteAction(MULTIBTN_FEATURE_DELETE);
        break;

      case MNUID_GET_ALLMESSAGE:
        // bZ[WS擾(Ď擾)
        return (ExecuteAction(MULTIBTN_FEATURE_ALLGET));
        break;

      case MNUID_UPDATE_MESSAGE:
        // bZ[W擾
        return (ExecuteAction(MULTIBTN_FEATURE_PARTGET));
        break;

      case MNUID_OPEN_MESSAGE:
        // XQ
        return (ExecuteAction(MULTIBTN_FEATURE_OPEN));
        break;

      case MNUID_FONT_MODE:
        // `惂[hύX
        return (ExecuteAction(MULTIBTN_FEATURE_GRAPHMODE));
        break;

      case MNUID_FONT:
        // tHgύX
        return (ExecuteAction(MULTIBTN_FEATURE_FONT));
        break;

      case MNUID_GET_MESSAGENUM:
        // XԎw̃bZ[W擾
        return (ExecuteAction(MULTIBTN_FEATURE_MESNUM));
        break;

      case MNUID_SEARCH_TITLE:
        // ^Cg(̐ݒ)
        err = ExecuteAction(MULTIBTN_FEATURE_SEARCH);
        break;

      case MNUID_SEARCH_NEXT:
        // X^C()
        err = ExecuteAction(MULTIBTN_FEATURE_NEXT);
        break;

      case MNUID_SEARCH_PREV:
        // X^C(O)
        err = ExecuteAction(MULTIBTN_FEATURE_PREV);
        break;

      case MNUID_MOVE_TOP:
        // X^Cg̐擪ֈړ
        return (ExecuteAction(MULTIBTN_FEATURE_TOP));
        break;

      case MNUID_MOVE_BOTTOM:
        // X^Cg̖ֈړ(_~[ňُf[^𑗂荞)
        return (ExecuteAction(MULTIBTN_FEATURE_BOTTOM));
        break;

      case MNUID_COPY_READONLY:
        // XQƃOփRs[
        (void) ExecuteAction(MULTIBTN_FEATURE_COPYGIKO);
        break;

      case MNUID_OS5_LAUNCH_WEB:
        // IXuEUŊJ
        (void) ExecuteAction(MULTIBTN_FEATURE_OPENWEB);
        break;

      case MNUID_BACKUP_DATABASE:
        // DBVFSɃobNAbv
        (void) ExecuteAction(MULTIBTN_FEATURE_DBCOPY);
        break;

      case MNUID_NET_CONFIG:
        // lbg[NݒJ
        (void) ExecuteAction(MULTIBTN_FEATURE_NETWORK);
        break;

      case MNUID_SORT_SUBJECT:
        // X̐s
        return (ExecuteAction(MULTIBTN_FEATURE_SORT));
        break;

      case MNUID_HANDERA_ROTATE:
        // HandEra ʉ] //
        (void) ExecuteAction(MULTIBTN_FEATURE_ROTATE);
        break;

      case MNUID_CONFIG_USER1TAB:
        // [U^uPݒ 
        (void) ExecuteAction(MULTIBTN_FEATURE_USER1TAB);
        break;

#ifdef USE_USERTAB_DETAIL
      case MNUID_CONFIG_USER2TAB:
        // [U^uQݒ 
        (void) ExecuteAction(MULTIBTN_FEATURE_USER2TAB);
        break;

      case MNUID_CONFIG_USER3TAB:
        // [U^uRݒ 
        (void) ExecuteAction(MULTIBTN_FEATURE_USER3TAB);
        break;

      case MNUID_CONFIG_USER4TAB:
        // [U^uSݒ 
        (void) ExecuteAction(MULTIBTN_FEATURE_USER4TAB);
        break;

      case MNUID_CONFIG_USER5TAB:
        // [U^uTݒ 
        (void) ExecuteAction(MULTIBTN_FEATURE_USER5TAB);
        break;
#endif

      case MNUID_NEW_THREAD:
        // X
        (void) ExecuteAction(MULTIBTN_FEATURE_NEWTHREAD);
        break;
        
      case MNUID_GOTO_DUMMY:
        // _~[ʂ
        (void) ExecuteAction(MULTIBTN_FEATURE_GOTODUMMY);
        break;

      case MNUID_NNSI_END:
        // NNsiI
        (void) ExecuteAction(MULTIBTN_FEATURE_NNSIEND);
        break;

      case MNUID_CHECK_NOFMESSAGE:
        // ^u(XmF)
        (void) ExecuteAction(MULTIBTN_FEATURE_TABINFO);
        break;

      case MNUID_MOVE_LOGMNGLOC:
        // OǗꏊύX
        (void) ExecuteAction(MULTIBTN_FEATURE_MOVELOGLOC);
        break;

      case MNUID_GET_URL:
        // URLJ
        (void) ExecuteAction(MULTIBTN_FEATURE_OPENURL);
        break;

#ifdef USE_MACROEDIT
      case MNUID_MACRO_SETTING:
        // }Nݒ
        (void) ExecuteAction(MULTIBTN_FEATURE_MACRO_SET);
        break;
#endif

      case MNUID_MACRO_EXECUTE:
        // }Ns
        (void) ExecuteAction(MULTIBTN_FEATURE_MACRO_EXEC);
        break;
      case MNUID_MACRO_EXECLOG:
        // }NsO
        (void) ExecuteAction(MULTIBTN_FEATURE_MACRO_LOG);
        break;

      case MNUID_MACRO_DATAVIEW:
        // }Ne\
        (void) ExecuteAction(MULTIBTN_FEATURE_MACRO_VIEW);
        break;

      case MNUID_OYSTERLOGIN:
        // OC
        (void) ExecuteAction(MULTIBTN_FEATURE_OYSTERLOGIN);
        break;

      case MNUID_SHOW_LISTHELP:
        // 
        (void) ExecuteAction(MULTIBTN_FEATURE_USAGE);
        break;

      case MNUID_SELECTIONMENU:
        // Ij[
        (void) ExecuteAction(MULTIBTN_FEATURE_SELMENU);
        break;
      case MNUID_GETLOGLIST:
        // QƃO擾ݒꗗ
        (void) ExecuteAction(MULTIBTN_FEATURE_OPENGETLOGLIST);
        break;

      case MNUID_SEARCH_BBS:
        // (̐ݒ)
        err = ExecuteAction(MULTIBTN_FEATURE_SEARCHBBS);
        break;

      case MNUID_SEARCH_NEXTBBS:
        // ̎
        err = ExecuteAction(MULTIBTN_FEATURE_NEXTSEARCHBBS);
        break;

      case MNUID_BEAM_URL:
        // URLBeam
        err = ExecuteAction(MULTIBTN_FEATURE_BEAMURL);
        break;

      default:
        // ̑(肦Ȃ͂...)
        break;
    }

    // Xꗗʂĕ\
    NNsi_RedrawThreadList();
    return (err);
}

/*=========================================================================*/
/*   Function : NNsi_RedrawThreadList                                      */
/*                                                    Xꗗʂĕ` */
/*=========================================================================*/
void NNsi_RedrawThreadList(void)
{
    FormType      *frm;
    RectangleType  dimF;
    UInt16         fontID, fontHeight, nlines;

    // XꗗʈȊOł͍XVȂ
    if (FrmGetActiveFormID() == FRMID_THREAD)
    {
        frm = FrmGetActiveForm();
        FrmDrawForm(frm);
        FrmGetObjectBounds(frm, FrmGetObjectIndex(frm, GADID_MESSAGE_LIST), 
                           &dimF);
        fontID = ((NNshGlobal->NNsiParam)->useSonyTinyFontTitle == 0) ?
                           (NNshGlobal->NNsiParam)->currentFont : (NNshGlobal->NNsiParam)->sonyHRFontTitle;

        NNsi_UpdateRectangle(&dimF, (NNshGlobal->NNsiParam)->useSonyTinyFontTitle,
                             &fontID, &fontHeight, &nlines);

        NNsi_WinDrawList((NNshGlobal->NNsiParam)->selectedTitleItem, 
                         NNshGlobal->msgTitleIndex, nlines, &dimF, fontHeight);
#ifdef USE_PIN_DIA
        if ((NNshGlobal->device == NNSH_DEVICE_DIASUPPORT)||
            (NNshGlobal->device == NNSH_DEVICE_GARMIN))
        {
            NNshGlobal->updateHR = NNSH_UPDATE_DISPLAY;
        }
#endif
    }
    return;
}

#ifdef USE_LOGCHARGE
/*-------------------------------------------------------------------------*/
/*   Function :   openURL                                                  */
/*                                                              URLJ  */
/*-------------------------------------------------------------------------*/
static void openURL(void)
{
    FormType            *frm;
    ListType            *lstP;
    UInt16               selBBS;
    Char                *url, *fileName, *ptr;
    NNshGetLogDatabase  *dbData;
    
    // \^uQƃO`FbN
    frm     = FrmGetActiveForm();
    lstP    = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, LSTID_BBSINFO));
    selBBS  = LstGetSelection(lstP);
    if (selBBS != NNSH_SELBBS_OFFLINE)
    {
        // ̋@\́AQƃŐ@\Ȃ̂ŉI
        NNsh_WarningMessage(ALTID_WARN, MSG_WARN_ONLY_READONLYLOG, MSG_ABORT_MESSAGE, 0);
        return;
    }

    // 擾URL̓
    url = MEMALLOC_PTR(BUFSIZE + MARGIN);
    if (url == NULL)
    {
        return;
    }
    MemSet(url, BUFSIZE + MARGIN, 0x00);

    // t@Ci[̈m
    fileName = MEMALLOC_PTR(MAX_THREADFILENAME + MARGIN);
    if (fileName == NULL)
    {
        MEMFREE_PTR(url);
        return;
    }
    MemSet(fileName, MAX_THREADFILENAME + MARGIN, 0x00);

    // DB̃_~[̈m
    dbData = MEMALLOC_PTR(sizeof(NNshGetLogDatabase) + MARGIN);
    if (dbData == NULL)
    {
        MEMFREE_PTR(url);
        MEMFREE_PTR(fileName);
        return;
    }
    MemSet(dbData, sizeof(NNshGetLogDatabase) + MARGIN, 0x00);

    // URL͂Ă炤B
    StrCopy(url, "http://");
    if (DataInputDialog(MSG_DIALOG_SET_URL, url, BUFSIZE, 
                            NNSH_DIALOG_USE_INPUTURL, NULL) != true)
    {
        // URL̓͂LZꂽꍇ
        goto ABORT_END;
    }
#ifdef USE_SSL
    if ((url[0] != 'h')||(url[1] != 't')||(url[2] != 't')||(url[3] != 'p')||
        ((url[4] != ':')&&(url[4] != 's'))||((url[5] != '/')&&(url[5] != ':')))
    {
        // URL̎w肪܂Ăꍇ(http:// ł͂܂Ȃꍇ)
        NNsh_WarningMessage(ALTID_WARN, MSG_WARN_WRONGURL, url, 0);
        goto ABORT_END;
    }
#else
    if ((url[0] != 'h')||(url[1] != 't')||(url[2] != 't')||(url[3] != 'p')||
        (url[4] != ':')||(url[5] != '/'))
    {
        // URL̎w肪܂Ăꍇ(http:// ł͂܂Ȃꍇ)
        NNsh_WarningMessage(ALTID_WARN, MSG_WARN_WRONGURL_NOTSSL, url, 0);
        goto ABORT_END;
    }
#endif
    if (NNsh_ConfirmMessage(ALTID_CONFIRM, url, MSG_GETURLLOG_CONFIRM, 0) != 0)
    {
        // f[^̎擾mFLZꂽꍇ
        goto ABORT_END;
    }

    // f[^ۑXt@C̓
    ptr = url + StrLen(url) - 1;
    while ((*ptr != '/')&&(*ptr != '?')&&(*ptr != '*')&&(*ptr != '.'))
    {
        ptr--;
    }

    // f[^̍ŌɃXbVꍇɂ̓t@CRs[Ȃ
    if (ptr < url + StrLen(url) - 1)
    {
        StrNCopy(fileName, (ptr + 1), (MAX_THREADFILENAME - 1));
    }

    // tqkf[^̎擾...
    ReadOnlyLogDataPickup(dbData, url, fileName, NNSH_MSGNUM_UNKNOWN, 0, 0, NULL);

    // QƃOTOPfBNg\
    (NNshGlobal->NNsiParam)->readOnlySelection = 0;

    // IꂽfBNgXVꂽꍇɂ́AX^CꗗXV
    Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 0, NNSH_STEP_UPDATE);

    // mۗ̈J
    MEMFREE_PTR(dbData);
    MEMFREE_PTR(fileName);
    MEMFREE_PTR(url);

    return;

ABORT_END:
    // mۗ̈J
    MEMFREE_PTR(dbData);
    MEMFREE_PTR(fileName);
    MEMFREE_PTR(url);
    
    // ʂĕ`悵ďI
    Update_Thread_List((NNshGlobal->NNsiParam)->lastBBS, 
                              (NNshGlobal->NNsiParam)->selectedTitleItem, NNSH_STEP_REDRAW);
    return;
}
#endif
