/*!
 *   ʐ䕔..
 *
 */
#include <QtGlobal>
#include <QMessageBox>
#include <QDateTime>
#include <QString>
#include <QVariant>
#include <QFileDialog>
#include "a2BCversion.h"
#include "screenControl.h"
#include "a2BCthread.h"

#include <QLocale>

/*!
 *  RXgN^
 *
 */
screenControl::screenControl(Ui::a2BCMain *apForm, QString &execPath, QWidget *parent)
  : QWidget(parent), mpForm(apForm), mpDB(0), mpModel(0), mpHttpConn(0), mpHttpMain(0)
{
    createClasses(execPath);
    initializeDatas();
    connectSignals();
}

/*!
 *  fXgN^
 *
 */
screenControl::~screenControl()
{
	deleteClasses();
}

/*!
 *  NX̐
 *
 */
void screenControl::createClasses(QString &execPath)
{
	mpDB          = new screenData();
    mpTimer       = new a2BCthread();
	mpHttpMain    = new QHttp();
    mpIndexParser = new a2BCindexParser();
	mpHttpConn    = new a2BChttpConnection(mpHttpMain);
	mpModel       = new a2BCmodel(mpDB, mpHttpConn, mpIndexParser);

    // p[^t@Cǂݏo...
    mParameterLoader.loadFromFile(execPath, mpDB);

	return;
}

/*!
 *  NX̍폜
 *
 */
void screenControl::deleteClasses(void)
{
	if (mpDB != 0)
	{
		delete mpDB;
		mpDB = 0;
	}

	if (mpModel != 0)
	{
		delete mpModel;
		mpModel = 0;
	}
}

/*!
 *  f[^̏(Windowf[^̏)s
 *
 */
void screenControl::initializeDatas(void)
{
    // Xe[^Xo[ɃvOXo[ǉ
    mProgressBar.setGeometry(QRect(0, 0, 150, 16));
    (mpForm->statusbar)->addPermanentWidget(&mProgressBar);

	// 擾URL
	QString data;
	data = mpDB->getBbsTableUrl();
	(mpForm->urlBbsTable)->setText(data);

	// XVt@C
	data = mpDB->getBbsTableFileName();
	(mpForm->lineEdit_File_bbsTable)->setText(data);

    // QuEŮǗfBNg
    QString logDir = mpDB->getOtherBrowserDirectory();
    (mpForm->lineEdit_2chLogDirectory)->setText(logDir);

	// subject.txtXV
	Qt::CheckState checkState;
	checkState = mpDB->getUpdateSubjectTxt();
	(mpForm->chkGetSubjectTxt)->setCheckState(checkState);

	// datXǂ߂悤ɂ
	checkState = mpDB->getEnableDownThread();
	(mpForm->chkEnableDownThread)->setCheckState(checkState);

	// q̃XǗΏۂɂ
	checkState = mpDB->getAddThreadToIndex();
	(mpForm->chkTrimDatLogFile)->setCheckState(checkState);
	(mpForm->chkTrimDatLogFile)->setEnabled(false);
    (mpForm->chkTrimDatLogFile)->hide();

	// ꗗɃX擾uCɓvƂĒǉ
	checkState = mpDB->getAddToBbsTable();
	(mpForm->chkModifyBbsTable)->setCheckState(checkState);

    // XSčĎ擾
    checkState = mpDB->getDisableGetPart();
    (mpForm->chkGetAgainAll)->setCheckState(checkState);

    // G[XǗΏۂ͂
    checkState = mpDB->getRemoveErrorMessage();
    (mpForm->chkRemoveErrorThread)->setCheckState(checkState);

    // ǗΏۂł͂Ȃ͕̂ʂQuEUɈړ
    checkState = mpDB->getBackupErrorLog();
    (mpForm->chkErrLogBackup)->setCheckState(checkState);

    // Xꗗ(subject.txt)Rs[
    checkState = mpDB->getCopySubjectTxt();
    (mpForm->chkCopySubjectTxt)->setCheckState(checkState);


	// X擾Ԋu
	QVariant interval = mpDB->getReceiveInterval();
	(mpForm->getInterval)->setText(interval.toString());

    // QuEŨ^Cv
    switch (mpDB->getOtherBrowserType())
    {
      case OTHERBROWSER_GIKONAVI:
        (mpForm->gikoNavitype)->setChecked(true);
        break;
      case OTHERBROWSER_ABONE:
        (mpForm->Abonetype)->setChecked(true);
        break;
      case OTHERBROWSER_HZN2:
        (mpForm->hotZonu2type)->setChecked(true);
        break;
      case OTHERBROWSER_V2C:
        (mpForm->V2Ctype)->setChecked(true);
        break;
      case OTHERBROWSER_JANE:
        (mpForm->janeType)->setChecked(true);
        break;
      case OTHERBROWSER_PGIKO:
      default:
        (mpForm->pGIKOtype)->setChecked(true);
        break;
    }
    
    // 
    switch (mpDB->getSynchronizeType())
    {
      case SYNC_ALL:
        (mpForm->btnSynchronize)->setChecked(true);
        break;
      case SYNC_TO_a2B:
        (mpForm->btnToa2B)->setChecked(true);
        break;
      case SYNC_FROM_a2B:
      default:
        (mpForm->btnToOtherBrowser)->setChecked(true);
        break;        
    }

	// {^Q̗L/ݒɂ
    if (data.contains("bbstable.html") == false)
    {
        // {^Q̗L/ݒɂ
        (mpForm->pBtnSelectionBbsTable)->setEnabled(true);
        (mpForm->pBtnUpdateBbsTable)->setEnabled(false);
        (mpForm->executeUpdate)->setEnabled(false);
        (mpForm->executeSync)->setEnabled(false);
        (mpForm->executeCancel)->setEnabled(false);
        (mpForm->executeCancel_2)->setEnabled(false);
    }
    else
    {
        // {^Q̗L/ݒɂ
        (mpForm->pBtnSelectionBbsTable)->setEnabled(true);
        (mpForm->pBtnUpdateBbsTable)->setEnabled(true);
        (mpForm->executeUpdate)->setEnabled(true);
        (mpForm->executeSync)->setEnabled(true);
        (mpForm->executeCancel)->setEnabled(false);
        (mpForm->executeCancel_2)->setEnabled(false);
    }

    // f[^NX̏
    mFavoriteEditor.prepare(mpDB, mpForm->tblViewFavorite);


    mpTimer->run();
	return;
}

/*!
 *  signalslotڑ
 *
 */
void screenControl::connectSignals(void)
{
    qDebug("screenControl::connectSignals()");

	// "Q"{^Ƃ̏
	connect(mpForm->pBtnSelectionBbsTable, SIGNAL(clicked()),
            this,                          SLOT(selection_bbsTableFile()));

    // "Q"{^Ƃ̏ (uEŮǗfBNgw)
    connect(mpForm->pBtnSelectionOtherBrowserDirectory, SIGNAL(clicked()),
            this,                          SLOT(selection_otherBrowserDirectory()));

	// "bbstable.html̍XV"{^Ƃ̏
	connect(mpForm->pBtnUpdateBbsTable, SIGNAL(clicked()),
            this,                       SLOT(select_updateBbsTableFile()));

	// s{^Ƃ̏
	connect(mpForm->executeUpdate, SIGNAL(clicked()),
            this,                  SLOT(executeUpdate()));

    // s{^Ƃ̏
    connect(mpForm->executeSync, SIGNAL(clicked()),
            this,                  SLOT(executeSync()));

	// LZ{^̏
    connect(mpForm->executeCancel, SIGNAL(clicked()),
            this,                  SLOT(cancelUpdate()));

    // LZ{^̏
    connect(mpForm->executeCancel_2, SIGNAL(clicked()),
            this,                   SLOT(cancelUpdate()));

	// eLXgXVƂ̏ (t@C)
	connect(mpForm->lineEdit_File_bbsTable, SIGNAL(editingFinished()),
            this,                           SLOT(changed_bbsTableFile()));

	// eLXgXVƂ̏ (URL)
	connect(mpForm->urlBbsTable, SIGNAL(editingFinished()),
            this,                SLOT(changed_bbsTableUrl()));

	// eLXgXV̏(擾Ԋu)
	connect(mpForm->getInterval, SIGNAL(editingFinished()),
            this,                SLOT(changed_interval()));

	// \bZ[W̎M
	connect(mpModel, SIGNAL(updateMessage(const QString &)),
            this,    SLOT(updateMessage(const QString &)));

    // \bZ[W̎M(p)
    connect(&mSyncLog, SIGNAL(updateMessage(const QString &)),
            this,     SLOT(updateMessage(const QString &)));

    // ̕
    connect(&mSyncLog, SIGNAL(completedSynchronize(const QString &)),
            this,       SLOT(completedSynchronize(const QString &)));

    // Cɓf[^̓ǂݍ
    connect(mpForm->btnReadFavorite, SIGNAL(clicked()),
            &mFavoriteEditor,        SLOT(extractFavoriteData()));
    
    // Cɓf[^̏
    connect(mpForm->btnWriteFavorite, SIGNAL(clicked()),
            &mFavoriteEditor,         SLOT(storeFavoriteData()));

    // Cɓf[^̍폜
    connect(mpForm->btnRemoveFavorite, SIGNAL(clicked()),
            &mFavoriteEditor,          SLOT(removeFavoriteData()));

    // Cɓf[^̓ւ
    connect(mpForm->btnSwapFavorite,   SIGNAL(clicked()),
            &mFavoriteEditor,          SLOT(swapFavoriteData()));

    // \bZ[W̎M(CɓǗp)
    connect(&mFavoriteEditor, SIGNAL(updateMessage(const QString &)),
            this,            SLOT(updateMessage(const QString &)));

    // ^C}ݒ
    connect(mpModel, SIGNAL(setTimer(int, unsigned long)),
            mpTimer, SLOT(setTimer(int, unsigned long)));

    // ^CAEg̎M
    connect(mpTimer, SIGNAL(timeout(int)),
            mpModel, SLOT(receiveTimeout(int)));

    // O擾̊Jn
    connect(mpModel, SIGNAL(startedUpdate()),
            this,    SLOT(startedUpdate()));

    // O擾̏I
    connect(mpModel, SIGNAL(completedUpdate()),
            this,    SLOT(completedUpdate()));

	// ʐMԍXV̕
	connect(mpHttpConn, SIGNAL(updateMessage(const QString &)),
            this,    SLOT(updateMessage(const QString &)));

	// ʐMI̕
	connect(mpHttpConn, SIGNAL(completedCommunication(int, QString &)),
            this,    SLOT(completedCommunication(int, QString &)));

    // ʐMI̕
    connect(this,    SIGNAL(completedCommunication(int)),
            mpModel,  SLOT(completedCommunication(int)));

    // ̒ʐMJn...
    connect(this,    SIGNAL(nextCommunication()),
            mpModel,  SLOT(nextCommunication()));

    // vOXo[̍XV
    connect(mpModel,        SIGNAL(updateValue(int)),
            &mProgressBar,  SLOT(setValue(int)));

    // vOXo[̍őlݒ
    connect(mpModel,        SIGNAL(setMaximum(int)),
            &mProgressBar,  SLOT(setMaximum(int)));

    // vOXo[̍XV
    connect(&mSyncLog,      SIGNAL(updateValue(int)),
            &mProgressBar,  SLOT(setValue(int)));

    // vOXo[̍őlݒ
    connect(&mSyncLog,      SIGNAL(setMaximum(int)),
            &mProgressBar,  SLOT(setMaximum(int)));
		
    //
    //connect(mpHttpMain, SIGNAL(requestFinished(int, bool)),
            //mpHttpConn,   SLOT(requestFinished(int, bool)));

	// 
    connect(mpHttpMain, SIGNAL(done(bool)),
            mpHttpConn,   SLOT(done(bool)));

    // 
    connect(mpHttpMain, SIGNAL(readyRead(const QHttpResponseHeader &)),
            mpHttpConn,   SLOT(readyRead(const QHttpResponseHeader &)));

    // 
    connect(mpForm->actionAbout_Qt, SIGNAL(triggered(bool)),
            this,   SLOT(show_aboutQt(bool)));

    // 
    connect(mpForm->actionAbout_a2B, SIGNAL(triggered(bool)),
            this,   SLOT(show_about_a2BC(bool)));

    return;
}

/*!
 *  "Q..."{^Ƃ̏
 *
 */
void screenControl::selection_bbsTableFile()
{
    qDebug("screenControl::selection_bbsTableFile()");

	QString fileName = mpDB->getBbsTableFileName();
	bool result = mpModel->selection_bbsTableFile(fileName);
	if (result == true)
	{
		// w肵t@Cݒ肷
		(mpForm->lineEdit_File_bbsTable)->setText(fileName);
		mpDB->setBbsTableFileName(fileName);
	}
	if (fileName.contains("bbstable.html") == false)
	{
		// {^Q̗L/ݒɂ
		(mpForm->pBtnSelectionBbsTable)->setEnabled(true);
		(mpForm->pBtnUpdateBbsTable)->setEnabled(false);
		(mpForm->executeUpdate)->setEnabled(false);
        (mpForm->executeSync)->setEnabled(false);
		(mpForm->executeCancel)->setEnabled(false);
        (mpForm->executeCancel_2)->setEnabled(false);
	}
	else
	{
		// {^Q̗L/ݒɂ
		(mpForm->pBtnSelectionBbsTable)->setEnabled(true);
		(mpForm->pBtnUpdateBbsTable)->setEnabled(true);
		(mpForm->executeUpdate)->setEnabled(true);
        (mpForm->executeSync)->setEnabled(true);
		(mpForm->executeCancel)->setEnabled(false);
        (mpForm->executeCancel_2)->setEnabled(false);
	}
	return;
}

/*!
 *  "Q..."{^Ƃ̏ (uEUfBNg̃fBNgw)
 *
 */
void screenControl::selection_otherBrowserDirectory()
{
    qDebug("screenControl::selection_otherBrowserDirectory()");

    QString fileName = mpDB->getOtherBrowserDirectory();
    QString s = QFileDialog::getExistingDirectory(this, "", fileName);
    if (s == 0)
    {
        return;
    }

    // w肵t@Cݒ肷
    (mpForm->lineEdit_2chLogDirectory)->setText(s);
    mpDB->setOtherBrowserDirectory(s);
    return;
}

/*!
 *  "bbstable.html̍XV" {^Ƃ̏
 *
 */
void screenControl::select_updateBbsTableFile()
{
	// ʏԂ֔f
	updateFormData();

    // XVt@C̊mF
	QString fileName = mpDB->getBbsTableFileName();
	if (fileName.contains("bbstable.html") == false)
	{
		// t@Cbbstable.htmlw肳ĂȂꍇ
		QMessageBox mb("a2BC", tr("Invalid FileName"),
		               QMessageBox::Information,
			           QMessageBox::Ok | QMessageBox::Default,
				       QMessageBox::NoButton,
					   QMessageBox::NoButton);
		mb.exec();
		return;
	}

	// 擾URLmF
	QString url = mpDB->getBbsTableUrl();
	if (url.contains("bbstable.html") == false)
	{
		// URLbbstable.htmlw肳ĂȂꍇ
		QMessageBox mb("a2BC", tr("Invalid URL"),
		               QMessageBox::Information,
			           QMessageBox::Ok | QMessageBox::Default,
				       QMessageBox::NoButton,
					   QMessageBox::NoButton);
		mb.exec();
		return;
	}

	// bbstable.html̍XVs邩mF
	QString information = tr("Updates bbstable.html") + "\n    file name : " + fileName;
	information = information + "\n    " + "URL         : " + url + "\n\n";
	information = information + tr("Are you OK?");

    QMessageBox mb(tr("get bbstable.html"), information,
                   QMessageBox::Information,
                   QMessageBox::Ok | QMessageBox::Default,
                   QMessageBox::Cancel | QMessageBox::Escape,
				   QMessageBox::NoButton);
    mb.setButtonText(QMessageBox::Ok, tr("OK"));
    mb.setButtonText(QMessageBox::Cancel, tr("Cancel"));
    switch(mb.exec())
	{
      case QMessageBox::Ok:
        // bbstable.html̍XVs
		mpModel->update_bbsTableFile(fileName, url);
        break;

	  case QMessageBox::Cancel:
	  default:
        // ɏI
        break;
    }
	return;
}


/*!
 *   usv{^ꂽƂ̏
 *
 */
void screenControl::executeSync()
{
    // ʏԂ֔f
    updateFormData();

    QString translationFile = QLocale::languageToString(QLocale::system().language());
    QMessageBox::information(0, "Info(Translation)", translationFile, QMessageBox::Ok);

    // a2Bgpbbstable.html̃t@Co^Ă邩mF
    QString fileName = mpDB->getBbsTableFileName();
    if (fileName.contains("bbstable.html") == false)
    {
        // t@Cbbstable.htmlw肳ĂȂꍇ
        // (bbstable.htmlw肳ĂȂ߁AsłȂ)
        QMessageBox mb("a2BC", tr("Invalid FileName"),
                       QMessageBox::Information,
                       QMessageBox::Ok | QMessageBox::Default,
                       QMessageBox::NoButton,
                       QMessageBox::NoButton);
        mb.exec();
        return;
    }

    // Ȍ...
    bool ret = mSyncLog.prepare(*mpDB);
    if (ret != true)
    {
        // sI 񍐂ďIB
        QMessageBox mb("a2BC", tr("DO NOT READY FOR SYNC."),
                       QMessageBox::Information,
                       QMessageBox::Ok | QMessageBox::Default,
                       QMessageBox::NoButton,
                       QMessageBox::NoButton);
        mb.exec();
        return;
    }

    // O{Ɏs邩mF
    QString information;
    information = "\n [" + mSyncLog.getSourceBrowserName() + " <==> " + mSyncLog.getDestinationBrowserName() + "] ";
    information = tr("Do synchronize, are you ready?") + information;
    QMessageBox mb(tr("sync a2B data"), information,
                   QMessageBox::Information,
                   QMessageBox::Ok | QMessageBox::Default,
                   QMessageBox::Cancel | QMessageBox::Escape,
                   QMessageBox::NoButton);
    mb.setButtonText(QMessageBox::Ok, tr("OK"));
    mb.setButtonText(QMessageBox::Cancel, tr("Cancel"));
    switch(mb.exec())
    {
      case QMessageBox::Ok:
        // LZ{^Lɂ
        (mpForm->executeCancel)->setEnabled(true);
        (mpForm->executeCancel_2)->setEnabled(true);

        // Os
        mSyncLog.doSync(mpDB->getSynchronizeType(), mpDB->getBackupErrorLog(), mpDB->getCopySubjectTxt());
        break;

      case QMessageBox::Cancel:
      default:
        // ɏI
        break;
    }

/**
    // {^Q̗L/ݒɂ
    (mpForm->pBtnSelectionBbsTable)->setEnabled(true);
    (mpForm->pBtnUpdateBbsTable)->setEnabled(true);
    (mpForm->executeUpdate)->setEnabled(true);
    (mpForm->executeSync)->setEnabled(true);
    (mpForm->executeCancel)->setEnabled(false);
    (mpForm->executeCancel_2)->setEnabled(false);
**/
    return;
}

/*!
 *   usv{^ꂽƂ̏
 *
 */
void screenControl::executeUpdate()
{
    // ʏԂ֔f
	updateFormData();

	// a2Bgpbbstable.html̃t@Co^Ă邩mF
	QString fileName = mpDB->getBbsTableFileName();
	if (fileName.contains("bbstable.html") == false)
	{
		// t@Cbbstable.htmlw肳ĂȂꍇ
		QMessageBox mb("a2BC", tr("Invalid FileName"),
		               QMessageBox::Information,
			           QMessageBox::Ok | QMessageBox::Default,
				       QMessageBox::NoButton,
					   QMessageBox::NoButton);
		mb.exec();
		return;
	}

    // VmFs (mFOŎsmF)
    mpModel->update_a2B_datas();

#if 0
	// VmF̍XVs邩mF
	QString information = tr("Updates a2B datas, are you ready?");

    QMessageBox mb(tr("update a2B data"), information,
                   QMessageBox::Information,
                   QMessageBox::Ok | QMessageBox::Default,
                   QMessageBox::Cancel | QMessageBox::Escape,
				   QMessageBox::NoButton);
    mb.setButtonText(QMessageBox::Ok, tr("OK"));
    mb.setButtonText(QMessageBox::Cancel, tr("Cancel"));
    switch(mb.exec())
	{
      case QMessageBox::Ok:
		// LZ{^Lɂ
		(mpForm->executeCancel)->setEnabled(true);
        (mpForm->executeCancel_2)->setEnabled(true);

		// VmFs
        mpModel->update_a2B_datas();
        break;

	  case QMessageBox::Cancel:
	  default:
        // ɏI
        break;
    }
#endif
	return;
}

/*!
 *   uLZv{^ꂽƂ̏
 *
 */
void screenControl::cancelUpdate()
{
	return;
}

/*!
 *   bbstable.html̃t@CXVꂽƂ
 *
 */
void screenControl::changed_bbsTableFile()
{
	QString fileName = (mpForm->lineEdit_File_bbsTable)->text();
	mpDB->setBbsTableFileName(fileName);
	if (fileName.contains("bbstable.html") == false)
	{
		// {^Q̗L/ݒɂ
		(mpForm->pBtnSelectionBbsTable)->setEnabled(true);
		(mpForm->pBtnUpdateBbsTable)->setEnabled(false);
		(mpForm->executeUpdate)->setEnabled(false);
        (mpForm->executeSync)->setEnabled(false);
		(mpForm->executeCancel)->setEnabled(false);
        (mpForm->executeCancel_2)->setEnabled(false);
	}
	else
	{
		// {^Q̗L/ݒɂ
		(mpForm->pBtnSelectionBbsTable)->setEnabled(true);
		(mpForm->pBtnUpdateBbsTable)->setEnabled(true);
		(mpForm->executeUpdate)->setEnabled(true);
        (mpForm->executeSync)->setEnabled(true);
		(mpForm->executeCancel)->setEnabled(false);
        (mpForm->executeCancel_2)->setEnabled(false);
	}
	return;
}

/*!
 *   bbstable.htmlURLf[^XVꂽƂ
 *
 */
void screenControl::changed_bbsTableUrl()
{
	mpDB->setBbsTableUrl((mpForm->urlBbsTable)->text());
	return;
}

/*!
 *   擾C^[o̒lXVꂽƂ
 *
 */
void screenControl::changed_interval()
{
	QVariant interval = (mpForm->getInterval)->text();
	mpDB->setReceiveInterval(interval.toInt());

	interval = mpDB->getReceiveInterval();
	(mpForm->getInterval)->setText(interval.toString());

	return;
}

/*!
 *   bZ[W̕\XV
 *
 */
void screenControl::updateMessage(const QString &arMessage)
{
    QDateTime time = QDateTime::currentDateTime();
    QString message = time.toString("MM/dd hh:mm:ss") + " " + arMessage + "\n";
	(mpForm->informData)->insertPlainText(message);
    (mpForm->textBrowser)->insertPlainText(message);
	return;
}

/*!
 *   HTTPʐM̏I(R[obN)
 *
 */
void screenControl::completedCommunication(int error, QString &arMessage)
{
    // ~{^̖
    (mpForm->executeCancel)->setEnabled(false);
    (mpForm->executeCancel_2)->setEnabled(false);

    // bZ[W̕\
	QString message;
	if (error < 0)
	{
		// G[I
		message = tr("Error Http Communication : ") + arMessage;
	}
	else
	{
		// I
		message = tr("Completed Http Communication : ") + arMessage;
	}

	// bZ[W̍XV...
	updateMessage(message);

    // ʐM̃VOis
    emit completedCommunication(error);

	return;
}


/*!
 *   ȌI(R[obN)
 *
 */
void screenControl::completedSynchronize(const QString &arMessage)
{
    // s{^̗L
    (mpForm->executeUpdate)->setEnabled(true);
    (mpForm->executeSync)->setEnabled(true);

    // ~{^̖
    (mpForm->executeCancel)->setEnabled(false);
    (mpForm->executeCancel_2)->setEnabled(false);

    // bZ[W̍XV...
    QString message = arMessage;
    updateMessage(message);

    // ̃VOis
    emit completedSynchronize();

    // ̕\...(bZ[W{bNXŕ\)
    QString caption = tr("End Synchronize");
    QMessageBox::information(this, caption, message, QMessageBox::Ok);

    // vOXo[̏
    mProgressBar.reset();

    return;
}

/*!
 *   ʂ̃`FbNԁAURLAt@Cɔf
 *
 */
void screenControl::updateFormData(void)
{
	mpDB->setBbsTableUrl((mpForm->urlBbsTable)->text());
	mpDB->setBbsTableFileName((mpForm->lineEdit_File_bbsTable)->text());
	mpDB->setUpdateSubjectTxt((mpForm->chkGetSubjectTxt)->checkState());
	mpDB->setEnableDownThread((mpForm->chkEnableDownThread)->checkState());
	mpDB->setAddThreadToIndex((mpForm->chkTrimDatLogFile)->checkState());
	mpDB->setAddToBbsTable((mpForm->chkModifyBbsTable)->checkState());
    mpDB->setDisableGetPart((mpForm->chkGetAgainAll)->checkState());
    mpDB->setRemoveErrorMessage((mpForm->chkRemoveErrorThread)->checkState());
    mpDB->setBackupErrorLog((mpForm->chkErrLogBackup)->checkState());
    mpDB->setCopySubjectTxt((mpForm->chkCopySubjectTxt)->checkState());

    mpDB->setOtherBrowserDirectory((mpForm->lineEdit_2chLogDirectory)->text());

    int otherBrowserType = OTHERBROWSER_PGIKO;
    if (((mpForm->gikoNavitype)->isChecked()) == true)
    {
        otherBrowserType = OTHERBROWSER_GIKONAVI;
    }
    if (((mpForm->Abonetype)->isChecked()) == true)
    {
        otherBrowserType = OTHERBROWSER_ABONE;
    }
    if (((mpForm->hotZonu2type)->isChecked()) == true)
    {
        otherBrowserType = OTHERBROWSER_HZN2;
    }
    if (((mpForm->V2Ctype)->isChecked()) == true)
    {
        otherBrowserType = OTHERBROWSER_V2C;
    }
    if (((mpForm->janeType)->isChecked()) == true)
    {
        otherBrowserType = OTHERBROWSER_JANE;
    }
    mpDB->setOtherBrowserType(otherBrowserType);


    int syncType = SYNC_ALL;
    if (((mpForm->btnToa2B)->isChecked()) == true)
    {
        syncType = SYNC_TO_a2B;
    }
    if (((mpForm->btnToOtherBrowser)->isChecked()) == true)
    {
        syncType = SYNC_FROM_a2B;
    }
    mpDB->setSynchronizeType(syncType);

	QVariant interval = (mpForm->getInterval)->text();
	mpDB->setReceiveInterval(interval.toInt());
	return;
}

/*!
 *   O擾Jn̏
 * 
 */
void screenControl::startedUpdate()
{
    // s{^̖
    (mpForm->executeUpdate)->setEnabled(false);
    (mpForm->executeSync)->setEnabled(false);

    // ~{^̗L
    (mpForm->executeCancel)->setEnabled(true);
    (mpForm->executeCancel_2)->setEnabled(false);
}

/*!
 *   O擾Ȉ
 * 
 */
void screenControl::completedUpdate()
{
    // s{^̗L
    (mpForm->executeUpdate)->setEnabled(true);
    (mpForm->executeSync)->setEnabled(true);

    // ~{^̖
    (mpForm->executeCancel)->setEnabled(false);
    (mpForm->executeCancel_2)->setEnabled(false);

    // vOXo[̏
    mProgressBar.reset();
}

/*!
 *  AvP[VȈ
 * 
 */
void screenControl::finishApp()
{
    // p[^f[^ɓfo
    mParameterLoader.saveToFile();
    return;
}

/*!
 *  Qt̃NWbg\
 * 
 */
void screenControl::show_aboutQt(bool /* checked */)
{
    QMessageBox::aboutQt(this);
    return;
}

/*!
 *  a2BC̃NWbg\
 * 
 */
void screenControl::show_about_a2BC(bool /* checked */)
{
   QString caption = "about a2BC";
   QString message = A2BC_CREDIT + "\n" + A2BC_VERSION + " (" + A2BC_DATE + ")\n\n" + A2BC_COMMENT;

    QMessageBox::information(this, caption, message, QMessageBox::Ok);
    return;
}

/*
 *  a2BC : a2B Connectivity
 *  Copyright (C) 2006- NNsi Project
 *  (see a2BC-src.txt for detail.)
 */
