/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.validator;

import java.util.ArrayList;
import java.util.Locale;

import jp.morpho.webapp.FrameworkContext;
import jp.morpho.webapp.PluginKeys;
import jp.morpho.webapp.resource.MessageResourceManager;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.HttpSessionAttributeNames;

/**
 * @author Kenichi Fukuda
 */
public class ValidatorSequence
	extends ArrayList
	implements FieldValidator
{
	private String name = null;

	public void setFieldName(String name)
	{
		this.name = name;
	}

	public String getFieldName()
	{
		return name;
	}

	public void validate(HttpActionRequest request) throws ValidationException
	{
		boolean errorFlag = false;

		try
		{
			FrameworkContext fc = FrameworkContext.getInstance(request.getSession().getServletContext());
			MessageResourceManager mrm = (MessageResourceManager)fc.get(PluginKeys.messageResourceManager);

			for (int i = 0; i < this.size(); i++)
			{
				FieldValidatorEntry entry = (FieldValidatorEntry)this.get(i);
				FieldValidator validator = entry.getValidator();
				String messageId = entry.getMessageId();
				try
				{
					validator.validate(request);
				}
				catch (Exception e)
				{
					errorFlag = true;
					if (validator.getFieldName() != null)
					{
						String message = null;
						if (messageId != null)
						{
							Locale locale = (Locale)request.getSession().getAttribute(HttpSessionAttributeNames.locale);
							if (locale == null)
							{
								locale = request.getLocale();
							}
							message = mrm.getMessage(messageId, null, locale);
						}
						ValidationState vs = ValidationState.getInstance(request);
						vs.addInvalidField(validator.getFieldName(), message);
					}
				}
			}

			if (errorFlag)
			{
				throw new ValidationException("");
			}
		}
		catch (Exception e)
		{
			throw new ValidationException(e.getMessage());
		}

	}

}
