/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.validator;

import java.text.SimpleDateFormat;

import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.http.HttpActionRequest;

/**
 * @author Kenichi Fukuda
 */
public class DateValidator extends AbstractFieldValidator
{
	private String pattern = null;
	private java.util.Date minimum = null;
	private java.util.Date maximum = null;

	public void validate(HttpActionRequest request) throws ValidationException
	{
		if (pattern == null)
		{
			throw new ValidationException("pattern is not set");
		}

		String value = request.getParameter(this.getFieldName());

		if (!this.isValidate(value))
		{
			return;
		}
		this.validateRequired(value);

		SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);

		java.util.Date date = null;
		try
		{
			date = dateFormat.parse(value);
			if (date == null)
			{
				throw new ValidationException("value is not date");
			}
		}
		catch (Exception e)
		{
			throw new ValidationException("value is not date");
		}

		if (minimum != null)
		{
			if (minimum.compareTo(date) < 0)
			{
				throw new ValidationException("out of range");
			}
		}

		if (maximum != null)
		{
			if (maximum.compareTo(date) > 0)
			{
				throw new ValidationException("out of range");
			}
		}

		if (this.getCompareFieldName() != null)
		{
			if (this.getCompareOperator() == null)
			{
				throw new ValidationException("compare operator is not set");
			}
			else
			{
				ConversionMap form = ConversionMap.valueOf(request.getParameterMap());
				java.util.Date compareValue = form.parseDate(this.getCompareFieldName(), pattern);
				String ope = this.getCompareOperator().trim();
				if (ope.equals(">"))
				{
					if (!(date.compareTo(compareValue) > 0))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals(">="))
				{
					if (!(date.compareTo(compareValue) >= 0))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals("=="))
				{
					if (!(date.compareTo(compareValue) == 0))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals("<="))
				{
					if (!(date.compareTo(compareValue) <= 0))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals("<"))
				{
					if (!(date.compareTo(compareValue) < 0))
					{
						throw new ValidationException("compare error");
					}
				}
				else if (ope.equals("!="))
				{
					if (!(date.compareTo(compareValue) != 0))
					{
						throw new ValidationException("compare error");
					}
				}
			}
		}

	}

	public String getPattern()
	{
		return pattern;
	}

	public void setPattern(String value)
	{
		pattern = value;
	}

	public void setMinimum(java.util.Date value) throws ValidationException
	{
		this.minimum = value;
	}

	public void setMaximum(java.util.Date value) throws ValidationException
	{
		this.maximum = value;
	}

	public java.util.Date getMaximum()
	{
		return maximum;
	}

	public java.util.Date getMinimum()
	{
		return minimum;
	}

}
