/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

import javax.servlet.jsp.JspException;

import jp.morpho.webapp.action.ActionMappingManager;

/**
 * <P>
 * {^쐬܂B
 * ActionButtonTag ɂ́AvANVƃXe[^Xݒ肷邽߂ action  status ܂B
 * ActionButtonTag ́AANVƃXe[^XtH[ɐݒ肷邽߂̃XNvg쐬Aonclick ɐݒ肵܂B
 * </P>
 * @author Kumiko Hiroi
 */
public class ActionButtonTag
	extends InputTag
{

	/**
	 * <P>
	 * ActionButtonTag 쐬܂B
	 * </P>
	 */
	public ActionButtonTag()
	{
		super();
	}

	/**
	 * <P>
	 * action Ԃ܂B
	 * </P>
	 * @return action 
	 */
	public String getAction()
	{
		return this.getAttributeMap().getString("action");
	}

	/**
	 * <P>
	 * form Ԃ܂B
	 * </P>
	 * @return form 
	 */
	public String getForm()
	{
		return this.getAttributeMap().getString("form");
	}

	/**
	 * <P>
	 * status Ԃ܂B
	 * </P>
	 * @return status 
	 */
	public String getStatus()
	{
		return this.getAttributeMap().getString("status");
	}

	/**
	 * <P>
	 * action ݒ肵܂B
	 * </P>
	 * @param action action 
	 */
	public void setAction(String action)
	{
		this.getAttributeMap().putString("action", action);
	}

	/**
	 * <P>
	 * form ݒ肵܂B
	 * </P>
	 * @param form form 
	 */
	public void setForm(String form)
	{
		this.getAttributeMap().putString("form", form);
	}

	/**
	 * <P>
	 * status ݒ肵܂B
	 * </P>
	 * @param status status 
	 */
	public void setStatus(String status)
	{
		this.getAttributeMap().putString("status", status);
	}

	/**
	 * <P>
	 * ̃^Õ^CvԂ܂B
	 * </P>
	 * @return ̃^Õ^Cv
	 * @see jp.morpho.webapp.servlet.jsp.tagext.TagTemplate#getTagType()
	 */
	public String getTagType()
	{
		return "jp.morpho.webapp.servlet.jsp.tagext.html.ActionButtonTag";
	}

	/**
	 * <P>
	 * Jn^ȌłB
	 * </P>
	 * @return EVAL_BODY_BUFFERED
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException
	{
		this.setType("button");
		if (!this.getAttributeMap().containsKey("form"))
		{
			throw new JspException("form attribute is not found.");
		}
		if (!this.getAttributeMap().containsKey("action"))
		{
			throw new JspException("action attribute is not found.");
		}

		ActionMappingManager amm = getActionMappingManager();
		StringBuffer buf = new StringBuffer();
		String formName = this.getForm();

		//action
		buf.append("document.").append(formName).append(".").append(amm.getActionParameterName())
			.append(".value='").append(this.getAction()).append("';");

		//status
		if (this.getAttributeMap().containsKey("status"))
		{
			buf.append("document.").append(formName).append(".").append(amm.getStatusParameterName())
				.append(".value='").append(this.getStatus()).append("';");
		}

		buf.append("document.").append(formName).append(".submit();");

		this.setOnclick(buf.toString());

		this.getAttributeMap().remove("action");
		this.getAttributeMap().remove("status");
		this.getAttributeMap().remove("form");

		return super.doStartTag();
	}

}
