/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;

import javax.servlet.ServletContext;

import jp.morpho.config.Configuration;
import jp.morpho.lang.LifeCycle;
import jp.morpho.lang.LifeCycleException;
import jp.morpho.webapp.impl.PluginContextImpl;

/**
 * <P>
 * FrameworkContext NX̓vOCi[܂B
 * vOC  add \bhgp FrameworkContext Ɋi[ł܂B
 * </P>
 * <P>
 * Web AvP[VPʂŌꍇAuT[ubgReLXgv 1 ɁA1  FrameworkContext Ή܂B
 * </P>
 * @author Kenichi Fukuda
 */
public class FrameworkContext
	extends Vector
	implements LifeCycle, Serializable
{

	/** K[ */
	private Logger log = Logger.getLogger("jp.morpho");

	/** T[ubgReLXgɃoCh鑮̖O */
	private static final String ATTRIBUTE = "jp.morpho.webapp.FrameworkContext";

	/** t[[N̔zLqq̃\[XpX */
	private static final String CONFIG_PATH = "/WEB-INF/morpho-config.xml";

	/** vOC̃}bv */
	private HashMap map = new HashMap();

	/** FrameworkContext X^[gĂꍇ true */
	private boolean running = false;

	/**
	 * <P>
	 * FrameworkContext 쐬܂B
	 * </P>
	 */
	protected FrameworkContext()
	{
		super();
	}

	/**
	 * <P>
	 * FrameworkContext 쐬܂͎擾܂B
	 * ł FrameworkContext 쐬Ăꍇ́AꂪԂ܂B
	 * łȂꍇ́AV FrameworkContext 쐬܂B
	 * </P>
	 * <P>
	 * V FrameworkContext 쐬ꍇÃt[[NRtBO̓T[ubgReLXg̑ jp.morpho.webapp.FrameworkContext ɃoCh܂B
	 * łɃT[ubgReLXg̑ jp.morpho.webapp.FrameworkContext  FrameworkContext oChĂꍇ́AꂪԂ܂B
	 * </P>
	 * @param sc  FrameworkContext i[T[ubgReLXg
	 * @return FrameworkContext IuWFNg
	 */
	public static synchronized FrameworkContext getInstance(ServletContext sc) throws FrameworkException
	{
		try
		{
			//T[ubgReLXg FrameworkContext 擾܂
			FrameworkContext fc =
				(FrameworkContext)sc.getAttribute(ATTRIBUTE);

			//܂ FrameworkContext 쐬ĂȂꍇ́A
			//V FrameworkContext 쐬܂B
			if (fc == null)
			{
				//FrameworkContext 쐬܂
				fc = new FrameworkContext();

				//t[[N̔zLqq URL 擾܂
				URL configURL = sc.getResource(CONFIG_PATH);

				//t[[Nݒ肵܂
				InputStream in = configURL.openStream();
				Configuration config = new Configuration();
				config.configure(fc, in);
				in.close();

				//T[ubgReLXgփoCh܂
				sc.setAttribute(ATTRIBUTE, fc);
			}

			return fc;
		}
		catch (Exception e)
		{
			throw new FrameworkException(e);
		}
	}

	/**
	 * <P>
	 * w肳ꂽIuWFNgvOCł邩ǂ𔻒肵܂B
	 * w肳ꂽIuWFNg jp.morpho.webapp.Plugin Ă邩ǂ𒲂ׂ܂B
	 * </P>
	 * @param obj vOCł邩ǂ𒲂ׂIuWFNg
	 * @exception IllegalArgumentException w肳ꂽIuWFNgvOCłȂꍇ
	 */
	private synchronized void checkInstance(Object obj)
	{
		if (!(obj instanceof Plugin))
		{
			throw new IllegalArgumentException("Object is not a Plugin: " + obj);
		}
	}

	/**
	 * <P>
	 * łɃvOCǉĂ邩ǂ𔻒肵܂B
	 * vOC̃}bvw̃L[̃}bsOێꍇ O IllegalArgumentException X[܂B
	 * </P>
	 * @param key }bvɂ邩ǂ肳L[
	 * @exception IllegalArgumentException vOC̃}bvw̃L[̃}bsOێĂꍇ
	 */
	private synchronized void checkMapping(String key)
	{
		if (map.containsKey(key))
		{
			throw new IllegalArgumentException("Plugin Key already exists: " + key);
		}
	}

	/**
	 * <P>
	 * FrameworkContext ̎w肳ꂽʒuɎw̃vOC}܂B
	 * ̈ʒuƂȍ~ɃvOC΂EɈړAevOC̃CfbNX 1 ܂B
	 * </P>
	 * @param index w̃vOC}CfbNX
	 * @param element }vOC
	 * @exception IndexOutOfBoundsException CfbNX͈͊Ȍꍇ (index < 0 || index > size())
	 * @exception IllegalArgumentException w肳ꂽIuWFNgvOCłȂꍇA܂͓ÕvOC FrameworkContext ɂꍇ
	 * @see java.util.List#add(int, Object)
	 */
	public synchronized void add(int index, Object element)
	{
		checkInstance(element);

		String key = ((Plugin)element).getPluginKey();
		checkMapping(key);

		map.put(key, element);
		super.add(index, element);
	}

	/**
	 * <P>
	 * FrameworkContext ̖Ɏw̃vOCǉ܂B
	 * </P>
	 * @param element FrameworkContext ɒǉvOC
	 * @return true (Collection.add ̔ėpKǂ)
	 * @exception IllegalArgumentException w肳ꂽIuWFNgvOCłȂꍇA܂͓ÕvOC FrameworkContext ɂꍇ
	 * @see java.util.Collection#add(Object)
	 */
	public synchronized boolean add(Object element)
	{
		checkInstance(element);

		String key = ((Plugin)element).getPluginKey();
		checkMapping(key);

		map.put(key, element);
		try
		{
			PluginContextImpl ctx = new PluginContextImpl();
			ctx.setFrameworkContext(this);
			((Plugin)element).setPluginContext(ctx);
		}
		catch (PluginException e)
		{
			log.warning(e.getMessage());
		}
		return super.add(element);
	}

	/**
	 * <P>
	 * w肳ꂽ Collection ׂ̂ẴvOC FrameworkContext ̖ɁA Collection  Iterator ɂĕԂ鏇Œǉ܂B
	 * ̃Iy[V̓́Aw肳ꂽ Collection Iy[V̐isɕύXƒ`܂B
	 * ́A Collection  FrameworkContext łꍇɂ̌Ăяo̓삪`ꂸAFrameworkContext łȂƂ܂B
	 * </P>
	 * @param c FrameworkContext ɑ}vOC
	 * @return ̌ĂяǒʁA FrameworkContext ύXꂽꍇ true
	 * @exception IndexOutOfBoundsException CfbNX͈͊Ȍꍇ (index < 0 || index > size())
	 * @exception NullPointerException w肳ꂽRNV null łꍇ
	 * @exception IllegalArgumentException w肳ꂽRNV̗vfvOCłȂꍇA܂͓ÕvOC FrameworkContext ɂꍇ
	 * @see java.util.Collection#addAll(Collection)
	 */
	public synchronized boolean addAll(Collection c)
	{
		for (Iterator i = c.iterator(); i.hasNext();)
		{
			Object o = i.next();
			checkInstance(o);

			String key = ((Plugin)o).getPluginKey();
			checkMapping(key);

			map.put(key, o);
		}

		return super.addAll(c);
	}

	/**
	 * <P>
	 * w肳ꂽ Collection ׂ̂ẴvOCAFrameworkContext ̎w肳ꂽʒuɑ}܂B
	 * ̈ʒuƂȍ~ɃvOCꍇ́AEɈړāAevOC̃CfbNX 1 ܂B
	 * VevOĆAw肳ꂽ Collection ̔qɂĕԂ鏇 FrameworkContext Ɋi[܂B
	 * </P>
	 * @param index w肳ꂽRNVŏ̃vOC}ʒũCfbNX
	 * @param c FrameworkContext ɑ}vOC
	 * @return ̌ĂяǒʁA FrameworkContext ύXꂽꍇ true
	 * @exception IndexOutOfBoundsException CfbNX͈͊Ȍꍇ (index < 0 || index > size())
	 * @exception NullPointerException w肳ꂽRNV null łꍇ
	 * @exception IllegalArgumentException w肳ꂽRNV̗vfvOCłȂꍇA܂͓ÕvOC FrameworkContext ɂꍇ
	 * @see java.util.List#addAll(int, Collection)
	 */
	public synchronized boolean addAll(int index, Collection c)
	{
		for (Iterator i = c.iterator(); i.hasNext();)
		{
			Object o = i.next();
			checkInstance(o);

			String key = ((Plugin)o).getPluginKey();
			checkMapping(key);

			map.put(key, o);
		}

		return super.addAll(index, c);
	}

	/**
	 * <P>
	 * w̃vOC FrameworkContext ̍ŌɒǉATCY 1 ₵܂B
	 * TCY FrameworkContext ̗eʂ傫ȂƂ͗eʂ₳܂B
	 * </P>
	 * <P>
	 * ̃\bh͋@\I add(Object) \bhƓłB́AList C^tF[ẌꕔłB
	 * </P>
	 * @param element ǉvOC
	 * @exception IllegalArgumentException w肳ꂽIuWFNgvOCłȂꍇA܂͓ÕvOC FrameworkContext ɂꍇ
	 * @see jp.morpho.webapp.FrameworkContext#add(Object)
	 */
	public synchronized void addElement(Object element)
	{
		checkInstance(element);

		String key = ((Plugin)element).getPluginKey();
		checkMapping(key);

		map.put(key, element);
		super.addElement(element);
	}

	/**
	 * <P>
	 * FrameworkContext ̎w肳ꂽ index ɁAw肳ꂽvOC}܂B
	 * w肳ꂽ index ɓA傫CfbNX̃vOCׂ͂ 1 ̃CfbNXɂ܂B
	 * </P>
	 * <P>
	 * CfbNX́A0 ɓA傫lłȂ΂Ȃ܂B
	 * ܂AFrameworkContext ݂̌̃TCYɓA菬lłȂ΂Ȃ܂B
	 * CfbNX FrameworkContext ݂̌̃TCYɓꍇAVvOC FrameworkContext ̖ɒǉ܂B
	 * </P>
	 * <P>
	 * ̃\bh͋@\I add(Object, int) \bhƓłB
	 * ́AList C^tF[ẌꕔłB
	 * z̎gɂK`ɂ邽߂ add \bhp[^̏tɂ邱ƂɒӂĂB
	 * </P>
	 * @param element }vOC
	 * @param index VvOC}ʒu
	 * @exception ArrayIndexOutOfBoundsException - CfbNX͈͊Ȍꍇ (index < 0 || index >= size())
	 * @exception IllegalArgumentException w肳ꂽIuWFNgvOCłȂꍇA܂͓ÕvOC FrameworkContext ɂꍇ
	 * @see java.util.Vector#insertElementAt(Object, int)
	 */
	public synchronized void insertElementAt(Object element, int index)
	{
		checkInstance(element);

		String key = ((Plugin)element).getPluginKey();
		checkMapping(key);

		map.put(key, element);
		super.insertElementAt(element, index);
	}

	/**
	 * <P>
	 * FrameworkContext ̎ẅʒuɂvOC폜܂B
	 * ȍ~ɃvOC΂ɈړAevOC̃CfbNX 1 炵܂B
	 * FrameworkContext 폜ꂽvOCԂ܂B
	 * </P>
	 * @param index 폜vOC̃CfbNX
	 * @exception ArrayIndexOutOfBoundsException - CfbNX͈͊Ȍꍇ (index < 0 || index >= size())
	 * @see java.util.List#remove(int)
	 */
	public synchronized Object remove(int index)
	{
		Object o = super.remove(index);
		if (o != null)
		{
			String key = ((Plugin)o).getPluginKey();
			map.remove(key);
		}
		return o;
	}

	/**
	 * <P>
	 * FrameworkContext ōŏɌoꂽw̃vOC폜܂B
	 * FrameworkContext vOCێĂȂꍇ́AύX܂B
	 * ܂A(element == null ? get(i) == null : element.equals(get(i))) łƂCfbNX i vOC΍폜܂B
	 * </P>
	 * @param element FrameworkContext 폜vOC (̃vOCꍇ)
	 * @return w肳ꂽvOC FrameworkContext ɂꍇ true
	 * @see java.util.Collection#remove(Object)
	 */
	public synchronized boolean remove(Object element)
	{
		boolean ret = super.remove(element);
		if (ret)
		{
			String key = ((Plugin)element).getPluginKey();
			map.remove(key);
		}

		return ret;
	}

	/**
	 * <P>
	 * FrameworkContext Aw肳ꂽ Collection ɕێĂ邷ׂẴvOC폜܂B
	 * </P>
	 * @param c FrameworkContext 폜vOC̃RNV
	 * @return FrameworkContext ĂяǒʂƂĕύXꂽꍇ true
	 * @exception NullPointerException w肳ꂽRNV null łꍇ
	 * @see java.util.Collection#removeAll(Collection)
	 */
	public synchronized boolean removeAll(Collection c)
	{
		boolean retAll = false;
		for (Iterator i = c.iterator(); i.hasNext();)
		{
			Object o = i.next();
			boolean ret = this.remove(o);
			retAll = (ret) ? ret : retAll;
		}
		return retAll;
	}

	/**
	 * <P>
	 * FrameworkContext 炷ׂẴvOC폜ATCY 0 ɐݒ肵܂B
	 * </P>
	 * <P>
	 * ̃\bh͋@\I clear \bhƓłB
	 * ́AList C^tF[ẌꕔłB
	 * </P>
	 * @see java.util.Vector#removeAllElements()
	 */
	public synchronized void removeAllElements()
	{
		map.clear();
		super.removeAllElements();
	}

	/**
	 * <P>
	 * ŏɌoꂽ (ŏCfbNX) ̃vOC FrameworkContext 폜܂B
	 * vOCoƁÃvOC̃CfbNXƓ傫CfbNX̃vOCׂ͂ 1 ÕCfbNXɋl߂܂B
	 * </P>
	 * <P>
	 * ̃\bh͋@\I remove(Object) \bhƓłB
	 * ́AList C^tF[ẌꕔłB
	 * </P>
	 * @param element 폜vOC
	 * @return  FrameworkContext ̃vOCłꍇ trueAłȂꍇ false
	 * @see java.util.Vector#removeElement(Object)
	 */
	public synchronized boolean removeElement(Object element)
	{
		boolean ret = super.removeElement(element);
		if (ret)
		{
			String key = ((Plugin)element).getPluginKey();
			map.remove(key);
		}

		return ret;
	}

	/**
	 * <P>
	 * w肳ꂽCfbNX̃vOC폜܂B
	 * w肳ꂽ index ɓA傫CfbNX̃vOĆAׂ 1 ÕCfbNXɋl߂܂B
	 * FrameworkContext ̃TCY 1 炳܂B
	 * </P>
	 * <P>
	 * CfbNX́A0 ɓA傫lłȂ΂Ȃ܂B
	 * ܂AFrameworkContext ݂̌̃TCY菬lłȂ΂Ȃ܂B
	 * </P>
	 * <P>
	 * ̃\bh͋@\I remove \bhƓłB
	 * ́AList C^tF[ẌꕔłB
	 * remove \bhẅʒuɊi[ĂÂlԂƂɒӂĂB
	 * </P>
	 * @param index 폜vOC̃CfbNX
	 * @exception ArrayIndexOutOfBoundsException - CfbNX͈͊Ȍꍇ (index < 0 || index >= size())
	 * @see java.util.Vector#removeElementAt(int)
	 */
	public synchronized void removeElementAt(int index)
	{
		String key = ((Plugin)get(index)).getPluginKey();
		map.remove(key);
		super.removeElementAt(index);
	}

	/**
	 * <P>
	 * w肳ꂽ Collection ɕێĂAFrameworkContext ̃vOCێ܂B
	 * ܂AFrameworkContext Aw肳ꂽ Collection ɕێĂȂׂẴvOC폜܂B
	 * </P>
	 * @param c FrameworkContext ɕێĂvOC̃RNV (قׂ̂ẴvOC͍폜)
	 * @return FrameworkContext ĂяǒʂƂĕύXꂽꍇ true
	 * @exception NullPointerException w肳ꂽRNV null łꍇ
	 * @see java.util.Collection#retainAll(Collection)
	 */
	public synchronized boolean retainAll(Collection c)
	{
		boolean ret = super.retainAll(c);
		Object[] keys = map.keySet().toArray();
		for (int i = 0; i < keys.length; i++)
		{
			String key = (String)keys[i];
			if (!(this.contains(map.get(key))))
			{
				map.remove(key);
			}
		}

		return ret;
	}

	/**
	 * <P>
	 * FrameworkContext ̎w肳ꂽʒuɂvOCAw̃vOCŒu܂B
	 * </P>
	 * @param index uvOC̃CfbNX
	 * @param element w肳ꂽʒuɊi[vOC
	 * @return w肳ꂽʒuɈȑOvOC
	 * @exception ArrayIndexOutOfBoundsException CfbNX͈͊Ȍꍇ (index < 0 || index >= size())
	 * @exception IllegalArgumentException w肳ꂽIuWFNgvOCłȂꍇA܂͓ÕvOC FrameworkContext ɂꍇ
	 * @see java.util.List#set(int, Object)
	 */
	public synchronized Object set(int index, Object element)
	{
		checkInstance(element);

		String key = ((Plugin)get(index)).getPluginKey();
		map.remove(key);

		key = ((Plugin)element).getPluginKey();
		map.put(key, element);
		return super.set(index, element);
	}

	/**
	 * <P>
	 * FrameworkContext ̎w肳ꂽ index ̃vOCɁAw肳ꂽvOCݒ肵܂B
	 * ̃CfbNXɂvOC͔j܂B
	 * </P>
	 * <P>
	 * CfbNX́A0 ɓA傫lłȂ΂Ȃ܂B
	 * ܂AFrameworkContext ݂̌̃TCY菬lłȂ΂Ȃ܂B
	 * </P>
	 * <P>
	 * ̃\bh͋@\I set \bhƓłB
	 * ́AList C^tF[ẌꕔłB
	 * z̎gɂ߂Â邽߂ɁAset \bhp[^̏tɂ邱ƂɒӂĂB
	 * ܂Aset \bhẅʒuɊi[ĂÂlԂƂɂӂĂB
	 * </P>
	 * @param element vOCɐݒ肳IuWFNg
	 * @param index CfbNX
	 * @exception ArrayIndexOutOfBoundsException CfbNX͈͊Ȍꍇ (index < 0 || index >= size())
	 * @exception IllegalArgumentException w肳ꂽIuWFNgvOCłȂꍇA܂͓ÕvOC FrameworkContext ɂꍇ
	 * @see java.util.Vector#setElementAt(Object, int)
	 */
	public synchronized void setElementAt(Object element, int index)
	{
		checkInstance(element);

		String key = ((Plugin)get(index)).getPluginKey();
		map.remove(key);

		key = ((Plugin)element).getPluginKey();
		map.put(key, element);
		super.setElementAt(element, index);
	}

	/**
	 * <P>
	 * w肳ꂽL[̃vOCԂ܂B
	 * FrameworkContext ̃L[̃vOCێĂȂꍇ null Ԃ܂B
	 * </P>
	 * @param key vOC̃L[
	 * @return w肳ꂽL[̃vOCBw肳ꂽL[̃vOCȂꍇ null
	 */
	public Object get(String key)
	{
		return map.get(key);
	}

	/**
	 * <P>
	 * ׂẴvOC FrameworkContext 폜܂B
	 * ̌ĂяoԂƁAꂪOX[ȂAFrameworkContext ͋ɂȂ܂B
	 * </P>
	 * @see java.util.Collection#clear()
	 */
	public synchronized void clear()
	{
		map.clear();
		super.clear();
	}

	/**
	 * <P>
	 * FrameworkContext X^[gĂꍇ true Ԃ܂B
	 * </P>
	 * @return FrameworkContext X^[gĂꍇ true
	 * @see jp.morpho.lang.LifeCycle#isRunning()
	 */
	public synchronized boolean isRunning()
	{
		return running;
	}

	/**
	 * <P>
	 * FrameworkContext X^[g܂B
	 * </P>
	 * @exception LifeCycleException FrameworkContext ̃X^[gɖ肪Nꍇ
	 * @see jp.morpho.lang.LifeCycle#start()
	 */
	public synchronized void start() throws LifeCycleException
	{
		if (isRunning())
		{
			throw new LifeCycleException("Already started");
		}
		running = true;

		Plugin[] plugins = new Plugin[this.size()];
		plugins = (Plugin[])this.toArray(plugins);
		for (int i = 0; i < plugins.length; i++)
		{
			try
			{
				plugins[i].pluginActivate();
			}
			catch (PluginException e)
			{
				//s
			}
		}
	}

	/**
	 * <P>
	 * FrameworkContext Xgbv܂B
	 * </P>
	 * @exception LifeCycleException FrameworkContext ̃Xgbvɖ肪Nꍇ
	 * @see jp.morpho.lang.LifeCycle#stop()
	 */
	public synchronized void stop() throws LifeCycleException
	{
		running = false;
		Plugin[] plugins = new Plugin[this.size()];
		plugins = (Plugin[])this.toArray(plugins);
		while (this.size() > 0)
		{
			try
			{
				plugins[this.size() - 1].pluginRemove();
			}
			catch (PluginException e)
			{
				//s
			}
			this.remove(this.size() - 1);
		}
	}

}
