/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import org.xml.sax.Attributes;

/**
 * <P>
 * em[h̒ۃNXłB
 * m[hƂ́AzLqqɋLq^OłB
 * </P>
 * <P>
 * ̃NX́A`͈قȂ邪vȋ@\͋ʂłÃm[h̒ۉłB
 * Ƃ set  get ȂǊẽm[hłAm[h̃c[\Åi[@Ȃǂ͋ʂ܂B
 * </P>
 * <P>
 * Node NX̃TuNXɂ́AꂼقȂނ̏̃Zbgi[AIuWFNǧ`@قȂ܂B
 * ̃m[hׂ͂āANode NX̃TuNXɂĎł܂B
 * </P>
 * @author Kumiko Hiroi
 */
public abstract class Node
	extends Vector
{
	private Node parent = null;
	private Map attributes = null;

	/**
	 * <P>
	 * em[hƃm[h̑w肵 Node IuWFNg쐬܂B
	 * </P>
	 * @param parent ̃m[h̐em[h
	 * @param attributes ̃m[h̑
	 */
	public Node(Node parent, Attributes attributes)
	{
		super();

		this.parent = parent;
		if (attributes != null)
		{
			this.attributes = new HashMap();
			for (int i = 0; i < attributes.getLength(); i++)
			{
				String key = attributes.getLocalName(i);
				if (key == null || key.equals(""))
				{
					key = attributes.getQName(i);
				}
				this.attributes.put(key, attributes.getValue(i));
			}
		}
	}

	/**
	 * <P>
	 * ̃m[ĥׂĂ̑}bvꂽ ConversionMap IuWFNg擾܂B
	 * </P>
	 * @return ׂĂ̑}bvꂽ ConversionMap IuWFNg
	 */
	public Map getAttributes()
	{
		return attributes;
	}

	/**
	 * <P>
	 * w肳ꂽȎ̒l擾܂B
	 * </P>
	 * @return ̒l
	 */
	public String getAttribute(String name)
	{
		return (String)attributes.get(name);
	}

	/**
	 * <P>
	 * ̃m[h̐em[h擾܂B
	 * </P>
	 * @return em[h
	 */
	public Node getParent()
	{
		return parent;
	}

	/**
	 * <P>
	 * ̃m[h class Ɏw肳ꂽNX擾܂B
	 * </P>
	 * @return class Ɏw肳ꂽNX
	 * @exception ClassNotFoundException NXȂꍇ
	 */
	protected Class getNodeClass() throws ClassNotFoundException
	{
		String className = getAttribute("class");
		if (className == null)
		{
			return null;
		}

		return Thread.currentThread().getContextClassLoader().loadClass(className);
	}

	/**
	 * <P>
	 * ̃m[h name Ɏw肳ꂽO擾܂B
	 * O 1 ڂ啶ɕϊ܂B
	 * </P>
	 * @return name Ɏw肳ꂽO
	 */
	protected String getNodeName()
	{
		String name = getAttribute("name");
		if (name == null || name.length() == 0)
		{
			return "";
		}
		else if (name.length() == 1)
		{
			return name.toUpperCase();
		}
		else
		{
			return name.substring(0, 1).toUpperCase() + name.substring(1);
		}
	}

	/**
	 * <P>
	 * w肳ꂽIuWFNg\l擾܂B
	 * IuWFNg Node IuWFNg̏ꍇ́A Node IuWFNg\l擾܂B
	 * </P>
	 * @param obj l擾IuWFNg
	 * @return IuWFNg\l
	 */
	protected Object getValue(Object obj) throws ConfigureException
	{
		try
		{
			if (size() == 0)
			{
				return null;
			}

			int first = 0;
			int last = size() - 1;

			Object item = null;
			while (first <= last)
			{
				item = get(first);
				if (!(item instanceof String))
				{
					break;
				}
				item = ((String) item).trim();
				if (((String) item).length() > 0)
				{
					break;
				}
				first++;
			}

			while (first < last)
			{
				item = get(last);
				if (!(item instanceof String))
				{
					break;
				}
				item = ((String) item).trim();
				if (((String) item).length() > 0)
				{
					break;
				}
				last--;
			}

			if (first > last)
			{
				return null;
			}

			Object value = null;

			if (first == last)
			{
				value = getItemValue(obj, get(first));
			}
			else
			{
				StringBuffer buf = new StringBuffer();
				synchronized (buf)
				{
					for (int i = first; i <= last; i++)
					{
						Object o = get(i);
						buf.append(getItemValue(obj, o));
					}
					value = buf.toString();
				}
			}

			if (value != null && value instanceof String)
			{
				return ((String) value).trim();
			}
			return value;
		}
		catch (Exception e)
		{
			throw new ConfigureException(e);
		}
	}

	/**
	 * <P>
	 * IuWFNg item \l擾܂B
	 * item  Node IuWFNg̏ꍇ́Aitem.configure(obj) ĂяoČ`ꂽIuWFNgԂ܂B
	 * </P>
	 * @param obj item  Node IuWFNg̏ꍇɌ`IuWFNg
	 * @return item \l
	 */
	protected Object getItemValue(Object obj, Object item) throws ConfigureException
	{
		try
		{
			if (item instanceof String)
			{
				return item;
			}

			Node node = (Node) item;
			return node.configure(obj);
		}
		catch (Exception e)
		{
			throw new ConfigureException(e);
		}
	}

	/**
	 * <P>
	 * ̃\bh͒ۃ\bĥ߉܂B
	 * ̃\bh́Ag̃m[h̃^OlԂ߂ɁATuNXɂĎ܂B
	 * </P>
	 * @return ^Ol
	 */
	public abstract int getTag();

	/**
	 * <P>
	 * ̃\bh͒ۃ\bĥ߉܂B
	 * ̃\bh́Aw肳ꂽIuWFNg`邽߂ɁATuNXɂĎ܂B
	 * </P>
	 * @param obj `IuWFNg
	 * @return ̃\bhŒlԂ邱Ƃ͂܂
	 * @exception ConfigureException IuWFNg`łȂꍇ
	 */
	public abstract Object configure(Object obj) throws ConfigureException;

	/**
	 * <P>
	 * w肳ꂽIuWFNg`܂B
	 * </P>
	 * @param obj `IuWFNg
	 * @param index ̃m[hɊi[ꂽqm[h̃Xg̃CfbNX
	 * @exception ConfigureException IuWFNg`łȂꍇ
	 */
	public void configure(Object obj, int index) throws ConfigureException
	{
		try
		{
			for (int i = index; i < size(); i++)
			{
				Object o = get(i);
				if (o instanceof String)
				{
					continue;
				}
				Node node = (Node) o;
				node.configure(obj);
			}
		}
		catch (Exception e)
		{
			throw new ConfigureException(e);
		}
	}

}
