/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.config;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

import org.xml.sax.Attributes;

/**
 * <P>
 * CallNode NX́Acall ^O\܂B
 * call ^Oɂ́Aarg Aget Aset Aput Acall  new ^O܂߂邱Ƃł܂B
 * </P>
 * <P>
 * Ⴆ call ^ÓÂ悤ɔzLqqɋLq܂B
 * </P>
 * <P>
 * <PRE>
 *     &lt;call name="someMethod"&gt;&lt;arg&gt;someValue&lt;/arg&gt;&lt;/call&gt;
 * </PRE>
 * </P>
 * <P>
 * ́Â悤ȃR[hƂƓłB
 * </P>
 * <P>
 * <PRE>
 *     someObject.someMethod("someValue");
 * </PRE>
 * </P>
 * @author Kumiko Hiroi
 */
public class CallNode extends Node
{

	/**
	 * <P>
	 * em[hƃm[h̑w肵 CallNode IuWFNg쐬܂B
	 * </P>
	 * @param parent ̃m[h̐em[h
	 * @param attributes ̃m[h̑
	 */
	public CallNode(Node parent, Attributes attributes)
	{
		super(parent, attributes);
	}

	/**
	 * <P>
	 * ^OlԂ܂B
	 * </P>
	 * @return ^Ol
	 * @see jp.morpho.config.Node#getTag()
	 */
	public int getTag()
	{
		return NodeTypes.CALL;
	}

	/**
	 * <P>
	 * w肳ꂽIuWFNg`܂B
	 * NX̐ɂ悤ɁAIuWFNg obj ̃\bhĂяo܂B
	 * </P>
	 * @param obj `IuWFNg
	 * @return `ꂽIuWFNg
	 * @exception ConfigureException IuWFNg`łȂꍇ
	 * @see jp.morpho.config.Node#configure(Object)
	 */
	public Object configure(Object obj) throws ConfigureException
	{
		try
		{
			Class objCls = getNodeClass();
			if (objCls != null)
			{
				obj = null;
			}
			else
			{
				objCls = obj.getClass();
			}

			int argLength = 0;
			int nextIndex = size();
			for (int i = 0; i < size(); i++)
			{
				Object o = get(i);
				if (o instanceof String)
				{
					continue;
				}
				if (((Node) o).getTag() != NodeTypes.ARG)
				{
					nextIndex = i;
					break;
				}
				argLength++;
			}

			Object[] arg = new Object[argLength];
			for (int i = 0, j = 0; j < argLength; i++)
			{
				Object o = get(i);
				if (o instanceof String)
				{
					continue;
				}
				arg[j++] = ((Node) o).getValue(obj);
			}

			String methodName = getAttribute("name");

			Method[] methods = objCls.getMethods();
			for (int c = 0; methods != null && c < methods.length; c++)
			{
				if (!methods[c].getName().equals(methodName))
				{
					continue;
				}
				if (methods[c].getParameterTypes().length != argLength)
				{
					continue;
				}
				if (Modifier.isStatic(methods[c].getModifiers()) != (obj == null))
				{
					continue;
				}
				if ((obj == null) && methods[c].getDeclaringClass() != objCls)
				{
					continue;
				}

				Object newObj = null;
				boolean succeeded = false;
				try
				{
					newObj = methods[c].invoke(obj, arg);
					succeeded = true;
				}
				catch (IllegalAccessException e)
				{
				}
				catch (IllegalArgumentException e)
				{
				}

				if (succeeded)
				{
					configure(newObj, nextIndex);
					return newObj;
				}
			}

			throw new IllegalStateException("No Method: " + getAttribute("class") + " on " + objCls + "." + methodName);
		}
		catch (Exception e)
		{
			throw new ConfigureException(e);
		}
	}

}
