/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.AbstractFieldValidator;
import jp.morpho.webapp.validator.ValidationException;

public class DoubleValidator
extends AbstractFieldValidator {
    private Double minimum = null;
    private Double maximum = null;

    public void validate(HttpActionRequest request) throws ValidationException {
        String value = request.getParameter(this.getFieldName());
        if (!this.isValidate(value)) {
            return;
        }
        this.validateRequired(value);
        double number = 0.0;
        try {
            number = Double.parseDouble(value);
        }
        catch (Exception e) {
            throw new ValidationException("value is not double");
        }
        if (this.minimum != null && this.minimum > number) {
            throw new ValidationException("out of range");
        }
        if (this.maximum != null && this.maximum < number) {
            throw new ValidationException("out of range");
        }
        if (this.getCompareFieldName() != null) {
            if (this.getCompareOperator() == null) {
                throw new ValidationException("compare operator is not set");
            }
            ConversionMap form = ConversionMap.valueOf(request.getParameterMap());
            double compareValue = form.getDouble(this.getCompareFieldName());
            String ope = this.getCompareOperator().trim();
            if (ope.equals(">")) {
                if (!(number > compareValue)) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals(">=")) {
                if (!(number >= compareValue)) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("==")) {
                if (number != compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<=")) {
                if (!(number <= compareValue)) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<")) {
                if (!(number < compareValue)) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("!=")) {
                if (number == compareValue) {
                    throw new ValidationException("compare error");
                }
            } else {
                throw new ValidationException("compare operator is not supported:" + ope);
            }
        }
    }

    public void setMinimum(double value) throws ValidationException {
        this.minimum = new Double(value);
    }

    public void setMaximum(double value) throws ValidationException {
        this.maximum = new Double(value);
    }

    public double getMaximum() {
        return this.maximum != null ? this.maximum : 0.0;
    }

    public double getMinimum() {
        return this.minimum != null ? this.minimum : 0.0;
    }
}

