<?php
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------+
// | PHP Version 5                                                        |
// +----------------------------------------------------------------------+
// | Copyright (c) 2010 Takahiro Ooishi                                   |
// +----------------------------------------------------------------------+
// | This source file is subject to version 3.0 of the PHP license,       |
// | that is bundled with this package in the file LICENSE, and is        |
// | available through the world-wide-web at the following url:           |
// | http://www.php.net/license/3_0.txt.                                  |
// | If you did not receive a copy of the PHP license and are unable to   |
// | obtain it through the world-wide-web, please send a note to          |
// | license@php.net so we can mail you a copy immediately.               |
// +----------------------------------------------------------------------+
// | Author: Takahiro Ooishi <taka0125.biz@gmail.com>                     |
// +----------------------------------------------------------------------+
//
// $Id$

abstract class Http_AgentTemplate
{
    protected $error;

    protected $options;
    protected $timeout;

    const DefaultTimeout = 300;

    abstract function send($url, $request);
    abstract protected function open();
    abstract protected function close();
    abstract protected function setOptions($options);
    abstract function setOption($name, $option);
    abstract function setBasicAuthenticationAccount($user, $password);    
 
    function __construct($options = array(), $timeout = self::DefaultTimeout)
    {
        $this->setOptions($options);
        $this->setTimeout($timeout);
        $this->open();
        $this->error = new Http_Error();
    }

    function __destruct()
    {
        $this->close();
    }

    function options()
    {
        return $this->options;
    }

    function setTimeout($timeout)
    {
        if (!is_numeric($timeout)) throw new ValidationException($timeout, 'Invalid Timeout.');
        $timeout = intval($timeout);
        if ($timeout < 1) throw new ValidationException($timeout, 'Invalid Timeout.');
        $this->timeout = $timeout;
    }

    function isError()
    {
        return $this->error->isError();
    }

    function getError()
    {
        return $this->error->get();
    }

    protected function clearError()
    {
        return $this->error->clear();
    }
}
