
package com.clustercontrol.ws.xcloud;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>platformのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * <p>
 * <pre>
 * &lt;simpleType name="platform">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="windows"/>
 *     &lt;enumeration value="linux"/>
 *     &lt;enumeration value="other"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "platform")
@XmlEnum
public enum Platform {

    @XmlEnumValue("windows")
    WINDOWS("windows"),
    @XmlEnumValue("linux")
    LINUX("linux"),
    @XmlEnumValue("other")
    OTHER("other");
    private final String value;

    Platform(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static Platform fromValue(String v) {
        for (Platform c: Platform.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
