package com.clustercontrol.xcloud.ui.handlers;

import java.text.MessageFormat;
import java.util.Arrays;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.xcloud.extensions.CloudOptionExtension;
import com.clustercontrol.xcloud.model.cloud.ICloudScope;
import com.clustercontrol.xcloud.model.cloud.IInstance;

public class RebootInstanceJobHandler extends AbstaractCloudOptionJobHandler {
	protected IInstance instance;
	
	@Override
	protected void setup(ExecutionEvent event) {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		instance = (IInstance)selection.getFirstElement();
	}

	@Override
	protected ICloudScope getCloudScope() {
		return instance.getCloudScope();
	}

	@Override
	protected String getCommand(CloudEndpoint endpoint) throws Exception {
		return endpoint.makeRebootInstancesCommand(instance.getCloudScope().getId(), instance.getLocation().getId(), Arrays.asList(instance.getId()));
	}

	@Override
	protected String getJobName() {
		return getJobId();
	}

	@Override
	protected String getJobId() {
		return String.format("%s_%s_%s_i-reboot", instance.getCloudScope().getId(), instance.getLocation().getId(), instance.getId());
	}
	
	@Override
	protected String getMethodName() {
		return "makeRebootInstancesCommand";
	}

	@Override
	protected String getWizardTitle() {
		return MessageFormat.format(dlgComputeReboot, CloudOptionExtension.getOptions().get(instance.getCloudScope().getCloudPlatform().getId()));
	}
}
