/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.xcloud.ui.handlers;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.xcloud.common.CloudConstants;
import com.clustercontrol.xcloud.model.cloud.ICloudScope;
import com.clustercontrol.xcloud.model.cloud.ILoginUser;
import com.clustercontrol.xcloud.model.cloud.IRoleRelation;
import com.clustercontrol.xcloud.ui.dialogs.EditAssignRoleDialog;
import com.clustercontrol.xcloud.ui.views.HinemosRole;

public class ModifyRoleAssignHandler extends AbstractHandler {
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection(event);
		HinemosRole role = (HinemosRole)selection.getFirstElement();
		
		EditAssignRoleDialog dialog = new EditAssignRoleDialog(HandlerUtil.getActiveShell(event), role);

		if (dialog.open() != Window.OK)
			return null;
			
		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			CloudConstants.bundle_messages.getString("message.confirm.role_assign.modify"))) {
			
			List<EditAssignRoleDialog.DialogOutput> output = new ArrayList<>(dialog.getOutput());
			
			for(ICloudScope scope: role.getManager().getCloudScopes().getCloudScopes()){
				for(ILoginUser user: scope.getLoginUsers().getLoginUsers()){
					for(IRoleRelation relation: user.getRoleRelations()){
						if(relation.getId().equals(role.getRoleInfo().getId())){
							int index = indexOf(output, scope.getId(), user.getId());
							if(index != -1){
								output.remove(index);
							} else {
								user.removeRoleRelation(role.getRoleInfo().getId());
							}
						}
					}
				}
			}
			
			for(EditAssignRoleDialog.DialogOutput item: output){
				role.getManager().getCloudScopes().getCloudScope(item.getCloudScopeId()).getLoginUsers().getLoginUser(item.getCloudUserId()).addRoleRelation(role.getRoleInfo().getId());
			}

			// 成功報告ダイアログを生成
			MessageDialog.openInformation(
				null,
				Messages.getString("successful"),
				CloudConstants.bundle_messages.getString("message.finish.role_assign.modify"));
		}
		else {
			return null;
		}
		return null;
	}
	
	private int indexOf(List<EditAssignRoleDialog.DialogOutput> list, String scopeId, String userId){
		for(EditAssignRoleDialog.DialogOutput item: list){
			if(item.getCloudScopeId().equals(scopeId) && item.getCloudUserId().equals(userId)){
				return list.indexOf(item);
			}
		}
		return -1;
	}
}