package com.clustercontrol.xcloud.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.CloudManagerException;
import com.clustercontrol.ws.xcloud.InvalidRole_Exception;
import com.clustercontrol.ws.xcloud.InvalidUserPass_Exception;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.CloudModelException;
import com.clustercontrol.xcloud.model.cloud.ICloudScope;
import com.clustercontrol.xcloud.ui.dialogs.job.CreateGroupJobWizard;

public abstract class AbstaractCloudOptionGroupJobHandler implements ICloudOptionHandler, CloudStringConstants {
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		try {
			setup(event);
			registJob(event);
		} catch (Exception e) {
			Logger logger = Logger.getLogger(this.getClass());
			logger.error(e.getMessage(), e);
	
			String message = e.getMessage();
			if (message == null) {
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				PrintStream ps = new PrintStream(bos, true);
				e.printStackTrace(ps);
				
				message = bos.toString();
			}
			
			// 失敗報告ダイアログを生成
			MessageDialog.openError(null, Messages.getString("failed"), message);
		}
		return null;
	}
	
	protected abstract void setup(ExecutionEvent event);
	
	protected abstract String getWizardTitle();

	protected abstract ICloudScope getCloudScope();
	
	protected abstract String getCommand(CloudEndpoint endpoint, String facilityId) throws Exception;

	protected abstract String getJobName(String facilityId);
	
	protected abstract String getJobId(String facilityId);

	protected abstract String getMethodName();

	protected void registJob(ExecutionEvent event) throws ExecutionException {
		CloudEndpoint endpoint = getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(CloudEndpoint.class);
		
		try {
			endpoint.checkCallable(getCloudScope().getId(), getMethodName());
		} catch(CloudManagerException e) {
			if ("COMMUNITY_EDITION_FUNC_NOT_AVAILABLE".equals(e.getFaultInfo().getErrorCode())) {
				throw new CloudModelException(msgFucNotAvailable);
			}
			throw new CloudModelException(e);
		} catch(InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
		
		Font bannerFont = JFaceResources.getBannerFont();
		Font dialogFont = JFaceResources.getDialogFont();
		FontData[] fontDatas = dialogFont.getFontData();
		for (FontData fontData: fontDatas) {
			fontData.setHeight(fontData.getHeight() + 2);
			fontData.setStyle(SWT.BOLD);
		}
		JFaceResources.getFontRegistry().put(JFaceResources.BANNER_FONT, fontDatas);
		
		try {
			CreateGroupJobWizard wizard = new CreateGroupJobWizard(getWizardTitle(), new CreateGroupJobWizard.IJobDetailProvider() {
				@Override
				public String getJobName(String facilityId) {
					return AbstaractCloudOptionGroupJobHandler.this.getJobName(facilityId);
				}
				@Override
				public String getJobId(String facilityId) {
					return AbstaractCloudOptionGroupJobHandler.this.getJobId(facilityId);
				}
				@Override
				public String getCommand(CloudEndpoint endpoint, String facilityId) throws Exception {
					return AbstaractCloudOptionGroupJobHandler.this.getCommand(endpoint, facilityId);
				}
				@Override
				public ICloudScope getCloudScope() {
					return AbstaractCloudOptionGroupJobHandler.this.getCloudScope();
				}
			});
			
			WizardDialog wizardDialog = new WizardDialog(HandlerUtil.getActiveShell(event), wizard);
			wizardDialog.open();
		} finally {
			Font changed = JFaceResources.getBannerFont();
			JFaceResources.getFontRegistry().put(JFaceResources.BANNER_FONT, bannerFont.getFontData());
			changed.dispose();
		}
		return;
	}
}
