package com.clustercontrol.xcloud.model.cloud;

import com.clustercontrol.ws.xcloud.PlatformServiceCondition;
import com.clustercontrol.xcloud.model.base.Element;

public class ServiceCondition extends Element implements IServiceCondition {
	private String id;
	private String name;
	private String status;
	private String detail;
	
	@Override
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	
	@Override
	public String getName() {
		return name;
	}
	public void setName(String name) {
		internalSetProperty(p.name, name);
	}

	@Override
	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		internalSetProperty(p.status, status);
	}

	@Override
	public String getDetail() {
		return detail;
	}
	public void setDetail(String detail) {
		internalSetProperty(p.detail, detail);
	}
	
	public void update(PlatformServiceCondition condition) {
		setId(condition.getId());
		setName(condition.getServiceName());
		setStatus(condition.getStatus().name());
		setDetail(condition.getDetail());
	}
	
	public static ServiceCondition convert(PlatformServiceCondition source) {
		ServiceCondition endpoint = new ServiceCondition();
		endpoint.update(source);
		return endpoint;
	}
}
