/*

Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.xcloud.ui.dialogs;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.accesscontrol.dialog.ObjectPrivilegeEditDialog;
import com.clustercontrol.accesscontrol.util.ObjectBean;
import com.clustercontrol.accesscontrol.util.ObjectPrivilegeBean;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.InvalidRole_Exception;
import com.clustercontrol.ws.xcloud.ObjectPrivilegeMode;
import com.clustercontrol.ws.xcloud.RoleObjectPrivilege;
import com.clustercontrol.ws.xcloud.SetBillingAlarmObjectPrivilegeRequest;
import com.clustercontrol.xcloud.Activator;
import com.clustercontrol.xcloud.common.CloudConstants;

/**
 * オブジェクト権限編集ダイアログクラス<BR>
 * 
 * @version 4.1.0
 * @since 4.1.0
 */
public class BillingAlarmObjectPrivilegeEditDialog extends ObjectPrivilegeEditDialog {
	public static final long serialVersionUID = 1L;
	private String objectId;
	
	public BillingAlarmObjectPrivilegeEditDialog(Shell parent, String managerName, String objectId, String ownerRoleId, HashMap<String, ObjectPrivilegeBean> objPrivMap) {
		super(parent, Arrays.asList(new ObjectBean(managerName, "CLOUD_BILLING_ALARM", objectId)), ownerRoleId, objPrivMap);
		this.objectId = objectId;
	}

	@SuppressWarnings("unchecked")
	@Override
	protected boolean action() {
		boolean result = true;

		Map<String, ObjectPrivilegeBean> modObjPrivMap;
		{
			boolean accessible = false;
			Field f = null;
			try {
				f = ObjectPrivilegeEditDialog.class.getDeclaredField("m_modObjPrivMap");
				accessible = f.isAccessible();
				f.setAccessible(true);
				modObjPrivMap = (Map<String, ObjectPrivilegeBean>) f.get(this);
			} catch (SecurityException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException e1) {
				throw new IllegalStateException(e1);
			}
			finally {
				if (f != null) {
					f.setAccessible(accessible);
				}
			}
		}
		
		List<ObjectBean> objects;
		{
			boolean accessible = false;
			Field f = null;
			try {
				f = ObjectPrivilegeEditDialog.class.getDeclaredField("m_objects");
				accessible = f.isAccessible();
				f.setAccessible(true);
				objects = (List<ObjectBean>)f.get(this);
			} catch (SecurityException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException e1) {
				throw new IllegalStateException(e1);
			}
			finally {
				if (f != null) {
					f.setAccessible(accessible);
				}
			}
		}

		// 一括でオブジェクト権限を変更する場合は、確認ダイアログを表示する
		StringBuffer confirmList = new StringBuffer();
		if (objects.size() > 1) {
			for (ObjectBean objectBean : objects) {
				confirmList.append(objectBean.getObjectId() + "\n");
			}
			
			if (!MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					Messages.getString("message.accesscontrol.53", new String[]{ confirmList.toString() } )))
			{
				return false;
			}
		}
		
		StringBuffer failureList = new StringBuffer();
		StringBuffer successList = new StringBuffer();
		
		for (ObjectBean objectBean : objects) {
			if (objectBean.getObjectType().equals("CLOUD_BILLING_ALARM")) {
				String objectPrivilegeParam = Messages.getString("object.privilege.param",
						new String[]{CloudConstants.bundle_messages.getString("word.billing_alarm"), objectBean.getObjectId()});
				try {
					SetBillingAlarmObjectPrivilegeRequest request = new SetBillingAlarmObjectPrivilegeRequest();
					request.setAlarmId(objectId);
					
					for (Map.Entry<String, ObjectPrivilegeBean> entry: modObjPrivMap.entrySet()) {
						RoleObjectPrivilege rop = new RoleObjectPrivilege();
						rop.setRoleId(entry.getKey());
						if (entry.getValue().getReadPrivilege()) rop.getPrivilegeModes().add(ObjectPrivilegeMode.READ);
						if (entry.getValue().getWritePrivilege()) rop.getPrivilegeModes().add(ObjectPrivilegeMode.MODIFY);
						if (entry.getValue().getExecPrivilege()) rop.getPrivilegeModes().add(ObjectPrivilegeMode.EXEC);
						request.getRoleObjectPrivileges().add(rop);
					}
					
					Activator.getDefault().getHinemosManager(objectBean.getManagerName()).getEndpoint(CloudEndpoint.class).setBillingAlarmObjectPrivilege(request);
					successList.append(objectPrivilegeParam + "\n");
				} catch (InvalidRole_Exception e) {
					// 権限なし
					failureList.append(objectPrivilegeParam + " (" + Messages.getString("message.accesscontrol.16") + ")\n");
				} catch (Exception e) {
					// 上記以外の例外
					Logger.getLogger(this.getClass()).warn("getOwnUserList(), " + e.getMessage(), e);
					failureList.append(objectPrivilegeParam + " (" + Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage() + ")\n");
				}
				
				break;
			}
		}
		
		// 成功ダイアログ
		if(successList.length() != 0){
			MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					Messages.getString("message.accesscontrol.49", new String[]{ successList.toString() }));
		}

		// 失敗ダイアログ
		if(failureList.length() != 0){
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.accesscontrol.50", new String[]{ failureList.toString() }));
		}

		return result;
	}
}
