/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.swt.widgets.baseline;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.widgets.baseline.Baseline;
import org.eclipse.wb.swt.widgets.baseline.Library;

final class GtkBaseline
extends Baseline {
    static {
        Library.loadLibrary("baseline");
    }

    GtkBaseline() {
    }

    private static native int fetchBaseline(long var0);

    private static native int fetchBaselineFromLayout(long var0);

    int fetchBaseline(Control control, int width, int height) {
        int baseline = -1;
        Class<?> clazz = control.getClass();
        Method setTextMethod = null;
        try {
            String oldText;
            Method getTextMethod = clazz.getMethod("getText", new Class[0]);
            if (getTextMethod != null && ((oldText = (String)getTextMethod.invoke((Object)control, new Object[0])) == null || oldText.length() == 0)) {
                setTextMethod = clazz.getMethod("setText", String.class);
                setTextMethod.invoke((Object)control, "a");
                while (Display.getDefault().readAndDispatch()) {
                }
            }
        }
        catch (Throwable e) {
            return -1;
        }
        try {
            if (control instanceof Link) {
                Link linkControl = (Link)control;
                Field layoutField = Link.class.getDeclaredField("layout");
                layoutField.setAccessible(true);
                TextLayout textLayout = (TextLayout)layoutField.get(linkControl);
                Field layoutHandleField = TextLayout.class.getDeclaredField("layout");
                layoutHandleField.setAccessible(true);
                long layoutHandle = layoutHandleField.getLong(textLayout);
                baseline = GtkBaseline.fetchBaselineFromLayout(layoutHandle);
            } else {
                Field controlHandleField = Widget.class.getDeclaredField("handle");
                long controlHandle = controlHandleField.getLong(control);
                baseline = GtkBaseline.fetchBaseline(controlHandle);
            }
            if (setTextMethod != null) {
                setTextMethod.invoke((Object)control, "");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return baseline;
    }
}

