/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.xcloud.azure.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.AccessKeyCredential;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.ModifyCloudLoginUserRequest;
import com.clustercontrol.ws.xcloud.ModifyPublicCloudScopeRequest;
import com.clustercontrol.xcloud.azure.ui.dialogs.CreateCloudScopeDialog;
import com.clustercontrol.xcloud.azure.ui.dialogs.CreateCloudScopeDialog.DialogData;
import com.clustercontrol.xcloud.common.CloudConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.ICloudScope;
import com.clustercontrol.xcloud.model.cloud.ILoginUser;

public class ModifyCloudScopeHandler implements ICloudOptionHandler {
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection(event);
		final ICloudScope cloudScope = (ICloudScope)selection.getFirstElement();
		
		final ILoginUser accountUser = cloudScope.getLoginUsers().getLoginUser(cloudScope.getAccountId());
		CreateCloudScopeDialog dialog = new CreateCloudScopeDialog(HandlerUtil.getActiveShell(event), true);
		
		DialogData data = new DialogData();
		data.setManagerName(cloudScope.getCloudScopes().getHinemosManager().getManagerName());
		data.setCloudScopeId(cloudScope.getId());
		data.setCloudScopeName(cloudScope.getName());
		data.setDescription(cloudScope.getDescription());
		data.setAccessKey(((AccessKeyCredential) accountUser.getCredential()).getAccessKey());
		data.setSecretKey(((AccessKeyCredential) accountUser.getCredential()).getSecretKey());
		data.setAccountId(accountUser.getId());
		data.setDisplayName(accountUser.getName());
		data.setOwnerRoleId(cloudScope.getOwnerRoleId());
		dialog.setDialogData(data);
		
		loop_end:
		while(true){
			try {
				if (dialog.open() != Window.OK)
					break loop_end;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);
	
				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}
			
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				CloudConstants.bundle_messages.getString("message.confirm.cloudscope.modify"))) {
				
				CreateCloudScopeDialog.DialogData output = dialog.getDialogData();
				
				ModifyPublicCloudScopeRequest modifyScopeRequest = new ModifyPublicCloudScopeRequest();
				modifyScopeRequest.setCloudScopeId(output.getCloudScopeId());
				modifyScopeRequest.setScopeName(output.getCloudScopeName());
				modifyScopeRequest.setDescription(output.getDescription());
				
				ModifyCloudLoginUserRequest modifyUserRequest = new ModifyCloudLoginUserRequest();
				AccessKeyCredential credential = new AccessKeyCredential();
				credential.setAccessKey(output.getAccessKey());
				credential.setSecretKey(output.getSecretKey());
				modifyUserRequest.setCredential(credential);
				modifyUserRequest.setLoginUserId(output.getAccountId());
				modifyUserRequest.setUserName(output.getDisplayName());
				modifyUserRequest.setCloudScopeId(cloudScope.getId());
				
				try {
					CloudEndpoint endpoint = cloudScope.getCloudScopes().getHinemosManager().getEndpoint(CloudEndpoint.class);
					endpoint.modifyCloudScope(modifyScopeRequest);
					accountUser.modifyCloudUser(modifyUserRequest);
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						CloudConstants.bundle_messages.getString("message.finish.cloudscope.modify"));
					
					Display.getCurrent().asyncExec(new Runnable() {
						@Override
						public void run() {
							cloudScope.getCloudScopes().getHinemosManager().update();
						}
					});
					
					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);
	
					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				}
			}
		}
		return null;
	}
}