package com.clustercontrol.xcloud.azure.ui.dialogs;

import java.text.MessageFormat;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.xcloud.azure.common.AzureStringConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.ui.dialogs.IDialogConstants;

public class ModifyConfigDialog extends Dialog implements CloudStringConstants, AzureStringConstants {
	private String selectedInstanceType;
	private AzureResourceProvider provider;

	public ModifyConfigDialog(Shell parentShell, String selectedInstanceType, AzureResourceProvider provider) {
		super(parentShell);
		this.selectedInstanceType = selectedInstanceType;
		this.provider = provider;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		GridLayout gridLayout = (GridLayout) container.getLayout();
		gridLayout.numColumns = 2;
		
		Label lblNewLabel = new Label(container, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNewLabel.setText(strInstanceType + strSeparator);
		
		final Combo cmbInstanceType = new Combo(container, SWT.READ_ONLY);
		cmbInstanceType.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				selectedInstanceType = cmbInstanceType.getText();
			}
		});
		cmbInstanceType.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
//		for (String instanceType: provider.getInstanceTypes()) {
//			cmbInstanceType.add(instanceType);
//		}
		if (selectedInstanceType != null) {
			for (String instanceType: cmbInstanceType.getItems()) {
				if (instanceType.equals(selectedInstanceType)) {
					cmbInstanceType.setText(instanceType);
					break;
				}
			}
		} else if (cmbInstanceType.getItems().length > 0)
			cmbInstanceType.select(0);
		
		return container;
	}
	
	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(MessageFormat.format(dlgComputeEditCofiguration, strAzure));
	}
	
	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(450, 152);
	}

	/**
	 */
	public String getSelectedInstanceType() {
		return selectedInstanceType;
	}
}
