package com.clustercontrol.xcloud.azure.plugin;

import static com.clustercontrol.xcloud.azure.common.AzureConstants.EPROP_CloudService;
import static com.clustercontrol.xcloud.azure.common.AzureConstants.EPROP_CloudIaaS;
import static com.clustercontrol.xcloud.azure.common.AzureConstants.EPROP_CloudPaaS;
import static com.clustercontrol.xcloud.azure.common.AzureConstants.FOLDER_CLOUDSERVICE;
import static com.clustercontrol.xcloud.azure.common.AzureConstants.FOLDER_CLOUDIAAS;
import static com.clustercontrol.xcloud.azure.common.AzureConstants.FOLDER_CLOUDPAAS;
import static com.clustercontrol.xcloud.azure.common.AzureConstants.EPROP_VNet;
import static com.clustercontrol.xcloud.azure.common.AzureConstants.FOLDER_VNET;
import static com.clustercontrol.xcloud.azure.common.AzureConstants.FOLDER_SUBNET;
import static com.clustercontrol.xcloud.azure.common.AzureConstants.EPROP_Subnet;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.graphics.Image;

import com.clustercontrol.xcloud.azure.common.AzureConstants;
import com.clustercontrol.xcloud.azure.common.AzureStringConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.IModelContentProvider;
import com.clustercontrol.xcloud.model.cloud.IResource;
import com.clustercontrol.xcloud.model.repository.ICloudScopeRootScope;
import com.clustercontrol.xcloud.model.repository.ICloudScopeScope;
import com.clustercontrol.xcloud.model.repository.IEntityNode;
import com.clustercontrol.xcloud.model.repository.IFacility;
import com.clustercontrol.xcloud.model.repository.IFolderScope;
import com.clustercontrol.xcloud.model.repository.IInstanceNode;
import com.clustercontrol.xcloud.model.repository.ILocationScope;
import com.clustercontrol.xcloud.model.repository.INode;
import com.clustercontrol.xcloud.model.repository.IScope;

public class AzureModelContentProvider implements IModelContentProvider, CloudStringConstants, AzureStringConstants {
	public static class FacilityModelTransformor<T> implements IFacility.ITransformer<T> {
		protected T defaultValue;
		public FacilityModelTransformor(T defaultValue) {this.defaultValue = defaultValue;}
		@Override public T transform(IFacility facility) {return defaultTransform(facility);}
		@Override public T transform(INode node) {return defaultTransform(node);}
		@Override public T transform(IScope scope) {return defaultTransform(scope);}
		@Override public T transform(ILocationScope scope) {return defaultTransform(scope);}
		@Override public T transform(IFolderScope scope) {return defaultTransform(scope);}
		@Override public T transform(ICloudScopeScope scope) {return defaultTransform(scope);}
		@Override public T transform(ICloudScopeRootScope scope) {return defaultTransform(scope);}
		@Override public T transform(IInstanceNode node) {return defaultTransform(node);}
		@Override public T transform(IEntityNode node) {return defaultTransform(node);}
		protected T defaultTransform(IFacility facility) {return defaultValue;}
	}
	
	@Override
	public Object getParent(Object o, Object defaultParent) {
		return defaultParent;
	}

	@Override
	public String getText(Object o, String defaultName) {
		if (o instanceof IFacility) {
			return ((IFacility)o).transform(new FacilityModelTransformor<String>(defaultName) {
				@Override public String transform(ICloudScopeScope scope) {
					return strAzure + " ( " + scope.getName() + " )";
				}
				@Override public String transform(IFolderScope folder) {
					switch (folder.getFolderType()) {
					case AzureConstants.FOLDER_CLOUDSERVICE:
						return String.format("%s (%s)", strAzureCloudService, folder.getName());
					case AzureConstants.FOLDER_CLOUDIAAS:
						return String.format("%s", strAzureCloudIaaS);
					case AzureConstants.FOLDER_CLOUDPAAS:
						return String.format("%s", strAzureCloudPaaS);
					case AzureConstants.FOLDER_VNET:
						return String.format("%s (%s)", strVNet, folder.getName());
					case AzureConstants.FOLDER_SUBNET:
						return String.format("%s (%s)", strSubnet, folder.getName());
					default:
						return defaultValue;
					}
				}
				@Override public String transform(ILocationScope location) {
					return location.getName();
				}
				@Override public String transform(IInstanceNode instance) {
					return String.format("%s (%s)", strInstance, instance.getName());
				}
				@Override public String transform(IEntityNode node) {
					return String.format("%s (%s)", node.getEntityType(), node.getName());
				}
			});
		}
		return defaultName;
	}

	@Override
	public Image getImage(Object o, Image defaultImage) {
		if (o instanceof IFacility) {
			return ((IFacility)o).transform(new FacilityModelTransformor<Image>(defaultImage) {
			});
		}
		return defaultImage;
	}
	
	protected void filterResource(IFolderScope folder, List<IResource> src, List<IResource> dest) {
		if (src.isEmpty())
			return;

		String cloudService = null;
		String cloudIaaS = null;
		String cloudPaaS = null;
		String vNet = null;
		String subnet = null;
		
		
		switch (folder.getFolderType()) {
		case FOLDER_CLOUDSERVICE:
			cloudService = folder.getExtendedProperty(EPROP_CloudService);
			break;
		case FOLDER_CLOUDIAAS:
			cloudIaaS = folder.getExtendedProperty(EPROP_CloudIaaS);
			break;
		case FOLDER_CLOUDPAAS:
			cloudPaaS = folder.getExtendedProperty(EPROP_CloudPaaS);
			break;
		case FOLDER_VNET:
			vNet = folder.getExtendedProperty(EPROP_VNet);
			break;
		case FOLDER_SUBNET:
			subnet = folder.getExtendedProperty(EPROP_Subnet);
			break;
		}
		
		Iterator<IResource> iter = src.iterator();
		while (iter.hasNext()) {
			IResource resource = iter.next();
			if (!((cloudService == null || cloudService.equals(resource.getExtendedProperty(EPROP_CloudService))) &&
				(cloudIaaS == null || cloudIaaS.equals(resource.getExtendedProperty(EPROP_CloudIaaS))) &&
				(cloudPaaS == null || cloudPaaS.equals(resource.getExtendedProperty(EPROP_CloudPaaS))) &&
				(vNet == null || vNet.equals(resource.getExtendedProperty(EPROP_VNet))) &&
				(subnet == null || subnet.equals(resource.getExtendedProperty(EPROP_Subnet)))))				
					continue;
				
			dest.add(resource);
			iter.remove();
		}
		
		for (IFacility facility: folder.getFacilities()) {
			if (!(facility instanceof IFolderScope))
				continue;
			filterResource((IFolderScope)facility, src, dest);
		}
	}

	@Override
	public <T> T[] getChildren(Object o, final T[] defaultChildren) {
		if (o instanceof IFacility) {
			return ((IFacility)o).transform(new FacilityModelTransformor<T[]>(defaultChildren) {
				@SuppressWarnings("unchecked")
				@Override
				public T[] transform(IFolderScope scope) {
					Class<?> componentType = defaultValue.getClass().getComponentType();
					if (!IResource.class.isAssignableFrom(componentType))
						return defaultTransform(scope);
					
					List<IResource> src = new ArrayList<>(Arrays.asList((IResource[])defaultChildren));
					List<IResource> dest = new ArrayList<>();
					filterResource(scope, src, dest);
					
					return (T[])dest.toArray((T[])Array.newInstance(componentType, dest.size()));
				}
			});
		}
		return defaultChildren;
	}
}