/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.azure.ui.dialogs;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

//import com.clustercontrol.ws.xcloud.KeyPair;
//import com.clustercontrol.ws.xcloud.SecurityGroup;
//import com.clustercontrol.ws.xcloud.Subnet;
import com.clustercontrol.ws.xcloud.Tag;
//import com.clustercontrol.ws.xcloud.Vpc;
import com.clustercontrol.xcloud.azure.common.AzureStringConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.cloud.ILocation;
import com.clustercontrol.xcloud.platform.PlatformDependent;
import com.clustercontrol.xcloud.ui.dialogs.IDialogConstants;
import com.clustercontrol.xcloud.util.ControlUtil;

public class CreateInstanceDialog extends Dialog implements CloudStringConstants, AzureStringConstants {
	public interface DialogDataFactory {
		DialogData createDialogData();
	}
	public interface DialogData {
		String getName();
		void setName(String value);
		String getMemo();
		void setMemo(String value);
		List<Tag> getTags();
		void setTags(List<Tag> value);
		Boolean isAssociatePublicIpAddress();
		void setAssociatePublicIpAddress(Boolean value);
		Boolean isDisableApiTermination();
		void setDisableApiTermination(Boolean value);
		Boolean isEbsOptimized();
		void setEbsOptimized(Boolean value);
		String getImageId();
		void setImageId(String value);
		String getInstanceInitiatedShutdownBehavior();
		void setInstanceInitiatedShutdownBehavior(String value);
		String getInstanceType();
		void setInstanceType(String value);
		String getKeyName();
		void setKeyName(String value);
		Boolean isMonitoring();
		void setMonitoring(Boolean value);
		Boolean isDeleteOnTermination();
		void setDeleteOnTermination(Boolean value);
		Integer getIops();
		void setIops(Integer value);
		Integer getVolumeSize();
		void setVolumeSize(Integer value);
		String getVolumeType();
		void setVolumeType(String value);
		List<String> getSecurityGroupIds();
		void setSecurityGroupIds(List<String> value);
		String getSubnetId();
		void setSubnetId(String value);
	}
	
	protected DialogDataFactory factory;
	protected DialogData model;

	protected Text txtAmiId;
	protected Combo cmbInstanceType;
	protected Combo cmbVpc;
	protected Combo cmbKeypair;
	
	protected Label lblLaunchInVPC;
	protected Combo cmbSubnet;
	
	protected ILocation location;
	protected String dlgTitle;
	
	protected AzureResourceProvider provider;
	protected CheckboxTableViewer tableViewer;
	protected Text text;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateInstanceDialog(Shell parentShell, ILocation location, String dlgTitle, AzureResourceProvider provider) {
		super(parentShell);
		setShellStyle(SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		this.location = location;
		this.provider = provider;
		this.dlgTitle = dlgTitle;
	}
	
	public void setDialogDataFactory(DialogDataFactory factory) {
		this.factory = factory;
	}
	
	public void setDialogData(DialogData data) {
		this.model = data;
	}
	
	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@SuppressWarnings("unchecked")
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(1, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);
		
		List<Control> labels = new ArrayList<>();
		List<Group> groups = new ArrayList<>();
		
		Group group = new Group(container, SWT.NONE);
		group.setText(strCloudScope);
		group.setLayout(new GridLayout(2, false));
		group.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		groups.add(group);
		
		Label lblNewLabel = new Label(group, SWT.RIGHT);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel.setText(strManager + strSeparator);
		labels.add(lblNewLabel);
		
		Label lblNewLabel_4 = new Label(group, SWT.BORDER);
		lblNewLabel_4.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		lblNewLabel_4.setText(location.getCloudScope().getCloudScopes().getHinemosManager().getManagerName());
		
		Label lblNewLabel_1 = new Label(group, SWT.RIGHT);
		lblNewLabel_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_1.setText(strCloudScope + strSeparator);
		labels.add(lblNewLabel_1);
		
		Label lblNewLabel_5 = new Label(group, SWT.BORDER);
		lblNewLabel_5.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblNewLabel_5.setText(String.format("%s (%s)", location.getCloudScope().getName(), location.getCloudScope().getId()));
		
		Label label = new Label(group, SWT.NONE);
		label.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		label.setText(strComputeName + strSeparator);
		
		text = new Text(group, SWT.BORDER);
		text.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		if (getOutput().getName() != null)
			text.setText(getOutput().getName());

		Group grpNodeInfo = new Group(container, SWT.NONE);
		grpNodeInfo.setText(strComputeType + strSeparator);
		GridLayout gl_grpNodeInfo = new GridLayout(3, false);
		gl_grpNodeInfo.verticalSpacing = 9;
		grpNodeInfo.setLayout(gl_grpNodeInfo);
		grpNodeInfo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 5, 1));
		groups.add(grpNodeInfo);
		
		Label lblid = new Label(grpNodeInfo, SWT.RIGHT);
		lblid.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblid.setText("AMI ID:");
		labels.add(lblid);

		txtAmiId = new Text(grpNodeInfo, SWT.BORDER);
		txtAmiId.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkFinished();
			}
		});
		txtAmiId.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		if (getOutput().getImageId() != null)
			txtAmiId.setText(getOutput().getImageId());
		
		Button btnNewButton = new Button(grpNodeInfo, SWT.NONE);
		btnNewButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
//				SelectAMIDialog dialog = new SelectAMIDialog(CreateInstanceDialog.this.getShell(), provider);
//				dialog.create();
//				Rectangle rect = CreateInstanceDialog.this.getShell().getBounds();
//				dialog.getShell().setLocation(rect.x + rect.width, rect.y);
//				if (dialog.open() == Window.OK) {
//					txtAmiId.setText(dialog.getOutput().getId());
//				}
			}
		});
		GridData gd_btnNewButton = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnNewButton.widthHint = 100;
		btnNewButton.setLayoutData(gd_btnNewButton);
		btnNewButton.setText(strBrowse);
		
		Label lblFacilityName = new Label(grpNodeInfo, SWT.RIGHT);
		lblFacilityName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblFacilityName.setText(strInstanceType + strSeparator);
		labels.add(lblFacilityName);
		
		cmbInstanceType = new Combo(grpNodeInfo, SWT.READ_ONLY);
		cmbInstanceType.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkFinished();
			}
		});
		cmbInstanceType.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
//		for (String instanceType: provider.getInstanceTypes()) {
//			cmbInstanceType.add(instanceType);
//		}
		if (getOutput().getInstanceType() != null) {
			for (String instanceType: cmbInstanceType.getItems()) {
				if (instanceType.equals(getOutput().getInstanceType())) {
					cmbInstanceType.setText(instanceType);
					break;
				}
			}
		} else if (cmbInstanceType.getItems().length > 0)
			cmbInstanceType.select(0);

		Group grpInstacneInfo = new Group(container, SWT.NONE);
		grpInstacneInfo.setText(strNetwork);
		GridLayout gl_grpInstacneInfo = new GridLayout(2, false);
		gl_grpInstacneInfo.verticalSpacing = 9;
		grpInstacneInfo.setLayout(gl_grpInstacneInfo);
		grpInstacneInfo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 5, 1));
		groups.add(grpInstacneInfo);

		Label lblRegion = new Label(grpInstacneInfo, SWT.RIGHT);
		lblRegion.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblRegion.setText(strNetwork + strSeparator);
		labels.add(lblRegion);

		cmbVpc = new Combo(grpInstacneInfo, SWT.READ_ONLY);
		cmbVpc.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		cmbVpc.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
//				// サブネットのクリア。
//				cmbSubnet.removeAll();
//				Vpc vpc = (Vpc)cmbVpc.getData(cmbVpc.getText());
//				if (vpc != null) {
//					for (Subnet subnet: vpc.getSubnets()) {
//						String subnetName = String.format("%s (%s) [%s]", subnet.getCidrBlock(), subnet.getSubnetId(), subnet.getAvailabilityZone());
//						cmbSubnet.add(subnetName);
//						cmbSubnet.setData(subnetName, subnet);
//					}
//					if (cmbSubnet.getItems().length > 0)
//						cmbSubnet.select(0);
//				}
//				
//				List<SecurityGroup> sgs = new ArrayList<>();
//				for (SecurityGroup sg: provider.getSecurityGroups()) {
//					if (vpc.getId().equals(sg.getVpcId())) {
//						sgs.add(sg);
//					}
//				}
//				tableViewer.setInput(sgs);
			}
		});
		
		lblLaunchInVPC = new Label(grpInstacneInfo, SWT.NONE);
		lblLaunchInVPC.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblLaunchInVPC.setAlignment(SWT.RIGHT);
		lblLaunchInVPC.setText(strSubnet + strSeparator);
		labels.add(lblLaunchInVPC);
		
		cmbSubnet = new Combo(grpInstacneInfo, SWT.READ_ONLY);
		cmbSubnet.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkFinished();
			}
		});
		cmbSubnet.setEnabled(false);
		cmbSubnet.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		cmbSubnet.setEnabled(true);
		
		Group group_1 = new Group(container, SWT.NONE);
		group_1.setLayout(new GridLayout(2, false));
		group_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		group_1.setText(strSecurity);
		
		Label lblNewLabel_2 = new Label(group_1, SWT.NONE);
		lblNewLabel_2.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_2.setText(strSecurityGroup + strSeparator);
		labels.add(lblNewLabel_2);
		
		tableViewer = CheckboxTableViewer.newCheckList(group_1, SWT.BORDER | SWT.CHECK | SWT.FULL_SELECTION);
		tableViewer.addCheckStateListener(new ICheckStateListener() {
			public void checkStateChanged(CheckStateChangedEvent event) {
				checkFinished();
			}
		});
		Table table = tableViewer.getTable();
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_table.widthHint = 308;
		gd_table.heightHint = 105;
		table.setLayoutData(gd_table);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		
		TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn = tableViewerColumn.getColumn();
		tblclmnNewColumn.setWidth(140);
		tblclmnNewColumn.setText(strSecurityGroupId + strSeparator);
//		tableViewerColumn.setLabelProvider(new ColumnLabelProvider() {
//			@Override public String getText(Object element) {return ((SecurityGroup)element).getGroupId();}
//		});
		TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnNewColumn_1 = tableViewerColumn_1.getColumn();
		tblclmnNewColumn_1.setWidth(159);
		tblclmnNewColumn_1.setText(strSecurityGroupName + strSeparator);
//		tableViewerColumn_1.setLabelProvider(new ColumnLabelProvider() {
//			@Override public String getText(Object element) {return ((SecurityGroup)element).getGroupName();}
//		});
		
		tableViewer.setContentProvider(new ArrayContentProvider());
		
		Label lblNewLabel_3 = new Label(group_1, SWT.NONE);
		lblNewLabel_3.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_3.setText(strKeypair + strSeparator);
		labels.add(lblNewLabel_3);
		
		cmbKeypair = new Combo(group_1, SWT.READ_ONLY);
		cmbKeypair.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				checkFinished();
			}
		});
		cmbKeypair.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
//		for (KeyPair keyPair: provider.getKeyNames()) {
//			cmbKeypair.add(keyPair.getKeyName());
//			cmbKeypair.setData(keyPair.getKeyName(), keyPair);
//		}
		if (getOutput().getKeyName() != null) {
			for (String keypair: cmbKeypair.getItems()) {
				if (getOutput().getKeyName().equals(keypair)) {
					cmbKeypair.setText(keypair);
				}
			}
		} else if (cmbKeypair.getItems().length > 0)
			cmbKeypair.select(0);		

		Button btnNewButton_1 = new Button(container, SWT.NONE);
		btnNewButton_1.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
			}
		});
		
		GridData gd_btnNewButton_1 = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_btnNewButton_1.widthHint = 100;
		btnNewButton_1.setLayoutData(gd_btnNewButton_1);
		btnNewButton_1.setText(strAdvance);
			
		if (!PlatformDependent.getPlatformDependent().isRapPlatfome()) {
			// 項目名の幅をグループ間で一致させる。
			container.layout();
			int maxWidth = 0;
			for (Control l: labels) {
				Point p = l.getSize();
				maxWidth = Math.max(maxWidth, p.x);
			}
			for (Control l: labels) {
				((GridData)l.getLayoutData()).widthHint = maxWidth;
			}
			for (Group g: groups) {
				g.layout(true);
			}
		}
		
		ControlUtil.setRequired(new Control[]{txtAmiId, cmbSubnet});
		
		getShell().getDisplay().asyncExec(new Runnable() {
			@Override
			public void run() {
				checkFinished();
			}
		});
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(521, 619);
	}

	@Override
	protected void okPressed() {
		model.setName(text.getText());
		model.setImageId(txtAmiId.getText());
		model.setInstanceType(cmbInstanceType.getText());
		model.setKeyName(cmbKeypair.getText());
		super.okPressed();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(dlgTitle);
	}
	
	public DialogData getOutput() {
		if (this.model == null)
			model = factory.createDialogData();
		return model;
	}
	
	protected void checkFinished() {
		Button okButton = getButton(IDialogConstants.OK_ID);
		if (okButton == null)
			return;
			
		if (txtAmiId != null && !txtAmiId.getText().isEmpty() &&
			cmbInstanceType != null && !cmbInstanceType.getText().isEmpty() &&
			cmbVpc != null && !cmbVpc.getText().isEmpty() &&
			cmbKeypair != null && !cmbKeypair.getText().isEmpty() &&
			tableViewer != null && tableViewer.getCheckedElements().length > 0 &&
			cmbSubnet != null && !cmbSubnet.getText().isEmpty()
			) {
			getButton(IDialogConstants.OK_ID).setEnabled(true);
		} else {
			getButton(IDialogConstants.OK_ID).setEnabled(false);
		}
	}
}