/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;



public interface IAccountResource extends IElement {
	public interface IRegion {
		IAccountResource getAccountResource();
		String getRegion();
		String getRegionName();
		<T> T getCloudService(Class<T> serviceClass);

		<T> void putService(Class<T> interfaceClass, T instance);
	}

	<T> void putService(Class<T> interfaceClass, T instance);
	
	// プロパティの Id
	public interface p2 {
		static final PropertyId2<ValueObserver2<String>> accountId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> accountResourceId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> accountResourceName = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> cloudServiceId = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<String>> description = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<Boolean>> billingDetailCollectorFlg = new PropertyId2<ValueObserver2<Boolean>>();
		static final PropertyId2<ValueObserver2<Integer>> retentionPeriod = new PropertyId2<ValueObserver2<Integer>>();
		static final PropertyId2<ValueObserver2<Long>> regDate = new PropertyId2<ValueObserver2<Long>>();
		static final PropertyId2<ValueObserver2<String>> regUser = new PropertyId2<ValueObserver2<String>>();
		static final PropertyId2<ValueObserver2<Long>> updateDate = new PropertyId2<ValueObserver2<Long>>();
		static final PropertyId2<ValueObserver2<String>> updateUser = new PropertyId2<ValueObserver2<String>>();
	}

	IAccountResourceManager getAccountResourceManager();
	void editBillingDetailCollectorSetting(EditBillingDetailCollectorSettingRequet request);
	IAccountResource modifyAccountResource(ModifyAccountResourceRequest modifyAccountResourceRequest);

	String getAccountId();
	String getAccountResourceId();
	String getAccountResourceName();
	String getCloudServiceId();
	String getDescription();
	Boolean getBillingDetailCollectorFlg();
	Integer getRetentionPeriod();
	Long getRegDate();
	String getRegUser();
	Long getUpdateDate();
	String getUpdateUser();

	void setActiveUser(ICloudUser cloudUser);
	ICloudUser getActiveUser();
	
	ICloudUserManager getCloudUserManager();

	IRegion[] getRegions();
	IRegion getRegion(String region);
	
	ICloudTemplateManager getCloudTemplateManager();
	<T> T getCloudService(Class<T> serviceClass);
}