/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.swt.widgets.baseline;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Library {
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final String OS_ARCH = System.getProperty("os.arch");
    private static final String OS_NAME = System.getProperty("os.name");
    private static final boolean IS_MAC = OS_NAME.startsWith("Mac");
    private static final boolean IS_WINDOWS = OS_NAME.startsWith("Windows");
    private static final boolean IS_64BIT_OS = OS_ARCH.indexOf("64") != -1;

    private static boolean extract(String fileName, String mappedName) {
        block14: {
            FileOutputStream os = null;
            InputStream is = null;
            File file = new File(fileName);
            file.deleteOnExit();
            boolean extracted = false;
            try {
                if (!file.exists() && (is = Library.class.getResourceAsStream(mappedName)) != null) {
                    int read;
                    extracted = true;
                    byte[] buffer = new byte[4096];
                    os = new FileOutputStream(fileName);
                    while ((read = is.read(buffer)) != -1) {
                        os.write(buffer, 0, read);
                    }
                    os.close();
                    is.close();
                    if (!IS_WINDOWS) {
                        try {
                            Runtime.getRuntime().exec(new String[]{"chmod", "755", fileName}).waitFor();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                if (Library.load(fileName)) {
                    return true;
                }
            }
            catch (Throwable e) {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!extracted || !file.exists()) break block14;
                file.delete();
            }
        }
        return false;
    }

    private static boolean load(String libName) {
        try {
            if (libName.indexOf(SEPARATOR) != -1) {
                System.load(libName);
            } else {
                System.loadLibrary(libName);
            }
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    public static void loadLibrary(String name) {
        if (IS_64BIT_OS && !IS_MAC) {
            name = String.valueOf(name) + "64";
        }
        String fileName = Library.mapLibraryName(name);
        String path = System.getProperty("java.io.tmpdir");
        File dir = new File(path, "wbp-baseline");
        boolean make = false;
        if (dir.exists() && dir.isDirectory() || (make = dir.mkdir())) {
            path = dir.getAbsolutePath();
            if (make && !IS_WINDOWS) {
                try {
                    Runtime.getRuntime().exec(new String[]{"chmod", "777", path}).waitFor();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (Library.load(String.valueOf(path) + SEPARATOR + fileName)) {
            return;
        }
        if (path != null && Library.extract(String.valueOf(path) + SEPARATOR + fileName, fileName)) {
            return;
        }
        throw new UnsatisfiedLinkError("Library " + name + " can't be loaded");
    }

    private static String mapLibraryName(String libName) {
        String ext;
        if ((libName = System.mapLibraryName(libName)).endsWith(ext = ".dylib")) {
            libName = String.valueOf(libName.substring(0, libName.length() - ext.length())) + ".jnilib";
        }
        return libName;
    }
}

