/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views.actions;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.CreateCloudUserRequest;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.IAccountResourceManager;
import com.clustercontrol.cloud.presenter.ICloudUserManager;
import com.clustercontrol.cloud.ui.dialogs.CreateCloudUserDialog;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;

public class CreateCloudUserAction
extends AbstractViewAction {
    public static final String ID = "com.clustercontrol.cloud.ui.views.actions.CreateCloudUserAction";
    private MessageManager messages = MessageManager.getInstance("messages");
    private String msgCreateCloudUserConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.cloud_user", "word.create"});
    private String msgCreateCloudUserResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.cloud_user", "word.create"});

    @Override
    protected void invoke(IAction action) throws InvocationException {
        CreateCloudUserDialog dialog = new CreateCloudUserDialog(this.viewPart.getSite().getShell());
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgCreateCloudUserConfirm)) {
                CreateCloudUserDialog.DialogOutput output = dialog.getOutput();
                CreateCloudUserRequest request = new CreateCloudUserRequest();
                ControlUtil.importObject(request, output);
                IAccountResourceManager accountResourceManager = Activator.getDefault().getCloudResourceManager().getAccountResourceManager();
                IAccountResource accountResource = accountResourceManager.getAccountResource(output.getAccountResourceId());
                ICloudUserManager manager = accountResource.getCloudUserManager();
                manager.createCloudUser(request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgCreateCloudUserResult);
            } else {
                return;
            }
        }
    }
}

