/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CloudResourceManager;
import com.clustercontrol.cloud.presenter.CloudService;
import com.clustercontrol.cloud.presenter.CreateCloudServiceRequest;
import com.clustercontrol.cloud.presenter.Element;
import com.clustercontrol.cloud.presenter.ICloudServiceManager;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import java.util.ArrayList;
import java.util.List;

public class CloudServiceManager
extends Element
implements ICloudServiceManager {
    private List<CloudService> cloudServices;
    private CloudResourceManager cloudResourceManager;

    public CloudServiceManager(CloudResourceManager cloudResourceManager) {
        this.cloudResourceManager = cloudResourceManager;
    }

    @Override
    public CloudResourceManager getCloudResourceManager() {
        return this.cloudResourceManager;
    }

    public CloudService[] getCloudServices() {
        if (!this.isInitialized().booleanValue()) {
            this.update();
        }
        return this.cloudServices.toArray(new CloudService[0]);
    }

    @Override
    public CloudService createCloudService(CreateCloudServiceRequest Request) {
        return null;
    }

    @Override
    public void removeCloudService(String cloudServiceId) {
    }

    @Override
    public CloudService getCloudService(String cloudServiceId) {
        for (CloudService cloudService : this.getCloudServices()) {
            if (!cloudService.getCloudServiceId().equals(cloudServiceId)) continue;
            return cloudService;
        }
        return null;
    }

    @Override
    public void update() {
        List wsCloudServices;
        this.cloudServices = new ArrayList<CloudService>();
        try {
            wsCloudServices = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class).getAllCloudServices();
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
        for (com.clustercontrol.ws.cloud.CloudService wsCloudService : wsCloudServices) {
            CloudService cloudService = new CloudService(this);
            ControlUtil.importObject(cloudService, wsCloudService);
            this.cloudServices.add(cloudService);
        }
        super.update();
    }

    Boolean isInitialized() {
        return this.cloudServices != null;
    }
}

