/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.annotation.Export;
import com.clustercontrol.cloud.commons.util.annotation.Import;
import com.clustercontrol.cloud.presenter.CloudInstanceBackupManager;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.ICloudInstanceBackup;
import com.clustercontrol.cloud.presenter.InternalComponent;
import com.clustercontrol.cloud.resources.Tag;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import java.util.ArrayList;

public class CloudInstanceBackup
extends InternalComponent<CloudInstanceBackupManager, com.clustercontrol.ws.cloud.CloudInstanceBackup>
implements ICloudInstanceBackup {
    private String accountResourceId;
    private String cloudUserId;
    private String description;
    private String instanceBackupId;
    private String name;
    private String platform;
    private Long regDate;
    private String regUser;
    private String region;
    private String restoreStatus;
    private String cloudTypeId;
    private ICloudInstanceBackup.BackupedData backupedData;

    public CloudInstanceBackup(CloudInstanceBackupManager container) {
        super(container);
    }

    @Override
    @Export
    public String getPlatform() {
        return this.platform;
    }

    @Import
    public void setPlatform(String platform) {
        this.internalSet("platform", ICloudInstanceBackup.p2.platform, platform);
    }

    @Override
    @Export
    public String getRegion() {
        return this.region;
    }

    @Import
    public void setRegion(String region) {
        this.internalSet("region", ICloudInstanceBackup.p2.region, region);
    }

    @Override
    @Export
    public Long getRegDate() {
        return this.regDate;
    }

    @Import
    public void setRegDate(Long regDate) {
        this.internalSet("regDate", ICloudInstanceBackup.p2.regDate, regDate);
    }

    @Override
    @Export
    public String getRegUser() {
        return this.regUser;
    }

    @Import
    public void setRegUser(String regUser) {
        this.internalSet("regUser", ICloudInstanceBackup.p2.regUser, regUser);
    }

    @Override
    @Export
    public String getCloudUserId() {
        return this.cloudUserId;
    }

    @Import
    public void setCloudUserId(String cloudUserId) {
        this.internalSet("cloudUserId", ICloudInstanceBackup.p2.cloudUserId, cloudUserId);
    }

    @Override
    @Export
    public String getRestoreStatus() {
        return this.restoreStatus;
    }

    @Import
    public void setRestoreStatus(String restoreStatus) {
        this.internalSet("restoreStatus", ICloudInstanceBackup.p2.restoreStatus, restoreStatus);
    }

    @Override
    @Export
    public String getName() {
        return this.name;
    }

    @Import
    public void setName(String name) {
        this.internalSet("name", ICloudInstanceBackup.p2.name, name);
    }

    @Override
    @Export
    public String getInstanceBackupId() {
        return this.instanceBackupId;
    }

    @Import
    public void setInstanceBackupId(String instanceBackupId) {
        this.internalSet("instanceBackupId", ICloudInstanceBackup.p2.instanceBackupId, instanceBackupId);
    }

    @Override
    @Export
    public String getDescription() {
        return this.description;
    }

    @Import
    public void setDescription(String description) {
        this.internalSet("description", ICloudInstanceBackup.p2.description, description);
    }

    @Override
    @Export
    public String getAccountResourceId() {
        return this.accountResourceId;
    }

    @Import
    public void setAccountResourceId(String accountResourceId) {
        this.internalSet("accountResourceId", ICloudInstanceBackup.p2.accountResourceId, accountResourceId);
    }

    @Override
    @Export
    public String getCloudTypeId() {
        return this.cloudTypeId;
    }

    @Import
    public void setCloudTypeId(String cloudTypeId) {
        this.internalSet("cloudTypeId", ICloudInstanceBackup.p2.cloudTypeId, cloudTypeId);
    }

    @Override
    public CloudInstanceBackupManager getCloudInstanceBackupManager() {
        return (CloudInstanceBackupManager)this.getContainer();
    }

    @Override
    public boolean equalValues(com.clustercontrol.ws.cloud.CloudInstanceBackup source) {
        return this.instanceBackupId.equals(source.getInstanceBackupId());
    }

    public static CloudInstanceBackup createCloudInstanceBackup(CloudInstanceBackupManager cloudInstanceManager, com.clustercontrol.ws.cloud.CloudInstanceBackup source) {
        CloudInstanceBackup cloudInstance = new CloudInstanceBackup(cloudInstanceManager);
        cloudInstance.overwrite(source);
        return cloudInstance;
    }

    @Override
    public com.clustercontrol.ws.cloud.CloudInstanceBackup getSource() throws CloudModelException {
        try {
            return this.getEndpoint().getInstanceBackup(this.getCloudInstanceBackupManager().getRegion().getAccountResource().getActiveUser().getRoleId(), this.region, this.instanceBackupId);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    protected void overwrite(com.clustercontrol.ws.cloud.CloudInstanceBackup source) {
        ControlUtil.importObject(this, source);
        if (source.getRestoreStatus() != null) {
            this.setRestoreStatus(source.getRestoreStatus().value());
        }
        this.setCloudTypeId(this.internalGetCloudTypeId());
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (com.clustercontrol.ws.cloud.Tag t : source.getBackupedData().getTags()) {
            tags.add(new Tag(t.getKey(), t.getValue()));
        }
        this.setBackupedData(new ICloudInstanceBackup.BackupedData(source.getBackupedData().getFacilityId(), source.getBackupedData().getFacilityName(), source.getBackupedData().getInstanceId(), source.getBackupedData().getNodeName(), source.getBackupedData().getFlavor(), source.getBackupedData().getInstanceDetail(), tags, source.getBackupedData().getZone()));
    }

    private CloudEndpoint getEndpoint() {
        return this.getCloudInstanceBackupManager().getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
    }

    private String internalGetCloudTypeId() {
        String cloudServiceId = this.getCloudInstanceBackupManager().getCloudComputeService().getRegion().getAccountResource().getCloudServiceId();
        String cloudTypeId = this.getCloudInstanceBackupManager().getCloudComputeService().getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getCloudServiceManager().getCloudService(cloudServiceId).getCloudTypeId();
        return cloudTypeId;
    }

    @Override
    public ICloudInstanceBackup.BackupedData getBackupedData() {
        return this.backupedData;
    }

    public void setBackupedData(ICloudInstanceBackup.BackupedData backupedData) {
        this.internalSet("backupedData", ICloudInstanceBackup.p2.backupedData, backupedData);
    }
}

