/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.ui.views.actions;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.ui.views.InstancesView;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DeleteInstanceAction
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strFacilityId = this.messages.getString("word.facility_id");
    private String strInstanceId = this.messages.getString("word.instance_id");
    private String msgDeleteInstanceConfirm = this.messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.instance", "word.remove"});
    private String msgDeleteInstanceResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.instance", "word.remove"});

    protected void invoke(IAction action) {
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)(this.msgDeleteInstanceConfirm + "\n" + this.strFacilityId + " = " + instance.getFacilityId() + ", " + this.strInstanceId + " = " + instance.getInstanceId()))) {
            instance.getCloudInstanceManager().removeCloudInstance(instance.getCloudInstanceManager().getRegion().getAccountResource().getActiveUser().getRoleId(), instance.getRegion(), instance.getInstanceId());
            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgDeleteInstanceResult);
            InstancesView view = (InstancesView)this.viewPart;
            view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FacilityTree.refresh();
                }
            });
        }
    }

    protected boolean canEnabled(IStructuredSelection selection) {
        ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        return !ICloudInstance.RegistStateType.deleted.name().equals(instance.getRegistState());
    }
}

