/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.resources;

import com.clustercontrol.cloud.aws.base.Activator;
import com.clustercontrol.cloud.aws.base.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.base.resources.Filter;
import com.clustercontrol.cloud.aws.base.resources.GroupIdentifier;
import com.clustercontrol.cloud.aws.base.resources.Image;
import com.clustercontrol.cloud.aws.base.resources.Snapshot;
import com.clustercontrol.cloud.aws.base.resources.Subnet;
import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.ws.aws.AWSOptionEndpoint;
import com.clustercontrol.ws.aws.KeyPair;
import com.clustercontrol.ws.aws.SecurityGroup;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.CloudRegion;
import com.clustercontrol.ws.cloud.CloudService;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.Zone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CloudResourceProviderImpl
implements CloudResourceProvider {
    private AWSOptionEndpoint awsEndpoint = Activator.getEndpointManager().getEndpoint(AWSOptionEndpoint.class);
    private CloudEndpoint cloudEndpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
    private String serviceId;
    private String roleId;

    public CloudResourceProviderImpl(String accountResourceId) {
        try {
            for (CloudService cloudService : this.cloudEndpoint.getAllCloudServices()) {
                if (!cloudService.getCloudServiceId().equals("AWS")) continue;
                this.serviceId = cloudService.getCloudServiceId();
            }
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            new CloudModelException(e);
        }
        this.roleId = AccountControlUtil.getRoleId((String)accountResourceId);
    }

    @Override
    public List<String> getAllRegion() {
        try {
            ArrayList<String> regions = new ArrayList<String>();
            for (CloudRegion r : this.cloudEndpoint.getCloudRegionsByService(this.serviceId)) {
                regions.add(r.getRegion());
            }
            return regions;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<AvailabilityZone> getAvailabilityZones(String region) {
        try {
            ArrayList<AvailabilityZone> azs = new ArrayList<AvailabilityZone>();
            for (Zone wsAZ : this.cloudEndpoint.getZones(this.roleId, region)) {
                AvailabilityZone az = new AvailabilityZone();
                az.setZoneName(wsAZ.getName());
                azs.add(az);
            }
            return azs;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Image> getImages(String region, List<Filter> filters) {
        try {
            ArrayList<com.clustercontrol.ws.cloud.Filter> wsFilters = new ArrayList<com.clustercontrol.ws.cloud.Filter>();
            for (Filter filter : filters) {
                com.clustercontrol.ws.cloud.Filter wsFilter = new com.clustercontrol.ws.cloud.Filter();
                wsFilter.setName(filter.getName());
                wsFilter.getValues().addAll(filter.getValues());
                wsFilters.add(wsFilter);
            }
            ArrayList<Image> images = new ArrayList<Image>();
            for (com.clustercontrol.ws.cloud.Image wsImage : this.cloudEndpoint.getImagesWithFilter(this.roleId, region, wsFilters)) {
                Image image = new Image();
                image.setImageId(wsImage.getImageId());
                image.setName(wsImage.getName());
                images.add(image);
            }
            return images;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<GroupIdentifier> getSecurityGroupsByRegion(String regionName) {
        List<Filter> filters = Collections.emptyList();
        return this.getSecurityGroups(regionName, filters);
    }

    @Override
    public List<GroupIdentifier> getSecurityGroups(String region, List<Filter> filters) {
        try {
            List wsSGs = Collections.emptyList();
            if (!filters.isEmpty()) {
                ArrayList<com.clustercontrol.ws.aws.Filter> wsFilters = new ArrayList<com.clustercontrol.ws.aws.Filter>();
                for (Filter filter : filters) {
                    com.clustercontrol.ws.aws.Filter wsFilter = new com.clustercontrol.ws.aws.Filter();
                    wsFilter.setName(filter.getName());
                    wsFilter.getValues().addAll(filter.getValues());
                    wsFilters.add(wsFilter);
                }
                wsSGs = this.awsEndpoint.getSecurityGroupsWithFilters(this.roleId, region, wsFilters);
            } else {
                wsSGs = this.awsEndpoint.getSecurityGroups(this.roleId, region);
            }
            ArrayList<GroupIdentifier> sgs = new ArrayList<GroupIdentifier>();
            for (SecurityGroup wsSG : wsSGs) {
                GroupIdentifier gi = new GroupIdentifier();
                gi.setGroupId(wsSG.getGroupId());
                gi.setGroupName(wsSG.getGroupName());
                gi.setVpcId(wsSG.getVpcId());
                sgs.add(gi);
            }
            return sgs;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> getAllInstanceType() {
        try {
            return this.cloudEndpoint.getInstanceFlavorsByService(this.serviceId);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> getKeyNames(String region) {
        try {
            ArrayList<String> keyNames = new ArrayList<String>();
            for (KeyPair k : this.awsEndpoint.getKeyNames(this.roleId, region)) {
                keyNames.add(k.getKeyName());
            }
            return keyNames;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Snapshot> getSnapshots(String region, List<Filter> filters) {
        try {
            ArrayList<com.clustercontrol.ws.cloud.Filter> wsFilters = new ArrayList<com.clustercontrol.ws.cloud.Filter>();
            for (Filter filter : filters) {
                com.clustercontrol.ws.cloud.Filter wsFilter = new com.clustercontrol.ws.cloud.Filter();
                wsFilter.setName(filter.getName());
                wsFilter.getValues().addAll(filter.getValues());
                wsFilters.add(wsFilter);
            }
            ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
            for (com.clustercontrol.ws.cloud.Snapshot ws : this.cloudEndpoint.getSnapshotsWithFilter(this.roleId, region, wsFilters)) {
                Snapshot s = new Snapshot();
                s.setSnapshotId(ws.getSnapshotId());
                s.setDescription(ws.getDescription());
                snapshots.add(s);
            }
            return snapshots;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> getAllVolumeType() {
        try {
            ArrayList<String> volumeTypes = new ArrayList<String>();
            for (String v : this.cloudEndpoint.getStorageFlavorsByService(this.serviceId)) {
                volumeTypes.add(v);
            }
            return volumeTypes;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> getAllServiceName() {
        try {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Subnet> getSubnets(String regionName, List<Filter> filters) {
        try {
            ArrayList<com.clustercontrol.ws.cloud.Filter> wsFilters = new ArrayList<com.clustercontrol.ws.cloud.Filter>();
            for (Filter filter : filters) {
                com.clustercontrol.ws.cloud.Filter wsFilter = new com.clustercontrol.ws.cloud.Filter();
                wsFilter.setName(filter.getName());
                wsFilter.getValues().addAll(filter.getValues());
                wsFilters.add(wsFilter);
            }
            ArrayList<Subnet> subnets = new ArrayList<Subnet>();
            for (com.clustercontrol.ws.aws.Subnet wsSubnet : this.awsEndpoint.getSubnets(this.roleId, regionName)) {
                Subnet subnet = new Subnet();
                subnet.setSubnetId(wsSubnet.getSubnetId());
                subnet.setVpcId(wsSubnet.getVpcId());
                subnet.setAvailabilityZone(wsSubnet.getAvailabilityZone());
                subnet.setCidrBlock(wsSubnet.getCidrBlock());
                subnets.add(subnet);
            }
            return subnets;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<Subnet> getSubnetsByRegion(String regionName) {
        try {
            ArrayList<Subnet> subnets = new ArrayList<Subnet>();
            for (com.clustercontrol.ws.aws.Subnet wsSubnet : this.awsEndpoint.getSubnets(this.roleId, regionName)) {
                Subnet subnet = new Subnet();
                subnet.setSubnetId(wsSubnet.getSubnetId());
                subnet.setVpcId(wsSubnet.getVpcId());
                subnet.setAvailabilityZone(wsSubnet.getAvailabilityZone());
                subnet.setCidrBlock(wsSubnet.getCidrBlock());
                subnets.add(subnet);
            }
            return subnets;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

