/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;

public class Node extends Facility implements INode {
	private Scope parent;
	private NodeType nodeType;
	
	public Node() {
	}
	
	@Override
	public IFacilityRoot getFacilityRoot() {
		return getParent().getFacilityRoot();
	}

	@Override
	public IScope getParent() {
		return parent;
	}
	
	public void setParent(Scope parent) {
		internalSet("parent", INode.p2.parent, parent);
	}

	@Override
	public IScope getAccountScope() {
		return getOptionalTypeScope(IScope.ScopeType.account_resource_scope);
	}

	@Override
	public IScope getRegionScope() {
		return getOptionalTypeScope(IScope.ScopeType.region);
	}

	@Override
	public IScope getZoneScope() {
		return getOptionalTypeScope(IScope.ScopeType.zone);
	}

	private IScope getOptionalTypeScope(IScope.ScopeType scopeType){
		Scope scope = parent;
		while (scope != null) { 
			if (scope.getScopeType() == scopeType) {
				return scope;
			}
			scope = scope.getParent();
		}
		return null;
	}
	
	@Override
	public NodeType getNodeType() {
		return nodeType;
	}
	
	public void setNodeType(NodeType nodeType){
		this.nodeType = nodeType;
	}

	@Override
	public String getAccountResourceId() {
		return getNodeType().getAccountResourceId(this);
	}

	@Override
	public String getRegion() {
		return getNodeType().getRegion(this);
	}
}
