/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.base.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Button;

public abstract class ListSelectionDialog<T> extends Dialog {
	private List<T> list = Collections.emptyList();

	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String strSelect = messages.getString("word.select");
	private String strUnselect = messages.getString("word.unselect");
	private String strRightMark = messages.getString("caption.right_mark");
	private String strLeftMark = messages.getString("caption.left_mark");
	private String strAllElementList = messages.getString("caption.all_element_list", new String[]{getElementName()});
	private String strSelectedElementList = messages.getString("caption.selected_element_list", new String[]{getElementName()});
	private String strSelectListDialog = messages.getString("caption.select_list_dialog", new String[]{getElementName()});
	
	org.eclipse.swt.widgets.List lstSelectedElement;
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public ListSelectionDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setLayout(new GridLayout(5, false));
		container.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		Text txtAllElement = new Text(container, SWT.READ_ONLY);
		GridData gdAllElement = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		gdAllElement.widthHint = 150;
		txtAllElement.setLayoutData(gdAllElement);
		txtAllElement.setText(strAllElementList);
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		Text txtSelectedElement = new Text(container, SWT.READ_ONLY);
		GridData gdSelectedElement = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		gdSelectedElement.widthHint = 150;
		txtSelectedElement.setLayoutData(gdSelectedElement);
		txtSelectedElement.setText(strSelectedElementList);
		
		final org.eclipse.swt.widgets.List lstAllElement = new org.eclipse.swt.widgets.List(container, SWT.BORDER  | SWT.MULTI);
		GridData gdAllElementList = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 5);
		gdAllElementList.widthHint = 150;
		lstAllElement.setLayoutData(gdAllElementList);

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		lstSelectedElement = new org.eclipse.swt.widgets.List(container, SWT.BORDER | SWT.MULTI);
		GridData gdSelectedElementList = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 5);
		gdSelectedElementList.widthHint = 150;
		lstSelectedElement.setLayoutData(gdSelectedElementList);
		new Label(container, SWT.NONE);

		Button btnSelect = new Button(container, SWT.NONE);
		btnSelect.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		btnSelect.setText(strSelect + strRightMark);
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		Button btnUnselect = new Button(container, SWT.NONE);
		btnUnselect.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		btnUnselect.setText(strLeftMark + strUnselect);
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		// 初期化1
		{
			for(T element: getAllList()){
				lstAllElement.add(getLabel(element));
				lstAllElement.setData(getLabel(element), element);
			}
		}
		
		// 入力値をコントロールに反映。
		if (!list.isEmpty()) {
			for(T element: list){
				if(lstAllElement.indexOf(getLabel(element)) != -1){
					lstAllElement.select(lstAllElement.indexOf(getLabel(element)));
				}
			}
			listToList(lstAllElement, lstSelectedElement);
		}

		// 挙動を追加
		{
			btnSelect.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					listToList(lstAllElement, lstSelectedElement);
				}
			});
			
			btnUnselect.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					listToList(lstSelectedElement, lstAllElement);
				}
			});
		}
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected void okPressed() {
		list = new ArrayList<T>();
		for (String label: lstSelectedElement.getItems()) {
			list.add((T)lstSelectedElement.getData(label));
		}
		
		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strSelectListDialog);
	}

	protected abstract String getLabel(T element);
	protected abstract List<T> getAllList();
	protected abstract String getElementName();
	
	public void setList(List<T> list) {
		assert list != null;
		this.list = new ArrayList<T>(list);
	}

	public List<T> getList() {
		return list;
	}
	
	protected void listToList(org.eclipse.swt.widgets.List list1, org.eclipse.swt.widgets.List list2){
		if(list1.getSelectionCount() > 0){
			List<String> labels = new ArrayList<>(Arrays.asList(list1.getSelection()));
			
			for(String label: labels){
				list2.add(label);
				list2.setData(label, list1.getData(label));
				list1.remove(label);
			}
		}
	}
}
