/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.cloudn.base.resources.Filter;
import com.clustercontrol.cloud.cloudn.base.resources.Template;
import com.clustercontrol.cloud.cloudn.base.resources.Zone;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateTemplateDialog;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.SelectVMIDialog;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Shell;

public class CreateTemplateAction
extends AbstractViewAction {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgCreateTemplateConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.template", "word.create"});
    private String msgCreateTemplateResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.template", "word.create"});
    private CloudResourceProvider provider;
    private IAccountResource.IRegion region;

    protected void invoke(IAction action) throws InvocationException {
        final IAccountResource accountResource = ((TemplatesView)this.viewPart).getAccountResource();
        this.provider = new CloudResourceProviderImpl(accountResource.getAccountResourceId());
        this.region = ((TemplatesView)this.viewPart).getActiveRegion() != null ? ((TemplatesView)this.viewPart).getActiveRegion() : accountResource.getRegion("jp-e1");
        final CreateTemplateDialog dialog = new CreateTemplateDialog(this.viewPart.getSite().getShell());
        dialog.setCloudInfoProvider(this.provider);
        try {
            dialog.setBehavior(new CreateTemplateDialog.IDialogBehavior(){

                @Override
                public void setup(final CreateTemplateDialog.DialogControlContainer container) {
                    String jobName;
                    String jobId;
                    ArrayList templateJobs;
                    MessageManagerExt messages = MessageManagerExt.getInstance("messages");
                    container.getCmbRegion().addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            this.setupZone(container);
                            container.getTxtVmi().setText("");
                            container.getTxtVmi().setData(null);
                        }
                    });
                    container.getCmbZone().addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            container.getTxtVmi().setText("");
                            container.getTxtVmi().setData(null);
                        }
                    });
                    try {
                        templateJobs = TemplateJobUtil.getTemplateJobList((String)accountResource.getAccountResourceId(), (Boolean)true);
                    }
                    catch (Exception e) {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)e.getMessage());
                        templateJobs = new ArrayList();
                    }
                    for (String regionName : CreateTemplateAction.this.provider.getAllRegion()) {
                        String regionLocaleName = messages.getString(regionName);
                        container.getCmbRegion().add(regionLocaleName);
                        container.getCmbRegion().setData(regionLocaleName, (Object)regionName);
                    }
                    if (CreateTemplateAction.this.region != null) {
                        String regionLocaleName = messages.getString(CreateTemplateAction.this.region.getRegionName());
                        container.getCmbRegion().select(container.getCmbRegion().indexOf(regionLocaleName));
                    } else {
                        container.getCmbRegion().select(0);
                    }
                    for (TemplateJobUtil.TemplateJobnet childJobItem : templateJobs) {
                        jobId = childJobItem.getJobnetId();
                        jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        container.getCmbLaunchJobId().add(jobName);
                        container.getCmbLaunchJobId().setData(jobName, (Object)jobId);
                    }
                    for (TemplateJobUtil.TemplateJobnet childJobItem : templateJobs) {
                        jobId = childJobItem.getJobnetId();
                        jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        container.getCmbStartJobId().add(jobName);
                        container.getCmbStartJobId().setData(jobName, (Object)jobId);
                    }
                    for (TemplateJobUtil.TemplateJobnet childJobItem : templateJobs) {
                        jobId = childJobItem.getJobnetId();
                        jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
                        container.getCmbStopJobId().add(jobName);
                        container.getCmbStopJobId().setData(jobName, (Object)jobId);
                    }
                    final Shell shell = dialog.getShell();
                    container.getBtnSelectVmi().addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            List<Template> officials = CreateTemplateAction.this.provider.getTemplates("jp-e1", Arrays.asList(new Filter("category", "official"), new Filter("zone", container.getCmbZone().getText())));
                            List<Template> mys = CreateTemplateAction.this.provider.getTemplates("jp-e1", Arrays.asList(new Filter("category", "my"), new Filter("zone", container.getCmbZone().getText())));
                            SelectVMIDialog dialog = new SelectVMIDialog(officials, mys, shell);
                            if (dialog.open() == 0) {
                                Template output = dialog.getOutput();
                                container.getTxtVmi().setText(output.getName() + " ( " + output.getId() + " ) ");
                                container.getTxtVmi().setData((Object)output);
                            }
                        }
                    });
                }

                private void setupZone(CreateTemplateDialog.DialogControlContainer container) {
                    container.getCmbZone().removeAll();
                    for (Zone zone : CreateTemplateAction.this.provider.getZones(CreateTemplateAction.this.region.getRegion())) {
                        container.getCmbZone().add(zone.getName());
                        container.getCmbZone().setData(zone.getName(), (Object)zone);
                    }
                    if (container.getCmbZone().getItemCount() > 0) {
                        container.getCmbZone().select(0);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new InvocationException((Throwable)e);
        }
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgCreateTemplateConfirm)) {
                ICloudTemplateManager templateManager = accountResource.getCloudTemplateManager();
                templateManager.createCloudTemplate(dialog.getOutput());
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgCreateTemplateResult);
            } else {
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (((TemplatesView)this.viewPart).getAccountResource() != null) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }
}

