/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.presenter.JobTrackingService;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.cloudn.base.resources.Filter;
import com.clustercontrol.cloud.cloudn.base.resources.Template;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateInstanceDialog_FLAT;
import com.clustercontrol.cloud.cloudn.base.ui.views.actions.CreateInstanceAction_FLAT;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceByTemplateRequest;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.InvalidStateException;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;

public class CreateInstanceByTemplateAction_FLAT
extends SingleSelectionActionEx {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgCreateInstanceConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.instance", "word.create"});
    private String msgCreateInstanceResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.instance", "word.create"});
    private ICloudTemplateManager templateManager;
    private ICloudTemplate template;
    private CloudResourceProvider provider;

    protected void invoke(IAction action) throws InvocationException {
        CreateInstanceDialog_FLAT dialog = new CreateInstanceDialog_FLAT(this.viewPart.getSite().getShell());
        TemplatesView view = (TemplatesView)this.viewPart;
        this.template = (ICloudTemplate)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
        this.templateManager = this.template.getCloudTemplateManager();
        dialog.setCloudTemplateManager(this.templateManager);
        this.provider = new CloudResourceProviderImpl(view.getAccountResource().getAccountResourceId());
        dialog.setCloudInfoProvider(this.provider);
        dialog.setRegion(this.template.getRegion());
        dialog.setBehavior(new CreateInstanceDialog_FLAT.IDialogBehavior(){
            private String msgTemplateDoesNotExists;
            {
                this.msgTemplateDoesNotExists = CreateInstanceByTemplateAction_FLAT.this.messages.getString("message.template_does_not_exists");
            }

            @Override
            public void setup(CreateInstanceDialog_FLAT.DialogControlContainer container) {
                Filter f1 = new Filter();
                f1.setName("image-id");
                f1.setValues(Arrays.asList(CreateInstanceByTemplateAction_FLAT.this.template.getImageId()));
                Filter f2 = new Filter();
                f2.setName("zone");
                f2.setValues(Arrays.asList(CreateInstanceByTemplateAction_FLAT.this.template.getImageId().substring(37)));
                List<Template> imageList = CreateInstanceByTemplateAction_FLAT.this.provider.getTemplates(CreateInstanceByTemplateAction_FLAT.this.template.getRegion(), Arrays.asList(f1, f2));
                if (!imageList.isEmpty()) {
                    Template image = imageList.get(0);
                    container.getCmbZone().select(container.getCmbZone().indexOf(image.getId().substring(37)));
                    container.getTxtVMI().setText(image.getName() + " ( " + image.getId() + " ) ");
                    container.getTxtVMI().setData((Object)image);
                    container.getTxtVMI().setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
                if (!(imageList = CreateInstanceByTemplateAction_FLAT.this.provider.getTemplates(CreateInstanceByTemplateAction_FLAT.this.template.getRegion(), Arrays.asList(f2))).isEmpty()) {
                    container.getBtnUseTemplate().setSelection(true);
                    for (ICloudTemplate tmpTemplate : CreateInstanceByTemplateAction_FLAT.this.templateManager.getCloudTemplates()) {
                        if (!tmpTemplate.getRegion().equals(CreateInstanceByTemplateAction_FLAT.this.template.getRegion()) || !tmpTemplate.getImageId().substring(37).equals(container.getCmbZone().getText())) continue;
                        String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
                        container.getCmbTemplate().add(tmpLabel);
                        container.getCmbTemplate().setData(tmpLabel, (Object)tmpTemplate);
                        if (!tmpTemplate.getImageId().equals(CreateInstanceByTemplateAction_FLAT.this.template.getImageId())) continue;
                        container.getCmbTemplate().select(container.getCmbTemplate().indexOf(tmpLabel));
                    }
                    if (container.getCmbTemplate().getSelectionIndex() == -1 && container.getCmbTemplate().getItemCount() > 0) {
                        container.getCmbTemplate().select(0);
                    }
                }
                if (container.getCmbTemplate().getItemCount() > 0) {
                    container.getLblTemplate().setEnabled(true);
                    container.getCmbTemplate().setEnabled(true);
                    container.getBtnEditArgument().setEnabled(true);
                    container.getLblVMI().setEnabled(false);
                    container.getTxtVMI().setEnabled(false);
                    container.getBtnSelectVMI().setEnabled(false);
                    container.getTxtVMI().setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                } else {
                    MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgTemplateDoesNotExists);
                    container.getBtnUseTemplate().setSelection(false);
                }
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgCreateInstanceConfirm)) {
                ICloudInstance instance;
                CreateCloudInstanceByTemplateRequest request;
                String detailJson;
                CreateInstanceDialog_FLAT.Model m = dialog.getOutput();
                IAccountResource.IRegion r = this.templateManager.getAccountResource().getRegion(this.template.getRegion());
                CreateInstanceAction_FLAT.InstanceDetail detail = new CreateInstanceAction_FLAT.InstanceDetail();
                if (m.getSecurityGroups() != null) {
                    detail.securityGroups.addAll(m.getSecurityGroups());
                }
                detail.group = m.getGroup();
                detail.attachingDisk = m.getAttachingDisk();
                ObjectMapper om = new ObjectMapper();
                ObjectWriter dw = om.writerWithType(CreateInstanceAction_FLAT.InstanceDetail.class);
                try {
                    detailJson = dw.writeValueAsString((Object)detail);
                }
                catch (Exception e) {
                    throw new CloudModelException((Throwable)e);
                }
                if (m.isTemplateUsed().booleanValue()) {
                    request = new CreateCloudInstanceByTemplateRequest();
                    request.setZone(m.getZone());
                    request.setTemplateId(m.getTemplateId());
                    request.setFlavor(m.getFlavor());
                    request.setFacilityId(m.getFacilityId());
                    request.setFacilityName(m.getFacilityName());
                    request.setDescription(m.getDescription());
                    request.setNodeName(m.getNodeName());
                    request.setReplaceNode(m.getReplaceNode());
                    request.setInstanceDetail(detailJson);
                    request.setTags(m.getTags());
                    request.setArguments(m.getArguments());
                    instance = ((ICloudComputeService)r.getAccountResource().getRegion(this.template.getRegion()).getCloudService(ICloudComputeService.class)).getInstanceManager().createCloudInstanceByTemplate(request);
                } else {
                    request = new CreateCloudInstanceRequest();
                    request.setZone(m.getZone());
                    request.setImageId(m.getImageId());
                    request.setFlavor(m.getFlavor());
                    request.setFacilityId(m.getFacilityId());
                    request.setFacilityName(m.getFacilityName());
                    request.setDescription(m.getDescription());
                    request.setNodeName(m.getNodeName());
                    request.setReplaceNode(m.getReplaceNode());
                    request.setInstanceDetail(detailJson);
                    request.setTags(m.getTags());
                    instance = ((ICloudComputeService)r.getAccountResource().getRegion(this.template.getRegion()).getCloudService(ICloudComputeService.class)).getInstanceManager().createCloudInstance((CreateCloudInstanceRequest)request);
                }
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgCreateInstanceResult);
                try {
                    JobTrackingService.trackPassword(this.viewPart, instance);
                }
                catch (InvalidStateException e) {
                    throw new InvocationException((Throwable)e);
                }
                view.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, new ICloudInstance.StateType[]{ICloudInstance.StateType.running, ICloudInstance.StateType.terminated, ICloudInstance.StateType.stopped});
                        FacilityTree.refresh();
                    }
                });
            } else {
                return;
            }
        }
    }
}

