/*
 
Copyright (C) since 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/
package com.clustercontrol.repository.bean;

/**
 * 
 * NodePropertyの定数部分を切り出した物。
 *
 */
public class NodeConstant {
	/** ----- ファシリティ関連 ----- */
	/** ファシリティID */
	public static final String FACILITY_ID = "facilityId";
	/** ファシリティ名 */
	public static final String FACILITY_NAME = "facilityName";
	/** 説明 */
	public static final String DESCRIPTION = "description";
	/** 有効/無効 */
	public static final String VALID = "valid";
	/** 作成者 */
	public static final String CREATOR_NAME = "creatorName";
	/** 作成日時 */
	public static final String CREATE_TIME = "createTimestamp";
	/** 最終更新者 */
	public static final String MODIFIER_NAME = "ModifierName";
	/** 最終更新日時 */
	public static final String MODIFY_TIME = "ModifyTime";
	
	/** ----- ノード関連 ----- */
	/** プラットフォームファミリ名 */
	public static final String PLATFORM_FAMILY_NAME = "platformFamilyName";
	/** H/Wタイプ */
	public static final String HARDWARE_TYPE = "hardwareType";
	/** アイコンイメージ */
	public static final String ICONIMAGE= "iconImage";
	
	/** ----- SNMP関連 ----- */
	/** SNMPポート番号 */
	public static final String SNMP_PORT = "snmpPort";
	/** SNMPコミュニティ名 */
	public static final String SNMP_COMMUNITY = "snmpCommunity";
	/** SNMPバージョン */
	public static final String SNMP_VERSION = "snmpVersion";
	/** SNMPポーリングタイムアウト */
	public static final String SNMPTIMEOUT = "snmpTimeout";
	/** SNMPポーリングリトライ回数 */
	public static final String SNMPRETRIES= "snmpRetries";
	/** SNMPプロキシ */
	public static final String SNMPPROXY= "snmpProxy";
	
	/** ----- WBEM関連 ----- */
	/** WBEM接続ユーザ */
	public static final String WBEM_USER = "wbemUser";
	/** WBEM接続ユーザパスワード */
	public static final String WBEM_USER_PASSWORD = "wbemUserPassword";
	/** WBEM接続ポート番号 */
	public static final String WBEM_PORT = "wbemPort";
	/** WBEM接続プロトコル */
	public static final String WBEM_PROTOCOL = "wbemProtocol";
	/** WBEM接続タイムアウト*/
	public static final String WBEM_TIMEOUT = "wbemTimeout";
	/** WBEM接続リトライ回数 */
	public static final String WBEM_RETRIES = "wbemRetries";
	
	
	/** ----- IPアドレス関連 ----- */
	/** DHCPクライアント */
	public static final String DHCP_CLIENT = "dhcpClient";
	/** IPアドレス種別 */
	public static final String IP_ADDRESS_TYPE = "ipAddressType";
	/** IPアドレスのバージョン */
	public static final String IP_ADDRESS_VERSION = "ipAddressVersion";
	/** IPv4のアドレス */
	public static final String IP_ADDRESS_V4 = "ipAddressV4";
	/** IPv6のアドレス */
	public static final String IP_ADDRESS_V6 = "ipAddressV6";
	
	/** ----- OS関連 ----- */
	/** ノード名 */
	public static final String NODE_NAME = "nodeName";
	/** OS名 */
	public static final String OS_NAME = "osName";
	/** OSリリース */
	public static final String OS_RELEASE = "osRelease";
	/** OSバージョン */
	public static final String OS_VERSION = "osVersion";
	/** 文字セット */
	public static final String CHARACTER_SET = "characterSet";
	
	/** ----- 仮想化関連 ----- */
	/** 仮想化ノード種別 */
	public static final String VIRTNODETYPE= "virtualizationNodeType";
	/** 仮想化管理ノード */
	public static final String VMMANAGEMENTNODE= "vMManagementNode";
	/** 仮想化INDEX */
	public static final String VMINDEX= "VMINDEX";
	/** 仮想化名 */
	public static final String VMNAME= "VMName";
	/** 仮想化ソリューション */
	public static final String VIRTSOLUTION= "virtualizationSolution";
	/** 仮想化ID */
	public static final String VMID = "vmId";
	/** 仮想化ユーザ名 */
	public static final String VMUSER= "vmUser";
	/** 仮想化ユーザパスワード */
	public static final String VMUSERPASSWORD= "vmUserPassword";
	/** 仮想化プロトコル */
	public static final String VMPROTOCOL= "vmProtocol";
	
	/** ----- 管理関連 ----- */
	/** 管理者 */
	public static final String ADMINISTRATOR = "administrator";
	/** 連絡先 */
	public static final String CONTACT = "contact";
	
	/** ----- 複数の格納情報 ----- */
	/** ホスト名 */	
	public static final String HOST_NAME = "hostName";
	
	/** 備考 */
	public static final String NOTE= "note";
	
	/** デバイス種別 */
	public static final String DEVICE_TYPE = "deviceType";
	/** デバイスインデックス */
	public static final String DEVICE_INDEX = "deviceIndex";
	/** デバイス名 */
	public static final String DEVICE_NAME = "deviceName";
	/** デバイス表示名 */
	public static final String DEVICE_DISPLAY_NAME = "deviceDisplayName";
	/** デバイスOID */
	public static final String DEVICE_OID = "deviceOID";
	/** デバイス説明 */
	public static final String DEVICE_DESCRIPTION = "deviceDescription";
	
	/** ファイルシステムINDEX */
	public static final String FILE_SYSTEM_INDEX = "fileSystemIndex";
	/** マウント位置 */
	public static final String FILE_SYSTEM_MOUNT_POINT = "fileSystemMountPoint";
	/** ファイルシステム表示名 */
	public static final String FILE_SYSTEM_DISPLAY_NAME = "fileSystemDisplayName";
	/** ファイルシステム種別 */
	public static final String FILE_SYSTEM_TYPE = "fileSystemType";
	/** ファイルシステムOID */
	public static final String FILE_SYSTEM_OID = "fileSystemOID";
	/** ファイルシステム説明 */
	public static final String FILE_SYSTEM_DESCRIPTION = "fileSystemDescription";
	
	/** ----- 情報グループ種別 ----- */
	/** ネットワーク */
	public static final String NETWORK = "network";
	/** OS */
	public static final String OS = "os";	
	/** 保守 */
	public static final String MAINTENANCE = "maintenance";	
	/** デバイス */
	public static final String DEVICE = "device";	
	/** ファイルシステム */
	public static final String FILE_SYSTEM = "fileSystem";
	/** SNMP */
	public static final String SNMP ="snmp";
	/** WBEM */
	public static final String WBEM = "wbem";
	/** 仮想化 */
	public static final String VIRTUALIZATION = "virtualization";
}
