/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performance.bean;

import java.io.Serializable;

/**
 * 収集項目の設定情報を保持するDTOクラス<p>
 * 
 * 収集設定には、全般の情報、収集項目に関する情報、閾値監視に関する情報があり、
 * そのうち、収集項目に関する情報を保持また、クライアントマネージャ間でやり取りをする
 * ためのクラスです。
 * 
 * @version 1.0
 * @since 1.0
 */
public class CollectorItemInfo implements Serializable {
	private static final long serialVersionUID = 4107793107236713239L;
	
	private String m_collectorId;   //収集ID
//	private String m_collectMethod; //収集方法 (Ver3.1.0より廃止)
//	private String m_platformId;    //プラットフォーム
	private String m_itemCode;      //収集項目コード
//	private String m_deviceName;   //デバイス名称 (Ver3.1.0より廃止)
	private String m_displayName;  //リポジトリ表示名 (Ver3.1.0)より追加
		
	/**
	 * 指定された値を保持した CollectorItemInfo オブジェクトを生成します。
	 * 
	 * @param collectMethod 収集方法
	 * @param platformId プラットフォーム
	 * @param itemCode 収集項目コード
	 * @param displayName リポジトリ表示名
	 */
	public CollectorItemInfo(
			final String collectorId,
//			final String collectMethod,
//			final String platformId,
			final String itemCode, 
//			final String deviceName,
			final String displayName){
		m_collectorId = collectorId;
//		m_collectMethod = collectMethod;
//		m_platformId = platformId;
		m_itemCode = itemCode;
//		m_deviceName = deviceName;
		m_displayName = displayName;
	}
	
	/**
	 * 収集IDを取得します。
	 * @return 収集ID
	 */
	public String getCollectorId() {
		return m_collectorId;
	}
	/**
	 * 収集IDを設定します。
	 * @param collectorId 収集ID
	 */
	public void setCollectorId(String collectorId) {
		m_collectorId = collectorId;
	}
//	/**
//	 * 収集方法を取得します。
//	 * @return 収集方法
//	 */
//	public String getCollectMethod() {
//		return m_collectMethod;
//	}
//	/**
//	 * 収集方法を設定します。
//	 * @param collectMethod 収集方法
//	 */
//	public void setCollectMethod(String collectMethod) {
//		m_collectMethod = collectMethod;
//	}
//	/**
//	 * プラットフォームを取得します。
//	 * @return プラットフォーム
//	 */
//	public String getPlatformId() {
//		return m_platformId;
//	}
//	/**
//	 * プラットフォームを設定します。
//	 * @param platformId プラットフォーム
//	 */
//	public void setPlatformId(String platformId) {
//		m_platformId = platformId;
//	}
	/**
	 * 収集項目コードを取得します。
	 * @return 収集項目コード
	 */
	public String getItemCode() {
		return m_itemCode;
	}
	/**
	 * 収集項目コードを設定します。
	 * @param itemCode 収集項目コード
	 */
	public void setItemCode(String itemCode) {
		m_itemCode = itemCode;
	}
//	/**
//	 * デバイス名称を取得します。
//	 * @return デバイス名称
//	 */
//	public String getDeviceName() {
//		return m_deviceName;
//	}
//	/**
//	 * デバイス名称を設定します。
//	 * @param name デバイス名称
//	 */
//	public void setDeviceName(String name) {
//		m_deviceName = name;
//	}
	/**
	 * リポジトリ表示名を取得します。
	 * @return リポジトリ表示名
	 */
	public String getDisplayName() {
		return m_displayName;
	}
	/**
	 * リポジトリ表示名を設定します。
	 * @param name リポジトリ表示名
	 */
	public void setDisplayName(String name) {
		m_displayName = name;
	}
	
	/**
	 * このオブジェクトと他のオブジェクトが等しいかどうかを示します。
	 */
	@Override
	public boolean equals( Object pOther )
	{
		if( pOther instanceof CollectorItemInfo )
		{
			CollectorItemInfo lTest = (CollectorItemInfo) pOther;
			boolean lEquals = true;

			if( this.m_collectorId == null )
			{
				lEquals = lEquals && ( lTest.m_collectorId == null );
			}
			else
			{
				lEquals = lEquals && this.m_collectorId.equals( lTest.m_collectorId );
			}
//			if( this.m_collectMethod == null )
//			{
//				lEquals = lEquals && ( lTest.m_collectMethod == null );
//			}
//			else
//			{
//				lEquals = lEquals && this.m_collectMethod.equals( lTest.m_collectMethod );
//			}
			if( this.m_itemCode == null )
			{
				lEquals = lEquals && ( lTest.m_itemCode == null );
			}
			else
			{
				lEquals = lEquals && this.m_itemCode.equals( lTest.m_itemCode );
			}
//			if( this.m_deviceName == null )
//			{
//				lEquals = lEquals && ( lTest.m_deviceName == null );
//			}
//			else
//			{
//				lEquals = lEquals && this.m_deviceName.equals( lTest.m_deviceName );
//			}
			if( this.m_displayName == null )
			{
				lEquals = lEquals && ( lTest.m_displayName == null );
			}
			else
			{
				lEquals = lEquals && this.m_displayName.equals( lTest.m_displayName );
			}
			
			return lEquals;
		}
		else
		{
			return false;
		}
	}

	/**
	 * オブジェクトのハッシュコード値を返します。
	 */
	@Override
	public int hashCode()
	{
		int result = 17;

		result = 37*result + ((this.m_collectorId != null) ? this.m_collectorId.hashCode() : 0);

//		result = 37*result + ((this.m_collectMethod != null) ? this.m_collectMethod.hashCode() : 0);

		result = 37*result + ((this.m_itemCode != null) ? this.m_itemCode.hashCode() : 0);

//		result = 37*result + ((this.m_deviceName != null) ? this.m_deviceName.hashCode() : 0);
		
		result = 37*result + ((this.m_displayName != null) ? this.m_displayName.hashCode() : 0);

		return result;
	}
}