/*
 
 Copyright (C) 2009 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.notify.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;


public class NotifyTypeMstMap  implements Serializable{
	private static final long serialVersionUID = -4117865541645163623L;
	
	// 登録されている通知のキュー名を保持するマップ
	// キー ： 通知方法
	// 値　 ： キュー名
	private final ConcurrentHashMap<Integer, NotifyTypeMstInfo> _parameterMap;
	
	public NotifyTypeMstMap(Collection<NotifyTypeMstInfo> mstDataColl){
		_parameterMap = new ConcurrentHashMap<Integer, NotifyTypeMstInfo>();
		for(NotifyTypeMstInfo data : mstDataColl){
			_parameterMap.put(data.getNotifyType(), data);
		}
	}

	public NotifyTypeMstInfo getNotifyTypeMstInfo(int notifyType){
		return _parameterMap.get(notifyType);
	}
	
	/**
	 * 保持している通知種別を全て返す。
	 * 
	 * @return 通知種別を示す数値（NotifyTypeConstantで定義）のセット
	 */
	public Set<Integer> getNotifyTypeAll(){
		return new TreeSet<Integer>(_parameterMap.keySet());
	}
	
	/**
	 * 保持している通知定義を全て返す。
	 * 
	 * @return 通知定義のインスタンス（NotifyTypeMstInfo）のセット
	 */
	public List<NotifyTypeMstInfo> getNotifyTypeMstInfoList(){
		ArrayList<NotifyTypeMstInfo> list = new ArrayList<NotifyTypeMstInfo>();

		for(Integer type : getNotifyTypeAll()){
			list.add(_parameterMap.get(type));
		}
		
		return list;
	}
}
